/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.gui.entries;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.gui.entries.AbstractNumberListEntry;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;

@OnlyIn(value=Dist.CLIENT)
public class LongListEntry
extends AbstractNumberListEntry<Long> {
    private long minimum = -9223372036854775807L;
    private long maximum = Long.MAX_VALUE;
    private final Consumer<Long> saveConsumer;

    @Deprecated
    @ApiStatus.Internal
    public LongListEntry(Component fieldName, Long value, Component resetButtonKey, Supplier<Long> defaultValue, Consumer<Long> saveConsumer) {
        super(fieldName, value, resetButtonKey, defaultValue);
        this.saveConsumer = saveConsumer;
    }

    @Deprecated
    @ApiStatus.Internal
    public LongListEntry(Component fieldName, Long value, Component resetButtonKey, Supplier<Long> defaultValue, Consumer<Long> saveConsumer, Supplier<Optional<Component[]>> tooltipSupplier) {
        this(fieldName, value, resetButtonKey, defaultValue, saveConsumer, tooltipSupplier, false);
    }

    @Deprecated
    @ApiStatus.Internal
    public LongListEntry(Component fieldName, Long value, Component resetButtonKey, Supplier<Long> defaultValue, Consumer<Long> saveConsumer, Supplier<Optional<Component[]>> tooltipSupplier, boolean requiresRestart) {
        super(fieldName, value, resetButtonKey, defaultValue, tooltipSupplier, requiresRestart);
        this.saveConsumer = saveConsumer;
    }

    @Override
    protected void textFieldPreRender(EditBox widget) {
        try {
            double i = Long.parseLong(this.textFieldWidget.m_94155_());
            if (i < (double)this.minimum || i > (double)this.maximum) {
                widget.m_94202_(0xFF5555);
            } else {
                widget.m_94202_(0xE0E0E0);
            }
        }
        catch (NumberFormatException ex) {
            widget.m_94202_(0xFF5555);
        }
    }

    @Override
    public void save() {
        if (this.saveConsumer != null) {
            this.saveConsumer.accept(this.getValue());
        }
    }

    @Override
    protected boolean isMatchDefault(String text) {
        return this.getDefaultValue().isPresent() && text.equals(((Long)this.defaultValue.get()).toString());
    }

    public LongListEntry setMinimum(long minimum) {
        this.minimum = minimum;
        return this;
    }

    public LongListEntry setMaximum(long maximum) {
        this.maximum = maximum;
        return this;
    }

    @Override
    public Long getValue() {
        try {
            return Long.valueOf(this.textFieldWidget.m_94155_());
        }
        catch (Exception e) {
            return 0L;
        }
    }

    @Override
    public Optional<Component> getError() {
        try {
            long i = Long.parseLong(this.textFieldWidget.m_94155_());
            if (i > this.maximum) {
                return Optional.of(new TranslatableComponent("text.cloth-config.error.too_large", new Object[]{this.maximum}));
            }
            if (i < this.minimum) {
                return Optional.of(new TranslatableComponent("text.cloth-config.error.too_small", new Object[]{this.minimum}));
            }
        }
        catch (NumberFormatException ex) {
            return Optional.of(new TranslatableComponent("text.cloth-config.error.not_valid_number_long"));
        }
        return super.getError();
    }
}

