/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.gui.entries;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.gui.entries.AbstractNumberListEntry;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;

@OnlyIn(value=Dist.CLIENT)
public class IntegerListEntry
extends AbstractNumberListEntry<Integer> {
    private int minimum = -2147483647;
    private int maximum = Integer.MAX_VALUE;
    private final Consumer<Integer> saveConsumer;

    @Deprecated
    @ApiStatus.Internal
    public IntegerListEntry(Component fieldName, Integer value, Component resetButtonKey, Supplier<Integer> defaultValue, Consumer<Integer> saveConsumer) {
        super(fieldName, value, resetButtonKey, defaultValue);
        this.saveConsumer = saveConsumer;
    }

    @Deprecated
    @ApiStatus.Internal
    public IntegerListEntry(Component fieldName, Integer value, Component resetButtonKey, Supplier<Integer> defaultValue, Consumer<Integer> saveConsumer, Supplier<Optional<Component[]>> tooltipSupplier) {
        this(fieldName, value, resetButtonKey, defaultValue, saveConsumer, tooltipSupplier, false);
    }

    @Deprecated
    @ApiStatus.Internal
    public IntegerListEntry(Component fieldName, Integer value, Component resetButtonKey, Supplier<Integer> defaultValue, Consumer<Integer> saveConsumer, Supplier<Optional<Component[]>> tooltipSupplier, boolean requiresRestart) {
        super(fieldName, value, resetButtonKey, defaultValue, tooltipSupplier, requiresRestart);
        this.saveConsumer = saveConsumer;
    }

    @Override
    protected void textFieldPreRender(EditBox widget) {
        try {
            double i = Integer.parseInt(this.textFieldWidget.m_94155_());
            if (i < (double)this.minimum || i > (double)this.maximum) {
                widget.m_94202_(0xFF5555);
            } else {
                widget.m_94202_(0xE0E0E0);
            }
        }
        catch (NumberFormatException ex) {
            widget.m_94202_(0xFF5555);
        }
    }

    @Override
    protected boolean isMatchDefault(String text) {
        return this.getDefaultValue().isPresent() && text.equals(((Integer)this.defaultValue.get()).toString());
    }

    @Override
    public void save() {
        if (this.saveConsumer != null) {
            this.saveConsumer.accept(this.getValue());
        }
    }

    public IntegerListEntry setMaximum(int maximum) {
        this.maximum = maximum;
        return this;
    }

    public IntegerListEntry setMinimum(int minimum) {
        this.minimum = minimum;
        return this;
    }

    @Override
    public Integer getValue() {
        try {
            return Integer.valueOf(this.textFieldWidget.m_94155_());
        }
        catch (Exception e) {
            return 0;
        }
    }

    @Override
    public Optional<Component> getError() {
        try {
            int i = Integer.parseInt(this.textFieldWidget.m_94155_());
            if (i > this.maximum) {
                return Optional.of(new TranslatableComponent("text.cloth-config.error.too_large", new Object[]{this.maximum}));
            }
            if (i < this.minimum) {
                return Optional.of(new TranslatableComponent("text.cloth-config.error.too_small", new Object[]{this.minimum}));
            }
        }
        catch (NumberFormatException ex) {
            return Optional.of(new TranslatableComponent("text.cloth-config.error.not_valid_number_int"));
        }
        return super.getError();
    }
}

