/*
 * Decompiled with CFR 0.152.
 */
package shadows.placebo.util;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import shadows.placebo.Placebo;
import shadows.placebo.recipe.RecipeHelper;
import shadows.placebo.util.IReplacementBlock;

public class PlaceboUtil {
    static boolean late = false;
    static Map<ResourceLocation, RecipeType<?>> unregisteredTypes = new HashMap();

    @SafeVarargs
    public static <T> List<T> asList(T ... objs) {
        ArrayList<T> list = new ArrayList<T>();
        for (T t : objs) {
            list.add(t);
        }
        return list;
    }

    public static CompoundTag getStackNBT(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            tag = new CompoundTag();
            stack.m_41751_(tag);
        }
        return tag;
    }

    public static ItemStack[] toStackArray(Object ... args) {
        ItemStack[] out = new ItemStack[args.length];
        for (int i = 0; i < args.length; ++i) {
            out[i] = RecipeHelper.makeStack(args[i]);
        }
        return out;
    }

    public static void registerOverrideBlock(Block b, final String modid) {
        Block old = (Block)ForgeRegistries.BLOCKS.getValue(b.getRegistryName());
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)b);
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)((Item)new BlockItem(b, new Item.Properties().m_41491_(old.m_5456_().m_41471_())){

            public String getCreatorModId(ItemStack itemStack) {
                return modid;
            }
        }.setRegistryName(b.getRegistryName())));
    }

    public static <B extends Block> void registerOverride(B block, final String modid) {
        Block old = (Block)ForgeRegistries.BLOCKS.getValue(block.getRegistryName());
        ForgeRegistries.BLOCKS.register(block);
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)((Item)new BlockItem(block, new Item.Properties().m_41491_(old.m_5456_().m_41471_())){

            public String getCreatorModId(ItemStack itemStack) {
                return modid;
            }
        }.setRegistryName(block.getRegistryName())));
        PlaceboUtil.overrideStates(old, block);
    }

    public static <B extends Block> void overrideStates(Block old, B block) {
        ((IReplacementBlock)block).setStateContainer((StateDefinition<Block, BlockState>)old.m_49965_());
        ((IReplacementBlock)block)._setDefaultState(old.m_49966_());
        block.m_49965_().m_61056_().forEach(b -> {
            b.f_61112_ = block;
        });
        block.m_49965_().f_61047_ = block;
    }

    public static <T> List<T> toMutable(List<T> list) {
        if (list instanceof ImmutableList) {
            list = new ArrayList<T>(list);
        }
        return list;
    }

    public static boolean tryHarvestBlock(ServerPlayer player, BlockPos pos) {
        return player.f_8941_.m_9280_(pos);
    }

    public static void addLore(ItemStack stack, Component lore) {
        CompoundTag display = stack.m_41698_("display");
        ListTag tag = display.m_128437_("Lore", 8);
        tag.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)lore)));
        display.m_128365_("Lore", (Tag)tag);
    }

    public static <T extends Recipe<?>> RecipeType<T> makeRecipeType(final String pIdentifier) {
        if (late) {
            throw new RuntimeException("Attempted to register a recipe type after the registration period closed.");
        }
        RecipeType type = new RecipeType<T>(){

            public String toString() {
                return pIdentifier;
            }
        };
        unregisteredTypes.put(new ResourceLocation(pIdentifier), type);
        return type;
    }

    public static void registerTypes() {
        unregisteredTypes.forEach((key, type) -> Registry.m_122965_((Registry)Registry.f_122864_, (ResourceLocation)key, (Object)type));
        Placebo.LOGGER.debug("Registered {} recipe types.", (Object)unregisteredTypes.size());
        unregisteredTypes.clear();
        late = true;
    }

    public static <T extends TextColor> void registerCustomColor(T color) {
        TextColor.f_131256_.put(color.m_131274_(), color);
    }
}

