/*
 * Decompiled with CFR 0.152.
 */
package shadows.placebo.json;

import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;

public class SerializerBuilder<V> {
    private final String name;
    private JsonDeserializer<V> jds;
    private JsonSerializer<V> js;
    private NetDeserializer<V> nds;
    private NetSerializer<V> ns;

    public SerializerBuilder(String name) {
        this.name = name;
    }

    public SerializerBuilder<V> withJsonDeserializer(JsonDeserializer<V> jds) {
        this.jds = jds;
        return this;
    }

    public SerializerBuilder<V> withJsonSerializer(JsonSerializer<V> js) {
        this.js = js;
        return this;
    }

    public SerializerBuilder<V> withNetworkDeserializer(NetDeserializer<V> nds) {
        this.nds = nds;
        return this;
    }

    public SerializerBuilder<V> withNetworkSerializer(NetSerializer<V> ns) {
        this.ns = ns;
        return this;
    }

    public SerializerBuilder<V> json(JsonDeserializer<V> jds, JsonSerializer<V> js) {
        return this.withJsonDeserializer(jds).withJsonSerializer(js);
    }

    public SerializerBuilder<V> net(NetDeserializer<V> jds, NetSerializer<V> js) {
        return this.withNetworkDeserializer(jds).withNetworkSerializer(js);
    }

    private static <V> BiFunction<Object, Object, V> coerce(Method m) {
        MethodHandle k;
        try {
            k = MethodHandles.lookup().unreflect(m);
        }
        catch (IllegalAccessException e1) {
            throw new RuntimeException(e1);
        }
        return (p1, p2) -> {
            try {
                return p1 == null ? k.invoke(p2) : k.invoke(p1, p2);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        };
    }

    public SerializerBuilder<V> autoRegister(Class<? extends V> clazz) {
        Method[] methods;
        for (Method m : methods = clazz.getDeclaredMethods()) {
            Class<?>[] p;
            if (Modifier.isStatic(m.getModifiers())) {
                if (!m.getName().equals("read") || (p = m.getParameterTypes()).length != 1) continue;
                if (p[0] == FriendlyByteBuf.class) {
                    this.withNetworkDeserializer(buf -> SerializerBuilder.coerce(m).apply(null, buf));
                    continue;
                }
                if (p[0] != JsonObject.class) continue;
                this.withJsonDeserializer(obj -> SerializerBuilder.coerce(m).apply(null, obj));
                continue;
            }
            if (!m.getName().equals("write")) continue;
            p = m.getParameterTypes();
            if (p.length == 1) {
                if (p[0] != FriendlyByteBuf.class) continue;
                this.withNetworkSerializer((inst, buf) -> SerializerBuilder.coerce(m).apply(inst, buf));
                continue;
            }
            if (p.length != 0 || m.getReturnType() != JsonObject.class) continue;
            this.withJsonSerializer(inst -> (JsonObject)SerializerBuilder.coerce(m).apply(null, inst));
        }
        return this;
    }

    public SerializerBuilder<V> builtin(Supplier<V> factory) {
        this.withJsonDeserializer(json -> factory.get()).withJsonSerializer(o -> new JsonObject());
        this.withNetworkDeserializer(net -> factory.get()).withNetworkSerializer((obj, buf) -> {});
        return this;
    }

    public Serializer build(boolean synced) {
        Preconditions.checkNotNull(this.jds, (Object)("Attempted to build a Serializer for " + this.name + " but no json deserializer was provided."));
        if (synced) {
            Preconditions.checkNotNull(this.nds, (Object)("Attempted to build a Synced Serializer for " + this.name + " but no network deserializer was provided."));
            Preconditions.checkNotNull(this.ns, (Object)("Attempted to build a Synced Serializer for " + this.name + " but no network serializer was provided."));
        }
        return new Serializer(this.name, this.jds, this.js, this.nds, this.ns);
    }

    public static interface JsonDeserializer<V> {
        public V read(JsonObject var1);
    }

    public static interface JsonSerializer<V> {
        public JsonObject write(V var1);
    }

    public static interface NetDeserializer<V> {
        public V read(FriendlyByteBuf var1);
    }

    public static interface NetSerializer<V> {
        public void write(V var1, FriendlyByteBuf var2);
    }

    public class Serializer
    implements JsonDeserializer<V>,
    JsonSerializer<V>,
    NetDeserializer<V>,
    NetSerializer<V> {
        private final String name;
        private final JsonDeserializer<V> jds;
        private final JsonSerializer<V> js;
        private final NetDeserializer<V> nds;
        private final NetSerializer<V> ns;

        public Serializer(String name, JsonDeserializer<V> jds, JsonSerializer<V> js, NetDeserializer<V> nds, NetSerializer<V> ns) {
            this.name = name;
            this.jds = jds;
            this.js = js;
            this.nds = nds;
            this.ns = ns;
        }

        @Override
        public JsonObject write(V src) {
            if (this.js == null) {
                throw new UnsupportedOperationException("Attempted to serialize a " + this.name + " to json, but this serializer does not support that operation.");
            }
            return this.js.write(src);
        }

        @Override
        public void write(V src, FriendlyByteBuf buf) {
            if (this.ns == null) {
                throw new UnsupportedOperationException("Attempted to serialize a " + this.name + " to the network, but this serializer does not support that operation.");
            }
            this.ns.write(src, buf);
        }

        @Override
        public V read(JsonObject json) throws JsonParseException {
            if (this.jds == null) {
                throw new UnsupportedOperationException("Attempted to deserialize a " + this.name + " from json, but this serializer does not support that operation.");
            }
            return this.jds.read(json);
        }

        @Override
        public V read(FriendlyByteBuf buf) {
            if (this.nds == null) {
                throw new UnsupportedOperationException("Attempted to deserialize a " + this.name + " from the network, but this serializer does not support that operation.");
            }
            return this.nds.read(buf);
        }
    }
}

