/*
 * Decompiled with CFR 0.152.
 */
package shadows.placebo.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Type;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class JsonUtil {
    public static <T extends IForgeRegistryEntry<T>> T getRegistryObject(JsonObject parent, String name, IForgeRegistry<T> registry) {
        String key = GsonHelper.m_13906_((JsonObject)parent, (String)name);
        IForgeRegistryEntry regObj = registry.getValue(new ResourceLocation(key));
        if (regObj == null) {
            throw new JsonSyntaxException("Failed to parse " + registry.getRegistryName() + " object with key " + key);
        }
        return (T)regObj;
    }

    public static <T extends IForgeRegistryEntry<T>> Object makeSerializer(IForgeRegistry<T> reg) {
        return new SDS<T>(reg);
    }

    public static <T> Object makeSerializer(JsonDeserializer<T> jds, JsonSerializer<T> js) {
        return new SDS2<T>(jds, js);
    }

    private static class SDS<T extends IForgeRegistryEntry<T>>
    implements JsonDeserializer<T>,
    JsonSerializer<T> {
        private final IForgeRegistry<T> reg;

        SDS(IForgeRegistry<T> reg) {
            this.reg = reg;
        }

        public JsonElement serialize(T src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src.getRegistryName().toString());
        }

        public T deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            IForgeRegistryEntry regObj = this.reg.getValue(new ResourceLocation(json.getAsString()));
            if (regObj == null) {
                throw new JsonSyntaxException("Failed to parse " + this.reg.getRegistryName() + " object with key " + json.getAsString());
            }
            return (T)regObj;
        }
    }

    private record SDS2<T>(JsonDeserializer<T> jds, JsonSerializer<T> js) implements JsonDeserializer<T>,
    JsonSerializer<T>
    {
        public JsonElement serialize(T src, Type typeOfSrc, JsonSerializationContext context) {
            return this.js.serialize(src, typeOfSrc, context);
        }

        public T deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return (T)this.jds.deserialize(json, typeOfT, context);
        }
    }
}

