/*
 * Decompiled with CFR 0.152.
 */
package shadows.placebo.json;

import java.util.ArrayList;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.level.ServerLevelAccessor;
import org.apache.logging.log4j.Logger;
import shadows.placebo.json.PlaceboJsonReloadListener;
import shadows.placebo.json.WeightedJsonReloadListener;

public abstract class DimWeightedJsonReloadListener<V extends PlaceboJsonReloadListener.TypeKeyed<V> & IDimWeighted>
extends WeightedJsonReloadListener<V> {
    public DimWeightedJsonReloadListener(Logger logger, String path, boolean synced, boolean subtypes) {
        super(logger, path, synced, subtypes);
    }

    @Nullable
    public V getRandomItem(Random rand, ServerLevelAccessor level) {
        return this.getRandomItem(rand, level.m_6018_().m_46472_().m_135782_());
    }

    @Nullable
    public V getRandomItem(Random rand, ResourceLocation dimId) {
        return this.getRandomItem(rand, 0.0f);
    }

    @Nullable
    public V getRandomItem(Random rand, float luck, ServerLevelAccessor level) {
        return this.getRandomItem(rand, luck, level.m_6018_().m_46472_().m_135782_());
    }

    @Nullable
    public V getRandomItem(Random rand, float luck, ResourceLocation dimId) {
        ArrayList list = new ArrayList(this.zeroLuckList.size());
        this.registry.values().stream().filter(IDimWeighted.matches(dimId)).map(l -> ((WeightedJsonReloadListener.ILuckyWeighted)((Object)l)).wrap(luck)).forEach(list::add);
        return (V)((PlaceboJsonReloadListener.TypeKeyed)WeightedRandom.m_146317_((Random)rand, list).map(WeightedEntry.Wrapper::m_146310_).orElse(null));
    }

    public static interface IDimWeighted
    extends WeightedJsonReloadListener.ILuckyWeighted {
        @Nullable
        public Set<ResourceLocation> getDimensions();

        public static Predicate<IDimWeighted> matches(ResourceLocation dimId) {
            return obj -> {
                Set<ResourceLocation> dims = obj.getDimensions();
                return dims == null || dims.isEmpty() || dims.contains(dimId);
            };
        }

        public static Predicate<IDimWeighted> matches(ServerLevelAccessor level) {
            return IDimWeighted.matches(level.m_6018_().m_46472_().m_135782_());
        }
    }
}

