/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.server;

import dev.latvian.mods.kubejs.core.PlayerSelector;
import dev.latvian.mods.kubejs.level.LevelJS;
import dev.latvian.mods.kubejs.level.ServerLevelJS;
import dev.latvian.mods.kubejs.net.SendDataFromServerMessage;
import dev.latvian.mods.kubejs.player.AdvancementJS;
import dev.latvian.mods.kubejs.player.EntityArrayList;
import dev.latvian.mods.kubejs.player.FakeServerPlayerDataJS;
import dev.latvian.mods.kubejs.player.ServerPlayerDataJS;
import dev.latvian.mods.kubejs.player.ServerPlayerJS;
import dev.latvian.mods.kubejs.script.AttachDataEvent;
import dev.latvian.mods.kubejs.server.IScheduledEventCallback;
import dev.latvian.mods.kubejs.server.ScheduledEvent;
import dev.latvian.mods.kubejs.server.ServerScriptManager;
import dev.latvian.mods.kubejs.util.AttachedData;
import dev.latvian.mods.kubejs.util.MessageSender;
import dev.latvian.mods.kubejs.util.WithAttachedData;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.advancements.Advancement;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ServerJS
implements MessageSender,
WithAttachedData {
    public static ServerJS instance;
    private MinecraftServer minecraftServer;
    public final transient ServerScriptManager serverScriptManager;
    public final transient List<ScheduledEvent> scheduledEvents;
    public final transient List<ScheduledEvent> scheduledTickEvents;
    public final transient Map<ResourceLocation, ServerLevelJS> levelMap;
    public final transient Map<UUID, ServerPlayerDataJS> playerMap;
    public final transient Map<UUID, FakeServerPlayerDataJS> fakePlayerMap;
    public final transient List<ServerLevelJS> allLevels;
    public final CompoundTag persistentData;
    public ServerLevelJS overworld;
    private AttachedData data;

    public ServerJS(MinecraftServer ms, ServerScriptManager m) {
        this.minecraftServer = ms;
        this.serverScriptManager = m;
        this.scheduledEvents = new LinkedList<ScheduledEvent>();
        this.scheduledTickEvents = new LinkedList<ScheduledEvent>();
        this.levelMap = new HashMap<ResourceLocation, ServerLevelJS>();
        this.playerMap = new HashMap<UUID, ServerPlayerDataJS>();
        this.fakePlayerMap = new HashMap<UUID, FakeServerPlayerDataJS>();
        this.allLevels = new ArrayList<ServerLevelJS>();
        this.persistentData = new CompoundTag();
    }

    public void release() {
        this.minecraftServer = null;
        this.scheduledEvents.clear();
        this.scheduledTickEvents.clear();
        this.playerMap.clear();
        this.fakePlayerMap.clear();
        this.overworld = null;
        this.levelMap.clear();
        this.allLevels.clear();
        this.data = null;
    }

    public void updateWorldList() {
        this.allLevels.clear();
        this.allLevels.addAll(this.levelMap.values());
    }

    @Override
    public AttachedData getData() {
        if (this.data == null) {
            this.data = new AttachedData(this);
        }
        return this.data;
    }

    public List<ServerLevelJS> getAllLevels() {
        return this.allLevels;
    }

    public ServerLevelJS getOverworld() {
        return this.overworld;
    }

    public MinecraftServer getMinecraftServer() {
        return this.minecraftServer;
    }

    public boolean isRunning() {
        return this.getMinecraftServer().m_130010_();
    }

    public boolean getHardcore() {
        return this.getMinecraftServer().m_7035_();
    }

    public boolean isSinglePlayer() {
        return this.getMinecraftServer().m_129792_();
    }

    public boolean isDedicated() {
        return this.getMinecraftServer().m_6982_();
    }

    public String getMotd() {
        return this.getMinecraftServer().m_129916_();
    }

    public void setMotd(Component text) {
        this.getMinecraftServer().m_129989_(text.getString());
    }

    public void stop() {
        this.getMinecraftServer().close();
    }

    @Override
    public Component getName() {
        return new TextComponent(this.getMinecraftServer().m_7326_());
    }

    @Override
    public Component getDisplayName() {
        return this.getMinecraftServer().m_129893_().m_81357_();
    }

    @Override
    public void tell(Component message) {
        this.getMinecraftServer().m_6352_(message, Util.f_137441_);
        for (ServerPlayer player : this.getMinecraftServer().m_6846_().m_11314_()) {
            player.m_6352_(message, Util.f_137441_);
        }
    }

    @Override
    public void setStatusMessage(Component message) {
        for (ServerPlayer player : this.getMinecraftServer().m_6846_().m_11314_()) {
            player.m_5661_(message, true);
        }
    }

    @Override
    public int runCommand(String command) {
        return this.getMinecraftServer().m_129892_().m_82117_(this.getMinecraftServer().m_129893_(), command);
    }

    @Override
    public int runCommandSilent(String command) {
        return this.getMinecraftServer().m_129892_().m_82117_(this.getMinecraftServer().m_129893_().m_81324_(), command);
    }

    public ServerLevelJS getLevel(ResourceLocation dimension) {
        ServerLevelJS level = this.levelMap.get(dimension);
        if (level != null) {
            return level;
        }
        ServerLevel minecraftLevel = this.getMinecraftServer().m_129880_(ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)dimension));
        if (minecraftLevel == null) {
            return null;
        }
        return this.wrapMinecraftLevel((Level)minecraftLevel);
    }

    @HideFromJS
    public ServerLevelJS wrapMinecraftLevel(Level minecraftLevel) {
        ServerLevelJS level = this.levelMap.get(minecraftLevel.m_46472_().m_135782_());
        if (level == null) {
            level = new ServerLevelJS(this, (ServerLevel)minecraftLevel);
            this.levelMap.put(minecraftLevel.m_46472_().m_135782_(), level);
            this.updateWorldList();
            AttachDataEvent.forLevel(level).invoke();
        }
        return level;
    }

    @Nullable
    public ServerPlayerJS getPlayer(PlayerSelector selector) {
        return selector.getPlayer(this.playerMap);
    }

    @Nullable
    public ServerPlayerJS getFakePlayer(PlayerSelector selector) {
        return selector.getPlayer(this.fakePlayerMap);
    }

    public EntityArrayList getPlayers() {
        return new EntityArrayList((LevelJS)this.overworld, this.getMinecraftServer().m_6846_().m_11314_());
    }

    public EntityArrayList getEntities() {
        EntityArrayList list = new EntityArrayList((LevelJS)this.overworld, 10);
        for (ServerLevelJS level : this.allLevels) {
            list.addAll(level.getEntities());
        }
        return list;
    }

    public EntityArrayList getEntities(String filter) {
        EntityArrayList list = new EntityArrayList((LevelJS)this.overworld, 10);
        for (ServerLevelJS level : this.allLevels) {
            list.addAll(level.getEntities(filter));
        }
        return list;
    }

    public ScheduledEvent schedule(long timer, @Nullable Object data, IScheduledEventCallback event) {
        ScheduledEvent e = new ScheduledEvent(this, false, timer, System.currentTimeMillis() + timer, data, event);
        this.scheduledEvents.add(e);
        return e;
    }

    public ScheduledEvent schedule(long timer, IScheduledEventCallback event) {
        return this.schedule(timer, null, event);
    }

    public ScheduledEvent scheduleInTicks(long ticks, @Nullable Object data, IScheduledEventCallback event) {
        ScheduledEvent e = new ScheduledEvent(this, true, ticks, this.overworld.getTime() + ticks, data, event);
        this.scheduledTickEvents.add(e);
        return e;
    }

    public ScheduledEvent scheduleInTicks(long ticks, IScheduledEventCallback event) {
        return this.scheduleInTicks(ticks, null, event);
    }

    public String toString() {
        return "Server";
    }

    @Nullable
    public AdvancementJS getAdvancement(ResourceLocation id) {
        Advancement a = this.getMinecraftServer().m_129889_().m_136041_(id);
        return a == null ? null : new AdvancementJS(a);
    }

    public void sendDataToAll(String channel, @Nullable CompoundTag data) {
        new SendDataFromServerMessage(channel, data).sendToAll(this.getMinecraftServer());
    }
}

