/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.level;

import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.ExplosionEvent;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.event.events.common.TickEvent;
import dev.latvian.mods.kubejs.level.ExplosionEventJS;
import dev.latvian.mods.kubejs.level.ServerLevelJS;
import dev.latvian.mods.kubejs.level.SimpleLevelEventJS;
import dev.latvian.mods.kubejs.script.AttachDataEvent;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.server.ServerJS;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;

public class KubeJSWorldEventHandler {
    public static void init() {
        LifecycleEvent.SERVER_LEVEL_LOAD.register(KubeJSWorldEventHandler::levelLoad);
        LifecycleEvent.SERVER_LEVEL_UNLOAD.register(KubeJSWorldEventHandler::levelUnload);
        TickEvent.SERVER_LEVEL_POST.register(KubeJSWorldEventHandler::levelPostTick);
        ExplosionEvent.PRE.register(KubeJSWorldEventHandler::preExplosion);
        ExplosionEvent.DETONATE.register(KubeJSWorldEventHandler::detonateExplosion);
    }

    private static void levelLoad(ServerLevel level) {
        if (ServerJS.instance != null && ServerJS.instance.overworld != null && !ServerJS.instance.levelMap.containsKey(level.m_46472_().m_135782_())) {
            ServerLevelJS l = new ServerLevelJS(ServerJS.instance, level);
            ServerJS.instance.levelMap.put(level.m_46472_().m_135782_(), l);
            ServerJS.instance.updateWorldList();
            AttachDataEvent.forLevel(l).invoke();
            new SimpleLevelEventJS(l).post(ScriptType.SERVER, "level.load");
        }
    }

    private static void levelUnload(ServerLevel level) {
        if (ServerJS.instance != null && ServerJS.instance.overworld != null && ServerJS.instance.levelMap.containsKey(level.m_46472_().m_135782_())) {
            ServerLevelJS l = ServerJS.instance.wrapMinecraftLevel((Level)level);
            new SimpleLevelEventJS(l).post(ScriptType.SERVER, "level.unload");
            ServerJS.instance.levelMap.remove(l.getDimension());
            ServerJS.instance.updateWorldList();
        }
    }

    private static void levelPostTick(ServerLevel level) {
        ServerLevelJS l = ServerJS.instance.wrapMinecraftLevel((Level)level);
        new SimpleLevelEventJS(l).post(ScriptType.SERVER, "level.tick");
    }

    private static EventResult preExplosion(Level level, Explosion explosion) {
        ExplosionEventJS.Pre event = new ExplosionEventJS.Pre(level, explosion);
        if (event.post("level.explosion.pre")) {
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }

    private static void detonateExplosion(Level level, Explosion explosion, List<Entity> affectedEntities) {
        new ExplosionEventJS.Post(level, explosion, affectedEntities).post("level.explosion.post");
    }
}

