/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.item.ingredient;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.latvian.mods.kubejs.item.ItemStackJS;
import dev.latvian.mods.kubejs.item.ingredient.IngredientJS;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public final class WeakNBTIngredientJS
implements IngredientJS {
    private final ItemStackJS item;

    public WeakNBTIngredientJS(ItemStackJS i) {
        this.item = i;
    }

    @Override
    public boolean test(ItemStackJS stack) {
        if (this.item.areItemsEqual(stack) && this.item.hasNBT() == stack.hasNBT()) {
            if (this.item.hasNBT()) {
                for (String key : this.item.getNbt().m_128431_()) {
                    if (Objects.equals(this.item.getNbt().m_128423_(key), stack.getNbt().m_128423_(key))) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean testVanilla(ItemStack stack) {
        if (this.item.areItemsEqual(stack) && this.item.hasNBT() == stack.m_41782_()) {
            if (this.item.hasNBT()) {
                CompoundTag t = this.item.getNbt();
                for (String key : t.m_128431_()) {
                    if (Objects.equals(t.m_128423_(key), stack.m_41783_().m_128423_(key))) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean testVanillaItem(Item i) {
        return this.item.getItem() == i;
    }

    @Override
    public Set<ItemStackJS> getStacks() {
        return this.item.getStacks();
    }

    @Override
    public Set<Item> getVanillaItems() {
        return Collections.singleton(this.item.getItem());
    }

    @Override
    public IngredientJS copy() {
        return new WeakNBTIngredientJS(this.item.copy());
    }

    @Override
    public JsonElement toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("item", this.item.getId());
        if (this.item.hasNBT()) {
            json.addProperty("type", "forge:partial_nbt");
            json.addProperty("nbt", this.item.getNbtString());
        }
        return json;
    }

    public String toString() {
        String stack = this.item.toString().replaceAll("^'(.*)'$", "Item.of($1)");
        return stack + ".weakNBT()";
    }
}

