/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.item;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import dev.latvian.mods.kubejs.core.ItemKJS;
import dev.latvian.mods.kubejs.core.ModifiableItemKJS;
import dev.latvian.mods.kubejs.item.FoodBuilder;
import dev.latvian.mods.kubejs.item.MutableToolTier;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;

public class ItemModificationProperties {
    private static final UUID BASE_ATTACK_DAMAGE_UUID = UUID.fromString("CB3F55D3-645C-4F38-A497-9C13A33DB5CF");
    private static final UUID BASE_ATTACK_SPEED_UUID = UUID.fromString("FA233E1C-4180-4865-B01B-BCCE9785ACA3");
    private static final UUID[] ARMOR_MODIFIER_UUID_PER_SLOT = new UUID[]{UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6B"), UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0D"), UUID.fromString("9F3D476D-C118-4544-8365-64846904B48E"), UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150")};
    public final ItemKJS item;

    public ItemModificationProperties(ItemKJS i) {
        this.item = i;
    }

    public void setMaxStackSize(int i) {
        this.item.setMaxStackSizeKJS(i);
    }

    public void setMaxDamage(int i) {
        this.item.setMaxDamageKJS(i);
    }

    public void setBurnTime(int i) {
        this.item.setBurnTimeKJS(i);
    }

    public void setCraftingRemainder(Item i) {
        this.item.setCraftingRemainderKJS(i);
    }

    public void setFireResistant(boolean b) {
        this.item.setFireResistantKJS(b);
    }

    public void setRarity(Rarity r) {
        this.item.setRarityKJS(r);
    }

    public void setDigSpeed(float speed) {
        ItemKJS itemKJS = this.item;
        if (!(itemKJS instanceof DiggerItem)) {
            throw new IllegalArgumentException("Item is not a digger item (axe, shovel, etc.)!");
        }
        DiggerItem diggerItem = (DiggerItem)itemKJS;
        diggerItem.f_40980_ = speed;
    }

    public float getDigSpeed() {
        ItemKJS itemKJS = this.item;
        if (itemKJS instanceof DiggerItem) {
            DiggerItem diggerItem = (DiggerItem)itemKJS;
            return diggerItem.f_40980_;
        }
        throw new IllegalArgumentException("Item is not a digger item (axe, shovel, etc.)!");
    }

    public void setTier(Consumer<MutableToolTier> c) {
        ItemKJS itemKJS = this.item;
        if (!(itemKJS instanceof TieredItem)) {
            throw new IllegalArgumentException("Item is not a tool/tiered item!");
        }
        TieredItem tiered = (TieredItem)itemKJS;
        tiered.f_43306_ = (Tier)Util.m_137469_((Object)new MutableToolTier(tiered.f_43306_), c);
    }

    public void setFoodProperties(Consumer<FoodBuilder> consumer) {
        Item originalItem = (Item)this.item;
        FoodProperties fp = originalItem.m_41473_();
        FoodBuilder builder = fp == null ? new FoodBuilder() : new FoodBuilder(fp);
        consumer.accept(builder);
        this.item.setFoodPropertiesKJS(builder.build());
    }

    public void setAttackDamage(double attackDamage) {
        if (this.item instanceof ArmorItem) {
            throw new UnsupportedOperationException("Modifying attack damage of unsupported item: " + this.item);
        }
        this.removeAttribute(Attributes.f_22281_, BASE_ATTACK_DAMAGE_UUID);
        this.addAttribute(Attributes.f_22281_, BASE_ATTACK_DAMAGE_UUID, "Tool modifier", attackDamage, AttributeModifier.Operation.ADDITION);
    }

    public void setAttackSpeed(double attackSpeed) {
        if (this.item instanceof ArmorItem) {
            throw new UnsupportedOperationException("Modifying attack speed of unsupported item: " + this.item);
        }
        this.removeAttribute(Attributes.f_22283_, BASE_ATTACK_SPEED_UUID);
        this.addAttribute(Attributes.f_22283_, BASE_ATTACK_SPEED_UUID, "Tool modifier", attackSpeed, AttributeModifier.Operation.ADDITION);
    }

    public void setArmorProtection(double armorProtection) {
        ItemKJS itemKJS = this.item;
        if (!(itemKJS instanceof ArmorItem)) {
            throw new UnsupportedOperationException("Modifying armor value of unsupported item: " + this.item.toString());
        }
        ArmorItem armor = (ArmorItem)itemKJS;
        UUID uuid = ARMOR_MODIFIER_UUID_PER_SLOT[armor.m_40402_().m_20749_()];
        this.removeAttribute(Attributes.f_22284_, uuid);
        this.addAttribute(Attributes.f_22284_, uuid, "Armor modifier", armorProtection, AttributeModifier.Operation.ADDITION);
    }

    public void setArmorToughness(double armorToughness) {
        ItemKJS itemKJS = this.item;
        if (!(itemKJS instanceof ArmorItem)) {
            throw new UnsupportedOperationException("Modifying protection of unsupported item: " + this.item.toString());
        }
        ArmorItem armor = (ArmorItem)itemKJS;
        UUID uuid = ARMOR_MODIFIER_UUID_PER_SLOT[armor.m_40402_().m_20749_()];
        this.removeAttribute(Attributes.f_22285_, uuid);
        this.addAttribute(Attributes.f_22285_, uuid, "Armor modifier", armorToughness, AttributeModifier.Operation.ADDITION);
    }

    public void setArmorKnockbackResistance(double knockbackResistance) {
        ItemKJS itemKJS = this.item;
        if (!(itemKJS instanceof ArmorItem)) {
            throw new UnsupportedOperationException("Modifying protection of unsupported item: " + this.item.toString());
        }
        ArmorItem armor = (ArmorItem)itemKJS;
        UUID uuid = ARMOR_MODIFIER_UUID_PER_SLOT[armor.m_40402_().m_20749_()];
        this.removeAttribute(Attributes.f_22278_, uuid);
        this.addAttribute(Attributes.f_22278_, uuid, "Armor modifier", knockbackResistance, AttributeModifier.Operation.ADDITION);
    }

    public void addAttribute(Attribute attribute, UUID uuid, String name, double d, AttributeModifier.Operation operation) {
        ItemKJS itemKJS = this.item;
        if (!(itemKJS instanceof ModifiableItemKJS)) {
            throw new UnsupportedOperationException("Adding attribute in unsupported item: " + this.item.toString());
        }
        ModifiableItemKJS modifiableItemKJS = (ModifiableItemKJS)((Object)itemKJS);
        Multimap<Attribute, AttributeModifier> attributes = modifiableItemKJS.getMutableAttributeMap();
        attributes.put((Object)attribute, (Object)new AttributeModifier(uuid, name, d, operation));
    }

    public void removeAttribute(Attribute attribute, UUID uuid) {
        ItemKJS itemKJS = this.item;
        if (!(itemKJS instanceof ModifiableItemKJS)) {
            throw new UnsupportedOperationException("Removing attribute in unsupported item: " + this.item.toString());
        }
        ModifiableItemKJS modifiableItem = (ModifiableItemKJS)((Object)itemKJS);
        Multimap<Attribute, AttributeModifier> attributes = modifiableItem.getMutableAttributeMap();
        Collection modifiers = attributes.get((Object)attribute);
        Optional<AttributeModifier> value = modifiers.stream().filter(modifier -> uuid.equals(modifier.m_22209_())).findFirst();
        value.ifPresent(modifier -> attributes.remove((Object)attribute, modifier));
    }

    public List<AttributeModifier> getAttributes(Attribute attribute) {
        ItemKJS itemKJS = this.item;
        if (!(itemKJS instanceof ModifiableItemKJS)) {
            throw new UnsupportedOperationException("Getting attribute in unsupported item: " + this.item.toString());
        }
        ModifiableItemKJS modifiableItem = (ModifiableItemKJS)((Object)itemKJS);
        Multimap<Attribute, AttributeModifier> attributes = modifiableItem.getAttributeMapKJS();
        return ImmutableList.copyOf((Collection)attributes.get((Object)attribute));
    }
}

