/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.entity;

import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.EntityEvent;
import dev.latvian.mods.kubejs.entity.CheckLivingEntitySpawnEventJS;
import dev.latvian.mods.kubejs.entity.EntitySpawnedEventJS;
import dev.latvian.mods.kubejs.entity.LivingEntityDeathEventJS;
import dev.latvian.mods.kubejs.entity.LivingEntityHurtEventJS;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.server.ServerJS;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public class KubeJSEntityEventHandler {
    public static void init() {
        EntityEvent.LIVING_CHECK_SPAWN.register(KubeJSEntityEventHandler::checkSpawn);
        EntityEvent.LIVING_DEATH.register(KubeJSEntityEventHandler::livingDeath);
        EntityEvent.LIVING_HURT.register(KubeJSEntityEventHandler::livingHurt);
        EntityEvent.ADD.register(KubeJSEntityEventHandler::entitySpawned);
    }

    private static EventResult checkSpawn(LivingEntity entity, LevelAccessor la, double x, double y, double z, MobSpawnType type, BaseSpawner spawner) {
        Level level;
        if (ServerJS.instance != null && ServerJS.instance.overworld != null && !la.m_5776_() && la instanceof Level && new CheckLivingEntitySpawnEventJS(entity, level = (Level)la, x, y, z, type).post(ScriptType.SERVER, "entity.check_spawn")) {
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }

    private static EventResult livingDeath(LivingEntity entity, DamageSource source) {
        if (entity != null && new LivingEntityDeathEventJS(entity, source).post("entity.death")) {
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }

    private static EventResult livingHurt(LivingEntity entity, DamageSource source, float amount) {
        if (entity != null && amount > 0.0f && new LivingEntityHurtEventJS(entity, source, amount).post("entity.hurt")) {
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }

    private static EventResult entitySpawned(Entity entity, Level level) {
        if (entity != null && ServerJS.instance != null && ServerJS.instance.overworld != null && !level.m_5776_() && new EntitySpawnedEventJS(entity, level).post(ScriptType.SERVER, "entity.spawned")) {
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }
}

