/*
 * Decompiled with CFR 0.152.
 */
package muramasa.gregtech.tile.single;

import muramasa.antimatter.capability.machine.MachineRecipeHandler;
import muramasa.antimatter.machine.Tier;
import muramasa.antimatter.machine.event.ContentEvent;
import muramasa.antimatter.machine.event.IMachineEvent;
import muramasa.antimatter.machine.types.Machine;
import muramasa.antimatter.recipe.IRecipe;
import muramasa.antimatter.tile.TileEntityMachine;
import muramasa.antimatter.util.AntimatterPlatformUtils;
import muramasa.gregtech.data.Machines;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class TileEntitySteamMachine
extends TileEntityMachine<TileEntitySteamMachine> {
    public static final TagKey<Fluid> STEAM = TagKey.m_203882_((ResourceKey)Registry.f_122899_, (ResourceLocation)new ResourceLocation(AntimatterPlatformUtils.isForge() ? "forge" : "c", "steam"));

    public TileEntitySteamMachine(Machine<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.recipeHandler.set(() -> new SteamMachineRecipeHandler(this));
    }

    public Tier getPowerLevel() {
        return Tier.LV;
    }

    public static class SteamMachineRecipeHandler
    extends MachineRecipeHandler<TileEntitySteamMachine> {
        protected boolean isSteamClear = false;

        public SteamMachineRecipeHandler(TileEntitySteamMachine tile) {
            super((TileEntityMachine)tile);
        }

        public boolean consumeResourceForRecipe(boolean simulate) {
            return ((TileEntitySteamMachine)this.tile).fluidHandler.map(t -> t.consumeTaggedInput(STEAM, (int)this.getPower(), simulate).getAmount() > 0).orElse(false);
        }

        protected boolean validateRecipe(IRecipe r) {
            return r.getPower() <= (long)Tier.LV.getVoltage();
        }

        public void setSteamClear(boolean steamClear) {
            this.isSteamClear = steamClear;
        }

        protected boolean canRecipeContinue() {
            this.isSteamClear = ((TileEntitySteamMachine)this.tile).f_58857_.m_46859_(((TileEntitySteamMachine)this.tile).f_58858_.m_142300_(((TileEntitySteamMachine)this.tile).getOutputFacing()));
            return super.canRecipeContinue() && this.isSteamClear;
        }

        public float getClientProgress() {
            if (((TileEntitySteamMachine)this.tile).getMachineType() == Machines.STEAM_FORGE_HAMMER) {
                float percent = (float)this.currentProgress / ((float)this.maxProgress / 3.0f);
                if (percent > 2.0f) {
                    percent -= 2.0f;
                } else if (percent > 1.0f) {
                    percent -= 1.0f;
                }
                return percent;
            }
            return super.getClientProgress();
        }

        public int getOverclock() {
            return ((TileEntitySteamMachine)this.tile).getMachineTier() == Tier.BRONZE ? 0 : 1;
        }

        public boolean accepts(FluidStack stack) {
            return stack.getFluid().m_205069_().m_203656_(STEAM);
        }

        protected boolean consumeGeneratorResources(boolean simulate) {
            return this.isSteamClear && super.consumeGeneratorResources(simulate);
        }

        public void onMachineEvent(IMachineEvent event, Object ... data) {
            super.onMachineEvent(event, data);
            if (event instanceof ContentEvent && event == ContentEvent.FLUID_INPUT_CHANGED && data != null && data.length > 0 && data[0] instanceof FluidStack && ((FluidStack)data[0]).getFluid().m_205069_().m_203656_(STEAM)) {
                this.checkRecipe();
            }
        }
    }
}

