/*
 * Decompiled with CFR 0.152.
 */
package muramasa.gregtech.tile.single;

import java.util.Optional;
import muramasa.antimatter.capability.FluidHandler;
import muramasa.antimatter.capability.fluid.FluidTanks;
import muramasa.antimatter.capability.machine.MachineFluidHandler;
import muramasa.antimatter.capability.machine.MachineRecipeHandler;
import muramasa.antimatter.machine.MachineState;
import muramasa.antimatter.machine.event.ContentEvent;
import muramasa.antimatter.machine.types.Machine;
import muramasa.antimatter.tile.TileEntityBase;
import muramasa.antimatter.tile.TileEntityMachine;
import muramasa.antimatter.util.Utils;
import muramasa.gregtech.data.Materials;
import muramasa.gregtech.tile.single.ISteamBoilerHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import tesseract.TesseractCapUtils;

public class TileEntitySolarBoiler
extends TileEntityMachine<TileEntitySolarBoiler> {
    public TileEntitySolarBoiler(Machine<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.fluidHandler.set(() -> new LavaBoilerFluidHandler(this));
        this.recipeHandler.set(() -> new SolarBoilerRecipeHandler(this));
    }

    public int getHeat() {
        return this.recipeHandler.map(r -> ((SolarBoilerRecipeHandler)r).getHeat()).orElse(0);
    }

    public int getMaxHeat() {
        return this.recipeHandler.map(r -> ((SolarBoilerRecipeHandler)r).getMaxHeat()).orElse(0);
    }

    public boolean isAllowedToWork() {
        return this.recipeHandler.map(r -> ((SolarBoilerRecipeHandler)r).isAllowedToWork()).orElse(false);
    }

    public static class SolarBoilerRecipeHandler
    extends MachineRecipeHandler<TileEntitySolarBoiler>
    implements ISteamBoilerHandler {
        int maxHeat = 1000;
        int heat;
        int lossTimer = 0;
        boolean hadNoWater;

        public SolarBoilerRecipeHandler(TileEntitySolarBoiler tile) {
            super((TileEntityMachine)tile);
        }

        @Override
        public int getProcessDelay() {
            return 25;
        }

        @Override
        public int getLossTimerMax() {
            return 45;
        }

        @Override
        public int getHeat() {
            return this.heat;
        }

        @Override
        public void setHeat(int heat) {
            this.heat = heat;
        }

        @Override
        public int getLossTimer() {
            return this.lossTimer;
        }

        @Override
        public void setLossTimer(int lossTimer) {
            this.lossTimer = lossTimer;
        }

        @Override
        public boolean hadNoWater() {
            return this.hadNoWater;
        }

        @Override
        public void setHadNoWater(boolean hadNoWater) {
            this.hadNoWater = hadNoWater;
        }

        @Override
        public TileEntityMachine<?> getTile() {
            return this.tile;
        }

        @Override
        public void exportFluid() {
            this.exportFluidFromMachineToSide(((TileEntitySolarBoiler)this.tile).getFacing());
        }

        public int getMaxHeat() {
            return this.maxHeat;
        }

        private boolean isAllowedToWork() {
            return ((TileEntitySolarBoiler)this.tile).m_58904_().m_45527_(((TileEntitySolarBoiler)this.tile).m_58899_().m_7494_()) && ((TileEntitySolarBoiler)this.tile).m_58904_().m_46461_() && !((TileEntitySolarBoiler)this.tile).m_58904_().m_46758_(((TileEntitySolarBoiler)this.tile).m_58899_().m_7494_()) && !((TileEntitySolarBoiler)this.tile).m_58904_().m_46470_();
        }

        public void onServerUpdate() {
            this.tick();
            if (((TileEntitySolarBoiler)this.tile).m_58904_().m_46467_() % 12L == 0L) {
                if (this.isAllowedToWork()) {
                    ++this.heat;
                    if (this.heat >= this.maxHeat) {
                        this.heat = this.maxHeat;
                    }
                    this.setActive(true);
                } else {
                    this.setActive(false);
                }
            }
            super.onServerUpdate();
        }

        public void exportFluidFromMachineToSide(Direction side) {
            BlockEntity adjTile = ((TileEntitySolarBoiler)this.tile).m_58904_().m_7702_(((TileEntitySolarBoiler)this.tile).m_58899_().m_142300_(side));
            if (adjTile == null) {
                return;
            }
            Optional cap = TesseractCapUtils.getFluidHandler((BlockEntity)adjTile, (Direction)side.m_122424_());
            ((TileEntitySolarBoiler)this.tile).fluidHandler.ifPresent(f -> cap.ifPresent(other -> Utils.transferFluids((IFluidHandler)f.getOutputTanks(), (IFluidHandler)other, (int)1000)));
        }

        public void setActive(boolean t) {
            if (t && ((TileEntitySolarBoiler)this.tile).getMachineState() != MachineState.ACTIVE) {
                ((TileEntitySolarBoiler)this.tile).setMachineState(MachineState.ACTIVE);
            } else if (!t && ((TileEntitySolarBoiler)this.tile).getMachineState() == MachineState.ACTIVE) {
                ((TileEntitySolarBoiler)this.tile).setMachineState(MachineState.IDLE);
            }
        }

        public boolean accepts(FluidStack fluid) {
            return fluid.getFluid() == Fluids.f_76193_ || fluid.getFluid() == Materials.DistilledWater.getLiquid();
        }

        public boolean canOutput() {
            return true;
        }

        public CompoundTag serializeNBT() {
            CompoundTag nbt = super.serializeNBT();
            nbt.m_128405_("heat", this.heat);
            nbt.m_128405_("maxHeat", this.maxHeat);
            nbt.m_128405_("lossTimer", this.lossTimer);
            nbt.m_128379_("hadNoWater", this.hadNoWater);
            return nbt;
        }

        public void deserializeNBT(CompoundTag nbt) {
            super.deserializeNBT(nbt);
            this.heat = nbt.m_128451_("heat");
            this.maxHeat = nbt.m_128451_("maxHeat");
            this.lossTimer = nbt.m_128451_("lossTimer");
            this.hadNoWater = nbt.m_128471_("hadNoWater");
        }
    }

    public static class LavaBoilerFluidHandler
    extends MachineFluidHandler<TileEntitySolarBoiler> {
        public LavaBoilerFluidHandler(TileEntitySolarBoiler tile) {
            super((TileEntityMachine)tile, 16000, 1000 * (250 + tile.getMachineTier().getIntegerId()));
            this.tanks.put(FluidHandler.FluidDirection.INPUT, FluidTanks.create((TileEntityBase)tile, (ContentEvent)ContentEvent.FLUID_INPUT_CHANGED, b -> {
                b.tank(p -> p.getFluid() == Fluids.f_76193_ || p.getFluid() == Materials.DistilledWater.getLiquid(), 16000);
                return b;
            }));
            this.tanks.put(FluidHandler.FluidDirection.OUTPUT, FluidTanks.create((TileEntityBase)tile, (ContentEvent)ContentEvent.FLUID_OUTPUT_CHANGED, b -> {
                b.tank(16000);
                return b;
            }));
        }

        protected FluidTanks getCellAccessibleTanks() {
            return this.getInputTanks();
        }
    }
}

