/*
 * Decompiled with CFR 0.152.
 */
package muramasa.gregtech.tile.single;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Objects;
import muramasa.antimatter.capability.item.ITrackedHandler;
import muramasa.antimatter.capability.machine.MachineEnergyHandler;
import muramasa.antimatter.gui.SlotType;
import muramasa.antimatter.gui.event.GuiEvents;
import muramasa.antimatter.gui.event.IGuiEvent;
import muramasa.antimatter.machine.MachineFlag;
import muramasa.antimatter.machine.event.ContentEvent;
import muramasa.antimatter.machine.event.IMachineEvent;
import muramasa.antimatter.machine.types.Machine;
import muramasa.antimatter.tile.TileEntityMachine;
import muramasa.antimatter.util.AntimatterPlatformUtils;
import muramasa.antimatter.util.Utils;
import muramasa.gregtech.data.SlotTypes;
import muramasa.gregtech.tile.single.IFilterable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.items.IItemHandler;
import tesseract.TesseractCapUtils;
import tesseract.api.gt.IEnergyHandler;

public class TileEntityItemFilter
extends TileEntityMachine<TileEntityItemFilter>
implements IFilterable {
    boolean blacklist = false;
    boolean nbt = true;
    boolean outputRedstone = false;
    boolean invertRedstone = false;
    boolean emitEnergy = false;

    public TileEntityItemFilter(Machine<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        if (type.has(MachineFlag.ENERGY)) {
            this.energyHandler.set(() -> new MachineEnergyHandler<TileEntityItemFilter>(this, 0L, (long)this.getMachineTier().getVoltage() * 66L, this.getMachineTier().getVoltage(), this.getMachineTier().getVoltage(), 1, 1){

                public boolean canOutput(Direction direction) {
                    return super.canOutput(direction) && direction == ((TileEntityItemFilter)this.tile).getFacing().m_122424_() && ((TileEntityItemFilter)this.tile).emitEnergy;
                }
            });
        }
    }

    @Override
    public boolean accepts(ItemStack stack) {
        boolean hasItem = this.itemHandler.map(h -> {
            ObjectArrayList list = new ObjectArrayList();
            ITrackedHandler outputs = h.getHandler(SlotType.DISPLAY_SETTABLE);
            for (int i = 0; i < outputs.getSlots(); ++i) {
                ItemStack slot = outputs.getStackInSlot(i);
                if (slot.m_41619_() || slot.m_41720_() != stack.m_41720_() || this.nbt && !Objects.equals(slot.m_41783_(), stack.m_41783_())) continue;
                list.add(slot.m_41777_().m_41720_());
            }
            return list.isEmpty() == this.blacklist;
        }).orElse(false);
        return hasItem;
    }

    public void onGuiEvent(IGuiEvent event, Player playerEntity) {
        if (event.getFactory() == GuiEvents.EXTRA_BUTTON) {
            int[] data = ((GuiEvents.GuiEvent)event).data;
            switch (data[0]) {
                case 0: {
                    this.emitEnergy = !this.emitEnergy;
                    playerEntity.m_6352_((Component)new TextComponent(this.emitEnergy ? "Emit energy to output side" : "Don't emit energy"), playerEntity.m_142081_());
                    AntimatterPlatformUtils.markAndNotifyBlock((Level)this.f_58857_, (BlockPos)this.m_58899_(), (LevelChunk)this.f_58857_.m_46745_(this.m_58899_()), (BlockState)this.m_58900_(), (BlockState)this.m_58900_(), (int)1, (int)512);
                    break;
                }
                case 1: {
                    this.outputRedstone = !this.outputRedstone;
                    playerEntity.m_6352_((Component)new TextComponent(this.outputRedstone ? "Emit redstone if slots contain something" : "Don't emit redstone"), playerEntity.m_142081_());
                    AntimatterPlatformUtils.markAndNotifyBlock((Level)this.f_58857_, (BlockPos)this.m_58899_(), (LevelChunk)this.f_58857_.m_46745_(this.m_58899_()), (BlockState)this.m_58900_(), (BlockState)this.m_58900_(), (int)1, (int)512);
                    break;
                }
                case 2: {
                    this.invertRedstone = !this.invertRedstone;
                    playerEntity.m_6352_((Component)new TextComponent((this.invertRedstone ? "I" : "Don't i") + "nvert redstone"), playerEntity.m_142081_());
                    AntimatterPlatformUtils.markAndNotifyBlock((Level)this.f_58857_, (BlockPos)this.m_58899_(), (LevelChunk)this.f_58857_.m_46745_(this.m_58899_()), (BlockState)this.m_58900_(), (BlockState)this.m_58900_(), (int)1, (int)512);
                    break;
                }
                case 3: {
                    this.blacklist = !this.blacklist;
                    playerEntity.m_6352_((Component)new TextComponent((this.blacklist ? "I" : "Don't i") + "nvert filter"), playerEntity.m_142081_());
                    break;
                }
                case 4: {
                    this.nbt = !this.nbt;
                    playerEntity.m_6352_((Component)new TextComponent(this.nbt ? "NBT has to match" : "Ignore NBT"), playerEntity.m_142081_());
                }
            }
        }
    }

    public void serverTick(Level level, BlockPos pos, BlockState state) {
        super.serverTick(level, pos, state);
        if (this.getCover(this.getFacing().m_122424_()).isEmpty() && this.energyHandler.map(e -> e.getEnergy() > 0L).orElse(false).booleanValue() && this.processItemOutput()) {
            this.energyHandler.ifPresent(e -> Utils.extractEnergy((IEnergyHandler)e, (long)1L));
        }
    }

    public void onMachineEvent(IMachineEvent event, Object ... data) {
        super.onMachineEvent(event, data);
        if ((event == ContentEvent.ITEM_OUTPUT_CHANGED || event == ContentEvent.ITEM_INPUT_CHANGED) && this.outputRedstone && !this.m_58904_().m_5776_()) {
            AntimatterPlatformUtils.markAndNotifyBlock((Level)this.f_58857_, (BlockPos)this.m_58899_(), (LevelChunk)this.f_58857_.m_46745_(this.m_58899_()), (BlockState)this.m_58900_(), (BlockState)this.m_58900_(), (int)1, (int)512);
        }
    }

    protected boolean processItemOutput() {
        Direction outputDir = this.getFacing().m_122424_();
        BlockEntity adjTile = Utils.getTile((BlockGetter)this.m_58904_(), (BlockPos)this.m_58899_().m_142300_(outputDir));
        if (adjTile == null) {
            return false;
        }
        boolean[] booleans = new boolean[]{false};
        TesseractCapUtils.getItemHandler((BlockEntity)adjTile, (Direction)outputDir.m_122424_()).ifPresent(adjHandler -> {
            booleans[0] = this.itemHandler.map(h -> Utils.transferItems((IItemHandler)h.getHandler(SlotTypes.FILTERABLE), (IItemHandler)adjHandler, (boolean)true)).orElse(false);
        });
        return booleans[0];
    }

    public int getWeakRedstonePower(Direction facing) {
        if (this.outputRedstone) {
            int[] redstone = new int[]{this.itemHandler.map(i -> {
                for (int slot = 0; slot < i.getHandler(SlotTypes.FILTERABLE).getSlots(); ++slot) {
                    ItemStack stack = i.getHandler(SlotTypes.FILTERABLE).getStackInSlot(slot);
                    if (stack.m_41619_()) continue;
                    return this.invertRedstone ? 0 : 15;
                }
                return this.invertRedstone ? 15 : 0;
            }).orElse(0)};
            if (redstone[0] > 0) {
                return redstone[0];
            }
        }
        return super.getWeakRedstonePower(facing);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.blacklist = tag.m_128471_("blacklist");
        this.nbt = tag.m_128471_("nbt");
        this.outputRedstone = tag.m_128471_("outputRedstone");
        this.invertRedstone = tag.m_128471_("invertRedstone");
        this.emitEnergy = tag.m_128471_("emitsEnergy");
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128379_("blacklist", this.blacklist);
        tag.m_128379_("nbt", this.nbt);
        tag.m_128379_("outputRedstone", this.outputRedstone);
        tag.m_128379_("invertRedstone", this.invertRedstone);
        tag.m_128379_("emitEnergy", this.emitEnergy);
    }

    public boolean isBlacklist() {
        return this.blacklist;
    }

    public boolean isEmitEnergy() {
        return this.emitEnergy;
    }

    public boolean isInvertRedstone() {
        return this.invertRedstone;
    }

    public boolean isNbt() {
        return this.nbt;
    }

    public boolean isOutputRedstone() {
        return this.outputRedstone;
    }
}

