/*
 * Decompiled with CFR 0.152.
 */
package muramasa.gregtech.tile.single;

import java.util.List;
import javax.annotation.Nonnull;
import muramasa.antimatter.capability.FluidHandler;
import muramasa.antimatter.capability.fluid.FluidTanks;
import muramasa.antimatter.capability.machine.MachineFluidHandler;
import muramasa.antimatter.cover.CoverOutput;
import muramasa.antimatter.cover.ICover;
import muramasa.antimatter.machine.event.ContentEvent;
import muramasa.antimatter.machine.types.Machine;
import muramasa.antimatter.tile.TileEntityBase;
import muramasa.antimatter.tile.TileEntityMachine;
import muramasa.gregtech.data.Materials;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;

public class TileEntityInfiniteFluid
extends TileEntityMachine<TileEntityInfiniteFluid> {
    public void onFirstTick() {
        super.onFirstTick();
        this.coverHandler.ifPresent(c -> {
            ICover stack = c.getOutputCover();
            ((CoverOutput)stack).setEjects(true, false);
        });
    }

    public void serverTick(Level level, BlockPos pos, BlockState state) {
        super.serverTick(level, pos, state);
        this.coverHandler.ifPresent(c -> {
            ICover patt1442$temp = c.get(c.getOutputFacing());
            if (patt1442$temp instanceof CoverOutput) {
                CoverOutput stack = (CoverOutput)patt1442$temp;
                stack.manualOutput();
            }
        });
    }

    public TileEntityInfiniteFluid(Machine<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.fluidHandler.set(() -> new InfiniteFluidHandler(this));
    }

    public List<String> getInfo() {
        List info = super.getInfo();
        this.energyHandler.ifPresent(h -> info.add("Amperage Out: " + h.getOutputAmperage()));
        return info;
    }

    protected static class InfiniteFluidHandler
    extends MachineFluidHandler<TileEntityInfiniteFluid> {
        public InfiniteFluidHandler(TileEntityInfiniteFluid tile) {
            super((TileEntityMachine)tile);
            this.tanks.put(FluidHandler.FluidDirection.OUTPUT, FluidTanks.create((TileEntityBase)tile, (ContentEvent)ContentEvent.FLUID_OUTPUT_CHANGED, b -> {
                b.tank(Integer.MAX_VALUE);
                return b;
            }));
            FluidTank tank = ((FluidTanks)this.tanks.get(FluidHandler.FluidDirection.OUTPUT)).getTank(0);
            tank.setFluid(Materials.Steam.getGas(0x7FFFFFFE));
        }

        public boolean canInput(FluidStack fluid, Direction direction) {
            return false;
        }

        public boolean canInput(Direction direction) {
            return false;
        }

        @Nonnull
        public FluidStack drain(FluidStack stack, IFluidHandler.FluidAction action) {
            return stack.copy();
        }

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return Materials.Steam.getGas(maxDrain);
        }

        @NotNull
        public FluidStack drain(long maxDrain, IFluidHandler.FluidAction action) {
            return Materials.Steam.getGas(maxDrain);
        }
    }
}

