/*
 * Decompiled with CFR 0.152.
 */
package muramasa.gregtech.tile.single;

import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;
import muramasa.antimatter.capability.FluidHandler;
import muramasa.antimatter.capability.fluid.FluidTanks;
import muramasa.antimatter.capability.machine.MachineFluidHandler;
import muramasa.antimatter.capability.machine.MachineRecipeHandler;
import muramasa.antimatter.machine.MachineState;
import muramasa.antimatter.machine.Tier;
import muramasa.antimatter.machine.event.ContentEvent;
import muramasa.antimatter.machine.types.Machine;
import muramasa.antimatter.tile.TileEntityBase;
import muramasa.antimatter.tile.TileEntityMachine;
import muramasa.antimatter.util.Utils;
import muramasa.gregtech.data.Materials;
import muramasa.gregtech.tile.single.ISteamBoilerHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import tesseract.TesseractCapUtils;

public class TileEntityCoalBoiler
extends TileEntityMachine<TileEntityCoalBoiler> {
    int maxHeat = 500;
    int heat;
    int fuel = 0;
    int maxFuel;
    int lossTimer = 0;
    boolean hadNoWater;

    public TileEntityCoalBoiler(Machine<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.fluidHandler.set(() -> new CoalBoilerFluidHandler(this));
        this.recipeHandler.set(() -> new CoalBoilerRecipeHandler(this));
    }

    public int getFuel() {
        return this.recipeHandler.map(r -> ((CoalBoilerRecipeHandler)r).getFuel()).orElse(0);
    }

    public int getHeat() {
        return this.recipeHandler.map(r -> ((CoalBoilerRecipeHandler)r).getHeat()).orElse(0);
    }

    public int getMaxFuel() {
        return this.recipeHandler.map(r -> ((CoalBoilerRecipeHandler)r).getMaxFuel()).orElse(0);
    }

    public int getMaxHeat() {
        return this.recipeHandler.map(r -> ((CoalBoilerRecipeHandler)r).getMaxHeat()).orElse(0);
    }

    public static class CoalBoilerRecipeHandler
    extends MachineRecipeHandler<TileEntityCoalBoiler>
    implements ISteamBoilerHandler {
        int maxHeat = 500;
        int heat;
        int fuel = 0;
        int maxFuel;
        int lossTimer = 0;
        boolean hadNoWater;
        protected final ContainerData GUI_SYNC_DATA2 = new ContainerData(){

            public int m_6413_(int index) {
                switch (index) {
                    case 0: {
                        return heat;
                    }
                    case 1: {
                        return maxHeat;
                    }
                    case 2: {
                        return fuel;
                    }
                    case 3: {
                        return maxFuel;
                    }
                }
                return 0;
            }

            public void m_8050_(int index, int value) {
                switch (index) {
                    case 0: {
                        heat = value;
                        break;
                    }
                    case 1: {
                        maxHeat = value;
                        break;
                    }
                    case 2: {
                        fuel = value;
                        break;
                    }
                    case 3: {
                        maxFuel = value;
                    }
                }
            }

            public int m_6499_() {
                return 4;
            }
        };

        public CoalBoilerRecipeHandler(TileEntityCoalBoiler tile) {
            super((TileEntityMachine)tile);
            this.GUI_SYNC_DATA2.m_8050_(0, 0);
            this.maxHeat = tile.getMachineTier() == Tier.BRONZE ? 500 : 1000;
        }

        public int getFuel() {
            return this.fuel;
        }

        @Override
        public int getProcessDelay() {
            return ((TileEntityCoalBoiler)this.tile).getMachineTier() == Tier.BRONZE ? 25 : 10;
        }

        @Override
        public int getLossTimerMax() {
            return ((TileEntityCoalBoiler)this.tile).getMachineTier() == Tier.BRONZE ? 45 : 40;
        }

        @Override
        public int getHeat() {
            return this.heat;
        }

        @Override
        public void setHeat(int heat) {
            this.heat = heat;
        }

        @Override
        public int getLossTimer() {
            return this.lossTimer;
        }

        @Override
        public void setLossTimer(int lossTimer) {
            this.lossTimer = lossTimer;
        }

        @Override
        public boolean hadNoWater() {
            return this.hadNoWater;
        }

        @Override
        public void setHadNoWater(boolean hadNoWater) {
            this.hadNoWater = hadNoWater;
        }

        @Override
        public TileEntityMachine<?> getTile() {
            return this.tile;
        }

        @Override
        public void exportFluid() {
            Arrays.stream(Direction.values()).filter(f -> f != Direction.DOWN).collect(Collectors.toList()).forEach(this::exportFluidFromMachineToSide);
        }

        public int getMaxFuel() {
            return this.maxFuel;
        }

        public int getMaxHeat() {
            return this.maxHeat;
        }

        public void onServerUpdate() {
            this.tick();
            super.onServerUpdate();
        }

        public void exportFluidFromMachineToSide(Direction side) {
            BlockEntity adjTile = ((TileEntityCoalBoiler)this.tile).m_58904_().m_7702_(((TileEntityCoalBoiler)this.tile).m_58899_().m_142300_(side));
            if (adjTile == null) {
                return;
            }
            Optional cap = TesseractCapUtils.getFluidHandler((BlockEntity)adjTile, (Direction)side.m_122424_());
            ((TileEntityCoalBoiler)this.tile).fluidHandler.ifPresent(f -> cap.ifPresent(other -> Utils.transferFluids((IFluidHandler)f.getOutputTanks(), (IFluidHandler)other, (int)1000)));
        }

        protected MachineState recipeFinish() {
            if (!this.canRecipeContinue()) {
                this.resetRecipe();
                return MachineState.IDLE;
            }
            return MachineState.ACTIVE;
        }

        protected MachineState tickRecipe() {
            if (this.activeRecipe == null) {
                System.out.println("Check Recipe when active recipe is null");
                return ((TileEntityCoalBoiler)this.tile).getMachineState();
            }
            ((TileEntityCoalBoiler)this.tile).onRecipePreTick();
            if (this.fuel <= 0 && this.canRecipeContinue()) {
                if (this.fuel < 0) {
                    this.fuel = 0;
                }
                this.maxFuel = this.activeRecipe.getDuration();
                this.addOutputs();
                this.fuel += this.maxFuel;
                this.consumeInputs();
            }
            if (this.heat < this.maxHeat && this.fuel > 0 && ((TileEntityCoalBoiler)this.tile).m_58904_().m_46467_() % 12L == 0L) {
                int fuelSubtract = ((TileEntityCoalBoiler)this.tile).getMachineTier() == Tier.BRONZE ? 1 : 2;
                this.fuel -= fuelSubtract;
                ++this.heat;
            }
            ((TileEntityCoalBoiler)this.tile).onRecipePostTick();
            if (this.fuel == 0) {
                return this.recipeFinish();
            }
            return MachineState.ACTIVE;
        }

        public void setActive(boolean t) {
            if (t && ((TileEntityCoalBoiler)this.tile).getMachineState() != MachineState.ACTIVE) {
                ((TileEntityCoalBoiler)this.tile).setMachineState(MachineState.ACTIVE);
            } else if (!t && ((TileEntityCoalBoiler)this.tile).getMachineState() == MachineState.ACTIVE) {
                ((TileEntityCoalBoiler)this.tile).setMachineState(MachineState.IDLE);
            }
        }

        public boolean accepts(FluidStack fluid) {
            return fluid.getFluid() == Fluids.f_76193_ || fluid.getFluid() == Materials.DistilledWater.getLiquid();
        }

        public boolean canOutput() {
            return true;
        }

        public CompoundTag serializeNBT() {
            CompoundTag nbt = super.serializeNBT();
            nbt.m_128405_("heat", this.heat);
            nbt.m_128405_("maxHeat", this.maxHeat);
            nbt.m_128405_("fuel", this.fuel);
            nbt.m_128405_("maxFuel", this.maxFuel);
            nbt.m_128405_("lossTimer", this.lossTimer);
            nbt.m_128379_("hadNoWater", this.hadNoWater);
            return nbt;
        }

        public void deserializeNBT(CompoundTag nbt) {
            super.deserializeNBT(nbt);
            this.heat = nbt.m_128451_("heat");
            this.maxHeat = nbt.m_128451_("maxHeat");
            this.fuel = nbt.m_128451_("fuel");
            this.maxFuel = nbt.m_128451_("maxFuel");
            this.lossTimer = nbt.m_128451_("lossTimer");
            this.hadNoWater = nbt.m_128471_("hadNoWater");
        }
    }

    public static class CoalBoilerFluidHandler
    extends MachineFluidHandler<TileEntityCoalBoiler> {
        public CoalBoilerFluidHandler(TileEntityCoalBoiler tile) {
            super((TileEntityMachine)tile, 16000, 1000 * (250 + tile.getMachineTier().getIntegerId()));
            this.tanks.put(FluidHandler.FluidDirection.INPUT, FluidTanks.create((TileEntityBase)tile, (ContentEvent)ContentEvent.FLUID_INPUT_CHANGED, b -> {
                b.tank(16000);
                return b;
            }));
            this.tanks.put(FluidHandler.FluidDirection.OUTPUT, FluidTanks.create((TileEntityBase)tile, (ContentEvent)ContentEvent.FLUID_OUTPUT_CHANGED, b -> {
                b.tank(16000);
                return b;
            }));
        }

        protected FluidTanks getCellAccessibleTanks() {
            return this.getInputTanks();
        }
    }
}

