/*
 * Decompiled with CFR 0.152.
 */
package muramasa.gregtech.tile.multi;

import java.util.List;
import muramasa.antimatter.machine.types.Machine;
import muramasa.antimatter.tile.multi.TileEntityMultiMachine;
import muramasa.gregtech.block.BlockCoil;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.state.BlockState;

public class TileEntityMultiSmelter
extends TileEntityMultiMachine<TileEntityMultiSmelter> {
    private int level = 1;
    private int discount = 1;

    public TileEntityMultiSmelter(Machine<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public boolean onStructureFormed() {
        super.onStructureFormed();
        List coils = this.getStates("coil");
        BlockCoil firstType = (BlockCoil)((BlockState)coils.get(0)).m_60734_();
        if (coils.stream().allMatch(s -> s.m_60734_() == firstType)) {
            this.setCoilValues(firstType);
            return true;
        }
        this.result.withError("all coils do not match");
        return false;
    }

    public void setCoilValues(BlockCoil coil) {
        switch (coil.getId()) {
            case "kanthal": {
                this.level = 2;
                break;
            }
            case "nichrome": {
                this.level = 4;
                break;
            }
            case "tungstensteel": {
                this.level = 8;
                break;
            }
            case "hssg": {
                this.level = 16;
                this.discount = 2;
                break;
            }
            case "naquadah": {
                this.level = 16;
                this.discount = 4;
                break;
            }
            case "naquadah_alloy": {
                this.level = 16;
                this.discount = 8;
            }
        }
    }
}

