/*
 * Decompiled with CFR 0.152.
 */
package muramasa.gregtech.tile.multi;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import java.util.List;
import muramasa.antimatter.capability.machine.MachineRecipeHandler;
import muramasa.antimatter.gui.GuiInstance;
import muramasa.antimatter.gui.ICanSyncData;
import muramasa.antimatter.gui.IGuiElement;
import muramasa.antimatter.gui.widget.InfoRenderWidget;
import muramasa.antimatter.gui.widget.WidgetSupplier;
import muramasa.antimatter.integration.jeirei.renderer.IInfoRenderer;
import muramasa.antimatter.machine.MachineState;
import muramasa.antimatter.machine.types.Machine;
import muramasa.antimatter.recipe.IRecipe;
import muramasa.antimatter.recipe.ingredient.FluidIngredient;
import muramasa.antimatter.tile.multi.TileEntityMultiMachine;
import muramasa.antimatter.util.Utils;
import muramasa.gregtech.data.Materials;
import net.minecraft.client.gui.Font;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.FluidStack;
import tesseract.api.gt.IEnergyHandler;

public class TileEntityLargeTurbine
extends TileEntityMultiMachine<TileEntityLargeTurbine> {
    protected long lastConsume = 0L;
    protected long recipeConsumption = 0L;
    protected long lastEU = 0L;

    public TileEntityLargeTurbine(Machine<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.recipeHandler.set(() -> new MachineRecipeHandler<TileEntityLargeTurbine>(this){
            private IRecipe sourceRecipe;
            private double efficiency;

            protected boolean validateRecipe(IRecipe r) {
                return true;
            }

            public IRecipe findRecipe() {
                IRecipe r = super.findRecipe();
                if (r == null) {
                    return null;
                }
                this.sourceRecipe = r;
                List stacks = r.getInputFluids();
                if (stacks.size() == 0) {
                    return null;
                }
                int flow = 120;
                this.efficiency = 1.15;
                long toConsume = this.calculateGeneratorConsumption(flow, this.sourceRecipe);
                TileEntityLargeTurbine.this.recipeConsumption = (int)toConsume;
                return Utils.getFluidPoweredRecipe(Collections.singletonList(((FluidIngredient)stacks.get(0)).copy((long)((int)toConsume))), (FluidStack[])new FluidStack[]{new FluidStack(Materials.DistilledWater.getLiquid(), ((FluidIngredient)stacks.get(0)).getAmount())}, (int)1, (long)flow, (int)1);
            }

            protected boolean consumeGeneratorResources(boolean simulate) {
                if (!this.activeRecipe.hasInputFluids()) {
                    throw new RuntimeException("Missing fuel in active generator recipe!");
                }
                long recipeAmount = ((FluidIngredient)this.activeRecipe.getInputFluids().get(0)).getAmount();
                long toConsume = recipeAmount;
                long consumed = ((TileEntityLargeTurbine)this.tile).fluidHandler.map(h -> {
                    FluidIngredient input = (FluidIngredient)this.activeRecipe.getInputFluids().get(0);
                    long amount = input.drainedAmount((long)((double)toConsume * 1.5), h, true, true);
                    if (amount > 0L) {
                        if (!simulate) {
                            input.drain(amount, h, true, false);
                            TileEntityLargeTurbine.this.lastConsume = amount;
                        }
                        return amount;
                    }
                    return 0L;
                }).orElse(0L);
                if (consumed > 0L) {
                    if (consumed < recipeAmount) {
                        consumed = (long)((double)consumed * Math.pow(1.0 / (double)(recipeAmount - consumed), 0.04));
                    }
                    if (consumed > recipeAmount) {
                        consumed = (long)((double)consumed * Math.pow(1.0 / (double)(consumed - recipeAmount), 0.04));
                    }
                    long finalConsumed = consumed;
                    if (!simulate) {
                        ((TileEntityLargeTurbine)this.tile).energyHandler.ifPresent(handler -> {
                            long eu = (long)(this.efficiency * (double)this.activeRecipe.getPower() * (double)finalConsumed / (double)recipeAmount);
                            Utils.addEnergy((IEnergyHandler)handler, (long)eu);
                            TileEntityLargeTurbine.this.lastEU = eu;
                        });
                    }
                    return true;
                }
                return false;
            }
        });
    }

    public int drawInfo(InfoRenderWidget.MultiRenderWidget instance, PoseStack stack, Font renderer, int left, int top) {
        int size = super.drawInfo(instance, stack, renderer, left, top);
        if (this.getMachineState() == MachineState.ACTIVE) {
            LargeTurbineWidget wid = (LargeTurbineWidget)instance;
            renderer.m_92883_(stack, "Current: " + wid.currentConsumption + " mb/t", (float)left, (float)(top + size), 0xFAFAFF);
            renderer.m_92883_(stack, "Optimal: " + wid.recommendedConsumption + " mb/t", (float)left, (float)(top + size + 8), 0xFAFAFF);
            renderer.m_92883_(stack, "EU generation: " + wid.lastEU, (float)left, (float)(top + size + 16), 0xFAFAFF);
            return size + 24;
        }
        return size;
    }

    public WidgetSupplier getInfoWidget() {
        return LargeTurbineWidget.build().setPos(10, 10);
    }

    public static class LargeTurbineWidget
    extends InfoRenderWidget.MultiRenderWidget {
        public long currentConsumption = 0L;
        public long lastEU = 0L;
        public long recommendedConsumption = 0L;

        protected LargeTurbineWidget(GuiInstance gui, IGuiElement parent, IInfoRenderer<InfoRenderWidget.MultiRenderWidget> renderer) {
            super(gui, parent, renderer);
        }

        public void init() {
            super.init();
            TileEntityLargeTurbine turbine = (TileEntityLargeTurbine)this.gui.handler;
            this.gui.syncLong(() -> turbine.lastConsume, i -> {
                this.currentConsumption = i;
            }, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
            this.gui.syncLong(() -> turbine.recipeConsumption, i -> {
                this.recommendedConsumption = i;
            }, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
            this.gui.syncLong(() -> turbine.lastEU, i -> {
                this.lastEU = i;
            }, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
        }

        public static WidgetSupplier build() {
            return LargeTurbineWidget.builder((a, b) -> new LargeTurbineWidget((GuiInstance)a, (IGuiElement)b, (IInfoRenderer<InfoRenderWidget.MultiRenderWidget>)((IInfoRenderer)a.handler)));
        }

        public boolean drawActiveInfo() {
            return false;
        }
    }
}

