/*
 * Decompiled with CFR 0.152.
 */
package muramasa.gregtech.tile.multi;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import muramasa.antimatter.capability.machine.MachineRecipeHandler;
import muramasa.antimatter.gui.widget.InfoRenderWidget;
import muramasa.antimatter.gui.widget.WidgetSupplier;
import muramasa.antimatter.machine.types.Machine;
import muramasa.antimatter.recipe.IRecipe;
import muramasa.antimatter.tile.multi.TileEntityMultiMachine;
import muramasa.gregtech.nuclear.TileEntityNuclearReactor;
import net.minecraft.client.gui.Font;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.state.BlockState;
import tesseract.api.heat.HeatTransaction;
import tesseract.api.heat.IHeatHandler;
import tesseract.api.heat.IHeatNode;

public class TileEntityHeatExchanger
extends TileEntityMultiMachine<TileEntityHeatExchanger> {
    protected List<IHeatHandler> HEAT_HANDLERS;

    public int drawInfo(InfoRenderWidget.MultiRenderWidget instance, PoseStack stack, Font renderer, int left, int top) {
        int size = super.drawInfo(instance, stack, renderer, left, top);
        renderer.m_92883_(stack, "Heat: " + ((TileEntityNuclearReactor.HeatInfoWidget)instance).heat, (float)left, (float)(top + size), 0xFAFAFF);
        return size + 8;
    }

    public WidgetSupplier getInfoWidget() {
        return TileEntityNuclearReactor.HeatInfoWidget.build().setPos(10, 10);
    }

    public TileEntityHeatExchanger(Machine type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.recipeHandler.set(() -> new MachineRecipeHandler<TileEntityHeatExchanger>(this){

            public boolean consumeResourceForRecipe(boolean simulate) {
                IRecipe r = this.activeRecipe;
                if (simulate) {
                    return (long)TileEntityHeatExchanger.this.HEAT_HANDLERS.stream().mapToInt(IHeatNode::getHeat).sum() >= r.getPower();
                }
                int[] count = new int[]{(int)r.getPower()};
                for (IHeatHandler heat_handler : TileEntityHeatExchanger.this.HEAT_HANDLERS) {
                    HeatTransaction txn = heat_handler.extract();
                    txn.addData(count[0], -1, a -> {
                        count[0] = count[0] - a;
                    });
                    txn.commit();
                    if (count[0] != 0) continue;
                    break;
                }
                return true;
            }
        });
    }
}

