/*
 * Decompiled with CFR 0.152.
 */
package muramasa.gregtech.tile.multi;

import muramasa.antimatter.Ref;
import muramasa.antimatter.capability.machine.MachineRecipeHandler;
import muramasa.antimatter.machine.types.Machine;
import muramasa.antimatter.recipe.IRecipe;
import muramasa.antimatter.tile.multi.TileEntityMultiMachine;
import muramasa.antimatter.util.Utils;
import muramasa.gregtech.block.BlockCoil;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.state.BlockState;

public class TileEntityElectricBlastFurnace
extends TileEntityMultiMachine<TileEntityElectricBlastFurnace> {
    private int heatingCapacity;

    public TileEntityElectricBlastFurnace(Machine<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.recipeHandler.set(() -> new MachineRecipeHandler<TileEntityElectricBlastFurnace>(this){

            protected void calculateDurations() {
                super.calculateDurations();
                this.maxProgress = this.activeRecipe.getDuration();
                this.overclock = 0;
                int tier = Utils.getVoltageTier((long)(TileEntityElectricBlastFurnace.this.getMaxInputVoltage() / 2L));
                int recipeTier = Utils.getVoltageTier((long)this.activeRecipe.getPower());
                if (recipeTier == tier) {
                    TileEntityElectricBlastFurnace.this.EUt = this.activeRecipe.getPower();
                    return;
                }
                if (TileEntityElectricBlastFurnace.this.heatingCapacity >= this.activeRecipe.getSpecialValue()) {
                    int heatDiv = (TileEntityElectricBlastFurnace.this.heatingCapacity - this.activeRecipe.getSpecialValue()) / 900;
                    if (this.activeRecipe.getPower() <= 16L) {
                        TileEntityElectricBlastFurnace.this.EUt = this.activeRecipe.getPower() * (1L << tier - 1) * (1L << tier - 1);
                        this.maxProgress = this.activeRecipe.getDuration() / (1 << tier - 1);
                    } else {
                        TileEntityElectricBlastFurnace.this.EUt = this.activeRecipe.getPower();
                        this.maxProgress = this.activeRecipe.getDuration();
                        for (int i = 2; i < Ref.V.length && TileEntityElectricBlastFurnace.this.EUt <= (long)Ref.V[tier - 1]; i += 2) {
                            TileEntityElectricBlastFurnace.this.EUt *= 4L;
                            this.maxProgress /= heatDiv >= i ? 4 : 2;
                        }
                    }
                }
            }

            public long getPower() {
                return TileEntityElectricBlastFurnace.this.EUt;
            }

            protected boolean validateRecipe(IRecipe r) {
                return super.validateRecipe(r) && TileEntityElectricBlastFurnace.this.heatingCapacity > r.getSpecialValue();
            }
        });
    }

    public boolean onStructureFormed() {
        super.onStructureFormed();
        this.heatingCapacity = this.getStates("coil").stream().mapToInt(s -> ((BlockCoil)s.m_60734_()).getHeatCapacity()).sum();
        return true;
    }
}

