/*
 * Decompiled with CFR 0.152.
 */
package muramasa.gregtech.nuclear;

import com.mojang.blaze3d.vertex.PoseStack;
import muramasa.antimatter.capability.machine.MachineRecipeHandler;
import muramasa.antimatter.gui.GuiInstance;
import muramasa.antimatter.gui.ICanSyncData;
import muramasa.antimatter.gui.IGuiElement;
import muramasa.antimatter.gui.widget.InfoRenderWidget;
import muramasa.antimatter.gui.widget.WidgetSupplier;
import muramasa.antimatter.integration.jeirei.renderer.IInfoRenderer;
import muramasa.antimatter.machine.MachineState;
import muramasa.antimatter.machine.event.IMachineEvent;
import muramasa.antimatter.machine.event.MachineEvent;
import muramasa.antimatter.machine.types.Machine;
import muramasa.antimatter.recipe.IRecipe;
import muramasa.antimatter.structure.StructureHandle;
import muramasa.antimatter.tile.multi.TileEntityBasicMultiMachine;
import muramasa.antimatter.tile.multi.TileEntityMultiMachine;
import muramasa.antimatter.util.Utils;
import muramasa.antimatter.util.int3;
import muramasa.gregtech.GregTech;
import muramasa.gregtech.data.Materials;
import net.minecraft.client.gui.Font;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import tesseract.TesseractGraphWrappers;
import tesseract.api.heat.HeatTransaction;
import tesseract.api.heat.IHeatHandler;
import tesseract.api.heat.IHeatNode;

public class TileEntityNuclearReactor
extends TileEntityMultiMachine<TileEntityNuclearReactor> {
    protected float efficiencyBonus = 1.0f;
    int count = 0;
    protected final StructureHandle<TileEntityNuclearReactor> LEFT = new StructureHandle(TileEntityNuclearReactor.class, (TileEntityBasicMultiMachine)this, new int3(3, 0, 0), this::onRemoveReactor, this::onAddReactor);
    protected final StructureHandle<TileEntityNuclearReactor> RIGHT = new StructureHandle(TileEntityNuclearReactor.class, (TileEntityBasicMultiMachine)this, new int3(-3, 0, 0), this::onRemoveReactor, this::onAddReactor);
    protected final StructureHandle<TileEntityNuclearReactor> FORWARD = new StructureHandle(TileEntityNuclearReactor.class, (TileEntityBasicMultiMachine)this, new int3(0, -3, 0), this::onRemoveReactor, this::onAddReactor);
    protected final StructureHandle<TileEntityNuclearReactor> BACKWARD = new StructureHandle(TileEntityNuclearReactor.class, (TileEntityBasicMultiMachine)this, new int3(0, 3, 0), this::onRemoveReactor, this::onAddReactor);

    public TileEntityNuclearReactor(Machine<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.recipeHandler.set(() -> new MachineRecipeHandler<TileEntityNuclearReactor>(this){

            protected boolean validateRecipe(IRecipe r) {
                return r.getPower() > 0L && r.getDuration() > 0;
            }

            protected MachineState tickRecipe() {
                MachineState state = super.tickRecipe();
                if (state == MachineState.ACTIVE) {
                    long conversionAmount = this.activeRecipe.getPower() * TesseractGraphWrappers.dropletMultiplier;
                    TileEntityNuclearReactor.this.fluidHandler.ifPresent(handler -> {
                        FluidStack coolant = Materials.Coolant.getLiquid(conversionAmount);
                        FluidStack drained = handler.drainInput(coolant, IFluidHandler.FluidAction.SIMULATE);
                        if (drained.getRealAmount() == coolant.getRealAmount() && handler.canOutputsFit(new FluidStack[]{Materials.HotCoolant.getLiquid(conversionAmount)})) {
                            handler.drainInput(coolant, IFluidHandler.FluidAction.EXECUTE);
                            handler.fillOutput(Materials.HotCoolant.getLiquid(conversionAmount), IFluidHandler.FluidAction.EXECUTE);
                            this.onMachineEvent((IMachineEvent)MachineEvent.FLUIDS_OUTPUTTED, new Object[0]);
                        }
                    });
                }
                return state;
            }

            public boolean consumeResourceForRecipe(boolean simulate) {
                return true;
            }
        });
    }

    private void onAddReactor(TileEntityNuclearReactor reactor) {
        GregTech.LOGGER.info("Added reactor at " + reactor.m_58899_());
        this.efficiencyBonus = (float)((double)this.efficiencyBonus + 0.3);
    }

    public void onRecipePostTick() {
        super.onRecipePostTick();
        IRecipe r = this.recipeHandler.map(MachineRecipeHandler::getActiveRecipe).orElse(null);
        long power = r.getPower();
        int in = (int)((float)power * this.efficiencyBonus);
        HeatTransaction tx = new HeatTransaction(in, 0, Utils.sink()).ignoreTemperature();
        for (IHeatHandler handler : this.heatHandlers) {
            handler.insert(tx);
        }
        tx.commit();
    }

    private void onRemoveReactor(TileEntityNuclearReactor reactor) {
        GregTech.LOGGER.info("Removed reactor at " + reactor.m_58899_());
        this.efficiencyBonus = (float)((double)this.efficiencyBonus - 0.3);
    }

    public int drawInfo(InfoRenderWidget.MultiRenderWidget instance, PoseStack stack, Font renderer, int left, int top) {
        int size = super.drawInfo(instance, stack, renderer, left, top);
        renderer.m_92883_(stack, "Heat: " + ((HeatInfoWidget)instance).heat, (float)left, (float)(top + size), 0xFAFAFF);
        return size + 8;
    }

    public void serverTick(Level level, BlockPos pos, BlockState state) {
        super.serverTick(level, pos, state);
        for (IHeatHandler handler : this.heatHandlers) {
            handler.update(this.getMachineState() == MachineState.ACTIVE);
        }
    }

    public int maxShares() {
        return 0;
    }

    public WidgetSupplier getInfoWidget() {
        return HeatInfoWidget.build().setPos(10, 10);
    }

    public static class HeatInfoWidget
    extends InfoRenderWidget.MultiRenderWidget {
        public int heat;
        public int neighbourBonus;

        protected HeatInfoWidget(GuiInstance gui, IGuiElement parent, IInfoRenderer<InfoRenderWidget.MultiRenderWidget> renderer) {
            super(gui, parent, renderer);
        }

        public static WidgetSupplier build() {
            return HeatInfoWidget.builder((a, b) -> new HeatInfoWidget((GuiInstance)a, (IGuiElement)b, (IInfoRenderer<InfoRenderWidget.MultiRenderWidget>)((IInfoRenderer)a.handler)));
        }

        public void init() {
            super.init();
            TileEntityMultiMachine m = (TileEntityMultiMachine)this.gui.handler;
            this.gui.syncInt(() -> m.getHeatHandlers().size() == 0 ? 0 : m.getHeatHandlers().stream().mapToInt(IHeatNode::getTemperature).sum() / m.getHeatHandlers().size(), a -> {
                this.heat = a;
            }, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
            this.gui.syncInt(() -> (m.getHeatHandlers().size() - 1) * 100, a -> {
                this.neighbourBonus = a;
            }, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
        }
    }
}

