/*
 * Decompiled with CFR 0.152.
 */
package muramasa.gregtech.material;

import com.google.common.collect.ImmutableMap;
import muramasa.antimatter.data.AntimatterMaterialTypes;
import muramasa.antimatter.event.MaterialEvent;
import muramasa.antimatter.material.IMaterialTag;
import muramasa.antimatter.material.MaterialTags;
import muramasa.antimatter.tool.AntimatterToolType;
import muramasa.gregtech.data.GregTechMaterialTags;
import net.minecraft.world.item.enchantment.Enchantment;

public class GregTechMaterialEvent
extends MaterialEvent<GregTechMaterialEvent> {
    public GregTechMaterialEvent asSolid(int meltingPoint, int blastFurnaceTemp, IMaterialTag ... tags) {
        this.asSolid(meltingPoint, tags);
        GregTechMaterialTags.BLAST_FURNACE_TEMP.add(this.material, (Object)blastFurnaceTemp);
        if (blastFurnaceTemp >= 1000) {
            this.flags(new IMaterialTag[]{GregTechMaterialTags.NEEDS_BLAST_FURNACE, MaterialTags.HAS_CUSTOM_SMELTING});
        }
        if (blastFurnaceTemp > 1750) {
            this.flags(new IMaterialTag[]{AntimatterMaterialTypes.INGOT_HOT});
        }
        return this;
    }

    public GregTechMaterialEvent asMetal(int meltingPoint, int blastFurnaceTemp, IMaterialTag ... tags) {
        this.flags(new IMaterialTag[]{MaterialTags.METAL});
        this.asSolid(meltingPoint, blastFurnaceTemp, tags);
        return this;
    }

    public GregTechMaterialEvent addTools(float toolDamage, float toolSpeed, int toolDurability, int toolQuality, ImmutableMap<Enchantment, Integer> toolEnchantment, AntimatterToolType ... toolTypes) {
        this.flags(new IMaterialTag[]{AntimatterMaterialTypes.ROD_LONG});
        return (GregTechMaterialEvent)super.addTools(toolDamage, toolSpeed, toolDurability, toolQuality, toolEnchantment, toolTypes);
    }
}

