/*
 * Decompiled with CFR 0.152.
 */
package muramasa.gregtech.machine.maps;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import muramasa.antimatter.AntimatterAPI;
import muramasa.antimatter.machine.BlockMachine;
import muramasa.antimatter.machine.Tier;
import muramasa.antimatter.machine.types.Machine;
import muramasa.antimatter.recipe.IRecipe;
import muramasa.antimatter.recipe.Recipe;
import muramasa.antimatter.recipe.ingredient.RecipeIngredient;
import muramasa.antimatter.recipe.map.IRecipeMap;
import muramasa.antimatter.recipe.map.RecipeMap;
import muramasa.antimatter.registration.IAntimatterObject;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.fluids.FluidStack;

public class DisassemblingMap
implements IRecipeMap {
    private RecipeManager manager;
    private final Map<Machine<?>, ShapedRecipe> LOOKUP = new Object2ObjectOpenHashMap();

    public DisassemblingMap() {
        AntimatterAPI.register(IRecipeMap.class, (IAntimatterObject)this);
    }

    public String getId() {
        return "gt_disassembling";
    }

    public Recipe find(@Nonnull ItemStack[] items, @Nonnull FluidStack[] fluids, Tier tier, @Nonnull Predicate<IRecipe> canHandle) {
        if (items.length == 0) {
            return null;
        }
        Machine machine = ((BlockMachine)((BlockItem)items[0].m_41720_()).m_40614_()).getType();
        ShapedRecipe recipe = this.LOOKUP.get(machine);
        if (recipe == null) {
            Optional<CraftingRecipe> rec = this.manager.m_44013_(RecipeType.f_44107_).stream().filter(t -> {
                BlockItem it;
                Block patt1846$temp;
                ShapedRecipe r;
                Item patt1777$temp;
                if (t instanceof ShapedRecipe && (patt1777$temp = (r = (ShapedRecipe)t).m_8043_().m_41720_()) instanceof BlockItem && (patt1846$temp = (it = (BlockItem)patt1777$temp).m_40614_()) instanceof BlockMachine) {
                    BlockMachine m = (BlockMachine)patt1846$temp;
                    return m.getType() == machine;
                }
                return false;
            }).findFirst();
            if (rec.isEmpty()) {
                return null;
            }
            this.LOOKUP.put(machine, (ShapedRecipe)rec.get());
            recipe = (ShapedRecipe)rec.get();
        }
        Deque<Ingredient> inputs = this.getInputs(recipe);
        float size = tier == Tier.ULV ? 0.2f : 0.2f + (float)(tier.getIntegerId() - 1) / 10.0f;
        Random rand = new Random((long)machine.getLoc().hashCode() | (long)tier.getId().hashCode() << 32);
        for (int i = 0; i < inputs.size(); ++i) {
            if (!(rand.nextFloat() >= size)) continue;
            inputs.removeLast();
        }
        ItemStack[] stacks = (ItemStack[])inputs.stream().filter(t -> t.m_43908_().length > 0).map(t -> t.m_43908_()[0]).toArray(ItemStack[]::new);
        ItemStack out = items[0].m_41777_();
        out.m_41764_(1);
        return new Recipe(Collections.singletonList(RecipeIngredient.of((ItemStack)out)), RecipeMap.uniqueItems((ItemStack[])stacks), Collections.emptyList(), EMPTY_FLUID, 200, (long)tier.getVoltage() - (2L << tier.getIntegerId()), 0, 1);
    }

    private Deque<Ingredient> getInputs(ShapedRecipe recipe) {
        return new ArrayDeque<Ingredient>((Collection<Ingredient>)recipe.m_7527_());
    }

    public void add(IRecipe recipe) {
    }

    public void compileRecipe(IRecipe recipe) {
    }

    public void compile(RecipeManager manager) {
        this.LOOKUP.clear();
        this.manager = manager;
    }

    public void resetCompiled() {
    }

    public Collection<IRecipe> getRecipes(boolean filterHidden) {
        return Collections.emptyList();
    }

    public boolean acceptsItem(ItemStack item) {
        Item item2 = item.m_41720_();
        if (item2 instanceof BlockItem) {
            BlockItem it = (BlockItem)item2;
            return it.m_40614_() instanceof BlockMachine;
        }
        return false;
    }

    public boolean acceptsFluid(FluidStack fluid) {
        return false;
    }
}

