/*
 * Decompiled with CFR 0.152.
 */
package muramasa.gregtech.machine;

import muramasa.antimatter.capability.Holder;
import muramasa.antimatter.capability.machine.DefaultHeatHandler;
import muramasa.antimatter.machine.event.IMachineEvent;
import muramasa.antimatter.machine.event.MachineEvent;
import muramasa.antimatter.machine.types.Machine;
import muramasa.antimatter.material.Material;
import muramasa.antimatter.material.MaterialTags;
import muramasa.antimatter.tile.TileEntityBase;
import muramasa.antimatter.tile.multi.TileEntityHatch;
import muramasa.gregtech.machine.HeatHatch;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import tesseract.api.heat.IHeatHandler;

public class BlockEntityHatchHeat<T extends BlockEntityHatchHeat<T>>
extends TileEntityHatch<T> {
    public final Material material;
    public Holder<IHeatHandler, DefaultHeatHandler> heatHandler;

    public BlockEntityHatchHeat(Machine<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.heatHandler = new Holder(IHeatHandler.class, this.dispatch);
        HeatHatch hath = (HeatHatch)type;
        this.material = hath.mat;
        this.heatHandler.set(() -> new DefaultHeatHandler((TileEntityBase)this, MaterialTags.MELTING_POINT.getInt(this.material) * hath.heatCoefficient, hath.heatCoefficient){

            protected void add(Integer temp) {
                super.add(temp);
                BlockEntityHatchHeat.this.onMachineEvent((IMachineEvent)MachineEvent.HEAT_INPUTTED, new Object[]{temp});
            }

            protected void sub(Integer temp) {
                super.sub(temp);
                BlockEntityHatchHeat.this.onMachineEvent((IMachineEvent)MachineEvent.HEAT_DRAINED, new Object[]{temp});
            }
        });
    }

    public void serverTick(Level level, BlockPos pos, BlockState state) {
        super.serverTick(level, pos, state);
        if (this.getComponentHandler().map(t -> t.getControllers().size()).orElse(0) == 0) {
            this.heatHandler.ifPresent(t -> t.update(false));
        }
    }
}

