/*
 * Decompiled with CFR 0.152.
 */
package muramasa.gregtech.loader.multi;

import muramasa.antimatter.data.AntimatterMaterialTypes;
import muramasa.antimatter.material.Element;
import muramasa.antimatter.recipe.ingredient.RecipeIngredient;
import muramasa.gregtech.data.RecipeMaps;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class NuclearLoader {
    public static void init() {
        AntimatterMaterialTypes.FISSILE_FUEL.all().forEach(f -> {
            int free_neutrons;
            long hls = f.getElement().halfLifeSeconds;
            int dur = hls < 60L ? 200 : (hls < 3600L ? 2000 : (hls < 86400L ? 6000 : (hls < 604800L ? 12000 : (hls < 2592000L ? 24000 : (hls < 31536000L ? 60000 : 120000)))));
            int start_protons = f.getElement().getProtons();
            int start_neutrons = f.getElement().getNeutrons();
            if (start_protons % 2 == 0) {
                int end_protons_1 = start_protons / 2;
                Element end_element = Element.getFromProtons((int)end_protons_1, (boolean)false);
                free_neutrons = start_neutrons - 2 * end_element.getNeutrons() - 1;
            } else {
                int end_protons_1 = (start_protons + 1) / 2;
                int end_protons_2 = (start_protons - 1) / 2;
                Element end_element_1 = Element.getFromProtons((int)end_protons_1, (boolean)false);
                Element end_element_2 = Element.getFromProtons((int)end_protons_2, (boolean)false);
                free_neutrons = start_neutrons - end_element_1.getNeutrons() - end_element_2.getNeutrons() - 1;
            }
            int pow = 1000 * free_neutrons;
            RecipeMaps.NUCLEAR.RB().ii(new Ingredient[]{RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{AntimatterMaterialTypes.FISSILE_FUEL.get(f)})}).io(new Item[]{AntimatterMaterialTypes.DEPLETED_FISSILE_FUEL.get(f)}).add(f.getId() + "_fissile_nuclear_processing", (long)dur, (long)pow);
        });
        RecipeMaps.NUCLEAR.RB().ii(new Ingredient[]{RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41905_})}).io(new Item[]{Items.f_42594_}).add("nuc_nuc_test", 200L, 10L);
    }
}

