/*
 * Decompiled with CFR 0.152.
 */
package muramasa.gregtech.loader.multi;

import muramasa.antimatter.data.AntimatterMaterialTypes;
import muramasa.antimatter.data.AntimatterMaterials;
import muramasa.antimatter.material.IMaterialTag;
import muramasa.antimatter.material.Material;
import muramasa.antimatter.recipe.ingredient.RecipeIngredient;
import muramasa.antimatter.recipe.map.RecipeBuilder;
import muramasa.gregtech.GregTechConfig;
import muramasa.gregtech.data.Materials;
import muramasa.gregtech.data.RecipeMaps;
import muramasa.gregtech.data.TierMaps;
import muramasa.gregtech.material.FluidProduct;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.fluids.FluidStack;

public class DistillationTower {
    public static void init() {
        DistillationTower.addDistillationDistillingRecipe(Materials.Creosote, 24, 16, 96, new FluidProduct(Materials.Lubricant, 12));
        DistillationTower.addDistillationDistillingRecipe(Materials.FishOil, 24, 16, 96, new FluidProduct(Materials.Lubricant, 12));
        DistillationTower.addDistillationDistillingRecipe(Materials.SeedOil, 32, 16, 96, new FluidProduct(Materials.Lubricant, 12));
        DistillationTower.addDistillationDistillingRecipe(Materials.OilLight, 150, 20, 96, new FluidProduct(Materials.SulfuricHeavyFuel, 10), new FluidProduct(Materials.SulfuricLightFuel, 20), new FluidProduct(Materials.SulfuricNaphtha, 30), new FluidProduct(Materials.SulfuricGas, 240));
        DistillationTower.addDistillationDistillingRecipe(Materials.OilMedium, 100, 20, 96, new FluidProduct(Materials.SulfuricHeavyFuel, 15), new FluidProduct(Materials.SulfuricLightFuel, 50), new FluidProduct(Materials.SulfuricNaphtha, 20), new FluidProduct(Materials.SulfuricGas, 60));
        DistillationTower.addDistillationDistillingRecipe(Materials.Oil, 50, 20, 96, new FluidProduct(Materials.SulfuricHeavyFuel, 15), new FluidProduct(Materials.SulfuricLightFuel, 50), new FluidProduct(Materials.SulfuricNaphtha, 20), new FluidProduct(Materials.SulfuricGas, 60));
        DistillationTower.addDistillationDistillingRecipe(Materials.OilHeavy, 100, 20, 96, new FluidProduct(Materials.SulfuricHeavyFuel, 250), new FluidProduct(Materials.SulfuricLightFuel, 45), new FluidProduct(Materials.SulfuricNaphtha, 15), new FluidProduct(Materials.SulfuricGas, 60));
        DistillationTower.addDistillationDistillingRecipe(Materials.RefineryGas, 1000, 240, 120, new FluidProduct(Materials.Butane, 60), new FluidProduct(Materials.Propane, 70), new FluidProduct(Materials.Ethane, 100), new FluidProduct(Materials.Methane, 750), new FluidProduct(Materials.Helium, 20));
        DistillationTower.addDistillationDistillingRecipe(Materials.DilutedSulfuricAcid, 2000, 600, 120, new FluidProduct(Materials.SulfuricAcid, 1000), new FluidProduct(AntimatterMaterials.Water, 1000));
        DistillationTower.addDistillationDistillingRecipe(Materials.FermentedBiomass, 1000, 75, 180, 8, 1500, ItemStack.f_41583_, new FluidProduct(Materials.AceticAcid, 25), new FluidProduct(AntimatterMaterials.Water, 375), new FluidProduct(Materials.Ethanol, 150), new FluidProduct(Materials.Methanol, 150), new FluidProduct(Materials.Ammonia, 100), new FluidProduct(Materials.CarbonDioxide, 400), new FluidProduct(Materials.Methane, 600));
        DistillationTower.addDistillationDistillingRecipe(Materials.CharcoalByproducts, 1000, 40, 256, 64, 80, AntimatterMaterialTypes.DUST_SMALL.get(AntimatterMaterials.Charcoal, 1), new FluidProduct(Materials.WoodTar, 250), new FluidProduct(Materials.WoodVinegar, 500), new FluidProduct(Materials.WoodGas, 250));
        DistillationTower.addDistillationDistillingRecipe(Materials.WoodGas, 1000, 40, 256, 64, 16, ItemStack.f_41583_, new FluidProduct(Materials.CarbonDioxide, 490), new FluidProduct(Materials.Ethylene, 20), new FluidProduct(Materials.Methane, 130), new FluidProduct(Materials.CarbonMonoxide, 340), new FluidProduct(Materials.Hydrogen, 20));
        DistillationTower.addDistillationDistillingRecipe(Materials.Biomass, 600, 16, 400, 24, 16, AntimatterMaterialTypes.DUST_SMALL.get(AntimatterMaterials.Wood, 1), new FluidProduct(Materials.Ethanol, 240), new FluidProduct(AntimatterMaterials.Water, 240));
        if (GregTechConfig.GAMEPLAY.MORE_COMPLICATED_CHEMICAL_RECIPES) {
            DistillationTower.initComplicated();
        } else {
            DistillationTower.initSimple();
        }
        DistillationTower.addDistillationRecipe(AntimatterMaterials.Water, 576, 16, 120, new FluidProduct(Materials.DistilledWater, 520));
        DistillationTower.addDistillationRecipe(Materials.SteamCrackedHeavyFuel, 1000, 120, 120, AntimatterMaterialTypes.DUST_SMALL.get(Materials.Carbon, 1), new FluidProduct(Materials.HeavyFuel, 100), new FluidProduct(Materials.Naphtha, 100), new FluidProduct(Materials.Toluene, 150), new FluidProduct(Materials.Benzene, 300), new FluidProduct(Materials.Butadiene, 300), new FluidProduct(Materials.Propene, 450), new FluidProduct(Materials.Ethylene, 450), new FluidProduct(Materials.Methane, 450));
        DistillationTower.addDistillationRecipe(Materials.SteamCrackedButane, 1000, 120, 120, AntimatterMaterialTypes.DUST_SMALL.get(Materials.Carbon, 1), new FluidProduct(Materials.Butadiene, 500), new FluidProduct(Materials.Propene, 1000), new FluidProduct(Materials.Ethylene, 1000), new FluidProduct(Materials.Methane, 500));
        DistillationTower.addDistillationRecipe(Materials.HydroCrackedLightFuel, 1000, 120, 120, new FluidProduct(Materials.Naphtha, 800), new FluidProduct(Materials.Butane, 400), new FluidProduct(Materials.Propane, 400), new FluidProduct(Materials.Ethane, 200), new FluidProduct(Materials.Methane, 200));
        DistillationTower.addDistillationRecipe(Materials.HydroCrackedEthane, 1000, 120, 120, new FluidProduct(Materials.Methane, 2000));
        DistillationTower.addDistillationRecipe(Materials.HydroCrackedHeavyFuel, 1000, 120, 120, new FluidProduct(Materials.LightFuel, 800), new FluidProduct(Materials.Naphtha, 400), new FluidProduct(Materials.Butane, 100), new FluidProduct(Materials.Propane, 100), new FluidProduct(Materials.Ethane, 75), new FluidProduct(Materials.Methane, 75));
        DistillationTower.addDistillationRecipe(Materials.HydroCrackedRefineryGas, 1000, 120, 120, new FluidProduct(Materials.Methane, 1500), new FluidProduct(Materials.Helium, 20));
        DistillationTower.addDistillationRecipe(Materials.SteamCrackedNaphtha, 1000, 120, 120, AntimatterMaterialTypes.DUST_SMALL.get(Materials.Carbon, 1), new FluidProduct(Materials.HeavyFuel, 100), new FluidProduct(Materials.LightFuel, 100), new FluidProduct(Materials.Toluene, 200), new FluidProduct(Materials.Benzene, 400), new FluidProduct(Materials.Butadiene, 400), new FluidProduct(Materials.Propene, 600), new FluidProduct(Materials.Ethylene, 600), new FluidProduct(Materials.Methane, 600));
        DistillationTower.addDistillationRecipe(Materials.HydroCrackedPropane, 1000, 120, 120, new FluidProduct(Materials.Ethane, 1000), new FluidProduct(Materials.Methane, 1000));
        DistillationTower.addDistillationRecipe(Materials.HydroCrackedButane, 1000, 120, 120, new FluidProduct(Materials.Propane, 1000), new FluidProduct(Materials.Ethane, 1000), new FluidProduct(Materials.Methane, 1000));
        DistillationTower.addDistillationRecipe(Materials.SteamCrackedLightFuel, 1000, 120, 120, AntimatterMaterialTypes.DUST_SMALL.get(Materials.Carbon, 1), new FluidProduct(Materials.LightFuel, 100), new FluidProduct(Materials.Naphtha, 100), new FluidProduct(Materials.Toluene, 100), new FluidProduct(Materials.Benzene, 200), new FluidProduct(Materials.Butadiene, 200), new FluidProduct(Materials.Propene, 300), new FluidProduct(Materials.Ethylene, 300), new FluidProduct(Materials.Methane, 300));
        DistillationTower.addDistillationRecipe(Materials.HydroCrackedNaphtha, 1000, 120, 120, new FluidProduct(Materials.Butane, 750), new FluidProduct(Materials.Propane, 750), new FluidProduct(Materials.Ethane, 750), new FluidProduct(Materials.Methane, 750));
        DistillationTower.addDistillationRecipe(Materials.SteamCrackedRefineryGas, 1000, 120, 120, AntimatterMaterialTypes.DUST_SMALL.get(Materials.Carbon, 1), new FluidProduct(Materials.Butadiene, 60), new FluidProduct(Materials.Propene, 70), new FluidProduct(Materials.Ethylene, 100), new FluidProduct(Materials.Methane, 750), new FluidProduct(Materials.Helium, 20));
        DistillationTower.addDistillationRecipe(Materials.SteamCrackedEthane, 1000, 120, 120, AntimatterMaterialTypes.DUST_SMALL.get(Materials.Carbon, 1), new FluidProduct(Materials.Ethylene, 1000), new FluidProduct(Materials.Methane, 500));
        DistillationTower.addDistillationRecipe(Materials.SteamCrackedPropane, 1000, 120, 120, AntimatterMaterialTypes.DUST_SMALL.get(Materials.Carbon, 1), new FluidProduct(Materials.Propene, 500), new FluidProduct(Materials.Ethylene, 1000), new FluidProduct(Materials.Methane, 500));
    }

    private static void initSimple() {
        DistillationTower.addDistillationDistillingRecipe(Materials.WoodVinegar, 1000, 40, 256, new FluidProduct(Materials.AceticAcid, 150), new FluidProduct(AntimatterMaterials.Water, 500), new FluidProduct(Materials.Ethanol, 20), new FluidProduct(Materials.Methanol, 300));
        DistillationTower.addDistillationDistillingRecipe(Materials.WoodTar, 1000, 40, 256, new FluidProduct(Materials.Creosote, 500), new FluidProduct(Materials.Benzene, 425), new FluidProduct(Materials.Toluene, 75));
    }

    private static void initComplicated() {
        DistillationTower.addDistillationDistillingRecipe(Materials.DilutedHydrochloricAcid, 2000, 300, 64, new FluidProduct(Materials.HydrochloricAcid, 1000), new FluidProduct(AntimatterMaterials.Water, 1000));
        DistillationTower.addDistillationDistillingRecipe(Materials.WoodVinegar, 1000, 40, 256, new FluidProduct(Materials.AceticAcid, 100), new FluidProduct(AntimatterMaterials.Water, 500), new FluidProduct(Materials.Ethanol, 10), new FluidProduct(Materials.Methanol, 300), new FluidProduct(Materials.Acetone, 50), new FluidProduct(Materials.MethylAcetate, 10));
        DistillationTower.addDistillationDistillingRecipe(Materials.WoodTar, 1000, 40, 256, new FluidProduct(Materials.Creosote, 500), new FluidProduct(Materials.Phenol, 75), new FluidProduct(Materials.Benzene, 350), new FluidProduct(Materials.Toluene, 75));
        DistillationTower.addDistillationDistillingRecipe(Materials.Acetone, 1000, 50, 640, new FluidProduct(Materials.Ethenone, 500), new FluidProduct(Materials.Methane, 500));
        DistillationTower.addDistillationDistillingRecipe(Materials.CalciumAcetateSolution, 4500, 100, 240, 60, 20, AntimatterMaterialTypes.DUST_SMALL.get(Materials.Quicklime, 1), new FluidProduct(Materials.Acetone, 2500), new FluidProduct(AntimatterMaterials.Water, 750), new FluidProduct(Materials.CarbonDioxide, 750));
    }

    private static void addDistillationDistillingRecipe(Material input, int amount, int ticks, int euPerTick, int distilleryPerTick, int distilleryTicks, ItemStack itemStack, FluidProduct ... outputs) {
        DistillationTower.addDistillationRecipe(input, amount, ticks, euPerTick, itemStack, outputs);
        for (int i = 0; i < outputs.length; ++i) {
            RecipeBuilder b = RecipeMaps.DISTILLING.RB().ii(new Ingredient[]{((RecipeIngredient)TierMaps.INT_CIRCUITS.get((Object)(i + 1))).setNoConsume()}).fi(new FluidStack[]{input.has(new IMaterialTag[]{AntimatterMaterialTypes.LIQUID}) ? input.getLiquid(amount) : input.getGas(amount)}).fo(new FluidStack[]{outputs[i].convert()});
            if (!itemStack.m_41619_()) {
                b.io(new ItemStack[]{itemStack});
            }
            b.add(input.getId() + "_" + outputs[i].mat().getId(), (long)distilleryTicks, (long)distilleryPerTick);
        }
    }

    private static void addDistillationDistillingRecipe(Material input, int amount, int ticks, int euPerTick, FluidProduct ... outputs) {
        DistillationTower.addDistillationDistillingRecipe(input, amount, ticks, euPerTick, euPerTick / 4, ticks, ItemStack.f_41583_, outputs);
    }

    private static void addDistillationRecipe(Material input, int amount, int ticks, int euPerTick, ItemStack itemOutput, FluidProduct ... outputs) {
        RecipeBuilder builder = RecipeMaps.DISTILLATION.RB().fi(new FluidStack[]{input.has(new IMaterialTag[]{AntimatterMaterialTypes.LIQUID}) ? input.getLiquid(amount) : input.getGas(amount)});
        for (int i = 0; i < outputs.length; ++i) {
            Material fo = outputs[i].mat();
            if (fo.has(new IMaterialTag[]{AntimatterMaterialTypes.LIQUID})) {
                builder.fo(new FluidStack[]{outputs[i].mat().getLiquid(outputs[i].amount())});
                continue;
            }
            if (!fo.has(new IMaterialTag[]{AntimatterMaterialTypes.GAS})) continue;
            builder.fo(new FluidStack[]{outputs[i].mat().getGas(outputs[i].amount())});
        }
        if (!itemOutput.m_41619_()) {
            builder.io(new ItemStack[]{itemOutput});
        }
        builder.add(input.getId(), (long)ticks, (long)euPerTick);
    }

    private static void addDistillationRecipe(Material input, int amount, int ticks, int euPerTick, FluidProduct ... outputs) {
        DistillationTower.addDistillationRecipe(input, amount, ticks, euPerTick, ItemStack.f_41583_, outputs);
    }
}

