/*
 * Decompiled with CFR 0.152.
 */
package muramasa.gregtech.loader.multi;

import muramasa.antimatter.data.AntimatterMaterialTypes;
import muramasa.antimatter.data.AntimatterMaterials;
import muramasa.antimatter.material.IMaterialTag;
import muramasa.antimatter.material.Material;
import muramasa.antimatter.material.MaterialTags;
import muramasa.antimatter.recipe.ingredient.RecipeIngredient;
import muramasa.gregtech.GTIRef;
import muramasa.gregtech.data.GregTechMaterialTags;
import muramasa.gregtech.data.Materials;
import muramasa.gregtech.data.RecipeBuilders;
import muramasa.gregtech.data.RecipeMaps;
import muramasa.gregtech.data.TierMaps;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;

public class Blasting {
    public static int mixedOreYield = GTIRef.mixedOreYieldsTwoThirdsPureOre ? 2 : 3;

    public static void init() {
        boolean multiplier = true;
        AntimatterMaterialTypes.CRUSHED.all().forEach(m -> {
            ItemStack aIngotSmeltInto;
            boolean needsBF;
            boolean bl = needsBF = m.has(new IMaterialTag[]{GregTechMaterialTags.NEEDS_BLAST_FURNACE}) || MaterialTags.DIRECT_SMELT_INTO.getMapping(m).has(new IMaterialTag[]{GregTechMaterialTags.NEEDS_BLAST_FURNACE});
            if (!m.has(new IMaterialTag[]{AntimatterMaterialTypes.ORE}) || !m.has(new IMaterialTag[]{AntimatterMaterialTypes.INGOT})) {
                return;
            }
            Item crushed = AntimatterMaterialTypes.CRUSHED.get(m);
            Item dust = AntimatterMaterialTypes.DUST.get(m);
            ItemStack ingot = m != MaterialTags.DIRECT_SMELT_INTO.getMapping(m) ? AntimatterMaterialTypes.INGOT.get(MaterialTags.DIRECT_SMELT_INTO.getMapping(m), 1) : AntimatterMaterialTypes.INGOT.get(m, 1);
            ItemStack itemStack = aIngotSmeltInto = m == MaterialTags.SMELT_INTO.getMapping(m) ? ingot : AntimatterMaterialTypes.INGOT.get(MaterialTags.SMELT_INTO.getMapping(m), 1);
            if (needsBF) {
                long aBlastDuration = Math.max(m.getMass() / 6L, 1L) * (long)GregTechMaterialTags.BLAST_FURNACE_TEMP.getInt(m);
                ItemStack blastOut = GregTechMaterialTags.BLAST_FURNACE_TEMP.getInt(m) > 1750 && MaterialTags.SMELT_INTO.getMapping(m).has(new IMaterialTag[]{AntimatterMaterialTypes.INGOT_HOT}) ? AntimatterMaterialTypes.INGOT_HOT.get(MaterialTags.SMELT_INTO.getMapping(m), 1) : aIngotSmeltInto;
                ((RecipeBuilders.BlastingBuilder)RecipeMaps.BLASTING.RB()).ii(new Ingredient[]{RecipeIngredient.of((ItemLike)crushed, (int)1), (Ingredient)TierMaps.INT_CIRCUITS.get((Object)1)}).io(new ItemStack[]{blastOut}).add("crushed_" + m.getId(), aBlastDuration, 120L, (long)GregTechMaterialTags.BLAST_FURNACE_TEMP.getInt(m));
                ((RecipeBuilders.BlastingBuilder)RecipeMaps.BLASTING.RB()).ii(new Ingredient[]{RecipeIngredient.of((ItemLike)dust, (int)1), (Ingredient)TierMaps.INT_CIRCUITS.get((Object)1)}).io(new ItemStack[]{blastOut}).add("dust_" + m.getId(), aBlastDuration / 4L, 120L, (long)GregTechMaterialTags.BLAST_FURNACE_TEMP.getInt(m));
                ((RecipeBuilders.BlastingBuilder)RecipeMaps.BLASTING.RB()).ii(new Ingredient[]{AntimatterMaterialTypes.CRUSHED_PURIFIED.getIngredient(m, 1), (Ingredient)TierMaps.INT_CIRCUITS.get((Object)1)}).io(new ItemStack[]{blastOut}).add("purified_" + m.getId(), aBlastDuration, 120L, (long)GregTechMaterialTags.BLAST_FURNACE_TEMP.getInt(m));
                ((RecipeBuilders.BlastingBuilder)RecipeMaps.BLASTING.RB()).ii(new Ingredient[]{AntimatterMaterialTypes.CRUSHED_REFINED.getIngredient(m, 1), (Ingredient)TierMaps.INT_CIRCUITS.get((Object)1)}).io(new ItemStack[]{blastOut}).add("refined_" + m.getId(), aBlastDuration, 120L, (long)GregTechMaterialTags.BLAST_FURNACE_TEMP.getInt(m));
                ((RecipeBuilders.BlastingBuilder)RecipeMaps.BLASTING.RB()).ii(new Ingredient[]{AntimatterMaterialTypes.DUST_PURE.getIngredient(m, 1), (Ingredient)TierMaps.INT_CIRCUITS.get((Object)1)}).io(new ItemStack[]{blastOut}).add("dust_pure_" + m.getId(), aBlastDuration, 120L, (long)GregTechMaterialTags.BLAST_FURNACE_TEMP.getInt(m));
                ((RecipeBuilders.BlastingBuilder)RecipeMaps.BLASTING.RB()).ii(new Ingredient[]{AntimatterMaterialTypes.DUST_IMPURE.getIngredient(m, 1), (Ingredient)TierMaps.INT_CIRCUITS.get((Object)1)}).io(new ItemStack[]{blastOut}).add("dust_impure_" + m.getId(), aBlastDuration, 120L, (long)GregTechMaterialTags.BLAST_FURNACE_TEMP.getInt(m));
            }
        });
        RecipeMaps.BASIC_BLASTING.RB().ii(new Ingredient[]{AntimatterMaterialTypes.INGOT.getMaterialIngredient(AntimatterMaterials.Iron, 1)}).io(new ItemStack[]{AntimatterMaterialTypes.INGOT.get(Materials.Steel, 1), AntimatterMaterialTypes.DUST_SMALL.get(Materials.DarkAsh, 8)}).chances(new double[]{1.0, 0.5}).add("steel_ingot", 7200L, 0L);
        AntimatterMaterialTypes.DUST.all().forEach(m -> {
            if (m.has(new IMaterialTag[]{GregTechMaterialTags.NEEDS_BLAST_FURNACE}) && m.has(new IMaterialTag[]{GregTechMaterialTags.BLAST_FURNACE_TEMP})) {
                ItemStack ingot = MaterialTags.DIRECT_SMELT_INTO.getMapping(m).has(new IMaterialTag[]{AntimatterMaterialTypes.INGOT_HOT}) ? AntimatterMaterialTypes.INGOT_HOT.get(MaterialTags.DIRECT_SMELT_INTO.getMapping(m), 1) : AntimatterMaterialTypes.INGOT.get(MaterialTags.DIRECT_SMELT_INTO.getMapping(m), 1);
                int heat = GregTechMaterialTags.BLAST_FURNACE_TEMP.getInt(m);
                ((RecipeBuilders.BlastingBuilder)RecipeMaps.BLASTING.RB()).temperature(heat).ii(new Ingredient[]{AntimatterMaterialTypes.DUST.getMaterialIngredient(m, 1)}).io(new ItemStack[]{ingot}).add(MaterialTags.DIRECT_SMELT_INTO.getMapping(m).getId() + "_ingot_from_" + m.getId() + "_dust", Math.max(m.getMass() / 40L, 1L) * (long)heat, 120L);
            }
        });
        RecipeMaps.BASIC_BLASTING.RB().ii(new Ingredient[]{AntimatterMaterialTypes.DUST.getMaterialIngredient(Materials.BlackSteel, 1)}).io(new Item[]{AntimatterMaterialTypes.INGOT.get(Materials.BlackSteel)}).add("black_steel", 10800L);
        RecipeMaps.BASIC_BLASTING.RB().ii(new Ingredient[]{AntimatterMaterialTypes.DUST.getMaterialIngredient(Materials.BlueSteel, 1)}).io(new Item[]{AntimatterMaterialTypes.INGOT.get(Materials.BlueSteel)}).add("blue_steel", 14400L);
        RecipeMaps.BASIC_BLASTING.RB().ii(new Ingredient[]{AntimatterMaterialTypes.DUST.getMaterialIngredient(Materials.RedSteel, 1)}).io(new Item[]{AntimatterMaterialTypes.INGOT.get(Materials.RedSteel)}).add("red_steel", 14400L);
        Blasting.addCalciteRecipe(Materials.BandedIron, 4, new ItemStack((ItemLike)Items.f_42416_, 1));
        Blasting.addCalciteRecipe(Materials.YellowLimonite, 6, new ItemStack((ItemLike)Items.f_42416_, 1));
        Blasting.addCalciteRecipe(Materials.BrownLimonite, 6, new ItemStack((ItemLike)Items.f_42416_, 1));
        Blasting.addCalciteRecipe(Materials.Magnetite, 11, new ItemStack((ItemLike)Items.f_42416_, 3));
        Blasting.addCalciteRecipe(Materials.Chalcopyrite, 6, new ItemStack((ItemLike)Items.f_151052_), new ItemStack((ItemLike)Items.f_42416_));
        Blasting.addCalciteRecipe(Materials.Galena, 4, AntimatterMaterialTypes.INGOT.get(Materials.Lead, 1), AntimatterMaterialTypes.INGOT.get(Materials.Silver, 1));
        Blasting.addCalciteRecipe(Materials.Garnierite, 1, AntimatterMaterialTypes.INGOT.get(Materials.Nickel, 1));
        Blasting.addCalciteRecipe(Materials.Cassiterite, 1, AntimatterMaterialTypes.INGOT.get(Materials.Tin, 1));
        Blasting.addCalciteRecipe(Materials.Cobaltite, 5, AntimatterMaterialTypes.INGOT.get(Materials.Cobalt, 1));
        Blasting.addCalciteRecipe(Materials.Pyrite, 4, new ItemStack((ItemLike)Items.f_42416_));
        Blasting.addCalciteRecipe(Materials.Stibnite, 4, AntimatterMaterialTypes.INGOT.get(Materials.Antimony, 1));
        Blasting.addCalciteRecipe(Materials.Tetrahedrite, 12, AntimatterMaterialTypes.INGOT.get(AntimatterMaterials.Copper, 3), AntimatterMaterialTypes.INGOT.get(Materials.Antimony, 1), AntimatterMaterialTypes.INGOT.get(AntimatterMaterials.Iron, 1));
        Blasting.addCalciteRecipe(Materials.Malachite, 15, AntimatterMaterialTypes.INGOT.get(AntimatterMaterials.Copper, 2));
        ((RecipeBuilders.BlastingBuilder)RecipeMaps.BLASTING.RB()).temperature(1200).ii(new Ingredient[]{AntimatterMaterialTypes.DUST.getMaterialIngredient(AntimatterMaterials.Copper, 1)}).fi(new FluidStack[]{Materials.Oxygen.getGas(1000)}).io(new Item[]{AntimatterMaterialTypes.INGOT.get(Materials.AnnealedCopper)}).add("annealed_copper_ingot", 500L, 120L);
        ((RecipeBuilders.BlastingBuilder)RecipeMaps.BLASTING.RB()).temperature(1700).ii(new Ingredient[]{AntimatterMaterialTypes.DUST.getMaterialIngredient(Materials.Ilmenite, 1), AntimatterMaterialTypes.DUST.getMaterialIngredient(Materials.Carbon, 1)}).io(new ItemStack[]{AntimatterMaterialTypes.NUGGET.get(Materials.WroughtIron, 4), AntimatterMaterialTypes.DUST_TINY.get(Materials.Rutile, 4)}).add("wrought_iron_nuggets", 800L, 500L);
        ((RecipeBuilders.BlastingBuilder)RecipeMaps.BLASTING.RB()).temperature(1000).ii(new Ingredient[]{AntimatterMaterialTypes.INGOT.getMaterialIngredient(AntimatterMaterials.Iron, 1)}).fi(new FluidStack[]{Materials.Oxygen.getGas(1000)}).io(new Item[]{AntimatterMaterialTypes.INGOT.get(Materials.Steel), AntimatterMaterialTypes.DUST_SMALL.get(Materials.DarkAsh)}).add("steel_ingot", 500L, 120L);
        ((RecipeBuilders.BlastingBuilder)RecipeMaps.BLASTING.RB()).temperature(1000).ii(new Ingredient[]{AntimatterMaterialTypes.INGOT.getMaterialIngredient(Materials.WroughtIron, 1)}).fi(new FluidStack[]{Materials.Oxygen.getGas(1000)}).io(new Item[]{AntimatterMaterialTypes.INGOT.get(Materials.Steel), AntimatterMaterialTypes.DUST_SMALL.get(Materials.DarkAsh)}).add("steel_ingot_2", 100L, 120L);
        ((RecipeBuilders.BlastingBuilder)RecipeMaps.BLASTING.RB()).temperature(1200).ii(new Ingredient[]{AntimatterMaterialTypes.DUST.getMaterialIngredient(Materials.Ruby, 1)}).io(new ItemStack[]{AntimatterMaterialTypes.NUGGET.get(Materials.Aluminium, 3), AntimatterMaterialTypes.DUST_TINY.get(Materials.DarkAsh, 1)}).add("aluminium_ingot_from_ruby", 400L, 100L);
        ((RecipeBuilders.BlastingBuilder)RecipeMaps.BLASTING.RB()).temperature(1200).ii(new Ingredient[]{AntimatterMaterialTypes.DUST.getMaterialIngredient(Materials.Sapphire, 1)}).io(new ItemStack[]{AntimatterMaterialTypes.NUGGET.get(Materials.Aluminium, 3)}).add("aluminium_ingot_from_blue_sapphire", 400L, 100L);
        ((RecipeBuilders.BlastingBuilder)RecipeMaps.BLASTING.RB()).temperature(1200).ii(new Ingredient[]{AntimatterMaterialTypes.DUST.getMaterialIngredient(Materials.GreenSapphire, 1)}).io(new ItemStack[]{AntimatterMaterialTypes.NUGGET.get(Materials.Aluminium, 3), AntimatterMaterialTypes.DUST_TINY.get(Materials.DarkAsh, 1)}).add("aluminium_ingot_from_green_sapphire", 400L, 100L);
        ((RecipeBuilders.BlastingBuilder)RecipeMaps.BLASTING.RB()).temperature(1700).ii(new Ingredient[]{AntimatterMaterialTypes.INGOT.getMaterialIngredient(AntimatterMaterials.Iron, 6), AntimatterMaterialTypes.INGOT.getMaterialIngredient(Materials.Nickel, 1), AntimatterMaterialTypes.INGOT.getMaterialIngredient(Materials.Manganese, 1), AntimatterMaterialTypes.INGOT.getMaterialIngredient(Materials.Chrome, 1)}).io(new ItemStack[]{AntimatterMaterialTypes.INGOT.get(Materials.StainlessSteel, 9), AntimatterMaterialTypes.DUST_SMALL.get(Materials.DarkAsh, 1)}).add("stainless_steel_ingot", 1000L, 120L);
        ((RecipeBuilders.BlastingBuilder)RecipeMaps.BLASTING.RB()).temperature(2140).ii(new Ingredient[]{RecipeIngredient.of((TagKey)AntimatterMaterialTypes.DUST.getMaterialTag(Materials.Magnesium), (int)2)}).fi(new FluidStack[]{Materials.Titaniumtetrachloride.getLiquid(1000)}).io(new ItemStack[]{AntimatterMaterialTypes.INGOT_HOT.get(Materials.Titanium, 1), AntimatterMaterialTypes.DUST.get(Materials.MagnesiumChloride, 2)}).add("titanium_ingot", 800L, 480L);
        ((RecipeBuilders.BlastingBuilder)RecipeMaps.BLASTING.RB()).temperature(3000).ii(new Ingredient[]{AntimatterMaterialTypes.INGOT.getMaterialIngredient(Materials.Tungsten, 1), AntimatterMaterialTypes.INGOT.getMaterialIngredient(Materials.Steel, 1)}).io(new ItemStack[]{AntimatterMaterialTypes.INGOT_HOT.get(Materials.TungstenSteel, 2), AntimatterMaterialTypes.DUST_SMALL.get(Materials.DarkAsh, 1)}).add("tungsten_steel_ingot", 3000L, 480L);
        ((RecipeBuilders.BlastingBuilder)RecipeMaps.BLASTING.RB()).temperature(3000).ii(new Ingredient[]{AntimatterMaterialTypes.INGOT.getMaterialIngredient(Materials.Tungsten, 1), AntimatterMaterialTypes.DUST.getMaterialIngredient(Materials.Carbon, 1)}).io(new ItemStack[]{AntimatterMaterialTypes.INGOT_HOT.get(Materials.TungstenCarbide, 1), AntimatterMaterialTypes.DUST_SMALL.get(Materials.DarkAsh, 2)}).add("tungsten_carbide_ingot", 4920L, 480L);
        ((RecipeBuilders.BlastingBuilder)RecipeMaps.BLASTING.RB()).temperature(4500).ii(new Ingredient[]{AntimatterMaterialTypes.INGOT.getMaterialIngredient(Materials.Niobium, 1), AntimatterMaterialTypes.INGOT.getMaterialIngredient(Materials.Titanium, 1)}).io(new ItemStack[]{AntimatterMaterialTypes.INGOT_HOT.get(Materials.NiobiumTitanium, 2), AntimatterMaterialTypes.DUST_SMALL.get(Materials.DarkAsh, 1)}).add("niobium_titanium_ingot", 4500L, 480L);
        ((RecipeBuilders.BlastingBuilder)RecipeMaps.BLASTING.RB()).temperature(4500).ii(new Ingredient[]{AntimatterMaterialTypes.INGOT.getMaterialIngredient(Materials.Vanadium, 3), AntimatterMaterialTypes.INGOT.getMaterialIngredient(Materials.Gallium, 1)}).io(new ItemStack[]{AntimatterMaterialTypes.INGOT_HOT.get(Materials.VanadiumGallium, 4)}).add("vanadium_gallium_ingot", 4500L, 480L);
        ((RecipeBuilders.BlastingBuilder)RecipeMaps.BLASTING.RB()).temperature(1800).ii(new Ingredient[]{AntimatterMaterialTypes.INGOT.getMaterialIngredient(AntimatterMaterials.Iron, 1), AntimatterMaterialTypes.INGOT.getMaterialIngredient(Materials.Aluminium, 1), AntimatterMaterialTypes.INGOT.getMaterialIngredient(Materials.Chrome, 1)}).io(new ItemStack[]{AntimatterMaterialTypes.INGOT_HOT.get(Materials.Kanthal, 3), AntimatterMaterialTypes.DUST_SMALL.get(Materials.DarkAsh, 1)}).add("kanthal_ingot", 1800L, 120L);
        ((RecipeBuilders.BlastingBuilder)RecipeMaps.BLASTING.RB()).temperature(2700).ii(new Ingredient[]{AntimatterMaterialTypes.INGOT.getMaterialIngredient(Materials.Nickel, 4), AntimatterMaterialTypes.INGOT.getMaterialIngredient(Materials.Chrome, 1)}).io(new ItemStack[]{AntimatterMaterialTypes.INGOT_HOT.get(Materials.Nichrome, 5), AntimatterMaterialTypes.DUST_SMALL.get(Materials.DarkAsh, 2)}).add("nichrome_ingot", 2700L, 480L);
        ((RecipeBuilders.BlastingBuilder)RecipeMaps.BLASTING.RB()).temperature(2900).ii(new Ingredient[]{AntimatterMaterialTypes.INGOT.getMaterialIngredient(Materials.Iridium, 3), AntimatterMaterialTypes.INGOT.getMaterialIngredient(Materials.Osmium, 1)}).fi(new FluidStack[]{Materials.Helium.getGas(1000)}).io(new ItemStack[]{AntimatterMaterialTypes.INGOT_HOT.get(Materials.Osmiridium, 4)}).add("osmiridium_ingot", 500L, 1920L);
        ((RecipeBuilders.BlastingBuilder)RecipeMaps.BLASTING.RB()).temperature(7200).ii(new Ingredient[]{AntimatterMaterialTypes.INGOT.getMaterialIngredient(Materials.Naquadah, 1), AntimatterMaterialTypes.INGOT.getMaterialIngredient(Materials.Osmiridium, 1)}).fi(new FluidStack[]{Materials.Argon.getGas(1000)}).io(new ItemStack[]{AntimatterMaterialTypes.INGOT_HOT.get(Materials.NaquadahAlloy, 2)}).add("naquadah_ingot", 500L, 30720L);
        ((RecipeBuilders.BlastingBuilder)RecipeMaps.BLASTING.RB()).temperature(1200).ii(new Ingredient[]{AntimatterMaterialTypes.INGOT.getMaterialIngredient(Materials.Nickel, 1), AntimatterMaterialTypes.INGOT.getMaterialIngredient(Materials.BlackBronze, 1), AntimatterMaterialTypes.INGOT.getMaterialIngredient(Materials.Steel, 3)}).io(new ItemStack[]{AntimatterMaterialTypes.INGOT.get(Materials.BlackSteel, 5)}).add("black_steel_ingot", 1200L, 120L);
        ((RecipeBuilders.BlastingBuilder)RecipeMaps.BLASTING.RB()).temperature(1400).ii(new Ingredient[]{AntimatterMaterialTypes.INGOT.getMaterialIngredient(Materials.SterlingSilver, 1), AntimatterMaterialTypes.INGOT.getMaterialIngredient(Materials.BismuthBronze, 1), AntimatterMaterialTypes.INGOT.getMaterialIngredient(Materials.Steel, 2), AntimatterMaterialTypes.INGOT.getMaterialIngredient(Materials.BlackSteel, 4)}).io(new ItemStack[]{AntimatterMaterialTypes.INGOT.get(Materials.BlueSteel, 8)}).add("blue_steel_ingot", 1400L, 120L);
        ((RecipeBuilders.BlastingBuilder)RecipeMaps.BLASTING.RB()).temperature(1300).ii(new Ingredient[]{AntimatterMaterialTypes.INGOT.getMaterialIngredient(Materials.RoseGold, 1), AntimatterMaterialTypes.INGOT.getMaterialIngredient(Materials.Brass, 1), AntimatterMaterialTypes.INGOT.getMaterialIngredient(Materials.Steel, 2), AntimatterMaterialTypes.INGOT.getMaterialIngredient(Materials.BlackSteel, 4)}).io(new ItemStack[]{AntimatterMaterialTypes.INGOT.get(Materials.RedSteel, 8)}).add("red_steel_ingot", 1300L, 120L);
        ((RecipeBuilders.BlastingBuilder)RecipeMaps.BLASTING.RB()).temperature(4500).ii(new Ingredient[]{AntimatterMaterialTypes.INGOT.getMaterialIngredient(Materials.TungstenSteel, 5), AntimatterMaterialTypes.INGOT.getMaterialIngredient(Materials.Chrome, 1), AntimatterMaterialTypes.INGOT.getMaterialIngredient(Materials.Molybdenum, 2), AntimatterMaterialTypes.INGOT.getMaterialIngredient(Materials.Vanadium, 1)}).io(new ItemStack[]{AntimatterMaterialTypes.INGOT_HOT.get(Materials.HSSG, 9)}).add("hssg_ingot", 9000L, 120L);
        ((RecipeBuilders.BlastingBuilder)RecipeMaps.BLASTING.RB()).temperature(5400).ii(new Ingredient[]{AntimatterMaterialTypes.INGOT.getMaterialIngredient(Materials.HSSG, 6), AntimatterMaterialTypes.INGOT.getMaterialIngredient(Materials.Cobalt, 1), AntimatterMaterialTypes.INGOT.getMaterialIngredient(Materials.Manganese, 1), AntimatterMaterialTypes.INGOT.getMaterialIngredient(Materials.Silicon, 1)}).io(new ItemStack[]{AntimatterMaterialTypes.INGOT_HOT.get(Materials.HSSE, 8)}).add("hsse_ingot", 10800L, 120L);
        ((RecipeBuilders.BlastingBuilder)RecipeMaps.BLASTING.RB()).temperature(5400).ii(new Ingredient[]{AntimatterMaterialTypes.INGOT.getMaterialIngredient(Materials.HSSG, 6), AntimatterMaterialTypes.INGOT.getMaterialIngredient(Materials.Osmiridium, 2), AntimatterMaterialTypes.INGOT.getMaterialIngredient(Materials.Iridium, 1)}).io(new ItemStack[]{AntimatterMaterialTypes.INGOT_HOT.get(Materials.HSSS, 9)}).add("hsss_ingot", 16200L, 120L);
    }

    private static void addCalciteRecipe(Material ore, int input, ItemStack ... outputs) {
        RecipeMaps.BASIC_BLASTING.RB().ii(new Ingredient[]{AntimatterMaterialTypes.RAW_ORE.getMaterialIngredient(ore, input), AntimatterMaterialTypes.DUST.getMaterialIngredient(Materials.Calcite, 1)}).io(outputs).add(ore.getId() + "_calcite", (long)(input * 1000));
        RecipeMaps.BASIC_BLASTING.RB().ii(new Ingredient[]{AntimatterMaterialTypes.RAW_ORE.getMaterialIngredient(ore, input), AntimatterMaterialTypes.DUST.getMaterialIngredient(Materials.Limestone, 1)}).io(outputs).add(ore.getId() + "_limestone", (long)(input * 1000));
        RecipeMaps.BASIC_BLASTING.RB().ii(new Ingredient[]{AntimatterMaterialTypes.RAW_ORE.getMaterialIngredient(ore, input), AntimatterMaterialTypes.DUST.getMaterialIngredient(Materials.Marble, 1)}).io(outputs).add(ore.getId() + "_marble", (long)(input * 1000));
        RecipeMaps.BASIC_BLASTING.RB().ii(new Ingredient[]{AntimatterMaterialTypes.CRUSHED.getMaterialIngredient(ore, input), AntimatterMaterialTypes.DUST.getMaterialIngredient(Materials.Calcite, 1)}).io(outputs).add("crushed_" + ore.getId() + "_calcite", (long)(input * 1000));
        RecipeMaps.BASIC_BLASTING.RB().ii(new Ingredient[]{AntimatterMaterialTypes.CRUSHED.getMaterialIngredient(ore, input), AntimatterMaterialTypes.DUST.getMaterialIngredient(Materials.Limestone, 1)}).io(outputs).add("crushed_" + ore.getId() + "_limestone", (long)(input * 1000));
        RecipeMaps.BASIC_BLASTING.RB().ii(new Ingredient[]{AntimatterMaterialTypes.CRUSHED.getMaterialIngredient(ore, input), AntimatterMaterialTypes.DUST.getMaterialIngredient(Materials.Marble, 1)}).io(outputs).add("crushed_" + ore.getId() + "_marble", (long)(input * 1000));
        RecipeMaps.BASIC_BLASTING.RB().ii(new Ingredient[]{AntimatterMaterialTypes.DUST_IMPURE.getMaterialIngredient(ore, input), AntimatterMaterialTypes.DUST.getMaterialIngredient(Materials.Calcite, 1)}).io(outputs).add("impure_" + ore.getId() + "_calcite", (long)(input * 1000));
        RecipeMaps.BASIC_BLASTING.RB().ii(new Ingredient[]{AntimatterMaterialTypes.DUST_IMPURE.getMaterialIngredient(ore, input), AntimatterMaterialTypes.DUST.getMaterialIngredient(Materials.Limestone, 1)}).io(outputs).add("impure_" + ore.getId() + "_limestone", (long)(input * 1000));
        RecipeMaps.BASIC_BLASTING.RB().ii(new Ingredient[]{AntimatterMaterialTypes.DUST_IMPURE.getMaterialIngredient(ore, input), AntimatterMaterialTypes.DUST.getMaterialIngredient(Materials.Marble, 1)}).io(outputs).add("impure_" + ore.getId() + "_marble", (long)(input * 1000));
        RecipeMaps.BASIC_BLASTING.RB().ii(new Ingredient[]{AntimatterMaterialTypes.DUST.getMaterialIngredient(ore, input), AntimatterMaterialTypes.DUST.getMaterialIngredient(Materials.Calcite, 1)}).io(outputs).add("dust_" + ore.getId() + "_calcite", (long)(input * 1000));
        RecipeMaps.BASIC_BLASTING.RB().ii(new Ingredient[]{AntimatterMaterialTypes.DUST.getMaterialIngredient(ore, input), AntimatterMaterialTypes.DUST.getMaterialIngredient(Materials.Limestone, 1)}).io(outputs).add("dust_" + ore.getId() + "_limestone", (long)(input * 1000));
        RecipeMaps.BASIC_BLASTING.RB().ii(new Ingredient[]{AntimatterMaterialTypes.DUST.getMaterialIngredient(ore, input), AntimatterMaterialTypes.DUST.getMaterialIngredient(Materials.Marble, 1)}).io(outputs).add("dust_" + ore.getId() + "_marble", (long)(input * 1000));
        ((RecipeBuilders.BlastingBuilder)RecipeMaps.BLASTING.RB()).ii(new Ingredient[]{AntimatterMaterialTypes.DUST.getMaterialIngredient(ore, input), AntimatterMaterialTypes.DUST.getMaterialIngredient(Materials.Calcite, 1)}).io(outputs).add(ore.getId() + "_calcite", (long)(input * 500), 120L);
        ((RecipeBuilders.BlastingBuilder)RecipeMaps.BLASTING.RB()).ii(new Ingredient[]{AntimatterMaterialTypes.DUST.getMaterialIngredient(ore, input), AntimatterMaterialTypes.DUST.getMaterialIngredient(Materials.Limestone, 1)}).io(outputs).add(ore.getId() + "_limestone", (long)(input * 500), 120L);
        ((RecipeBuilders.BlastingBuilder)RecipeMaps.BLASTING.RB()).ii(new Ingredient[]{AntimatterMaterialTypes.DUST.getMaterialIngredient(ore, input), AntimatterMaterialTypes.DUST.getMaterialIngredient(Materials.Marble, 1)}).io(outputs).add(ore.getId() + "_marble", (long)(input * 500), 120L);
    }
}

