/*
 * Decompiled with CFR 0.152.
 */
package muramasa.gregtech.loader.machines;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import muramasa.antimatter.data.AntimatterMaterialTypes;
import muramasa.antimatter.material.IMaterialTag;
import muramasa.antimatter.material.Material;
import muramasa.antimatter.recipe.ingredient.RecipeIngredient;
import muramasa.gregtech.data.RecipeMaps;
import net.minecraft.world.item.ItemStack;

public class OreByproducts {
    public static void init() {
        AntimatterMaterialTypes.CRUSHED.all().forEach(m -> {
            if (!m.has(new IMaterialTag[]{AntimatterMaterialTypes.ORE})) {
                return;
            }
            if (!m.has(new IMaterialTag[]{AntimatterMaterialTypes.INGOT})) {
                return;
            }
            RecipeIngredient ore = AntimatterMaterialTypes.ORE.getMaterialIngredient(m, 1);
            RecipeIngredient crushed = AntimatterMaterialTypes.CRUSHED.getIngredient(m, 1);
            if (m.hasByProducts()) {
                List byProducts = m.getByProducts();
                int byProductsCount = byProducts.size();
                ObjectArrayList ores = new ObjectArrayList();
                if (m.has(new IMaterialTag[]{AntimatterMaterialTypes.ORE})) {
                    ores.add(ore);
                }
                if (m.has(new IMaterialTag[]{AntimatterMaterialTypes.ROCK})) {
                    ores.add(AntimatterMaterialTypes.ROCK.getIngredient(m, 1));
                }
                if (m.has(new IMaterialTag[]{AntimatterMaterialTypes.CRUSHED})) {
                    ores.add(crushed);
                }
                if (m.has(new IMaterialTag[]{AntimatterMaterialTypes.CRUSHED_PURIFIED})) {
                    ores.add(AntimatterMaterialTypes.CRUSHED_PURIFIED.getIngredient(m, 1));
                }
                if (m.has(new IMaterialTag[]{AntimatterMaterialTypes.CRUSHED_REFINED})) {
                    ores.add(AntimatterMaterialTypes.CRUSHED_REFINED.getIngredient(m, 1));
                }
                ObjectArrayList dusts = new ObjectArrayList(byProductsCount);
                byProducts.forEach(arg_0 -> OreByproducts.lambda$init$0((List)dusts, arg_0));
                RecipeMaps.ORE_BYPRODUCTS.RB().ii((List)ores).io(dusts.toArray(new ItemStack[byProductsCount])).add(m.getId() + "_byproducts");
            }
        });
    }

    private static /* synthetic */ void lambda$init$0(List dusts, Material p) {
        dusts.add(AntimatterMaterialTypes.DUST.get(p, 1));
    }
}

