/*
 * Decompiled with CFR 0.152.
 */
package muramasa.gregtech.loader.machines;

import java.util.List;
import java.util.stream.Collectors;
import muramasa.antimatter.data.AntimatterMaterialTypes;
import muramasa.antimatter.data.AntimatterMaterials;
import muramasa.antimatter.material.Material;
import muramasa.antimatter.material.MaterialTypeItem;
import muramasa.antimatter.recipe.ingredient.RecipeIngredient;
import muramasa.gregtech.data.Materials;
import muramasa.gregtech.data.RecipeMaps;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;

public class MixerLoader {
    public static void init() {
        MixerLoader.addDust(Materials.StainlessSteel, 8, 900);
        MixerLoader.addDust(Materials.Nichrome, 8, 500);
        MixerLoader.addDust(Materials.Invar, 8, 300);
        MixerLoader.addDust(Materials.Bronze, 8, 200);
        MixerLoader.addDust(Materials.BlackBronze, 8, 500);
        MixerLoader.addDust(Materials.FerriteMixture, 8, 600);
        MixerLoader.addDust(Materials.IndiumGalliumPhosphide, 8, 400);
        MixerLoader.addDust(Materials.Energium, 8, 200);
        MixerLoader.addDust(Materials.GalliumArsenide, 8, 300);
        MixerLoader.addDust(Materials.VanadiumSteel, 8, 1000);
        MixerLoader.addDust(Materials.CobaltBrass, 8, 900);
        MixerLoader.addDust(Materials.BlueSteel, 8, 800);
        MixerLoader.addDust(Materials.RedSteel, 8, 800);
        MixerLoader.addDust(Materials.BlackSteel, 8, 500);
        MixerLoader.addDust(Materials.SterlingSilver, 8, 500);
        MixerLoader.addDust(Materials.RoseGold, 8, 500);
        MixerLoader.addDust(Materials.BismuthBronze, 8, 500);
        MixerLoader.addDust(Materials.VanadiumGallium, 8, 400);
        MixerLoader.addDust(Materials.Ultimet, 8, 900);
        MixerLoader.addDust(Materials.TinAlloy, 8, 200);
        MixerLoader.addDust(Materials.SodiumSulfide, 8, 60);
        MixerLoader.addDust(Materials.Magnalium, 8, 400);
        MixerLoader.addDust(Materials.Kanthal, 8, 300);
        MixerLoader.addDust(Materials.Electrum, 8, 200);
        MixerLoader.addDust(Materials.Brass, 8, 400);
        MixerLoader.addDust(Materials.BatteryAlloy, 8, 500);
        MixerLoader.addDust(Materials.Cupronickel, 8, 200);
        MixerLoader.addDust(AntimatterMaterials.EnderEye, 8, 100);
        MixerLoader.recipes();
    }

    private static void addDust(Material mat, int eut, int duration) {
        for (MaterialTypeItem type : new MaterialTypeItem[]{AntimatterMaterialTypes.DUST, AntimatterMaterialTypes.DUST_SMALL, AntimatterMaterialTypes.DUST_TINY}) {
            List ings = mat.getProcessInto().stream().map(t -> type.getMaterialIngredient(t.m, t.s)).collect(Collectors.toList());
            if (ings.size() == 0) {
                return;
            }
            MaterialTypeItem type2 = type;
            int count = mat.getProcessInto().stream().mapToInt(t -> t.s).sum();
            if (type != AntimatterMaterialTypes.DUST) {
                if (type == AntimatterMaterialTypes.DUST_SMALL) {
                    if (count % 4 == 0) {
                        count /= 4;
                        type2 = AntimatterMaterialTypes.DUST;
                    }
                } else if (count % 9 == 0) {
                    count /= 9;
                    type2 = AntimatterMaterialTypes.DUST;
                }
            }
            RecipeMaps.MIXING.RB().ii(ings).io(new ItemStack[]{type2.get(mat, count)}).add(type.getId() + "_" + mat.getId(), (long)duration, (long)eut);
        }
    }

    private static void recipes() {
        RecipeMaps.MIXING.RB().fi(new FluidStack[]{Materials.NitricAcid.getLiquid(1000), Materials.SulfuricAcid.getLiquid(1000)}).fo(new FluidStack[]{Materials.NitrationMixture.getLiquid(2000)}).add("nitration_mixture", 500L, 2L);
        RecipeMaps.MIXING.RB().fi(new FluidStack[]{Materials.PolyvinylAcetate.getLiquid(1000), Materials.Acetone.getLiquid(1500)}).fo(new FluidStack[]{Materials.Glue.getLiquid(2500)}).add("glue", 50L, 8L);
        RecipeMaps.MIXING.RB().fi(new FluidStack[]{Materials.PolyvinylAcetate.getLiquid(1000), Materials.MethylAcetate.getLiquid(1500)}).fo(new FluidStack[]{Materials.Glue.getLiquid(2500)}).add("glue_1", 50L, 8L);
        RecipeMaps.MIXING.RB().fi(new FluidStack[]{Materials.BioDiesel.getLiquid(1000), Materials.Tetranitromethane.getLiquid(40)}).fo(new FluidStack[]{Materials.CetaneBoostedDiesel.getLiquid(750)}).add("nitro_fuel", 20L, 480L);
        RecipeMaps.MIXING.RB().fi(new FluidStack[]{Materials.Diesel.getLiquid(1000), Materials.Tetranitromethane.getLiquid(20)}).fo(new FluidStack[]{Materials.CetaneBoostedDiesel.getLiquid(1000)}).add("nitro_fuel_1", 20L, 480L);
        RecipeMaps.MIXING.RB().fi(new FluidStack[]{Materials.Oxygen.getGas(1000), Materials.Dimethylhydrazine.getLiquid(1000)}).fo(new FluidStack[]{Materials.RocketFuel.getLiquid(3000)}).add("rocket_fuel", 60L, 16L);
        RecipeMaps.MIXING.RB().fi(new FluidStack[]{Materials.DinitrogenTetroxide.getGas(1000), Materials.Dimethylhydrazine.getLiquid(1000)}).fo(new FluidStack[]{Materials.RocketFuel.getLiquid(6000)}).add("rocket_fuel_1", 60L, 16L);
        RecipeMaps.MIXING.RB().fi(new FluidStack[]{Materials.LightFuel.getLiquid(5000), Materials.HeavyFuel.getLiquid(1000)}).fo(new FluidStack[]{Materials.Diesel.getLiquid(6000)}).add("diesel", 16L, 120L);
        RecipeMaps.MIXING.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemStack)AntimatterMaterialTypes.DUST.get(AntimatterMaterials.Wood, 4))}).fi(new FluidStack[]{Materials.SulfuricAcid.getLiquid(1000)}).io(new ItemStack[]{Items.f_42414_.m_7968_()}).fo(new FluidStack[]{Materials.DilutedSulfuricAcid.getLiquid(1000)}).add("diluted_sulfuric_acid", 1200L, 2L);
        RecipeMaps.MIXING.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemStack)AntimatterMaterialTypes.DUST.get(AntimatterMaterials.Sugar, 4))}).fi(new FluidStack[]{Materials.SulfuricAcid.getLiquid(1000)}).io(new ItemStack[]{Items.f_42414_.m_7968_()}).fo(new FluidStack[]{Materials.DilutedSulfuricAcid.getLiquid(1000)}).add("diluted_sulfuric_acid_1", 1200L, 2L);
        RecipeMaps.MIXING.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemStack)AntimatterMaterialTypes.DUST.get(Materials.Salt, 2))}).fi(new FluidStack[]{AntimatterMaterials.Water.getLiquid(1000)}).fo(new FluidStack[]{Materials.SaltWater.getLiquid(1000)}).add("salt_water", 40L, 8L);
        RecipeMaps.MIXING.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemStack)AntimatterMaterialTypes.DUST.get(AntimatterMaterials.Copper, 3)), RecipeIngredient.of((ItemStack)AntimatterMaterialTypes.DUST.get(Materials.Barium, 2)), RecipeIngredient.of((ItemStack)AntimatterMaterialTypes.DUST.get(Materials.Yttrium, 1))}).fi(new FluidStack[]{Materials.Oxygen.getGas(7000)}).io(new ItemStack[]{AntimatterMaterialTypes.DUST.get(Materials.YttriumBariumCuprate, 13)}).add("yttrium_barium_cuprate", 800L, 8L);
        RecipeMaps.MIXING.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemStack)AntimatterMaterialTypes.DUST.get(Materials.Talc, 1))}).fi(new FluidStack[]{Materials.Oil.getLiquid(750)}).fo(new FluidStack[]{Materials.Lubricant.getLiquid(750)}).add("lubricant", 128L, 4L);
        RecipeMaps.MIXING.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemStack)AntimatterMaterialTypes.DUST.get(Materials.Talc, 1))}).fi(new FluidStack[]{Materials.Creosote.getLiquid(750)}).fo(new FluidStack[]{Materials.Lubricant.getLiquid(750)}).add("lubricant_1", 128L, 4L);
        RecipeMaps.MIXING.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemStack)AntimatterMaterialTypes.DUST.get(Materials.Talc, 1))}).fi(new FluidStack[]{Materials.SeedOil.getLiquid(750)}).fo(new FluidStack[]{Materials.Lubricant.getLiquid(750)}).add("lubricant_2", 128L, 4L);
        RecipeMaps.MIXING.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemStack)AntimatterMaterialTypes.DUST.get(Materials.Soapstone, 1))}).fi(new FluidStack[]{Materials.Oil.getLiquid(750)}).fo(new FluidStack[]{Materials.Lubricant.getLiquid(750)}).add("lubricant_3", 128L, 4L);
        RecipeMaps.MIXING.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemStack)AntimatterMaterialTypes.DUST.get(Materials.Soapstone, 1))}).fi(new FluidStack[]{Materials.Creosote.getLiquid(750)}).fo(new FluidStack[]{Materials.Lubricant.getLiquid(750)}).add("lubricant_4", 128L, 4L);
        RecipeMaps.MIXING.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemStack)AntimatterMaterialTypes.DUST.get(Materials.Soapstone, 1))}).fi(new FluidStack[]{Materials.SeedOil.getLiquid(750)}).fo(new FluidStack[]{Materials.Lubricant.getLiquid(750)}).add("lubricant_5", 128L, 4L);
        RecipeMaps.MIXING.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemStack)AntimatterMaterialTypes.DUST.get(AntimatterMaterials.Redstone, 1))}).fi(new FluidStack[]{Materials.Oil.getLiquid(750)}).fo(new FluidStack[]{Materials.Lubricant.getLiquid(750)}).add("lubricant_6", 128L, 4L);
        RecipeMaps.MIXING.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemStack)AntimatterMaterialTypes.DUST.get(AntimatterMaterials.Redstone, 1))}).fi(new FluidStack[]{Materials.Creosote.getLiquid(750)}).fo(new FluidStack[]{Materials.Lubricant.getLiquid(750)}).add("lubricant_7", 128L, 4L);
        RecipeMaps.MIXING.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemStack)AntimatterMaterialTypes.DUST.get(AntimatterMaterials.Redstone, 1))}).fi(new FluidStack[]{Materials.SeedOil.getLiquid(750)}).fo(new FluidStack[]{Materials.Lubricant.getLiquid(750)}).add("lubricant_8", 128L, 4L);
        RecipeMaps.MIXING.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemStack)AntimatterMaterialTypes.DUST.get(Materials.Glass, 7)), RecipeIngredient.of((ItemStack)AntimatterMaterialTypes.DUST.get(Materials.Boron, 1))}).io(new ItemStack[]{AntimatterMaterialTypes.DUST.get(Materials.BorosilicateGlass, 8)}).add("borosilicate_glass", 800L, 8L);
        RecipeMaps.MIXING.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemStack)AntimatterMaterialTypes.DUST.get(Materials.Saltpeter, 2)), RecipeIngredient.of((ItemStack)AntimatterMaterialTypes.DUST.get(Materials.Sulfur, 1)), RecipeIngredient.of((ItemStack)AntimatterMaterialTypes.DUST.get(AntimatterMaterials.Coal, 1))}).io(new Item[]{Items.f_42403_}).add("gunpowder", 400L, 8L);
        RecipeMaps.MIXING.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemStack)AntimatterMaterialTypes.DUST.get(Materials.Saltpeter, 2)), RecipeIngredient.of((ItemStack)AntimatterMaterialTypes.DUST.get(Materials.Sulfur, 1)), RecipeIngredient.of((ItemStack)AntimatterMaterialTypes.DUST.get(AntimatterMaterials.Charcoal, 1))}).io(new ItemStack[]{new ItemStack((ItemLike)Items.f_42403_, 2)}).add("gunpowder_1", 300L, 8L);
        RecipeMaps.MIXING.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemStack)AntimatterMaterialTypes.DUST.get(AntimatterMaterials.Stone, 1))}).fi(new FluidStack[]{Materials.Lubricant.getLiquid(20), AntimatterMaterials.Water.getLiquid(4980)}).fo(new FluidStack[]{Materials.DrillingFluid.getLiquid(5000)}).add("drilling_fluid", 64L, 16L);
        RecipeMaps.MIXING.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemStack)AntimatterMaterialTypes.DUST.get(AntimatterMaterials.Stone, 3)), RecipeIngredient.of((ItemStack)AntimatterMaterialTypes.DUST.get(Materials.Clay, 1))}).fi(new FluidStack[]{AntimatterMaterials.Water.getLiquid(500)}).fo(new FluidStack[]{Materials.Concrete.getLiquid(576)}).add("concrete", 20L, 16L);
        RecipeMaps.MIXING.RB().fi(new FluidStack[]{Materials.SodiumCarbonateSolution.getLiquid(1000), Materials.SodiumBicarbonateSolution.getLiquid(1000)}).fo(new FluidStack[]{Materials.LeachingSolution.getLiquid(2000)}).add("leaching_solution", 60L, 32L);
    }
}

