/*
 * Decompiled with CFR 0.152.
 */
package muramasa.gregtech.loader.machines;

import io.github.gregtechintergalactical.gtrubber.GTRubberData;
import java.util.ArrayList;
import muramasa.antimatter.AntimatterAPI;
import muramasa.antimatter.data.AntimatterMaterialTypes;
import muramasa.antimatter.data.AntimatterMaterials;
import muramasa.antimatter.material.IMaterialTag;
import muramasa.antimatter.material.Material;
import muramasa.antimatter.material.MaterialTags;
import muramasa.antimatter.ore.CobbleStoneType;
import muramasa.antimatter.ore.StoneType;
import muramasa.antimatter.recipe.ingredient.RecipeIngredient;
import muramasa.antimatter.recipe.map.RecipeBuilder;
import muramasa.antimatter.recipe.map.RecipeMap;
import muramasa.antimatter.util.Utils;
import muramasa.gregtech.data.GregTechData;
import muramasa.gregtech.data.Materials;
import muramasa.gregtech.data.RecipeMaps;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class MaceratorLoader {
    public static void initAuto() {
        AntimatterMaterialTypes.ORE.all().forEach(m -> AntimatterAPI.all(StoneType.class).stream().filter(s -> s.generateOre).forEach(s -> {
            Material sm = s.getMaterial();
            if (!m.has(new IMaterialTag[]{AntimatterMaterialTypes.DUST}) || !m.has(new IMaterialTag[]{AntimatterMaterialTypes.CRUSHED})) {
                return;
            }
            ItemStack stoneDust = sm.has(new IMaterialTag[]{AntimatterMaterialTypes.DUST}) ? AntimatterMaterialTypes.DUST.get(sm, 1) : ItemStack.f_41583_;
            TagKey oreTag = AntimatterMaterialTypes.ORE.getMaterialTag(m, s);
            RecipeIngredient ore = RecipeIngredient.of((TagKey)oreTag, (int)1);
            ItemStack crushedStack = AntimatterMaterialTypes.CRUSHED.get(m, MaterialTags.ORE_MULTI.getInt(m));
            Material oreByProduct1 = m.getByProducts().size() > 0 ? (Material)m.getByProducts().get(0) : MaterialTags.MACERATE_INTO.getMapping(m);
            RecipeMap<RecipeBuilder> rm = s.isSandLike() ? RecipeMaps.SIFTING : RecipeMaps.MACERATING;
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            stacks.add(Utils.ca((int)(MaterialTags.ORE_MULTI.getInt(m) * (rm == RecipeMaps.SIFTING ? 1 : 2)), (ItemStack)crushedStack));
            if (rm == RecipeMaps.SIFTING) {
                stacks.add(crushedStack);
                stacks.add(crushedStack);
                stacks.add(crushedStack);
            }
            stacks.add(AntimatterMaterialTypes.DUST.get(oreByProduct1, 1));
            if (!stoneDust.m_41619_()) {
                stacks.add(stoneDust);
            }
            ItemStack[] stackArray = stacks.toArray(new ItemStack[0]);
            ArrayList<Double> ints = new ArrayList<Double>();
            if (rm == RecipeMaps.SIFTING) {
                ints.add(0.7);
                ints.add(0.5);
                ints.add(0.3);
                ints.add(0.1);
            } else {
                ints.add(1.0);
            }
            ints.add(0.1 * (double)MaterialTags.BY_PRODUCT_MULTI.getInt(m));
            if (!stoneDust.m_41619_()) {
                ints.add(0.5);
            }
            double[] chances = ints.stream().mapToDouble(i -> i).toArray();
            rm.RB().ii(new Ingredient[]{ore}).io(stackArray).chances(chances).add("ore_" + m.getId() + "_" + s.getId(), 400L, 2L);
        }));
        AntimatterMaterialTypes.CRUSHED.all().forEach(m -> {
            if (!m.has(new IMaterialTag[]{AntimatterMaterialTypes.ORE})) {
                return;
            }
            if (!m.has(new IMaterialTag[]{AntimatterMaterialTypes.CRUSHED})) {
                return;
            }
            int multiplier = 1;
            RecipeIngredient ore = RecipeIngredient.of((TagKey)AntimatterMaterialTypes.ORE.getMaterialTag(m), (int)1);
            RecipeIngredient crushed = AntimatterMaterialTypes.CRUSHED.getIngredient(m, 1);
            ItemStack crushedStack = AntimatterMaterialTypes.CRUSHED.get(m, 1);
            Material aOreByProduct1 = m.getByProducts().size() >= 1 ? (Material)m.getByProducts().get(0) : MaterialTags.MACERATE_INTO.getMapping(m);
            Material aOreByProduct2 = m.getByProducts().size() >= 2 ? (Material)m.getByProducts().get(1) : aOreByProduct1;
            RecipeMaps.MACERATING.RB().ii(new Ingredient[]{crushed}).io(new ItemStack[]{AntimatterMaterialTypes.DUST_IMPURE.get(MaterialTags.MACERATE_INTO.getMapping(m), 1), AntimatterMaterialTypes.DUST.get(aOreByProduct1, 1)}).chances(new double[]{1.0, 0.1}).add("crushed_" + m.getId(), 400L, 2L);
            if (m.has(new IMaterialTag[]{AntimatterMaterialTypes.CRUSHED_REFINED})) {
                RecipeMaps.MACERATING.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemStack)AntimatterMaterialTypes.CRUSHED_REFINED.get(m, 1))}).io(new ItemStack[]{AntimatterMaterialTypes.DUST.get(MaterialTags.MACERATE_INTO.getMapping(m), 1), AntimatterMaterialTypes.DUST.get(aOreByProduct2, 1)}).chances(new double[]{1.0, 0.1}).add("refined_" + m.getId(), 400L, 2L);
            }
            if (m.has(new IMaterialTag[]{AntimatterMaterialTypes.CRUSHED_PURIFIED}) && m.has(new IMaterialTag[]{AntimatterMaterialTypes.DUST_PURE})) {
                RecipeMaps.MACERATING.RB().ii(new Ingredient[]{AntimatterMaterialTypes.CRUSHED_PURIFIED.getIngredient(m, 1)}).io(new ItemStack[]{AntimatterMaterialTypes.DUST_PURE.get(MaterialTags.MACERATE_INTO.getMapping(m), 1), AntimatterMaterialTypes.DUST.get(aOreByProduct1, 1)}).chances(new double[]{1.0, 0.1}).add("purified_" + m.getId(), 400L, 2L);
            }
            if (m.has(new IMaterialTag[]{AntimatterMaterialTypes.RAW_ORE})) {
                RecipeMaps.MACERATING.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)AntimatterMaterialTypes.RAW_ORE.getMaterialTag(m), (int)1)}).io(new ItemStack[]{Utils.ca((int)(MaterialTags.ORE_MULTI.getInt(m) * multiplier * 2), (ItemStack)crushedStack), AntimatterMaterialTypes.DUST.get(aOreByProduct1, 1)}).chances(new double[]{1.0, 0.1 * (double)multiplier * (double)MaterialTags.BY_PRODUCT_MULTI.getInt(m)}).add("raw_" + m.getId(), 400L, 2L);
            }
        });
        AntimatterMaterialTypes.GEM_EXQUISITE.all().forEach(m -> {
            if (!m.has(new IMaterialTag[]{AntimatterMaterialTypes.DUST})) {
                return;
            }
            RecipeMaps.MACERATING.RB().ii(new Ingredient[]{AntimatterMaterialTypes.GEM_EXQUISITE.getMaterialIngredient(m, 1)}).io(new ItemStack[]{AntimatterMaterialTypes.DUST.get(m, 4)}).add(m.getId() + "_exquisite", m.getMass(), 4L);
            RecipeMaps.MACERATING.RB().ii(new Ingredient[]{AntimatterMaterialTypes.GEM_FLAWLESS.getMaterialIngredient(m, 1)}).io(new ItemStack[]{AntimatterMaterialTypes.DUST.get(m, 2)}).add(m.getId() + "_flawless", m.getMass(), 4L);
            RecipeMaps.MACERATING.RB().ii(new Ingredient[]{AntimatterMaterialTypes.GEM_FLAWED.getMaterialIngredient(m, 1)}).io(new ItemStack[]{AntimatterMaterialTypes.DUST_SMALL.get(m, 2)}).add(m.getId() + "_flawed", m.getMass(), 4L);
            RecipeMaps.MACERATING.RB().ii(new Ingredient[]{AntimatterMaterialTypes.GEM_CHIPPED.getMaterialIngredient(m, 1)}).io(new ItemStack[]{AntimatterMaterialTypes.DUST_SMALL.get(m, 1)}).add(m.getId() + "_chipped", m.getMass(), 4L);
        });
        AntimatterMaterialTypes.GEM_BRITTLE.all().forEach(m -> {
            if (!m.has(new IMaterialTag[]{AntimatterMaterialTypes.DUST})) {
                return;
            }
            RecipeMaps.MACERATING.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)AntimatterMaterialTypes.GEM_BRITTLE.get(m), (int)1)}).io(new ItemStack[]{AntimatterMaterialTypes.DUST_SMALL.get(m, 2)}).add("gem_brittle_" + m.getId(), 40L, 8L);
        });
        AntimatterMaterialTypes.GEM_POLISHED.all().forEach(m -> {
            if (!m.has(new IMaterialTag[]{AntimatterMaterialTypes.DUST})) {
                return;
            }
            RecipeMaps.MACERATING.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)AntimatterMaterialTypes.GEM_POLISHED.get(m), (int)1)}).io(new ItemStack[]{AntimatterMaterialTypes.DUST.get(m, 2)}).add("gem_polished_" + m.getId(), 60L, 16L);
        });
        AntimatterMaterialTypes.INGOT.all().forEach(t -> {
            if (!t.has(new IMaterialTag[]{AntimatterMaterialTypes.DUST})) {
                return;
            }
            RecipeMaps.MACERATING.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)AntimatterMaterialTypes.INGOT.getMaterialTag(t), (int)1)}).io(new ItemStack[]{AntimatterMaterialTypes.DUST.get(t, 1)}).add("dust_" + t.getId(), 40L, 2L);
        });
        AntimatterAPI.all(StoneType.class, s -> {
            if (s.getMaterial() == Material.NULL || !s.getMaterial().has(new IMaterialTag[]{AntimatterMaterialTypes.DUST}) || s.isSandLike()) {
                return;
            }
            RecipeMaps.MACERATING.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)s.getState().m_60734_().m_5456_(), (int)1)}).io(new ItemStack[]{AntimatterMaterialTypes.DUST.get(s.getMaterial(), 1)}).add(s.getMaterial().getId() + "_dust", 400L, 2L);
            if (s instanceof CobbleStoneType) {
                RecipeMaps.MACERATING.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)((CobbleStoneType)s).getBlock("cobble").m_5456_(), (int)1)}).io(new ItemStack[]{AntimatterMaterialTypes.DUST.get(s.getMaterial(), 1)}).add("cobbled_" + s.getMaterial().getId() + "_dust", 400L, 2L);
            }
        });
    }

    public static void init() {
        RecipeMaps.MACERATING.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)Items.f_41905_, (int)1)}).io(new ItemStack[]{new ItemStack((ItemLike)Items.f_41832_, 1)}).add("gravel", 100L, 2L);
        RecipeMaps.MACERATING.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)Items.f_42594_, (int)1)}).io(new ItemStack[]{new ItemStack((ItemLike)Items.f_41830_, 1)}).add("sand", 100L, 2L);
        RecipeMaps.MACERATING.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)Items.f_42460_, (int)1)}).io(new ItemStack[]{AntimatterMaterialTypes.DUST_SMALL.get(Materials.Brick, 2)}).add("brick_dust", 50L, 4L);
        RecipeMaps.MACERATING.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)Items.f_42413_, (int)1)}).io(new ItemStack[]{AntimatterMaterialTypes.DUST.get(AntimatterMaterials.Coal, 1)}).add("coal_dust", 50L, 4L);
        RecipeMaps.MACERATING.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)ItemTags.f_13182_, (int)1)}).io(new ItemStack[]{AntimatterMaterialTypes.DUST.get(AntimatterMaterials.Wood, 2)}).add("wood_dust", 40L, 2L);
        RecipeMaps.MACERATING.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)Items.f_42461_, (int)1)}).io(new ItemStack[]{AntimatterMaterialTypes.DUST_SMALL.get(Materials.Clay, 2)}).add("clay_dust_small", 16L, 4L);
        RecipeMaps.MACERATING.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)Items.f_41983_, (int)1)}).io(new ItemStack[]{AntimatterMaterialTypes.DUST.get(Materials.Clay, 2)}).add("clay_dust", 30L, 4L);
        RecipeMaps.MACERATING.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)Items.f_42199_, (int)1)}).io(new ItemStack[]{AntimatterMaterialTypes.DUST.get(Materials.Clay, 1)}).add("clay_dust_1", 16L, 4L);
        RecipeMaps.MACERATING.RB().ii(new Ingredient[]{RecipeIngredient.of(GregTechData.PlantBall, (int)1)}).io(new ItemStack[]{new ItemStack(GregTechData.Biochaff, 1)}).add("biochaff", 32L, 2L);
        RecipeMaps.MACERATING.RB().ii(new Ingredient[]{RecipeIngredient.of(GregTechData.Biochaff, (int)1)}).io(new ItemStack[]{new ItemStack((ItemLike)Items.f_42329_, 1)}).add("dirt", 32L, 2L);
        RecipeMaps.MACERATING.RB().ii(new Ingredient[]{RecipeIngredient.m_204132_((TagKey)GTRubberData.RUBBER_LOGS)}).io(new ItemStack[]{AntimatterMaterialTypes.DUST.get(AntimatterMaterials.Wood, 6), new ItemStack((ItemLike)GTRubberData.StickyResin, 1)}).chances(new double[]{1.0, 0.33}).add("rubber_log", 400L, 2L);
    }
}

