/*
 * Decompiled with CFR 0.152.
 */
package muramasa.gregtech.loader.machines;

import muramasa.antimatter.AntimatterAPI;
import muramasa.antimatter.data.AntimatterMaterialTypes;
import muramasa.antimatter.data.AntimatterMaterials;
import muramasa.antimatter.data.ForgeCTags;
import muramasa.antimatter.material.IMaterialTag;
import muramasa.antimatter.material.MaterialTags;
import muramasa.antimatter.ore.CobbleStoneType;
import muramasa.antimatter.ore.StoneType;
import muramasa.antimatter.recipe.ingredient.RecipeIngredient;
import muramasa.antimatter.util.TagUtils;
import muramasa.antimatter.util.Utils;
import muramasa.gregtech.data.Materials;
import muramasa.gregtech.data.RecipeMaps;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class HammerLoader {
    public static void init() {
        AntimatterMaterialTypes.CRUSHED.all().forEach(m -> {
            if (!m.has(new IMaterialTag[]{AntimatterMaterialTypes.ORE}) && m != AntimatterMaterials.Gold && m != AntimatterMaterials.Iron && m != AntimatterMaterials.Diamond && m != AntimatterMaterials.Emerald && m != AntimatterMaterials.Lapis && m != AntimatterMaterials.Redstone) {
                return;
            }
            int multiplier = 1;
            RecipeIngredient ore = RecipeIngredient.of((TagKey)TagUtils.getForgelikeItemTag((String)("ores/" + m.getId())), (int)1);
            RecipeIngredient crushed = AntimatterMaterialTypes.CRUSHED.getIngredient(m, 1);
            ItemStack crushedStack = AntimatterMaterialTypes.CRUSHED.get(m, 1);
            RecipeMaps.HAMMERING.RB().ii(new Ingredient[]{ore}).io(new ItemStack[]{Utils.ca((int)(MaterialTags.ORE_MULTI.getInt(m) * multiplier), (ItemStack)crushedStack)}).add(m.getId() + "_ore", 16L, 10L);
            RecipeMaps.HAMMERING.RB().ii(new Ingredient[]{crushed}).io(new ItemStack[]{AntimatterMaterialTypes.DUST_IMPURE.get(MaterialTags.MACERATE_INTO.getMapping(m), 1)}).add(m.getId() + "_crushed_ore", 16L, 10L);
            RecipeMaps.HAMMERING.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemStack)AntimatterMaterialTypes.CRUSHED_PURIFIED.get(m, 1))}).io(new ItemStack[]{AntimatterMaterialTypes.DUST_PURE.get(MaterialTags.MACERATE_INTO.getMapping(m), 1)}).add(m.getId() + "_purified_ore", 16L, 10L);
            if (m.has(new IMaterialTag[]{AntimatterMaterialTypes.CRUSHED_REFINED})) {
                RecipeMaps.HAMMERING.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemStack)AntimatterMaterialTypes.CRUSHED_REFINED.get(m, 1))}).io(new ItemStack[]{AntimatterMaterialTypes.DUST.get(MaterialTags.MACERATE_INTO.getMapping(m), 1)}).add(m.getId() + "_centrifuged_ore", 16L, 10L);
            }
            if (m.has(new IMaterialTag[]{AntimatterMaterialTypes.RAW_ORE})) {
                RecipeMaps.HAMMERING.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)AntimatterMaterialTypes.RAW_ORE.getMaterialTag(m), (int)1)}).io(new ItemStack[]{Utils.ca((int)(MaterialTags.ORE_MULTI.getInt(m) * multiplier), (ItemStack)crushedStack)}).add(m.getId() + "_raw_ore", 16L, 10L);
            }
        });
        AntimatterMaterialTypes.PLATE.all().forEach(plate -> {
            if (!plate.has(new IMaterialTag[]{AntimatterMaterialTypes.INGOT}) || plate.has(new IMaterialTag[]{MaterialTags.NOSMASH})) {
                return;
            }
            RecipeMaps.HAMMERING.RB().ii(new Ingredient[]{AntimatterMaterialTypes.INGOT.getMaterialIngredient(plate, 3)}).io(new ItemStack[]{AntimatterMaterialTypes.PLATE.get(plate, 2)}).add("plate_" + plate.getId(), plate.getMass() * 2L, 16L);
        });
        AntimatterMaterialTypes.ROD_LONG.all().stream().filter(m -> !m.has(new IMaterialTag[]{MaterialTags.NOSMASH})).forEach(rod -> RecipeMaps.HAMMERING.RB().ii(new Ingredient[]{AntimatterMaterialTypes.ROD.getMaterialIngredient(rod, 2)}).io(new ItemStack[]{AntimatterMaterialTypes.ROD_LONG.get(rod, 1)}).add("rod_long_" + rod.getId(), rod.getMass() * 2L, 16L));
        AntimatterMaterialTypes.GEM_EXQUISITE.all().forEach(m -> {
            RecipeMaps.HAMMERING.RB().ii(new Ingredient[]{AntimatterMaterialTypes.GEM_EXQUISITE.getMaterialIngredient(m, 1)}).io(new ItemStack[]{AntimatterMaterialTypes.GEM_FLAWLESS.get(m, 2)}).add(m.getId() + "_exquisite", 64L, 16L);
            RecipeMaps.HAMMERING.RB().ii(new Ingredient[]{AntimatterMaterialTypes.GEM_FLAWLESS.getMaterialIngredient(m, 1)}).io(new ItemStack[]{AntimatterMaterialTypes.GEM.get(m, 2)}).add(m.getId() + "_flawless", 64L, 16L);
            RecipeMaps.HAMMERING.RB().ii(new Ingredient[]{AntimatterMaterialTypes.GEM.getMaterialIngredient(m, 1)}).io(new ItemStack[]{AntimatterMaterialTypes.GEM_FLAWED.get(m, 2)}).add(m.getId() + "_flawed", 64L, 16L);
            RecipeMaps.HAMMERING.RB().ii(new Ingredient[]{AntimatterMaterialTypes.GEM_FLAWED.getMaterialIngredient(m, 1)}).io(new ItemStack[]{AntimatterMaterialTypes.GEM_CHIPPED.get(m, 2)}).add(m.getId() + "_chipped", 64L, 16L);
        });
        AntimatterAPI.all(StoneType.class, (String)"gti", s -> {
            if (!(s instanceof CobbleStoneType)) {
                return;
            }
            RecipeMaps.HAMMERING.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)((CobbleStoneType)s).getBlock(""), (int)1)}).io(new ItemStack[]{new ItemStack((ItemLike)((CobbleStoneType)s).getBlock("cobble"))}).add(s.getId() + "_to_cobble", 10L, 16L);
            RecipeMaps.HAMMERING.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)((CobbleStoneType)s).getBlock("cobble").m_5456_(), (int)1)}).io(new ItemStack[]{AntimatterMaterialTypes.DUST.get(s.getMaterial(), 1)}).add("cobbled_" + s.getMaterial().getId() + "_dust", 10L, 16L);
        });
        RecipeMaps.HAMMERING.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)Items.f_42594_, (int)1)}).io(new ItemStack[]{new ItemStack((ItemLike)Items.f_41832_)}).add("gravel", 10L, 16L);
        RecipeMaps.HAMMERING.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)Items.f_41905_, (int)1)}).io(new ItemStack[]{new ItemStack((ItemLike)Items.f_42594_)}).add("cobblestone", 10L, 16L);
        RecipeMaps.HAMMERING.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)ForgeCTags.GRAVEL, (int)1)}).io(new ItemStack[]{new ItemStack((ItemLike)Items.f_41830_)}).add("sand", 10L, 16L);
        RecipeMaps.HAMMERING.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)Items.f_42460_, (int)1)}).io(new ItemStack[]{AntimatterMaterialTypes.DUST_SMALL.get(Materials.Brick, 2)}).add("brick_dust_small", 10L, 16L);
        RecipeMaps.HAMMERING.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)Items.f_41995_, (int)1)}).io(new ItemStack[]{AntimatterMaterialTypes.DUST.get(Materials.Brick, 2)}).add("brick_dust", 40L, 16L);
    }
}

