/*
 * Decompiled with CFR 0.152.
 */
package muramasa.gregtech.loader.machines;

import muramasa.antimatter.Ref;
import muramasa.antimatter.data.AntimatterMaterialTypes;
import muramasa.antimatter.material.IMaterialTag;
import muramasa.antimatter.material.Material;
import muramasa.antimatter.material.MaterialTags;
import muramasa.antimatter.material.MaterialTypeItem;
import muramasa.antimatter.recipe.ingredient.RecipeIngredient;
import muramasa.gregtech.data.RecipeMaps;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.fluids.FluidStack;

public class FluidExtractor {
    public static void init() {
        AntimatterMaterialTypes.ROD.all().forEach(r -> FluidExtractor.add(r, AntimatterMaterialTypes.ROD, 0.5f));
        AntimatterMaterialTypes.PLATE.all().forEach(r -> FluidExtractor.add(r, AntimatterMaterialTypes.PLATE, 1.0f));
        AntimatterMaterialTypes.INGOT.all().forEach(r -> FluidExtractor.add(r, AntimatterMaterialTypes.INGOT, 1.0f));
        AntimatterMaterialTypes.SCREW.all().forEach(r -> FluidExtractor.add(r, AntimatterMaterialTypes.SCREW, 0.125f));
        AntimatterMaterialTypes.GEAR.all().forEach(r -> FluidExtractor.add(r, AntimatterMaterialTypes.GEAR, 4.0f));
        AntimatterMaterialTypes.FOIL.all().forEach(r -> FluidExtractor.add(r, AntimatterMaterialTypes.FOIL, 0.25f));
        AntimatterMaterialTypes.BOLT.all().forEach(r -> FluidExtractor.add(r, AntimatterMaterialTypes.BOLT, 0.125f));
        AntimatterMaterialTypes.PLATE_DENSE.all().forEach(r -> FluidExtractor.add(r, AntimatterMaterialTypes.PLATE_DENSE, 9.0f));
    }

    private static void add(Material m, MaterialTypeItem<?> i, float ratio) {
        if (!m.has(new IMaterialTag[]{AntimatterMaterialTypes.LIQUID})) {
            return;
        }
        long amount = (long)((float)Ref.L * ratio);
        RecipeMaps.FLUID_EXTRACTING.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)i.getMaterialTag(m), (int)1)}).fo(new FluidStack[]{m.getLiquid(amount)}).add(m.getId() + "_from_" + i.getId(), (long)((float)m.getMass() * ((float)amount / (float)Ref.L)), 64L, (long)MaterialTags.MELTING_POINT.getInt(m));
    }
}

