/*
 * Decompiled with CFR 0.152.
 */
package muramasa.gregtech.loader.machines;

import muramasa.antimatter.AntimatterAPI;
import muramasa.antimatter.data.AntimatterMaterialTypes;
import muramasa.antimatter.data.AntimatterMaterials;
import muramasa.antimatter.material.IMaterialTag;
import muramasa.antimatter.material.Material;
import muramasa.antimatter.pipe.PipeItemBlock;
import muramasa.antimatter.pipe.PipeSize;
import muramasa.antimatter.pipe.types.FluidPipe;
import muramasa.antimatter.pipe.types.HeatPipe;
import muramasa.antimatter.pipe.types.ItemPipe;
import muramasa.antimatter.pipe.types.PipeType;
import muramasa.antimatter.pipe.types.Wire;
import muramasa.antimatter.recipe.ingredient.RecipeIngredient;
import muramasa.gregtech.data.GregTechData;
import muramasa.gregtech.data.RecipeMaps;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class ExtruderLoader {
    public static void init() {
        AntimatterMaterialTypes.RING.all().forEach(r -> {
            if (!r.has(new IMaterialTag[]{AntimatterMaterialTypes.INGOT})) {
                return;
            }
            long duration = r.getElement() == null ? Math.max(r.getMass(), 1L) : (long)r.getElement().getHardness();
            RecipeMaps.EXTRUDING.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)AntimatterMaterialTypes.INGOT.getMaterialTag(r), (int)1), RecipeIngredient.of(GregTechData.ShapeRing, (int)1).setNoConsume()}).io(new ItemStack[]{AntimatterMaterialTypes.RING.get(r, 4)}).add("ring_" + r.getId(), duration, 30L);
        });
        AntimatterMaterialTypes.GEAR.all().forEach(g -> {
            if (!g.has(new IMaterialTag[]{AntimatterMaterialTypes.INGOT})) {
                return;
            }
            long duration = g.getElement() == null ? Math.max(g.getMass(), 1L) : (long)g.getElement().getHardness();
            RecipeMaps.EXTRUDING.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)AntimatterMaterialTypes.INGOT.getMaterialTag(g), (int)4), RecipeIngredient.of(GregTechData.ShapeGear, (int)1).setNoConsume()}).io(new ItemStack[]{AntimatterMaterialTypes.GEAR.get(g, 1)}).add("gear_" + g.getId(), duration * 4L, 30L);
        });
        AntimatterMaterialTypes.BOLT.all().forEach(b -> {
            if (!b.has(new IMaterialTag[]{AntimatterMaterialTypes.INGOT})) {
                return;
            }
            long duration = b.getElement() == null ? Math.max(b.getMass(), 1L) : (long)b.getElement().getHardness();
            RecipeMaps.EXTRUDING.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)AntimatterMaterialTypes.INGOT.getMaterialTag(b), (int)1), RecipeIngredient.of(GregTechData.ShapeBolt, (int)1).setNoConsume()}).io(new ItemStack[]{AntimatterMaterialTypes.BOLT.get(b, 8)}).add("bolt_" + b.getId(), duration, 30L);
        });
        AntimatterMaterialTypes.GEAR_SMALL.all().forEach(g -> {
            if (!g.has(new IMaterialTag[]{AntimatterMaterialTypes.INGOT})) {
                return;
            }
            long duration = g.getElement() == null ? Math.max(g.getMass(), 1L) : (long)g.getElement().getHardness();
            RecipeMaps.EXTRUDING.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)AntimatterMaterialTypes.INGOT.getMaterialTag(g), (int)1), RecipeIngredient.of(GregTechData.ShapeGearSmall, (int)1).setNoConsume()}).io(new ItemStack[]{AntimatterMaterialTypes.GEAR_SMALL.get(g, 1)}).add("gear_small_" + g.getId(), duration, 30L);
        });
        AntimatterMaterialTypes.PLATE.all().forEach(p -> {
            if (!p.has(new IMaterialTag[]{AntimatterMaterialTypes.INGOT})) {
                return;
            }
            long duration = p.getElement() == null ? Math.max(p.getMass(), 1L) : (long)p.getElement().getHardness();
            RecipeMaps.EXTRUDING.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)AntimatterMaterialTypes.INGOT.getMaterialTag(p), (int)1), RecipeIngredient.of(GregTechData.ShapePlate, (int)1).setNoConsume()}).io(new ItemStack[]{AntimatterMaterialTypes.PLATE.get(p, 1)}).add("plate_" + p.getId(), duration, 30L);
        });
        AntimatterMaterialTypes.ROD.all().forEach(r -> {
            if (!r.has(new IMaterialTag[]{AntimatterMaterialTypes.INGOT})) {
                return;
            }
            long duration = r.getElement() == null ? Math.max(r.getMass(), 1L) : (long)r.getElement().getHardness();
            RecipeMaps.EXTRUDING.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)AntimatterMaterialTypes.INGOT.getMaterialTag(r), (int)1), RecipeIngredient.of(GregTechData.ShapeRod, (int)1).setNoConsume()}).io(new ItemStack[]{AntimatterMaterialTypes.ROD.get(r, 2)}).add("rod_" + r.getId(), duration, 30L);
        });
        AntimatterAPI.all(Wire.class).forEach(t -> {
            PipeItemBlock wireItem = t.getBlockItem(PipeSize.VTINY);
            ItemStack stack = new ItemStack((ItemLike)wireItem, 2);
            long duration = t.getMaterial().getElement() == null ? Math.max(t.getMaterial().getMass(), 1L) : (long)t.getMaterial().getElement().getHardness();
            RecipeMaps.EXTRUDING.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)AntimatterMaterialTypes.INGOT.getMaterialTag(t.getMaterial()), (int)1), RecipeIngredient.of(GregTechData.ShapeWire, (int)1).setNoConsume()}).io(new ItemStack[]{stack}).add("wire_" + t.getMaterial().getId(), duration, 30L);
        });
        AntimatterAPI.all(FluidPipe.class).stream().filter(t -> t.getMaterial() != AntimatterMaterials.Wood).forEach(t -> {
            ExtruderLoader.addPipeRecipe(t.getMaterial(), 1, 2, PipeSize.TINY, t, 2);
            ExtruderLoader.addPipeRecipe(t.getMaterial(), 1, 1, PipeSize.SMALL, t, 1);
            ExtruderLoader.addPipeRecipe(t.getMaterial(), 3, 1, PipeSize.NORMAL, t, 3);
            ExtruderLoader.addPipeRecipe(t.getMaterial(), 6, 1, PipeSize.LARGE, t, 6);
            ExtruderLoader.addPipeRecipe(t.getMaterial(), 12, 1, PipeSize.HUGE, t, 12);
        });
        AntimatterAPI.all(ItemPipe.class).forEach(t -> {
            ExtruderLoader.addPipeRecipe(t.getMaterial(), 1, 2, PipeSize.TINY, t, 2);
            ExtruderLoader.addPipeRecipe(t.getMaterial(), 1, 1, PipeSize.SMALL, t, 1);
            ExtruderLoader.addPipeRecipe(t.getMaterial(), 3, 1, PipeSize.NORMAL, t, 3);
            ExtruderLoader.addPipeRecipe(t.getMaterial(), 6, 1, PipeSize.LARGE, t, 6);
            ExtruderLoader.addPipeRecipe(t.getMaterial(), 12, 1, PipeSize.HUGE, t, 12);
        });
        AntimatterAPI.all(HeatPipe.class).forEach(t -> {
            ExtruderLoader.addPipeRecipe(t.getMaterial(), 1, 2, PipeSize.TINY, t, 10);
            ExtruderLoader.addPipeRecipe(t.getMaterial(), 1, 1, PipeSize.SMALL, t, 20);
            ExtruderLoader.addPipeRecipe(t.getMaterial(), 3, 1, PipeSize.NORMAL, t, 30);
            ExtruderLoader.addPipeRecipe(t.getMaterial(), 6, 1, PipeSize.LARGE, t, 40);
            ExtruderLoader.addPipeRecipe(t.getMaterial(), 12, 1, PipeSize.HUGE, t, 50);
        });
    }

    private static void addPipeRecipe(Material material, int countIn, int countOut, PipeSize size, PipeType<?> pipe, int durationMultiplier) {
        if (pipe.getSizes().contains((Object)size)) {
            long duration = material.getElement() == null ? Math.max(material.getMass(), 1L) : (long)material.getElement().getHardness();
            RecipeMaps.EXTRUDING.RB().ii(new Ingredient[]{AntimatterMaterialTypes.INGOT.getMaterialIngredient(material, countIn), RecipeIngredient.of((ItemLike)ExtruderLoader.getPipeMold(size), (int)1).setNoConsume()}).io(new ItemStack[]{new ItemStack((ItemLike)pipe.getBlockItem(size), countOut)}).add(size.getId() + "_" + pipe.getType() + "_" + material.getId(), duration * (long)durationMultiplier, 30L);
        }
    }

    private static Item getPipeMold(PipeSize size) {
        return switch (size) {
            default -> throw new IncompatibleClassChangeError();
            case PipeSize.HUGE -> GregTechData.ShapePipeHuge;
            case PipeSize.LARGE -> GregTechData.ShapePipeLarge;
            case PipeSize.NORMAL -> GregTechData.ShapePipeNormal;
            case PipeSize.SMALL -> GregTechData.ShapePipeSmall;
            case PipeSize.TINY, PipeSize.VTINY -> GregTechData.ShapePipeTiny;
        };
    }
}

