/*
 * Decompiled with CFR 0.152.
 */
package muramasa.gregtech.loader.machines;

import muramasa.antimatter.data.AntimatterMaterialTypes;
import muramasa.antimatter.material.IMaterialTag;
import muramasa.antimatter.material.MaterialTags;
import muramasa.antimatter.recipe.ingredient.RecipeIngredient;
import muramasa.gregtech.data.GregTechMaterialTags;
import muramasa.gregtech.data.RecipeMaps;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;

public class ElectrolyzerLoader {
    public static void init() {
        AntimatterMaterialTypes.DUST.all().stream().filter(t -> t.has(new IMaterialTag[]{GregTechMaterialTags.ELEC})).forEach(t -> {
            FluidStack[] fluids;
            for (FluidStack fluid : fluids = (FluidStack[])t.getProcessInto().stream().filter(mat -> (mat.m.has(new IMaterialTag[]{AntimatterMaterialTypes.GAS}) || mat.m.has(new IMaterialTag[]{AntimatterMaterialTypes.LIQUID})) && !mat.m.has(new IMaterialTag[]{AntimatterMaterialTypes.DUST})).map(mat -> mat.m.has(new IMaterialTag[]{AntimatterMaterialTypes.GAS}) ? mat.m.getGas(mat.s * 1000) : mat.m.getLiquid(mat.s * 1000)).toArray(FluidStack[]::new)) {
                if (!fluid.isEmpty()) continue;
                return;
            }
            if (fluids.length > 6) {
                return;
            }
            int euPerTick = t.has(new IMaterialTag[]{GregTechMaterialTags.ELEC30}) ? 30 : (t.has(new IMaterialTag[]{GregTechMaterialTags.ELEC60}) ? 60 : (t.has(new IMaterialTag[]{GregTechMaterialTags.ELEC90}) ? 90 : 120));
            ItemStack[] items = (ItemStack[])t.getProcessInto().stream().filter(mat -> mat.m.has(new IMaterialTag[]{AntimatterMaterialTypes.DUST})).map(mat -> AntimatterMaterialTypes.DUST.get(mat.m, mat.s)).toArray(ItemStack[]::new);
            int inputAmount = (Integer)((Pair)MaterialTags.PROCESS_INTO.get(t)).getRight() > 0 ? ((Integer)((Pair)MaterialTags.PROCESS_INTO.get(t)).getRight()).intValue() : t.getProcessInto().stream().mapToInt(mat -> mat.s).sum();
            RecipeIngredient input = AntimatterMaterialTypes.DUST.getMaterialIngredient(t, inputAmount);
            RecipeMaps.ELECTROLYZING.RB().ii(new Ingredient[]{input}).io(items).fo(fluids).add("dust_" + t.getId(), t.getMass() * 20L, (long)euPerTick);
        });
    }
}

