/*
 * Decompiled with CFR 0.152.
 */
package muramasa.gregtech.loader.machines;

import muramasa.antimatter.data.AntimatterMaterialTypes;
import muramasa.antimatter.data.AntimatterMaterials;
import muramasa.antimatter.material.IMaterialTag;
import muramasa.antimatter.material.Material;
import muramasa.antimatter.material.MaterialTags;
import muramasa.antimatter.recipe.ingredient.RecipeIngredient;
import muramasa.gregtech.data.Materials;
import muramasa.gregtech.data.RecipeMaps;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;

public class CuttingLoader {
    public static void init() {
        for (Material mat : AntimatterMaterialTypes.PLATE.all()) {
            if (!mat.has(new IMaterialTag[]{AntimatterMaterialTypes.BLOCK})) continue;
            int multiplier = 1;
            if (mat == AntimatterMaterials.Diamond || mat == AntimatterMaterials.NetherizedDiamond) {
                multiplier = 5;
            }
            int count = mat.has(new IMaterialTag[]{MaterialTags.QUARTZ_LIKE_BLOCKS}) ? 4 : 9;
            CuttingLoader.addCutterRecipe((TagKey<Item>)AntimatterMaterialTypes.BLOCK.getMaterialTag(mat), AntimatterMaterialTypes.PLATE.get(mat, count), "plate_" + mat.getId(), (int)(mat.getMass() * 10L * (long)multiplier), 30);
            if (!mat.has(new IMaterialTag[]{AntimatterMaterialTypes.ITEM_CASING})) continue;
            CuttingLoader.addCutterRecipe((TagKey<Item>)AntimatterMaterialTypes.PLATE.getMaterialTag(mat), AntimatterMaterialTypes.ITEM_CASING.get(mat, 2), "item_casing_" + mat.getId(), (int)(mat.getMass() * 5L * (long)multiplier), 16);
        }
        AntimatterMaterialTypes.BOLT.all().forEach(t -> {
            if (t.has(new IMaterialTag[]{AntimatterMaterialTypes.ROD})) {
                CuttingLoader.addCutterRecipe((TagKey<Item>)AntimatterMaterialTypes.ROD.getMaterialTag(t), AntimatterMaterialTypes.BOLT.get(t, 4), "bolt_" + t.getId(), (int)(t.getMass() * 2L), 4);
            }
        });
        AntimatterMaterialTypes.ROD_LONG.all().forEach(m -> CuttingLoader.addCutterRecipe((TagKey<Item>)AntimatterMaterialTypes.ROD_LONG.getMaterialTag(m), AntimatterMaterialTypes.ROD.get(m, 2), "rod_" + m.getId(), (int)(m.getMass() * 2L), 4));
    }

    private static void addCutterRecipe(TagKey<Item> input, ItemStack output, String id, int duration, int euPerTick) {
        RecipeMaps.CUTTING.RB().ii(new Ingredient[]{RecipeIngredient.of(input, (int)1)}).fi(new FluidStack[]{new FluidStack((Fluid)Fluids.f_76193_, Math.max(4, Math.min(1000, duration * euPerTick / 320)))}).io(new ItemStack[]{output}).add(id + "_with_water", (long)duration * 2L, (long)euPerTick);
        RecipeMaps.CUTTING.RB().ii(new Ingredient[]{RecipeIngredient.of(input, (int)1)}).fi(new FluidStack[]{Materials.Lubricant.getLiquid(Math.max(1, Math.min(250, duration * euPerTick / 1280)))}).io(new ItemStack[]{output}).add(id + "_with_lubricant", (long)duration, (long)euPerTick);
        RecipeMaps.CUTTING.RB().ii(new Ingredient[]{RecipeIngredient.of(input, (int)1)}).fi(new FluidStack[]{Materials.DistilledWater.getLiquid(Math.max(3, Math.min(750, duration * euPerTick / 426)))}).io(new ItemStack[]{output}).add(id + "_with_distilled_water", (long)duration * 2L, (long)euPerTick);
    }
}

