/*
 * Decompiled with CFR 0.152.
 */
package muramasa.gregtech.loader.machines;

import muramasa.antimatter.data.AntimatterMaterialTypes;
import muramasa.antimatter.data.AntimatterMaterials;
import muramasa.antimatter.recipe.ingredient.RecipeIngredient;
import muramasa.antimatter.util.AntimatterPlatformUtils;
import muramasa.gregtech.data.Materials;
import muramasa.gregtech.data.RecipeMaps;
import muramasa.gregtech.data.TierMaps;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;

public class ChemicalReactorLoader {
    public static void init() {
        ChemicalReactorLoader.addChemicalRecipesSimple();
        ChemicalReactorLoader.nuclear_processing();
    }

    private static void addChemicalRecipesSimple() {
        RecipeMaps.CHEMICAL_REACTING.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)AntimatterMaterialTypes.DUST.getMaterialTag(Materials.Rutile), (int)1), RecipeIngredient.of((TagKey)AntimatterMaterialTypes.DUST.getMaterialTag(Materials.Carbon), (int)2)}).fi(new FluidStack[]{Materials.Chlorine.getGas(4000)}).fo(new FluidStack[]{Materials.Titaniumtetrachloride.getLiquid(1000), Materials.CarbonMonoxide.getGas(2000)}).add("titanium_tetrachloride", 500L, 480L);
        RecipeMaps.CHEMICAL_REACTING.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)AntimatterMaterialTypes.DUST.getMaterialTag(Materials.Sulfur), (int)1), ((RecipeIngredient)TierMaps.INT_CIRCUITS.get((Object)1)).setNoConsume()}).fi(new FluidStack[]{AntimatterMaterials.Water.getLiquid(2000)}).fo(new FluidStack[]{Materials.SulfuricAcid.getLiquid(3000)}).add("sulfuric_acid", 1150L, 30L);
        RecipeMaps.CHEMICAL_REACTING.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)AntimatterMaterialTypes.DUST.getMaterialTag(Materials.Sulfur), (int)1), ((RecipeIngredient)TierMaps.INT_CIRCUITS.get((Object)2)).setNoConsume()}).fi(new FluidStack[]{AntimatterMaterials.Water.getLiquid(3000), Materials.Oxygen.getGas(3000)}).fo(new FluidStack[]{Materials.SulfuricAcid.getLiquid(7000)}).add("sulfuric_acid_2", 480L, 30L);
        RecipeMaps.CHEMICAL_REACTING.RB().fi(new FluidStack[]{AntimatterMaterials.Water.getLiquid(1000), Materials.HydrogenSulfide.getGas(1000)}).fo(new FluidStack[]{Materials.SulfuricAcid.getLiquid(1500)}).add("sulfuric_acid_3", 320L, 30L);
        RecipeMaps.CHEMICAL_REACTING.RB().fi(new FluidStack[]{Materials.Oxygen.getGas(4000), Materials.HydrogenSulfide.getGas(3000)}).ii(new Ingredient[]{((RecipeIngredient)TierMaps.INT_CIRCUITS.get((Object)2)).setNoConsume()}).fo(new FluidStack[]{Materials.SulfuricAcid.getLiquid(7000)}).add("sulfuric_acid_4", 240L, 30L);
        RecipeMaps.CHEMICAL_REACTING.RB().fi(new FluidStack[]{Materials.Oxygen.getGas(1000), Materials.HydrogenSulfide.getGas(750)}).ii(new Ingredient[]{((RecipeIngredient)TierMaps.INT_CIRCUITS.get((Object)1)).setNoConsume()}).fo(new FluidStack[]{Materials.SulfuricAcid.getLiquid(1750)}).add("sulfuric_acid_5", 60L, 30L);
        RecipeMaps.CHEMICAL_REACTING.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)AntimatterMaterialTypes.DUST.getMaterialTag(Materials.Sulfur), (int)1)}).fi(new FluidStack[]{Materials.Hydrogen.getGas(2000)}).fo(new FluidStack[]{Materials.HydrogenSulfide.getGas(3000)}).add("hydrogen_sulfide", 60L, 8L);
        RecipeMaps.CHEMICAL_REACTING.RB().fi(new FluidStack[]{Materials.Hydrogen.getGas(125), Materials.NaturalGas.getGas(2000)}).fo(new FluidStack[]{Materials.HydrogenSulfide.getGas(125), Materials.RefineryGas.getGas(2000)}).add("hydrogen_sulfide_2", 20L, 30L);
        RecipeMaps.CHEMICAL_REACTING.RB().fi(new FluidStack[]{Materials.Hydrogen.getGas(125), Materials.SulfuricHeavyFuel.getLiquid(1000)}).fo(new FluidStack[]{Materials.HydrogenSulfide.getGas(125), Materials.HeavyFuel.getLiquid(1000)}).add("hydrogen_sulfide_3", 20L, 30L);
        RecipeMaps.CHEMICAL_REACTING.RB().fi(new FluidStack[]{Materials.Hydrogen.getGas(125), Materials.SulfuricGas.getGas(1000)}).fo(new FluidStack[]{Materials.HydrogenSulfide.getGas(125), Materials.RefineryGas.getGas(1000)}).add("hydrogen_sulfide_4", 20L, 30L);
        RecipeMaps.CHEMICAL_REACTING.RB().fi(new FluidStack[]{Materials.Hydrogen.getGas(250), Materials.SulfuricLightFuel.getLiquid(3000)}).fo(new FluidStack[]{Materials.HydrogenSulfide.getGas(250), Materials.LightFuel.getLiquid(3000)}).add("hydrogen_sulfide_5", 40L, 30L);
        RecipeMaps.CHEMICAL_REACTING.RB().fi(new FluidStack[]{Materials.Hydrogen.getGas(250), Materials.SulfuricNaphtha.getLiquid(3000)}).fo(new FluidStack[]{Materials.HydrogenSulfide.getGas(250), Materials.Naphtha.getLiquid(3000)}).add("hydrogen_sulfide_6", 40L, 30L);
        RecipeMaps.CHEMICAL_REACTING.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)AntimatterMaterialTypes.DUST.getMaterialTag(Materials.Sulfur), (int)1), RecipeIngredient.of((ItemLike)AntimatterMaterialTypes.DUST.get(Materials.RawRubber), (int)9)}).fo(new FluidStack[]{Materials.Rubber.getLiquid(AntimatterPlatformUtils.isFabric() ? 1000 : 1296)}).add("rubber", 200L, 8L);
        RecipeMaps.CHEMICAL_REACTING.RB().fi(new FluidStack[]{Materials.Oxygen.getGas(14000), Materials.Isoprene.getLiquid(2000)}).ii(new Ingredient[]{((RecipeIngredient)TierMaps.INT_CIRCUITS.get((Object)2)).setNoConsume()}).io(new ItemStack[]{new ItemStack((ItemLike)AntimatterMaterialTypes.DUST.get(Materials.RawRubber), 21)}).add("raw_rubber_dust", 2240L, 30L);
        RecipeMaps.CHEMICAL_REACTING.RB().fi(new FluidStack[]{Materials.Oxygen.getGas(2000), Materials.Isoprene.getLiquid(288)}).ii(new Ingredient[]{((RecipeIngredient)TierMaps.INT_CIRCUITS.get((Object)1)).setNoConsume()}).io(new ItemStack[]{new ItemStack((ItemLike)AntimatterMaterialTypes.DUST.get(Materials.RawRubber), 3)}).add("raw_rubber_dust_2", 320L, 30L);
        RecipeMaps.CHEMICAL_REACTING.RB().fi(new FluidStack[]{Materials.Oxygen.getGas(2000), Materials.Naphtha.getLiquid(144)}).fo(new FluidStack[]{Materials.Polyethylene.getLiquid(72)}).add("ethylene_to_polyethylene", 320L, 30L);
        RecipeMaps.CHEMICAL_REACTING.RB().fi(new FluidStack[]{Materials.Oxygen.getGas(1000), Materials.Ethylene.getGas(144)}).fo(new FluidStack[]{Materials.Polyethylene.getLiquid(216)}).add("ethylene_to_polyethylene_1", 160L, 30L);
        RecipeMaps.CHEMICAL_REACTING.RB().fi(new FluidStack[]{Materials.Oxygen.getGas(2000), Materials.Ethylene.getGas(288)}).ii(new Ingredient[]{((RecipeIngredient)TierMaps.INT_CIRCUITS.get((Object)1)).setNoConsume()}).fo(new FluidStack[]{Materials.Polyethylene.getLiquid(288)}).add("polyethylene_2", 320L, 30L);
        RecipeMaps.CHEMICAL_REACTING.RB().fi(new FluidStack[]{Materials.Oxygen.getGas(16000), Materials.Naphtha.getLiquid(1296)}).ii(new Ingredient[]{RecipeIngredient.of((TagKey)AntimatterMaterialTypes.DUST_TINY.getMaterialTag(Materials.Titanium), (int)1)}).fo(new FluidStack[]{Materials.Polyethylene.getLiquid(1296)}).add("ethylene_to_polyethylene_3", 640L, 30L);
        RecipeMaps.CHEMICAL_REACTING.RB().fi(new FluidStack[]{Materials.Oxygen.getGas(7000), Materials.Ethylene.getGas(1000)}).ii(new Ingredient[]{((RecipeIngredient)TierMaps.INT_CIRCUITS.get((Object)2)).setNoConsume()}).fo(new FluidStack[]{Materials.Polyethylene.getLiquid(1500)}).add("ethylene_to_polyethylene_4", 1120L, 30L);
        RecipeMaps.CHEMICAL_REACTING.RB().fi(new FluidStack[]{Materials.Oxygen.getGas(1000), Materials.VinylChloride.getGas(144)}).fo(new FluidStack[]{Materials.PolyvinylChloride.getLiquid(216)}).add("vinylchloride_to_polyvinylchloride", 160L, 30L);
        RecipeMaps.CHEMICAL_REACTING.RB().fi(new FluidStack[]{Materials.Oxygen.getGas(7000), Materials.VinylChloride.getGas(1000)}).fo(new FluidStack[]{Materials.PolyvinylChloride.getLiquid(1500)}).add("vinylchloride_to_polyvinylchloride_1", 1120L, 30L);
        RecipeMaps.CHEMICAL_REACTING.RB().fi(new FluidStack[]{Materials.Fluorine.getGas(1000), Materials.Ethylene.getGas(500)}).ii(new Ingredient[]{((RecipeIngredient)TierMaps.INT_CIRCUITS.get((Object)1)).setNoConsume()}).fo(new FluidStack[]{Materials.Tetrafluoroethylene.getGas(1500)}).add("ethylene_to_tetrafluoroethylene", 90L, 180L);
        RecipeMaps.CHEMICAL_REACTING.RB().fi(new FluidStack[]{Materials.Fluorine.getGas(2000), Materials.Ethylene.getGas(1000)}).ii(new Ingredient[]{((RecipeIngredient)TierMaps.INT_CIRCUITS.get((Object)2)).setNoConsume()}).fo(new FluidStack[]{Materials.Tetrafluoroethylene.getGas(3000)}).add("ethylene_to_tetrafluoroethylene_1", 180L, 180L);
        RecipeMaps.CHEMICAL_REACTING.RB().fi(new FluidStack[]{Materials.Oxygen.getGas(1000), Materials.Tetrafluoroethylene.getGas(144)}).ii(new Ingredient[]{((RecipeIngredient)TierMaps.INT_CIRCUITS.get((Object)1)).setNoConsume()}).fo(new FluidStack[]{Materials.Polytetrafluoroethylene.getLiquid(216)}).add("tetrafluoroethylene_to_polytetrafluoroethylene", 160L, 30L);
        RecipeMaps.CHEMICAL_REACTING.RB().fi(new FluidStack[]{Materials.Oxygen.getGas(7000), Materials.Tetrafluoroethylene.getGas(1000)}).ii(new Ingredient[]{((RecipeIngredient)TierMaps.INT_CIRCUITS.get((Object)2)).setNoConsume()}).fo(new FluidStack[]{Materials.Polytetrafluoroethylene.getLiquid(1500)}).add("tetrafluoroethylene_to_polytetrafluoroethylene_1", 1120L, 30L);
        RecipeMaps.CHEMICAL_REACTING.RB().fi(new FluidStack[]{Materials.Naphtha.getLiquid(3000), Materials.Fluorine.getGas(1000), Materials.Epichlorohydrin.getLiquid(432)}).fo(new FluidStack[]{Materials.Polytetrafluoroethylene.getLiquid(432)}).add("tetrafluoroethylene_to_polytetrafluoroethylene_2", 240L, 256L);
        RecipeMaps.CHEMICAL_REACTING.RB().fi(new FluidStack[]{Materials.Benzene.getLiquid(1000), Materials.Ethylene.getGas(500)}).ii(new Ingredient[]{((RecipeIngredient)TierMaps.INT_CIRCUITS.get((Object)1)).setNoConsume()}).fo(new FluidStack[]{Materials.Styrene.getLiquid(1500)}).add("ethylene_to_styrene", 60L, 30L);
        RecipeMaps.CHEMICAL_REACTING.RB().fi(new FluidStack[]{Materials.Benzene.getLiquid(2000), Materials.Ethylene.getGas(1000)}).ii(new Ingredient[]{((RecipeIngredient)TierMaps.INT_CIRCUITS.get((Object)2)).setNoConsume()}).fo(new FluidStack[]{Materials.Styrene.getLiquid(3000)}).add("ethylene_to_styrene_1", 120L, 30L);
        RecipeMaps.CHEMICAL_REACTING.RB().fi(new FluidStack[]{Materials.Oxygen.getGas(1000), Materials.Styrene.getLiquid(144)}).ii(new Ingredient[]{((RecipeIngredient)TierMaps.INT_CIRCUITS.get((Object)1)).setNoConsume()}).fo(new FluidStack[]{Materials.Polystyrene.getLiquid(216)}).add("styrene_to_polystyrene", 160L, 30L);
        RecipeMaps.CHEMICAL_REACTING.RB().fi(new FluidStack[]{Materials.Oxygen.getGas(7000), Materials.Styrene.getLiquid(1000)}).ii(new Ingredient[]{((RecipeIngredient)TierMaps.INT_CIRCUITS.get((Object)2)).setNoConsume()}).fo(new FluidStack[]{Materials.Polystyrene.getLiquid(1500)}).add("styrene_to_polystyrene_1", 1120L, 30L);
        RecipeMaps.CHEMICAL_REACTING.RB().ii(new Ingredient[]{AntimatterMaterialTypes.DUST.getMaterialIngredient(Materials.Carbon, 1)}).fi(new FluidStack[]{Materials.Hydrogen.getGas(4000)}).fo(new FluidStack[]{Materials.Methane.getGas(5000)}).add("methane", 14000L, 30L);
        RecipeMaps.CHEMICAL_REACTING.RB().fi(new FluidStack[]{Materials.Propene.getGas(1500), Materials.Ethylene.getGas(1000)}).ii(new Ingredient[]{((RecipeIngredient)TierMaps.INT_CIRCUITS.get((Object)1)).setNoConsume()}).fo(new FluidStack[]{Materials.Isoprene.getLiquid(1500)}).add("isopropene", 60L, 30L);
        RecipeMaps.CHEMICAL_REACTING.RB().fi(new FluidStack[]{Materials.Propene.getGas(3000), Materials.Ethylene.getGas(2000)}).ii(new Ingredient[]{((RecipeIngredient)TierMaps.INT_CIRCUITS.get((Object)2)).setNoConsume()}).fo(new FluidStack[]{Materials.Isoprene.getLiquid(5000)}).add("isopropene_1", 120L, 30L);
        RecipeMaps.CHEMICAL_REACTING.RB().fi(new FluidStack[]{Materials.Benzene.getLiquid(1000)}).ii(new Ingredient[]{RecipeIngredient.of((TagKey)AntimatterMaterialTypes.DUST.getMaterialTag(Materials.Sulfur), (int)1)}).fo(new FluidStack[]{Materials.PolyphenyleneSulfide.getLiquid(2000)}).add("polyphenylene_sulfide", 320L, 30L);
        RecipeMaps.CHEMICAL_REACTING.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)AntimatterMaterialTypes.DUST.getMaterialTag(Materials.Carbon), (int)1)}).fi(new FluidStack[]{Materials.LPG.getGas(432), Materials.Chlorine.getGas(1000)}).fo(new FluidStack[]{Materials.Epichlorohydrin.getLiquid(432)}).add("epichlorohydrin", 480L, 30L);
        RecipeMaps.CHEMICAL_REACTING.RB().fi(new FluidStack[]{Materials.Hydrogen.getGas(1000), Materials.CarbonDioxide.getGas(500)}).ii(new Ingredient[]{((RecipeIngredient)TierMaps.INT_CIRCUITS.get((Object)1)).setNoConsume()}).fo(new FluidStack[]{Materials.Methanol.getLiquid(1000)}).add("methanol", 100L, 120L);
        RecipeMaps.CHEMICAL_REACTING.RB().fi(new FluidStack[]{Materials.Hydrogen.getGas(2000), Materials.CarbonDioxide.getGas(1000)}).ii(new Ingredient[]{((RecipeIngredient)TierMaps.INT_CIRCUITS.get((Object)2)).setNoConsume()}).fo(new FluidStack[]{Materials.Methanol.getLiquid(2000), AntimatterMaterials.Water.getLiquid(1000)}).add("methanol_1", 200L, 120L);
        RecipeMaps.CHEMICAL_REACTING.RB().fi(new FluidStack[]{Materials.Hydrogen.getGas(2000), Materials.CarbonDioxide.getGas(1000)}).ii(new Ingredient[]{((RecipeIngredient)TierMaps.INT_CIRCUITS.get((Object)3)).setNoConsume()}).fo(new FluidStack[]{Materials.Methanol.getLiquid(2000)}).add("methanol_2", 200L, 120L);
        RecipeMaps.CHEMICAL_REACTING.RB().fi(new FluidStack[]{Materials.Hydrogen.getGas(1000), Materials.CarbonMonoxide.getGas(500)}).ii(new Ingredient[]{((RecipeIngredient)TierMaps.INT_CIRCUITS.get((Object)1)).setNoConsume()}).fo(new FluidStack[]{Materials.Methanol.getLiquid(1500)}).add("methanol_3", 150L, 120L);
        RecipeMaps.CHEMICAL_REACTING.RB().fi(new FluidStack[]{Materials.Hydrogen.getGas(2000), Materials.CarbonMonoxide.getGas(1000)}).ii(new Ingredient[]{((RecipeIngredient)TierMaps.INT_CIRCUITS.get((Object)2)).setNoConsume()}).fo(new FluidStack[]{Materials.Methanol.getLiquid(3000)}).add("methanol_4", 150L, 120L);
        RecipeMaps.CHEMICAL_REACTING.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)AntimatterMaterialTypes.DUST.getMaterialTag(AntimatterMaterials.Charcoal), (int)1), ((RecipeIngredient)TierMaps.INT_CIRCUITS.get((Object)2)).setNoConsume()}).fi(new FluidStack[]{Materials.Oxygen.getGas(2000)}).fo(new FluidStack[]{Materials.CarbonDioxide.getGas(3000)}).io(new ItemStack[]{AntimatterMaterialTypes.DUST_TINY.get(Materials.Ash, 1)}).add("carbon_dioxide", 40L, 8L);
        RecipeMaps.CHEMICAL_REACTING.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)AntimatterMaterialTypes.DUST.getMaterialTag(Materials.Carbon), (int)1), ((RecipeIngredient)TierMaps.INT_CIRCUITS.get((Object)2)).setNoConsume()}).fi(new FluidStack[]{Materials.Oxygen.getGas(2000)}).fo(new FluidStack[]{Materials.CarbonDioxide.getGas(3000)}).add("carbon_dioxide_1", 40L, 8L);
        RecipeMaps.CHEMICAL_REACTING.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)AntimatterMaterialTypes.GEM.getMaterialTag(AntimatterMaterials.Charcoal), (int)1), ((RecipeIngredient)TierMaps.INT_CIRCUITS.get((Object)2)).setNoConsume()}).fi(new FluidStack[]{Materials.Oxygen.getGas(2000)}).fo(new FluidStack[]{Materials.CarbonDioxide.getGas(3000)}).io(new ItemStack[]{AntimatterMaterialTypes.DUST_TINY.get(Materials.Ash, 1)}).add("carbon_dioxide_2", 40L, 8L);
        RecipeMaps.CHEMICAL_REACTING.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)AntimatterMaterialTypes.GEM.getMaterialTag(AntimatterMaterials.Coal), (int)1), ((RecipeIngredient)TierMaps.INT_CIRCUITS.get((Object)2)).setNoConsume()}).fi(new FluidStack[]{Materials.Oxygen.getGas(2000)}).fo(new FluidStack[]{Materials.CarbonDioxide.getGas(3000)}).io(new ItemStack[]{AntimatterMaterialTypes.DUST_TINY.get(Materials.Ash, 1)}).add("carbon_dioxide_3", 40L, 8L);
        RecipeMaps.CHEMICAL_REACTING.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)AntimatterMaterialTypes.DUST.getMaterialTag(AntimatterMaterials.Coal), (int)1), ((RecipeIngredient)TierMaps.INT_CIRCUITS.get((Object)2)).setNoConsume()}).fi(new FluidStack[]{Materials.Oxygen.getGas(2000)}).fo(new FluidStack[]{Materials.CarbonDioxide.getGas(3000)}).io(new ItemStack[]{AntimatterMaterialTypes.DUST_TINY.get(Materials.Ash, 1)}).add("carbon_dioxide_4", 40L, 8L);
        RecipeMaps.CHEMICAL_REACTING.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)AntimatterMaterialTypes.DUST.getMaterialTag(Materials.Calcite), (int)5), ((RecipeIngredient)TierMaps.INT_CIRCUITS.get((Object)1)).setNoConsume()}).fo(new FluidStack[]{Materials.CarbonDioxide.getGas(3000)}).io(new ItemStack[]{AntimatterMaterialTypes.DUST.get(Materials.Quicklime, 2)}).add("carbon_dioxide_5", 240L, 30L);
        RecipeMaps.CHEMICAL_REACTING.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)AntimatterMaterialTypes.DUST.getMaterialTag(Materials.Magnesia), (int)5), ((RecipeIngredient)TierMaps.INT_CIRCUITS.get((Object)1)).setNoConsume()}).fo(new FluidStack[]{Materials.CarbonDioxide.getGas(3000)}).io(new ItemStack[]{AntimatterMaterialTypes.DUST.get(Materials.Magnesia, 2)}).add("carbon_dioxide_6", 240L, 30L);
        RecipeMaps.CHEMICAL_REACTING.RB().fi(new FluidStack[]{AntimatterMaterials.Water.getLiquid(3000), Materials.Methane.getGas(2000)}).fo(new FluidStack[]{Materials.CarbonDioxide.getGas(1500), Materials.Hydrogen.getGas(4000)}).add("carbon_dioxide_7", 20L, 240L);
        RecipeMaps.CHEMICAL_REACTING.RB().fi(new FluidStack[]{Materials.Butene.getGas(1000)}).ii(new Ingredient[]{((RecipeIngredient)TierMaps.INT_CIRCUITS.get((Object)12)).setNoConsume()}).fo(new FluidStack[]{Materials.Ethylene.getGas(1000)}).add("ethylene", 720L, 120L);
        RecipeMaps.CHEMICAL_REACTING.RB().fi(new FluidStack[]{Materials.Propene.getGas(1000)}).ii(new Ingredient[]{((RecipeIngredient)TierMaps.INT_CIRCUITS.get((Object)2)).setNoConsume()}).fo(new FluidStack[]{Materials.Ethylene.getGas(1000)}).add("ethylene_1", 720L, 120L);
        RecipeMaps.CHEMICAL_REACTING.RB().fi(new FluidStack[]{Materials.SulfuricAcid.getLiquid(2000), Materials.Ethanol.getLiquid(3000)}).fo(new FluidStack[]{Materials.Ethylene.getGas(2000), Materials.DilutedSulfuricAcid.getLiquid(3000)}).add("ethylene_2", 400L, 120L);
        RecipeMaps.CHEMICAL_REACTING.RB().fi(new FluidStack[]{Materials.SulfuricAcid.getLiquid(2000), Materials.Ethanol.getLiquid(3000)}).ii(new Ingredient[]{((RecipeIngredient)TierMaps.INT_CIRCUITS.get((Object)11)).setNoConsume()}).fo(new FluidStack[]{Materials.Ethylene.getGas(2000), Materials.DilutedSulfuricAcid.getLiquid(3000)}).add("ethylene_3", 400L, 120L);
        RecipeMaps.CHEMICAL_REACTING.RB().fi(new FluidStack[]{Materials.Ethane.getGas(4000)}).ii(new Ingredient[]{((RecipeIngredient)TierMaps.INT_CIRCUITS.get((Object)8)).setNoConsume()}).fo(new FluidStack[]{Materials.Ethylene.getGas(3000), Materials.Hydrogen.getGas(1000)}).add("ethylene_4", 320L, 120L);
        RecipeMaps.CHEMICAL_REACTING.RB().ii(new Ingredient[]{((RecipeIngredient)TierMaps.INT_CIRCUITS.get((Object)9)).setNoConsume()}).fi(new FluidStack[]{Materials.Oxygen.getGas(1000), Materials.Ethylene.getGas(3000)}).fo(new FluidStack[]{Materials.AceticAcid.getLiquid(4000)}).add("acetic_acid", 50L, 30L);
        RecipeMaps.CHEMICAL_REACTING.RB().ii(new Ingredient[]{((RecipeIngredient)TierMaps.INT_CIRCUITS.get((Object)1)).setNoConsume()}).fi(new FluidStack[]{Materials.CarbonMonoxide.getGas(1000), Materials.Methanol.getLiquid(3000)}).fo(new FluidStack[]{Materials.AceticAcid.getLiquid(4000)}).add("acetic_acid_1", 150L, 30L);
        RecipeMaps.CHEMICAL_REACTING.RB().fi(new FluidStack[]{Materials.SeedOil.getLiquid(6000), Materials.Methanol.getLiquid(1000)}).ii(new Ingredient[]{RecipeIngredient.of((TagKey)AntimatterMaterialTypes.DUST_TINY.getMaterialTag(Materials.SodiumHydroxide), (int)1)}).fo(new FluidStack[]{Materials.BioDiesel.getLiquid(6000), Materials.Glyceryl.getLiquid(1000)}).add("biodiesel_and_glyceryl", 600L, 30L);
        RecipeMaps.CHEMICAL_REACTING.RB().fi(new FluidStack[]{Materials.FishOil.getLiquid(6000), Materials.Methanol.getLiquid(1000)}).ii(new Ingredient[]{RecipeIngredient.of((TagKey)AntimatterMaterialTypes.DUST_TINY.getMaterialTag(Materials.SodiumHydroxide), (int)1)}).fo(new FluidStack[]{Materials.BioDiesel.getLiquid(6000), Materials.Glyceryl.getLiquid(1000)}).add("biodiesel_and_glyceryl_1", 600L, 30L);
        RecipeMaps.CHEMICAL_REACTING.RB().fi(new FluidStack[]{Materials.SeedOil.getLiquid(6000), Materials.Ethanol.getLiquid(1000)}).ii(new Ingredient[]{RecipeIngredient.of((TagKey)AntimatterMaterialTypes.DUST_TINY.getMaterialTag(Materials.SodiumHydroxide), (int)1)}).fo(new FluidStack[]{Materials.BioDiesel.getLiquid(6000), Materials.Glyceryl.getLiquid(1000)}).add("biodiesel_and_glyceryl_2", 600L, 30L);
        RecipeMaps.CHEMICAL_REACTING.RB().fi(new FluidStack[]{Materials.FishOil.getLiquid(6000), Materials.Methanol.getLiquid(1000)}).ii(new Ingredient[]{RecipeIngredient.of((TagKey)AntimatterMaterialTypes.DUST_TINY.getMaterialTag(Materials.SodiumHydroxide), (int)1)}).fo(new FluidStack[]{Materials.BioDiesel.getLiquid(6000), Materials.Glyceryl.getLiquid(1000)}).add("biodiesel_and_glyceryl_3", 600L, 30L);
        RecipeMaps.CHEMICAL_REACTING.RB().ii(new Ingredient[]{RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42501_}), RecipeIngredient.of((ItemStack)AntimatterMaterialTypes.DUST_TINY.get(Materials.Polyethylene, 1))}).fi(new FluidStack[]{Materials.Toluene.getLiquid(133)}).io(new ItemStack[]{AntimatterMaterialTypes.DUST.get(Materials.GelledToluene, 2)}).add("gelled_toluene", 140L, 192L);
        RecipeMaps.CHEMICAL_REACTING.RB().fi(new FluidStack[]{Materials.Nitrogen.getGas(500), Materials.Oxygen.getGas(1000)}).ii(new Ingredient[]{((RecipeIngredient)TierMaps.INT_CIRCUITS.get((Object)1)).setNoConsume()}).fo(new FluidStack[]{Materials.NitrogenDioxide.getGas(1500)}).add("nitrogen_dioxide", 625L, 30L);
        RecipeMaps.CHEMICAL_REACTING.RB().fi(new FluidStack[]{Materials.Nitrogen.getGas(1000), Materials.Oxygen.getGas(2000)}).ii(new Ingredient[]{((RecipeIngredient)TierMaps.INT_CIRCUITS.get((Object)2)).setNoConsume()}).fo(new FluidStack[]{Materials.NitrogenDioxide.getGas(3000)}).add("nitrogen_dioxide_2", 1250L, 30L);
        RecipeMaps.CHEMICAL_REACTING.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)AntimatterMaterialTypes.DUST.getMaterialTag(AntimatterMaterials.Charcoal), (int)1), ((RecipeIngredient)TierMaps.INT_CIRCUITS.get((Object)1)).setNoConsume()}).fi(new FluidStack[]{Materials.Oxygen.getGas(1000)}).fo(new FluidStack[]{Materials.CarbonMonoxide.getGas(2000)}).io(new ItemStack[]{AntimatterMaterialTypes.DUST_TINY.get(Materials.Ash, 1)}).add("carbon_monoxide", 40L, 8L);
        RecipeMaps.CHEMICAL_REACTING.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)AntimatterMaterialTypes.DUST.getMaterialTag(Materials.Carbon), (int)1), ((RecipeIngredient)TierMaps.INT_CIRCUITS.get((Object)1)).setNoConsume()}).fi(new FluidStack[]{Materials.Oxygen.getGas(1000)}).fo(new FluidStack[]{Materials.CarbonMonoxide.getGas(2000)}).add("carbon_monoxide_1", 40L, 8L);
        RecipeMaps.CHEMICAL_REACTING.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)AntimatterMaterialTypes.GEM.getMaterialTag(AntimatterMaterials.Charcoal), (int)1), ((RecipeIngredient)TierMaps.INT_CIRCUITS.get((Object)1)).setNoConsume()}).fi(new FluidStack[]{Materials.Oxygen.getGas(1000)}).fo(new FluidStack[]{Materials.CarbonMonoxide.getGas(2000)}).io(new ItemStack[]{AntimatterMaterialTypes.DUST_TINY.get(Materials.Ash, 1)}).add("carbon_monoxide_2", 40L, 8L);
        RecipeMaps.CHEMICAL_REACTING.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)AntimatterMaterialTypes.GEM.getMaterialTag(AntimatterMaterials.Coal), (int)1), ((RecipeIngredient)TierMaps.INT_CIRCUITS.get((Object)1)).setNoConsume()}).fi(new FluidStack[]{Materials.Oxygen.getGas(1000)}).fo(new FluidStack[]{Materials.CarbonMonoxide.getGas(2000)}).io(new ItemStack[]{AntimatterMaterialTypes.DUST_TINY.get(Materials.Ash, 1)}).add("carbon_monoxide_3", 40L, 8L);
        RecipeMaps.CHEMICAL_REACTING.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)AntimatterMaterialTypes.DUST.getMaterialTag(AntimatterMaterials.Coal), (int)1), ((RecipeIngredient)TierMaps.INT_CIRCUITS.get((Object)1)).setNoConsume()}).fi(new FluidStack[]{Materials.Oxygen.getGas(1000)}).fo(new FluidStack[]{Materials.CarbonMonoxide.getGas(2000)}).io(new ItemStack[]{AntimatterMaterialTypes.DUST_TINY.get(Materials.Ash, 1)}).add("carbon_monoxide_4", 40L, 8L);
        RecipeMaps.CHEMICAL_REACTING.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)AntimatterMaterialTypes.DUST.getMaterialTag(Materials.Carbon), (int)1)}).fi(new FluidStack[]{Materials.CarbonDioxide.getGas(3000)}).fo(new FluidStack[]{Materials.CarbonMonoxide.getGas(4000)}).add("carbon_monoxide_5", 800L, 30L);
        RecipeMaps.CHEMICAL_REACTING.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)AntimatterMaterialTypes.DUST.getMaterialTag(Materials.Rutile), (int)1), RecipeIngredient.of((TagKey)AntimatterMaterialTypes.DUST.getMaterialTag(Materials.Carbon), (int)2), ((RecipeIngredient)TierMaps.INT_CIRCUITS.get((Object)1)).setNoConsume()}).fi(new FluidStack[]{Materials.Chlorine.getGas(4000)}).fo(new FluidStack[]{Materials.CarbonMonoxide.getGas(2000), Materials.Titaniumtetrachloride.getLiquid(1000)}).add("carbon_monoxide_6", 500L, 480L);
        RecipeMaps.CHEMICAL_REACTING.RB().fi(new FluidStack[]{Materials.Hydrogen.getGas(3000), Materials.Nitrogen.getGas(1000)}).ii(new Ingredient[]{((RecipeIngredient)TierMaps.INT_CIRCUITS.get((Object)1)).setNoConsume()}).fo(new FluidStack[]{Materials.Ammonia.getGas(1000)}).add("ammonia", 320L, 384L);
        RecipeMaps.CHEMICAL_REACTING.RB().ii(new Ingredient[]{((RecipeIngredient)TierMaps.INT_CIRCUITS.get((Object)11)).setNoConsume()}).fi(new FluidStack[]{Materials.Oxygen.getGas(1000), Materials.Ammonia.getGas(1000)}).fo(new FluidStack[]{Materials.NitricAcid.getLiquid(1000), AntimatterMaterials.Water.getLiquid(1000)}).add("nitric_acid", 160L, 30L);
        RecipeMaps.CHEMICAL_REACTING.RB().ii(new Ingredient[]{((RecipeIngredient)TierMaps.INT_CIRCUITS.get((Object)12)).setNoConsume()}).fi(new FluidStack[]{Materials.Oxygen.getGas(1000), Materials.Ammonia.getGas(1000)}).fo(new FluidStack[]{Materials.NitricAcid.getLiquid(1000)}).add("nitric_acid_2", 160L, 30L);
        RecipeMaps.CHEMICAL_REACTING.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)AntimatterMaterialTypes.DUST.getMaterialTag(Materials.Carbon), (int)1), RecipeIngredient.of((TagKey)AntimatterMaterialTypes.DUST.getMaterialTag(Materials.Calcium), (int)1)}).fi(new FluidStack[]{Materials.Oxygen.getGas(3000)}).io(new ItemStack[]{AntimatterMaterialTypes.DUST.get(Materials.Calcite, 5)}).add("calcite", 500L, 30L);
        RecipeMaps.CHEMICAL_REACTING.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)AntimatterMaterialTypes.DUST.getMaterialTag(Materials.Quicklime), (int)2)}).fi(new FluidStack[]{Materials.CarbonDioxide.getGas(3000)}).io(new ItemStack[]{AntimatterMaterialTypes.DUST.get(Materials.Calcite, 5)}).add("calcite_1", 80L, 30L);
        RecipeMaps.CHEMICAL_REACTING.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)AntimatterMaterialTypes.DUST.getMaterialTag(Materials.Magnesia), (int)2)}).fi(new FluidStack[]{Materials.CarbonDioxide.getGas(3000)}).io(new ItemStack[]{AntimatterMaterialTypes.DUST.get(Materials.Magnesite, 5)}).add("magnesite", 80L, 30L);
        RecipeMaps.CHEMICAL_REACTING.RB().fi(new FluidStack[]{Materials.Glyceryl.getLiquid(1000), Materials.NitrationMixture.getLiquid(3000)}).fo(new FluidStack[]{Materials.GlycerylTrinitrate.getLiquid(1000), Materials.DilutedSulfuricAcid.getLiquid(3000)}).add("glyceryl_trinitrate", 180L, 30L);
        RecipeMaps.CHEMICAL_REACTING.RB().fi(new FluidStack[]{Materials.Nitrogen.getGas(1000), AntimatterMaterials.Water.getLiquid(2000)}).ii(new Ingredient[]{RecipeIngredient.of((TagKey)AntimatterMaterialTypes.DUST.getMaterialTag(Materials.Carbon), (int)1)}).fo(new FluidStack[]{Materials.GlycerylTrinitrate.getLiquid(4000)}).add("glyceryl_trinitrate_1", 2700L, 30L);
        RecipeMaps.CHEMICAL_REACTING.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)AntimatterMaterialTypes.DUST.getMaterialTag(Materials.Potassium), (int)1)}).fi(new FluidStack[]{Materials.Nitrogen.getGas(1000), Materials.Oxygen.getGas(3000)}).io(new ItemStack[]{AntimatterMaterialTypes.DUST.get(Materials.Saltpeter, 5)}).add("saltpeter", 180L, 30L);
        RecipeMaps.CHEMICAL_REACTING.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)AntimatterMaterialTypes.DUST.getMaterialTag(Materials.Sodium), (int)1), RecipeIngredient.of((ItemStack)AntimatterMaterialTypes.DUST.get(Materials.Sulfur, 1))}).fi(new FluidStack[]{Materials.Oxygen.getGas(4000)}).fo(new FluidStack[]{Materials.SodiumPersulfate.getLiquid(6000)}).add("sodium_persulfate", 8000L, 30L);
        RecipeMaps.CHEMICAL_REACTING.RB().fi(new FluidStack[]{Materials.Diesel.getLiquid(1000), Materials.NitricAcid.getLiquid(125)}).fo(new FluidStack[]{Materials.CetaneBoostedDiesel.getLiquid(500)}).add("cetaneboosteddiesel", 40L, 8L);
        RecipeMaps.CHEMICAL_REACTING.RB().fi(new FluidStack[]{Materials.BioDiesel.getLiquid(1000), Materials.NitricAcid.getLiquid(250)}).fo(new FluidStack[]{Materials.CetaneBoostedDiesel.getLiquid(750)}).add("cetaneboosteddiesel_1", 80L, 8L);
        RecipeMaps.CHEMICAL_REACTING.RB().fi(new FluidStack[]{Materials.LightFuel.getLiquid(1000), Materials.NitricAcid.getLiquid(250)}).fo(new FluidStack[]{Materials.CetaneBoostedDiesel.getLiquid(1000)}).add("cetaneboosteddiesel_2", 80L, 8L);
        RecipeMaps.CHEMICAL_REACTING.RB().fi(new FluidStack[]{Materials.LightFuel.getLiquid(1000), Materials.GlycerylTrinitrate.getLiquid(250)}).fo(new FluidStack[]{Materials.CetaneBoostedDiesel.getLiquid(1250)}).add("cetaneboosteddiesel_3", 250L, 30L);
        RecipeMaps.CHEMICAL_REACTING.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)AntimatterMaterialTypes.INGOT.getMaterialTag(Materials.Plutonium239), (int)3)}).fo(new FluidStack[]{Materials.Radon.getGas(50)}).io(new ItemStack[]{AntimatterMaterialTypes.DUST.get(Materials.Plutonium239, 3)}).add("radon", 6000L, 8L);
        RecipeMaps.CHEMICAL_REACTING.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)AntimatterMaterialTypes.DUST.getMaterialTag(Materials.GelledToluene), (int)4)}).fi(new FluidStack[]{Materials.SulfuricAcid.getLiquid(250)}).io(new Item[]{Items.f_41996_}).add("tnt", 200L, 24L);
        RecipeMaps.CHEMICAL_REACTING.RB().fi(new FluidStack[]{Materials.Hydrogen.getGas(1000), Materials.Oxygen.getGas(500)}).fo(new FluidStack[]{AntimatterMaterials.Water.getLiquid(1500)}).add("water", 5L, 30L);
        RecipeMaps.CHEMICAL_REACTING.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)AntimatterMaterialTypes.NUGGET.getMaterialTag(AntimatterMaterials.Gold), (int)8), RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42575_})}).io(new Item[]{Items.f_42546_}).add("glistering_melon_slice", 50L, 30L);
        RecipeMaps.CHEMICAL_REACTING.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)AntimatterMaterialTypes.INGOT.getMaterialTag(AntimatterMaterials.Gold), (int)8), RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42410_})}).io(new Item[]{Items.f_42436_}).add("golden_apple", 50L, 30L);
        RecipeMaps.CHEMICAL_REACTING.RB().ii(new Ingredient[]{RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42518_}), RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42593_})}).io(new Item[]{Items.f_42542_}).add("magma_cream", 50L, 30L);
        RecipeMaps.CHEMICAL_REACTING.RB().ii(new Ingredient[]{RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42584_}), RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42593_})}).io(new Item[]{Items.f_42545_}).add("ender_eye", 50L, 30L);
        RecipeMaps.CHEMICAL_REACTING.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)AntimatterMaterialTypes.NUGGET.getMaterialTag(AntimatterMaterials.Gold), (int)8), RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42619_})}).io(new Item[]{Items.f_42677_}).add("golden_carrot", 50L, 30L);
        RecipeMaps.CHEMICAL_REACTING.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)AntimatterMaterialTypes.CRUSHED_PURIFIED.getMaterialTag(Materials.Chalcopyrite), (int)1)}).fi(new FluidStack[]{Materials.NitricAcid.getLiquid(1000)}).io(new ItemStack[]{AntimatterMaterialTypes.DUST_TINY.get(Materials.PlatinumGroupSludge, 1)}).fo(new FluidStack[]{Materials.BlueVitriol.getLiquid(9000)}).add("tiny_pile_of_platinum_group_sludge", 50L, 30L);
        RecipeMaps.CHEMICAL_REACTING.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)AntimatterMaterialTypes.CRUSHED_PURIFIED.getMaterialTag(Materials.Pentlandite), (int)1)}).fi(new FluidStack[]{Materials.NitricAcid.getLiquid(1000)}).io(new ItemStack[]{AntimatterMaterialTypes.DUST_TINY.get(Materials.PlatinumGroupSludge, 1)}).fo(new FluidStack[]{Materials.NickelSulfate.getLiquid(9000)}).add("tiny_pile_of_platinum_group_sludge_1", 50L, 30L);
        RecipeMaps.CHEMICAL_REACTING.RB().fi(new FluidStack[]{Materials.Naphtha.getLiquid(3000), Materials.NitrogenDioxide.getGas(1000), Materials.Epichlorohydrin.getLiquid(144)}).fo(new FluidStack[]{Materials.EpoxyResin.getLiquid(288)}).add("epoxy_resin", 240L, 30L);
        RecipeMaps.CHEMICAL_REACTING.RB().fi(new FluidStack[]{Materials.Propene.getGas(1000), Materials.Benzene.getLiquid(1000), Materials.Chlorine.getGas(500)}).fo(new FluidStack[]{Materials.EpoxyResin.getLiquid(288)}).add("epoxy_resin_1", 120L, 240L);
        RecipeMaps.CHEMICAL_REACTING.RB().fi(new FluidStack[]{Materials.Ethylene.getGas(1000), Materials.AceticAcid.getLiquid(2000), Materials.Methanol.getLiquid(1000)}).fo(new FluidStack[]{Materials.Glue.getLiquid(4000)}).add("glue", 240L, 30L);
        RecipeMaps.CHEMICAL_REACTING.RB().fi(new FluidStack[]{AntimatterMaterials.Water.getLiquid(1000)}).ii(new Ingredient[]{RecipeIngredient.of((TagKey)AntimatterMaterialTypes.DUST.getMaterialTag(Materials.CertusQuartz), (int)3), RecipeIngredient.of((TagKey)AntimatterMaterialTypes.DUST.getMaterialTag(Materials.Sodium), (int)1)}).io(new ItemStack[]{AntimatterMaterialTypes.GEM.get(Materials.CertusQuartz, 3)}).add("certus_quartz", 500L, 30L);
        RecipeMaps.CHEMICAL_REACTING.RB().fi(new FluidStack[]{AntimatterMaterials.Water.getLiquid(1000)}).ii(new Ingredient[]{RecipeIngredient.of((TagKey)AntimatterMaterialTypes.DUST.getMaterialTag(AntimatterMaterials.Quartz), (int)3), RecipeIngredient.of((TagKey)AntimatterMaterialTypes.DUST.getMaterialTag(Materials.Sodium), (int)1)}).io(new ItemStack[]{AntimatterMaterialTypes.GEM.get(AntimatterMaterials.Quartz, 3)}).add("quartz", 500L, 30L);
        RecipeMaps.CHEMICAL_REACTING.RB().fi(new FluidStack[]{AntimatterMaterials.Water.getLiquid(1000)}).ii(new Ingredient[]{RecipeIngredient.of((ItemStack[])new ItemStack[]{AntimatterMaterialTypes.DUST.get(Materials.Quartzite, 3), AntimatterMaterialTypes.DUST.get(Materials.Sodium, 1)})}).io(new ItemStack[]{AntimatterMaterialTypes.GEM.get(Materials.Quartzite, 3)}).add("quartzite", 500L, 30L);
        RecipeMaps.CHEMICAL_REACTING.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)AntimatterMaterialTypes.DUST.getMaterialTag(Materials.Polydimethylsiloxane), (int)9), RecipeIngredient.of((TagKey)AntimatterMaterialTypes.DUST.getMaterialTag(Materials.Sulfur), (int)1)}).fo(new FluidStack[]{Materials.SiliconeRubber.getLiquid(1296)}).add("silcone_rubber", 600L, 30L);
        RecipeMaps.CHEMICAL_REACTING.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)AntimatterMaterialTypes.DUST.getMaterialTag(Materials.Silicon), (int)1)}).fi(new FluidStack[]{Materials.Epichlorohydrin.getLiquid(144)}).fo(new FluidStack[]{Materials.SiliconeRubber.getLiquid(144)}).add("silcone_rubber_1", 240L, 96L);
        RecipeMaps.CHEMICAL_REACTING.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)AntimatterMaterialTypes.DUST.getMaterialTag(Materials.RawStyreneButadieneRubber), (int)9), RecipeIngredient.of((ItemLike)AntimatterMaterialTypes.DUST.get(Materials.Sulfur), (int)1)}).fo(new FluidStack[]{Materials.StyreneButadieneRubber.getLiquid(1296)}).add("styrenebutadiene_rubber", 600L, 30L);
        RecipeMaps.CHEMICAL_REACTING.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)AntimatterMaterialTypes.DUST.getMaterialTag(Materials.Saltpeter), (int)1)}).fi(new FluidStack[]{Materials.Naphtha.getLiquid(576)}).fo(new FluidStack[]{Materials.Polycaprolactam.getLiquid(1296)}).add("polycaprolactam", 640L, 30L);
        RecipeMaps.CHEMICAL_REACTING.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)AntimatterMaterialTypes.DUST.getMaterialTag(Materials.Uraninite), (int)1), RecipeIngredient.of((TagKey)AntimatterMaterialTypes.DUST.getMaterialTag(Materials.Magnesium), (int)1)}).io(new ItemStack[]{AntimatterMaterialTypes.DUST.get(Materials.Uranium238, 1)}).add("uranium238", 1000L, 30L);
        RecipeMaps.CHEMICAL_REACTING.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)AntimatterMaterialTypes.DUST.getMaterialTag(Materials.Uraninite), (int)1), RecipeIngredient.of((TagKey)AntimatterMaterialTypes.DUST.getMaterialTag(Materials.Aluminium), (int)1)}).io(new ItemStack[]{AntimatterMaterialTypes.DUST.get(Materials.Uranium238, 1)}).add("uranium238_1", 1000L, 30L);
        RecipeMaps.CHEMICAL_REACTING.RB().ii(new Ingredient[]{((RecipeIngredient)TierMaps.INT_CIRCUITS.get((Object)4)).setNoConsume()}).fi(new FluidStack[]{Materials.Butene.getGas(1200)}).fo(new FluidStack[]{Materials.Hydrogen.getGas(500), Materials.Butadiene.getGas(1000)}).add("butadiene", 64L, 120L);
        RecipeMaps.CHEMICAL_REACTING.RB().ii(new Ingredient[]{((RecipeIngredient)TierMaps.INT_CIRCUITS.get((Object)4)).setNoConsume()}).fi(new FluidStack[]{Materials.Ethylene.getGas(25)}).fo(new FluidStack[]{Materials.Butene.getGas(25)}).add("butane_to_butene", 18L, 120L);
        RecipeMaps.CHEMICAL_REACTING.RB().ii(new Ingredient[]{((RecipeIngredient)TierMaps.INT_CIRCUITS.get((Object)5)).setNoConsume()}).fi(new FluidStack[]{Materials.Butane.getGas(3500)}).fo(new FluidStack[]{Materials.Hydrogen.getGas(500), Materials.Butene.getGas(3000)}).add("butane_to_butene_1", 160L, 120L);
        RecipeMaps.CHEMICAL_REACTING.RB().fi(new FluidStack[]{Materials.Methane.getGas(2000), Materials.Chlorine.getGas(1000)}).io(new ItemStack[]{AntimatterMaterialTypes.DUST.get(Materials.Polydimethylsiloxane, 3)}).add("polydimethylsiloxane_pulp", 240L, 120L);
        RecipeMaps.CHEMICAL_REACTING.RB().ii(new Ingredient[]{((RecipeIngredient)TierMaps.INT_CIRCUITS.get((Object)1)).setNoConsume()}).fi(new FluidStack[]{Materials.Ethanol.getLiquid(1500), Materials.SulfuricAcid.getLiquid(1000)}).fo(new FluidStack[]{Materials.DilutedSulfuricAcid.getLiquid(1500)}).add("diluted_sulfuric_acid", 200L, 120L);
        RecipeMaps.CHEMICAL_REACTING.RB().ii(new Ingredient[]{((RecipeIngredient)TierMaps.INT_CIRCUITS.get((Object)3)).setNoConsume()}).fi(new FluidStack[]{Materials.Ethylene.getGas(25)}).fo(new FluidStack[]{Materials.Propene.getGas(25)}).add("propane_to_propene", 18L, 120L);
        RecipeMaps.CHEMICAL_REACTING.RB().ii(new Ingredient[]{((RecipeIngredient)TierMaps.INT_CIRCUITS.get((Object)8)).setNoConsume()}).fi(new FluidStack[]{Materials.Propane.getGas(5500)}).fo(new FluidStack[]{Materials.Propene.getGas(4500), Materials.Hydrogen.getGas(500)}).add("propane_to_propene_1", 320L, 120L);
        RecipeMaps.CHEMICAL_REACTING.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)AntimatterMaterialTypes.CRUSHED_PURIFIED.getMaterialTag(Materials.Galena), (int)3), RecipeIngredient.of((TagKey)AntimatterMaterialTypes.CRUSHED_PURIFIED.getMaterialTag(Materials.Sphalerite), (int)1)}).fi(new FluidStack[]{Materials.SulfuricAcid.getLiquid(4000)}).fo(new FluidStack[]{Materials.IndiumConcentrate.getLiquid(8000)}).add("indiumconcentrate", 60L, 150L);
        RecipeMaps.CHEMICAL_REACTING.RB().ii(new Ingredient[]{((RecipeIngredient)TierMaps.INT_CIRCUITS.get((Object)12)).setNoConsume()}).fi(new FluidStack[]{Materials.Methane.getGas(2500), AntimatterMaterials.Water.getLiquid(3000)}).fo(new FluidStack[]{Materials.Hydrogen.getGas(4000)}).add("hydrogen", 20L, 240L);
        RecipeMaps.CHEMICAL_REACTING.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)AntimatterMaterialTypes.DUST.getMaterialTag(Materials.Aluminium), (int)4)}).fi(new FluidStack[]{Materials.IndiumConcentrate.getLiquid(8000)}).fo(new FluidStack[]{Materials.LeadZincSolution.getLiquid(8000)}).io(new ItemStack[]{AntimatterMaterialTypes.DUST_TINY.get(Materials.Indium, 1)}).add("tiny_pile_of_indium_dust", 50L, 600L);
        RecipeMaps.CHEMICAL_REACTING.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)AntimatterMaterialTypes.DUST.getMaterialTag(Materials.Rutile), (int)1), RecipeIngredient.of((TagKey)AntimatterMaterialTypes.DUST.getMaterialTag(Materials.Carbon), (int)2), ((RecipeIngredient)TierMaps.INT_CIRCUITS.get((Object)2)).setNoConsume()}).fi(new FluidStack[]{Materials.Chlorine.getGas(4000)}).fo(new FluidStack[]{Materials.Titaniumtetrachloride.getLiquid(1000)}).add("titaniumtetrachloride", 500L, 480L);
        RecipeMaps.CHEMICAL_REACTING.RB().fi(new FluidStack[]{Materials.Ethanol.getLiquid(1000), Materials.Butene.getGas(1000)}).fo(new FluidStack[]{Materials.EthylTertButylEther.getLiquid(2000)}).add("ethyltertbutylether", 400L, 480L);
        RecipeMaps.CHEMICAL_REACTING.RB().fi(new FluidStack[]{Materials.NitrogenDioxide.getGas(1000), Materials.Hydrogen.getGas(3000)}).fo(new FluidStack[]{Materials.RocketFuel.getLiquid(3000), AntimatterMaterials.Water.getLiquid(4000)}).add("rocketfuel", 1000L, 388L);
        RecipeMaps.CHEMICAL_REACTING.RB().fi(new FluidStack[]{Materials.Chlorine.getGas(1000), Materials.Ammonia.getGas(3000), Materials.Methanol.getLiquid(4000)}).fo(new FluidStack[]{Materials.RocketFuel.getLiquid(7000)}).add("rocketfuel_1", 3600L, 480L);
        RecipeMaps.CHEMICAL_REACTING.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)AntimatterMaterialTypes.DUST.getMaterialTag(Materials.Sodium), (int)1), RecipeIngredient.of((TagKey)AntimatterMaterialTypes.DUST.getMaterialTag(Materials.MagnesiumChloride), (int)2)}).fo(new FluidStack[]{Materials.Chlorine.getGas(3000)}).io(new ItemStack[]{AntimatterMaterialTypes.DUST_SMALL.get(Materials.Magnesium, 6)}).add("chlorine", 300L, 240L);
        RecipeMaps.CHEMICAL_REACTING.RB().fi(new FluidStack[]{Materials.Butadiene.getGas(3000), Materials.Oxygen.getGas(4000), Materials.Styrene.getLiquid(1000)}).io(new ItemStack[]{AntimatterMaterialTypes.DUST.get(Materials.RawStyreneButadieneRubber, 6)}).add("raw_styrenebutadiene_rubber_pulp", 160L, 240L);
    }

    private static void nuclear_processing() {
        RecipeMaps.CHEMICAL_REACTING.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemStack)AntimatterMaterialTypes.DUST.get(Materials.Thorium, 1))}).fi(new FluidStack[]{Materials.LeachingSolution.getLiquid(1000)}).fo(new FluidStack[]{Materials.LeachedThorium.getLiquid(1000)}).add("thorium_leaching", 120L, 1000L);
        RecipeMaps.CHEMICAL_REACTING.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemStack)AntimatterMaterialTypes.DUST.get(Materials.Uranium, 1))}).fi(new FluidStack[]{Materials.LeachingSolution.getLiquid(1000)}).fo(new FluidStack[]{Materials.LeachedUranium.getLiquid(1000)}).add("uranium_leaching", 120L, 1000L);
        RecipeMaps.CHEMICAL_REACTING.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemStack)AntimatterMaterialTypes.DUST.get(Materials.TrithoriumOctoxide, 11))}).fi(new FluidStack[]{Materials.NitricAcid.getLiquid(3000)}).fo(new FluidStack[]{Materials.Thoriumdioxidedinitrate.getLiquid(3000), AntimatterMaterials.Water.getLiquid(4000), Materials.NitrogenDioxide.getGas(2000)}).add("thoriumdioxidedinatrate", 120L, 1000L);
        RecipeMaps.CHEMICAL_REACTING.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemStack)AntimatterMaterialTypes.DUST.get(Materials.TriuraniumOctoxide, 11))}).fi(new FluidStack[]{Materials.NitricAcid.getLiquid(3000)}).fo(new FluidStack[]{Materials.Uraniumdioxidedinitrate.getLiquid(3000), AntimatterMaterials.Water.getLiquid(4000), Materials.NitrogenDioxide.getGas(2000)}).add("uraniumdioxidedinatrate", 120L, 1000L);
        RecipeMaps.CHEMICAL_REACTING.RB().fi(new FluidStack[]{Materials.Thoriumdioxidedinitrate.getLiquid(10000), Materials.Ammonia.getGas(22000)}).io(new ItemStack[]{AntimatterMaterialTypes.DUST.get(Materials.Ammoniumdithoranate, 5)}).fo(new FluidStack[]{AntimatterMaterials.Water.getLiquid(13000), Materials.NitricOxide.getGas(32000)}).add("ammoniumdithoranate", 120L, 1000L);
        RecipeMaps.CHEMICAL_REACTING.RB().fi(new FluidStack[]{Materials.Uraniumdioxidedinitrate.getLiquid(10000), Materials.Ammonia.getGas(22000)}).io(new ItemStack[]{AntimatterMaterialTypes.DUST.get(Materials.Ammoniumdiuranate, 5)}).fo(new FluidStack[]{AntimatterMaterials.Water.getLiquid(13000), Materials.NitricOxide.getGas(32000)}).add("ammoniumdiuranate", 120L, 1000L);
        RecipeMaps.CHEMICAL_REACTING.RB().ii(new Ingredient[]{RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{AntimatterMaterialTypes.DUST.get(Materials.Ammoniumdithoranate)})}).fi(new FluidStack[]{Materials.Hydrogen.getGas(4000)}).io(new ItemStack[]{AntimatterMaterialTypes.DUST.get(Materials.ThoriumDioxide, 2)}).fo(new FluidStack[]{Materials.Ammonia.getGas(2000), AntimatterMaterials.Water.getLiquid(3000)}).add("secondary_thorium_dioxide", 120L, 1000L);
        RecipeMaps.CHEMICAL_REACTING.RB().ii(new Ingredient[]{RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{AntimatterMaterialTypes.DUST.get(Materials.Ammoniumdiuranate)})}).fi(new FluidStack[]{Materials.Hydrogen.getGas(4000)}).io(new ItemStack[]{AntimatterMaterialTypes.DUST.get(Materials.UraniumDioxide, 2)}).fo(new FluidStack[]{Materials.Ammonia.getGas(2000), AntimatterMaterials.Water.getLiquid(3000)}).add("secondary_uranium_dioxide", 120L, 1000L);
        RecipeMaps.CHEMICAL_REACTING.RB().ii(new Ingredient[]{RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{AntimatterMaterialTypes.DUST.get(Materials.ThoriumDioxide)})}).fi(new FluidStack[]{Materials.HydrofluoricAcid.getLiquid(4000)}).fo(new FluidStack[]{Materials.ThoriumTetrafluoride.getGas(1000), AntimatterMaterials.Water.getLiquid(2000)}).add("thoriumtetrafluoride", 120L, 1000L);
        RecipeMaps.CHEMICAL_REACTING.RB().ii(new Ingredient[]{RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{AntimatterMaterialTypes.DUST.get(Materials.UraniumDioxide)})}).fi(new FluidStack[]{Materials.HydrofluoricAcid.getLiquid(4000)}).fo(new FluidStack[]{Materials.UraniumTetrafluoride.getGas(1000), AntimatterMaterials.Water.getLiquid(2000)}).add("uraniumtetrafluoride", 120L, 1000L);
        RecipeMaps.CHEMICAL_REACTING.RB().fi(new FluidStack[]{Materials.ThoriumTetrafluoride.getGas(1000), Materials.Fluorine.getGas(2000)}).fo(new FluidStack[]{Materials.ThoriumHexafluoride.getGas(1000)}).add("thoriumhexafluoride", 120L, 1000L);
        RecipeMaps.CHEMICAL_REACTING.RB().fi(new FluidStack[]{Materials.UraniumTetrafluoride.getGas(1000), Materials.Fluorine.getGas(2000)}).fo(new FluidStack[]{Materials.UraniumHexafluoride.getGas(1000)}).add("uraniumhexafluoride", 120L, 1000L);
        RecipeMaps.CHEMICAL_REACTING.RB().fi(new FluidStack[]{Materials.Thorium227Hexafluoride.getGas(1000), AntimatterMaterials.Water.getLiquid(2000), Materials.Hydrogen.getGas(2000)}).io(new Item[]{AntimatterMaterialTypes.DUST.get(Materials.Thorium227Dioxide)}).fo(new FluidStack[]{Materials.HydrofluoricAcid.getLiquid(6000)}).add("thorium227_hexafluoride_reduction", 120L, 1000L);
        RecipeMaps.CHEMICAL_REACTING.RB().fi(new FluidStack[]{Materials.Thorium228Hexafluoride.getGas(1000), AntimatterMaterials.Water.getLiquid(2000), Materials.Hydrogen.getGas(2000)}).io(new Item[]{AntimatterMaterialTypes.DUST.get(Materials.Thorium228Dioxide)}).fo(new FluidStack[]{Materials.HydrofluoricAcid.getLiquid(6000)}).add("thorium228_hexafluoride_reduction", 120L, 1000L);
        RecipeMaps.CHEMICAL_REACTING.RB().fi(new FluidStack[]{Materials.Thorium229Hexafluoride.getGas(1000), AntimatterMaterials.Water.getLiquid(2000), Materials.Hydrogen.getGas(2000)}).io(new Item[]{AntimatterMaterialTypes.DUST.get(Materials.Thorium229Dioxide)}).fo(new FluidStack[]{Materials.HydrofluoricAcid.getLiquid(6000)}).add("thorium229_hexafluoride_reduction", 120L, 1000L);
        RecipeMaps.CHEMICAL_REACTING.RB().fi(new FluidStack[]{Materials.Thorium230Hexafluoride.getGas(1000), AntimatterMaterials.Water.getLiquid(2000), Materials.Hydrogen.getGas(2000)}).io(new Item[]{AntimatterMaterialTypes.DUST.get(Materials.Thorium230Dioxide)}).fo(new FluidStack[]{Materials.HydrofluoricAcid.getLiquid(6000)}).add("thorium230_hexafluoride_reduction", 120L, 1000L);
        RecipeMaps.CHEMICAL_REACTING.RB().fi(new FluidStack[]{Materials.Thorium231Hexafluoride.getGas(1000), AntimatterMaterials.Water.getLiquid(2000), Materials.Hydrogen.getGas(2000)}).io(new Item[]{AntimatterMaterialTypes.DUST.get(Materials.Thorium231Dioxide)}).fo(new FluidStack[]{Materials.HydrofluoricAcid.getLiquid(6000)}).add("thorium231_hexafluoride_reduction", 120L, 1000L);
        RecipeMaps.CHEMICAL_REACTING.RB().fi(new FluidStack[]{Materials.Thorium233Hexafluoride.getGas(1000), AntimatterMaterials.Water.getLiquid(2000), Materials.Hydrogen.getGas(2000)}).io(new Item[]{AntimatterMaterialTypes.DUST.get(Materials.Thorium233Dioxide)}).fo(new FluidStack[]{Materials.HydrofluoricAcid.getLiquid(6000)}).add("thorium233_hexafluoride_reduction", 120L, 1000L);
        RecipeMaps.CHEMICAL_REACTING.RB().fi(new FluidStack[]{Materials.Thorium234Hexafluoride.getGas(1000), AntimatterMaterials.Water.getLiquid(2000), Materials.Hydrogen.getGas(2000)}).io(new Item[]{AntimatterMaterialTypes.DUST.get(Materials.Thorium234Dioxide)}).fo(new FluidStack[]{Materials.HydrofluoricAcid.getLiquid(6000)}).add("thorium234_hexafluoride_reduction", 120L, 1000L);
        RecipeMaps.CHEMICAL_REACTING.RB().fi(new FluidStack[]{Materials.Uranium232Hexafluoride.getGas(1000), AntimatterMaterials.Water.getLiquid(2000), Materials.Hydrogen.getGas(2000)}).io(new Item[]{AntimatterMaterialTypes.DUST.get(Materials.Uranium232Dioxide)}).fo(new FluidStack[]{Materials.HydrofluoricAcid.getLiquid(6000)}).add("uranium232_hexafluoride_reduction", 120L, 1000L);
        RecipeMaps.CHEMICAL_REACTING.RB().fi(new FluidStack[]{Materials.Uranium233Hexafluoride.getGas(1000), AntimatterMaterials.Water.getLiquid(2000), Materials.Hydrogen.getGas(2000)}).io(new Item[]{AntimatterMaterialTypes.DUST.get(Materials.Uranium233Dioxide)}).fo(new FluidStack[]{Materials.HydrofluoricAcid.getLiquid(6000)}).add("uranium233_hexafluoride_reduction", 120L, 1000L);
        RecipeMaps.CHEMICAL_REACTING.RB().fi(new FluidStack[]{Materials.Uranium234Hexafluoride.getGas(1000), AntimatterMaterials.Water.getLiquid(2000), Materials.Hydrogen.getGas(2000)}).io(new Item[]{AntimatterMaterialTypes.DUST.get(Materials.Uranium234Dioxide)}).fo(new FluidStack[]{Materials.HydrofluoricAcid.getLiquid(6000)}).add("uranium234_hexafluoride_reduction", 120L, 1000L);
        RecipeMaps.CHEMICAL_REACTING.RB().fi(new FluidStack[]{Materials.Uranium235Hexafluoride.getGas(1000), AntimatterMaterials.Water.getLiquid(2000), Materials.Hydrogen.getGas(2000)}).io(new Item[]{AntimatterMaterialTypes.DUST.get(Materials.Uranium235Dioxide)}).fo(new FluidStack[]{Materials.HydrofluoricAcid.getLiquid(6000)}).add("uranium235_hexafluoride_reduction", 120L, 1000L);
        RecipeMaps.CHEMICAL_REACTING.RB().fi(new FluidStack[]{Materials.Uranium236Hexafluoride.getGas(1000), AntimatterMaterials.Water.getLiquid(2000), Materials.Hydrogen.getGas(2000)}).io(new Item[]{AntimatterMaterialTypes.DUST.get(Materials.Uranium236Dioxide)}).fo(new FluidStack[]{Materials.HydrofluoricAcid.getLiquid(6000)}).add("uranium236_hexafluoride_reduction", 120L, 1000L);
        RecipeMaps.CHEMICAL_REACTING.RB().fi(new FluidStack[]{Materials.Uranium237Hexafluoride.getGas(1000), AntimatterMaterials.Water.getLiquid(2000), Materials.Hydrogen.getGas(2000)}).io(new Item[]{AntimatterMaterialTypes.DUST.get(Materials.Uranium237Dioxide)}).fo(new FluidStack[]{Materials.HydrofluoricAcid.getLiquid(6000)}).add("uranium237_hexafluoride_reduction", 120L, 1000L);
        RecipeMaps.CHEMICAL_REACTING.RB().fi(new FluidStack[]{Materials.Uranium238Hexafluoride.getGas(1000), AntimatterMaterials.Water.getLiquid(2000), Materials.Hydrogen.getGas(2000)}).io(new Item[]{AntimatterMaterialTypes.DUST.get(Materials.Uranium238Dioxide)}).fo(new FluidStack[]{Materials.HydrofluoricAcid.getLiquid(6000)}).add("uranium238_hexafluoride_reduction", 120L, 1000L);
        RecipeMaps.CHEMICAL_REACTING.RB().fi(new FluidStack[]{Materials.Uranium239Hexafluoride.getGas(1000), AntimatterMaterials.Water.getLiquid(2000), Materials.Hydrogen.getGas(2000)}).io(new Item[]{AntimatterMaterialTypes.DUST.get(Materials.Uranium239Dioxide)}).fo(new FluidStack[]{Materials.HydrofluoricAcid.getLiquid(6000)}).add("uranium239_hexafluoride_reduction", 120L, 1000L);
        RecipeMaps.CHEMICAL_REACTING.RB().fi(new FluidStack[]{Materials.Uranium240Hexafluoride.getGas(1000), AntimatterMaterials.Water.getLiquid(2000), Materials.Hydrogen.getGas(2000)}).io(new Item[]{AntimatterMaterialTypes.DUST.get(Materials.Uranium240Dioxide)}).fo(new FluidStack[]{Materials.HydrofluoricAcid.getLiquid(6000)}).add("uranium240_hexafluoride_reduction", 120L, 1000L);
    }
}

