/*
 * Decompiled with CFR 0.152.
 */
package muramasa.gregtech.loader.machines;

import io.github.gregtechintergalactical.gtrubber.GTRubberData;
import muramasa.antimatter.data.AntimatterMaterialTypes;
import muramasa.antimatter.data.AntimatterMaterials;
import muramasa.antimatter.material.IMaterialTag;
import muramasa.antimatter.material.Material;
import muramasa.antimatter.material.MaterialTags;
import muramasa.antimatter.recipe.ingredient.RecipeIngredient;
import muramasa.antimatter.recipe.map.RecipeBuilder;
import muramasa.antimatter.util.AntimatterPlatformUtils;
import muramasa.gregtech.data.GregTechData;
import muramasa.gregtech.data.GregTechMaterialTags;
import muramasa.gregtech.data.Materials;
import muramasa.gregtech.data.RecipeMaps;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;

public class CentrifugingLoader {
    public static void init() {
        AntimatterMaterialTypes.DUST_IMPURE.all().forEach(dust -> {
            if (dust.hasByProducts()) {
                RecipeMaps.CENTRIFUGING.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)AntimatterMaterialTypes.DUST_IMPURE.get(dust), (int)1)}).io(new ItemStack[]{new ItemStack((ItemLike)AntimatterMaterialTypes.DUST.get(dust), 1), AntimatterMaterialTypes.DUST_TINY.get((Material)dust.getByProducts().get(0), 1)}).add("dust_impure_" + dust.getId(), 400L, 2L);
            } else {
                RecipeMaps.CENTRIFUGING.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)AntimatterMaterialTypes.DUST_IMPURE.get(dust), (int)1)}).io(new ItemStack[]{new ItemStack((ItemLike)AntimatterMaterialTypes.DUST.get(dust), 1)}).chances(new double[]{1.0, 0.1}).add("dust_impure_" + dust.getId(), dust.getMass(), 2L);
            }
        });
        AntimatterMaterialTypes.DUST_PURE.all().forEach(dust -> {
            if (dust.hasByProducts()) {
                int index = dust.getByProducts().size() > 1 ? 1 : 0;
                RecipeMaps.CENTRIFUGING.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)AntimatterMaterialTypes.DUST_PURE.get(dust), (int)1)}).io(new ItemStack[]{new ItemStack((ItemLike)AntimatterMaterialTypes.DUST.get(dust), 1), AntimatterMaterialTypes.DUST_TINY.get((Material)dust.getByProducts().get(index), 1)}).add("dust_pure_" + dust.getId(), dust.getMass(), 2L);
            } else {
                RecipeMaps.CENTRIFUGING.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)AntimatterMaterialTypes.DUST_IMPURE.get(dust), (int)1)}).io(new ItemStack[]{new ItemStack((ItemLike)AntimatterMaterialTypes.DUST.get(dust), 1)}).chances(new double[]{1.0, 0.1}).add("dust_pure_" + dust.getId(), dust.getMass(), 2L);
            }
        });
        GregTechMaterialTags.CENT.all().forEach(t -> {
            if (!(t.has(new IMaterialTag[]{AntimatterMaterialTypes.DUST}) || t.has(new IMaterialTag[]{AntimatterMaterialTypes.LIQUID}) || t.has(new IMaterialTag[]{AntimatterMaterialTypes.GAS}))) {
                return;
            }
            FluidStack[] fluids = (FluidStack[])t.getProcessInto().stream().filter(mat -> (mat.m.has(new IMaterialTag[]{AntimatterMaterialTypes.GAS}) || mat.m.has(new IMaterialTag[]{AntimatterMaterialTypes.LIQUID})) && !mat.m.has(new IMaterialTag[]{AntimatterMaterialTypes.DUST})).map(mat -> mat.m.has(new IMaterialTag[]{AntimatterMaterialTypes.GAS}) ? mat.m.getGas(mat.s * 1000) : mat.m.getLiquid(mat.s * 1000)).toArray(FluidStack[]::new);
            if (fluids.length > 6) {
                return;
            }
            for (FluidStack fluid : fluids) {
                if (!fluid.isEmpty()) continue;
                return;
            }
            ItemStack[] items = (ItemStack[])t.getProcessInto().stream().filter(mat -> mat.m.has(new IMaterialTag[]{AntimatterMaterialTypes.DUST})).map(mat -> AntimatterMaterialTypes.DUST.get(mat.m, mat.s)).toArray(ItemStack[]::new);
            int inputAmount = (Integer)((Pair)MaterialTags.PROCESS_INTO.get(t)).getRight() > 0 ? ((Integer)((Pair)MaterialTags.PROCESS_INTO.get(t)).getRight()).intValue() : t.getProcessInto().stream().mapToInt(mat -> mat.s).sum();
            RecipeBuilder b = RecipeMaps.CENTRIFUGING.RB();
            if (t.has(new IMaterialTag[]{AntimatterMaterialTypes.DUST})) {
                b.ii(new Ingredient[]{AntimatterMaterialTypes.DUST.getMaterialIngredient(t, inputAmount)});
            } else {
                b.fi(new FluidStack[]{t.has(new IMaterialTag[]{AntimatterMaterialTypes.LIQUID}) ? t.getLiquid(inputAmount * 1000) : t.getGas(inputAmount * 1000)});
            }
            int euPerTick = t.has(new IMaterialTag[]{GregTechMaterialTags.CENT5}) ? 5 : (t.has(new IMaterialTag[]{GregTechMaterialTags.CENT10}) ? 10 : (t.has(new IMaterialTag[]{GregTechMaterialTags.CENT15}) ? 15 : (t.has(new IMaterialTag[]{GregTechMaterialTags.CENT20}) ? 20 : 16)));
            b.io(items).fo(fluids).add("dust_" + t.getId(), t.getMass() * 4L, (long)euPerTick);
        });
        RecipeMaps.CENTRIFUGING.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)Items.f_42542_, (int)1)}).io(new Item[]{Items.f_42593_, Items.f_42518_}).add("magma_cream", 500L, 5L);
        RecipeMaps.CENTRIFUGING.RB().fi(new FluidStack[]{Materials.Propane.getGas(320)}).fo(new FluidStack[]{Materials.Lubricant.getLiquid(290)}).add("propane", 20L, 5L);
        RecipeMaps.CENTRIFUGING.RB().fi(new FluidStack[]{Materials.Butane.getGas(320)}).fo(new FluidStack[]{Materials.Lubricant.getLiquid(370)}).add("butane", 20L, 5L);
        RecipeMaps.CENTRIFUGING.RB().fi(new FluidStack[]{Materials.RefineryGas.getGas(800)}).fo(new FluidStack[]{Materials.LPG.getGas(400)}).add("refinery_gas", 20L, 5L);
        RecipeMaps.CENTRIFUGING.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemStack)AntimatterMaterialTypes.DUST.get(Materials.ThoriumCake, 5))}).io(new ItemStack[]{AntimatterMaterialTypes.DUST.get(Materials.ThoriumDioxide, 1), AntimatterMaterialTypes.DUST.get(Materials.TrithoriumOctoxide, 4)}).add("thorium_cake_centrifuging", 400L, 500L);
        RecipeMaps.CENTRIFUGING.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemStack)AntimatterMaterialTypes.DUST.get(Materials.UraniumCake, 5))}).io(new ItemStack[]{AntimatterMaterialTypes.DUST.get(Materials.UraniumDioxide, 1), AntimatterMaterialTypes.DUST.get(Materials.TriuraniumOctoxide, 4)}).add("uranium_cake_centrifuging", 400L, 500L);
        RecipeMaps.CENTRIFUGING.RB().ii(new Ingredient[]{RecipeIngredient.m_204132_((TagKey)GTRubberData.RUBBER_LOGS)}).io(new ItemStack[]{new ItemStack((ItemLike)GTRubberData.StickyResin), new ItemStack(GregTechData.PlantBall), AntimatterMaterialTypes.DUST.get(Materials.Carbon, 1), AntimatterMaterialTypes.DUST.get(AntimatterMaterials.Wood, 1)}).fo(new FluidStack[]{Materials.Methane.getGas(60)}).chances(new double[]{0.5, 0.375, 0.25, 0.25}).add("rubber_logs", 200L, 20L);
        CentrifugingLoader.addMethaneRecipe(Items.f_42028_, 9, 72);
        CentrifugingLoader.addMethaneRecipe(Items.f_42406_, 9, 72);
        CentrifugingLoader.addMethaneRecipe(Items.f_42572_, 9, 72);
        CentrifugingLoader.addMethaneRecipe(Items.f_41952_, 18, 144);
        CentrifugingLoader.addMethaneRecipe(Items.f_41953_, 18, 144);
        CentrifugingLoader.addMethaneRecipe(Items.f_42410_, 18, 144);
        CentrifugingLoader.addMethaneRecipe(Items.f_42588_, 18, 144);
        CentrifugingLoader.addMethaneRecipe(Items.f_42591_, 18, 144);
        CentrifugingLoader.addMethaneRecipe(Items.f_42674_, 24, 192);
        CentrifugingLoader.addMethaneRecipe(Items.f_42046_, 36, 288);
        CentrifugingLoader.addMethaneRecipe(Items.f_42580_, 36, 288);
        CentrifugingLoader.addMethaneRecipe(Items.f_42620_, 36, 288);
        CentrifugingLoader.addMethaneRecipe(Items.f_42486_, 36, 288);
        CentrifugingLoader.addMethaneRecipe(Items.f_42583_, 36, 288);
        CentrifugingLoader.addMethaneRecipe(Items.f_42619_, 36, 288);
        CentrifugingLoader.addMethaneRecipe(Items.f_42732_, 36, 288);
        CentrifugingLoader.addMethaneRecipe(Items.f_42531_, 36, 288);
        CentrifugingLoader.addMethaneRecipe(Items.f_42530_, 36, 288);
        CentrifugingLoader.addMethaneRecipe(Items.f_42582_, 36, 288);
        CentrifugingLoader.addMethaneRecipe(Items.f_42659_, 36, 288);
        CentrifugingLoader.addMethaneRecipe(Items.f_42698_, 36, 288);
        CentrifugingLoader.addMethaneRecipe(Items.f_42400_, 36, 288, new ItemStack((ItemLike)Items.f_42399_));
        CentrifugingLoader.addMethaneRecipe(Items.f_42579_, 48, 384);
        CentrifugingLoader.addMethaneRecipe(Items.f_42581_, 48, 384);
        CentrifugingLoader.addMethaneRecipe(Items.f_42485_, 48, 384);
        CentrifugingLoader.addMethaneRecipe(Items.f_42658_, 48, 384);
        CentrifugingLoader.addMethaneRecipe(Items.f_42697_, 48, 384);
        CentrifugingLoader.addMethaneRecipe(Items.f_42526_, 48, 384);
        CentrifugingLoader.addMethaneRecipe(Items.f_42527_, 48, 384);
        CentrifugingLoader.addMethaneRecipe(Items.f_42529_, 48, 384);
        CentrifugingLoader.addMethaneRecipe(Items.f_42528_, 48, 384);
        CentrifugingLoader.addMethaneRecipe(Items.f_42023_, 48, 384);
        CentrifugingLoader.addMethaneRecipe(Items.f_42022_, 48, 384);
        CentrifugingLoader.addMethaneRecipe(Items.f_42675_, 48, 384);
        CentrifugingLoader.addMethaneRecipe(Items.f_42502_, 72, 576);
        CentrifugingLoader.addMethaneRecipe(Items.f_42436_, 576, 9216, new ItemStack((ItemLike)Items.f_42417_, 7));
        CentrifugingLoader.addMethaneRecipe(Items.f_42437_, 4608, 9216, new ItemStack((ItemLike)Items.f_42417_, 64));
        CentrifugingLoader.addMethaneRecipe(Items.f_42677_, 576, 9216, new ItemStack((ItemLike)Items.f_42587_, 6));
        CentrifugingLoader.addMethaneRecipe(Items.f_42546_, 576, 9216, new ItemStack((ItemLike)Items.f_42587_, 6));
    }

    private static void addMethaneRecipe(Item input, int methane, int ticks) {
        RecipeMaps.CENTRIFUGING.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)input, (int)1)}).fo(new FluidStack[]{Materials.Methane.getGas(methane)}).add(AntimatterPlatformUtils.getIdFromItem((Item)input).m_135815_() + "_into_methane", (long)ticks, 5L);
    }

    private static void addMethaneRecipe(Item input, int methane, int ticks, ItemStack extra) {
        RecipeMaps.CENTRIFUGING.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)input, (int)1)}).io(new ItemStack[]{extra}).fo(new FluidStack[]{Materials.Methane.getGas(methane)}).add(AntimatterPlatformUtils.getIdFromItem((Item)input).m_135815_() + "_into_methane", (long)ticks, 5L);
    }
}

