/*
 * Decompiled with CFR 0.152.
 */
package muramasa.gregtech.loader.machines;

import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import muramasa.antimatter.AntimatterAPI;
import muramasa.antimatter.Ref;
import muramasa.antimatter.data.AntimatterMaterialTypes;
import muramasa.antimatter.data.AntimatterMaterials;
import muramasa.antimatter.item.ItemBasic;
import muramasa.antimatter.item.ItemCover;
import muramasa.antimatter.machine.Tier;
import muramasa.antimatter.material.Material;
import muramasa.antimatter.material.MaterialTypeBlock;
import muramasa.antimatter.pipe.PipeItemBlock;
import muramasa.antimatter.pipe.PipeSize;
import muramasa.antimatter.pipe.types.Cable;
import muramasa.antimatter.pipe.types.Wire;
import muramasa.antimatter.recipe.ingredient.RecipeIngredient;
import muramasa.antimatter.util.AntimatterPlatformUtils;
import muramasa.gregtech.GregTech;
import muramasa.gregtech.block.BlockCasing;
import muramasa.gregtech.block.BlockCoil;
import muramasa.gregtech.data.GregTechData;
import muramasa.gregtech.data.GregTechTags;
import muramasa.gregtech.data.Materials;
import muramasa.gregtech.data.RecipeMaps;
import muramasa.gregtech.data.TierMaps;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.fluids.FluidStack;

public class AssemblyLoader {
    public static void init() {
        AssemblyLoader.batteries();
        AssemblyLoader.casings();
        AssemblyLoader.cables();
        AssemblyLoader.coils();
        AssemblyLoader.frames();
        AssemblyLoader.misc();
        AssemblyLoader.motors();
        AssemblyLoader.pistons();
        AssemblyLoader.rotors();
        AssemblyLoader.smdComponents();
    }

    private static void batteries() {
        RecipeMaps.ASSEMBLING.RB().ii(new Ingredient[]{AntimatterMaterialTypes.PLATE.getMaterialIngredient(Materials.BatteryAlloy, 1), RecipeIngredient.ofObject((Object)TierMaps.CABLE_GETTER.apply((Object)PipeSize.VTINY, (Object)Tier.LV, (Object)false), (int)1)}).fi(new FluidStack[]{Materials.Polyethylene.getLiquid(Ref.L)}).io(new ItemStack[]{GregTechData.BatteryHullSmall.m_7968_()}).add("battery_hull_small", 800L, 1L);
        RecipeMaps.ASSEMBLING.RB().ii(new Ingredient[]{AntimatterMaterialTypes.PLATE.getMaterialIngredient(Materials.BatteryAlloy, 3), RecipeIngredient.ofObject((Object)TierMaps.CABLE_GETTER.apply((Object)PipeSize.VTINY, (Object)Tier.MV, (Object)false), (int)2)}).fi(new FluidStack[]{Materials.Polyethylene.getLiquid(Ref.L * 3L)}).io(new ItemStack[]{GregTechData.BatteryHullMedium.m_7968_()}).add("battery_hull_medium", 1600L, 2L);
        RecipeMaps.ASSEMBLING.RB().ii(new Ingredient[]{AntimatterMaterialTypes.PLATE.getMaterialIngredient(Materials.BatteryAlloy, 9), RecipeIngredient.ofObject((Object)TierMaps.CABLE_GETTER.apply((Object)PipeSize.VTINY, (Object)Tier.HV, (Object)false), (int)4)}).fi(new FluidStack[]{Materials.Polyethylene.getLiquid(Ref.L * 9L)}).io(new ItemStack[]{GregTechData.BatteryHullLarge.m_7968_()}).add("battery_hull_large", 3200L, 4L);
        RecipeMaps.ASSEMBLING.RB().ii(new Ingredient[]{AntimatterMaterialTypes.DUST.getMaterialIngredient(Materials.Tantalum, 1), AntimatterMaterialTypes.FOIL.getMaterialIngredient(Materials.Manganese, 1)}).fi(new FluidStack[]{Materials.Polyethylene.getLiquid(Ref.L)}).io(new ItemStack[]{new ItemStack(GregTechData.BatteryTantalum, 8)}).add("tantalum_capacitor", 100L, 4L);
    }

    private static void casings() {
        AssemblyLoader.addTierCasing(Tier.ULV);
        AssemblyLoader.addTierCasing(Tier.LV);
        AssemblyLoader.addTierCasing(Tier.MV);
        AssemblyLoader.addTierCasing(Tier.HV);
        AssemblyLoader.addTierCasing(Tier.EV);
        AssemblyLoader.addTierCasing(Tier.IV);
        AssemblyLoader.addTierCasing(Tier.LUV);
        AssemblyLoader.addTierCasing(Tier.ZPM);
        AssemblyLoader.addTierCasing(Tier.UV);
        AssemblyLoader.addTierCasing(Tier.MAX);
        AssemblyLoader.addTierHull(AntimatterMaterials.Wood, Tier.ULV);
        AssemblyLoader.addTierHull(Materials.WroughtIron, Tier.LV);
        AssemblyLoader.addTierHull(Materials.WroughtIron, Tier.MV);
        AssemblyLoader.addTierHull(Materials.Polyethylene, Tier.HV);
        AssemblyLoader.addTierHull(Materials.Polyethylene, Tier.EV);
        AssemblyLoader.addTierHull(Materials.Polyethylene, Tier.IV);
        AssemblyLoader.addTierHull(Materials.Polyethylene, Tier.LUV);
        AssemblyLoader.addTierHull(Materials.Polytetrafluoroethylene, Tier.ZPM);
        AssemblyLoader.addTierHull(Materials.Polytetrafluoroethylene, Tier.UV);
        AssemblyLoader.addTierHull(Materials.Polytetrafluoroethylene, Tier.MAX);
        AssemblyLoader.addCasing(Materials.Bronze, GregTech.get(BlockCasing.class, "casing_bronze"));
        AssemblyLoader.addCasing(Materials.Steel, GregTech.get(BlockCasing.class, "casing_solid_steel"));
        AssemblyLoader.addCasing(Materials.StainlessSteel, GregTech.get(BlockCasing.class, "casing_stainless_steel"));
        AssemblyLoader.addCasing(Materials.Titanium, GregTech.get(BlockCasing.class, "casing_titanium"));
        AssemblyLoader.addCasing(Materials.TungstenSteel, GregTech.get(BlockCasing.class, "casing_tungstensteel"));
        AssemblyLoader.addCasing(Materials.Invar, GregTech.get(BlockCasing.class, "casing_heat_proof"));
        AssemblyLoader.addCasing(Materials.Aluminium, GregTech.get(BlockCasing.class, "casing_frost_proof"));
        AssemblyLoader.addCasing(Materials.Lead, GregTech.get(BlockCasing.class, "casing_radiation_proof"));
    }

    private static void cables() {
        AntimatterAPI.all(Wire.class, t -> {
            Cable cable = (Cable)AntimatterAPI.get(Cable.class, (String)("cable_" + t.getMaterial().getId()));
            if (cable == null) {
                return;
            }
            ImmutableSet sizes = t.getSizes();
            sizes.forEach(size -> {
                PipeItemBlock wireItem = t.getBlockItem(size);
                PipeItemBlock cableItem = cable.getBlockItem(size);
                long multiplier = AntimatterPlatformUtils.isFabric() ? 1000L : 16L;
                RecipeMaps.ASSEMBLING.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)wireItem, (int)1), (Ingredient)TierMaps.INT_CIRCUITS.get((Object)size.getCableThickness())}).fi(new FluidStack[]{Materials.Rubber.getLiquid((long)size.getCableThickness() * multiplier)}).io(new ItemStack[]{new ItemStack((ItemLike)cableItem, 1)}).add("cable_" + t.getMaterial().getId() + "_" + size.getId(), (long)size.getCableThickness() * 20L, 8L);
            });
        });
    }

    private static void coils() {
        AssemblyLoader.addCoil(GregTech.get(BlockCoil.class, "coil_cupronickel"), GregTechData.WIRE_CUPRONICKEL.getBlockItem(PipeSize.SMALL), Materials.Tin, 1);
        AssemblyLoader.addCoil(GregTech.get(BlockCoil.class, "coil_kanthal"), GregTechData.WIRE_KANTHAL.getBlockItem(PipeSize.SMALL), Materials.AnnealedCopper, 2);
        AssemblyLoader.addCoil(GregTech.get(BlockCoil.class, "coil_nichrome"), GregTechData.WIRE_NICHROME.getBlockItem(PipeSize.SMALL), Materials.Kanthal, 3);
        AssemblyLoader.addCoil(GregTech.get(BlockCoil.class, "coil_tungstensteel"), GregTechData.WIRE_TUNGSTEN_STEEL.getBlockItem(PipeSize.SMALL), Materials.Nichrome, 4);
        AssemblyLoader.addCoil(GregTech.get(BlockCoil.class, "coil_hssg"), GregTechData.WIRE_HSSG.getBlockItem(PipeSize.SMALL), Materials.TungstenSteel, 5);
        AssemblyLoader.addCoil(GregTech.get(BlockCoil.class, "coil_naquadah"), GregTechData.WIRE_NAQUADAH.getBlockItem(PipeSize.SMALL), Materials.HSSG, 6);
        AssemblyLoader.addCoil(GregTech.get(BlockCoil.class, "coil_naquadah_alloy"), GregTechData.WIRE_NAQUADAH_ALLOY.getBlockItem(PipeSize.SMALL), Materials.Naquadah, 7);
        AssemblyLoader.addCoil(GregTech.get(BlockCoil.class, "coil_superconductor"), GregTechData.WIRE_SUPERCONDUCTOR.getBlockItem(PipeSize.SMALL), Materials.NaquadahAlloy, 8);
    }

    private static void frames() {
        AntimatterMaterialTypes.FRAME.all().forEach(m -> {
            MaterialTypeBlock.Container f = ((MaterialTypeBlock.IBlockGetter)AntimatterMaterialTypes.FRAME.get()).get(m);
            RecipeMaps.ASSEMBLING.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)AntimatterMaterialTypes.ROD.get(m), (int)6)}).io(new ItemStack[]{new ItemStack((ItemLike)f.asItem(), 2)}).add(AntimatterPlatformUtils.getIdFromBlock((Block)f.asBlock()).m_135815_(), 40L, 24L);
        });
    }

    private static void misc() {
        RecipeMaps.ASSEMBLING.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)ItemTags.f_13168_, (int)8), (Ingredient)TierMaps.INT_CIRCUITS.get((Object)8)}).io(new ItemStack[]{new ItemStack((ItemLike)Items.f_42009_, 1)}).add("chest", 100L, 4L);
        RecipeMaps.ASSEMBLING.RB().ii(new Ingredient[]{RecipeIngredient.of(GregTechTags.PLATES_IRON_ALUMINIUM, (int)2), RecipeIngredient.of((ItemLike)Items.f_42025_, (int)2)}).io(new ItemStack[]{new ItemStack((ItemLike)GregTech.get(ItemCover.class, GregTechData.COVER_DRAIN.getId()))}).add("drain", 800L, 16L);
        RecipeMaps.ASSEMBLING.RB().ii(new Ingredient[]{RecipeIngredient.of(GregTechData.CarbonFibre, (int)2), (Ingredient)TierMaps.INT_CIRCUITS.get((Object)2)}).io(new Item[]{GregTechData.CarbonMesh}).add("carbon_mesh", 800L, 2L);
        RecipeMaps.ASSEMBLING.RB().ii(new Ingredient[]{RecipeIngredient.of(GregTechData.CarbonFibre, (int)4), AntimatterMaterialTypes.FOIL.getMaterialIngredient(Materials.Zinc, 16)}).io(new Item[]{GregTechData.ItemFilter}).add("item_filter", 1600L, 32L);
    }

    private static void motors() {
        Arrays.stream(Tier.getStandard()).forEach(t -> {
            Material magnet = t == Tier.ULV || t == Tier.LV ? Materials.IronMagnetic : (t == Tier.EV || t == Tier.IV ? Materials.NeodymiumMagnetic : Materials.SteelMagnetic);
            RecipeMaps.ASSEMBLING.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)((ItemLike)TierMaps.TIER_WIRES.get(t)), (int)4), RecipeIngredient.of((ItemLike)AntimatterMaterialTypes.ROD.get((Material)TierMaps.TIER_MATERIALS.get(t)), (int)2), RecipeIngredient.of((ItemLike)AntimatterMaterialTypes.ROD.get(magnet), (int)1), RecipeIngredient.ofObject((Object)TierMaps.CABLE_GETTER.apply((Object)PipeSize.VTINY, t, (Object)false), (int)2)}).io(new ItemStack[]{new ItemStack((ItemLike)GregTech.get(ItemBasic.class, "motor_" + t.getId()))}).add("motor_" + t.getId(), 150L, 16L);
        });
    }

    private static void pistons() {
        Arrays.stream(Tier.getStandard()).forEach(t -> RecipeMaps.ASSEMBLING.RB().ii(new Ingredient[]{RecipeIngredient.ofObject((Object)TierMaps.CABLE_GETTER.apply((Object)PipeSize.VTINY, t, (Object)false), (int)2), RecipeIngredient.of((ItemLike)AntimatterMaterialTypes.ROD.get((Material)TierMaps.TIER_MATERIALS.get(t)), (int)2), RecipeIngredient.of((ItemLike)AntimatterMaterialTypes.PLATE.get((Material)TierMaps.TIER_MATERIALS.get(t)), (int)3), RecipeIngredient.of((ItemLike)((ItemLike)GregTech.get(ItemBasic.class, "motor_" + t.getId())), (int)1), RecipeIngredient.of((ItemLike)AntimatterMaterialTypes.GEAR.get((Material)TierMaps.TIER_MATERIALS.get(t)), (int)1)}).io(new ItemStack[]{new ItemStack((ItemLike)GregTech.get(ItemBasic.class, "piston_" + t.getId()))}).add("piston_" + t.getId(), 150L, 16L));
    }

    private static void rotors() {
        AntimatterMaterialTypes.ROTOR.all().forEach(r -> RecipeMaps.ASSEMBLING.RB().ii(new Ingredient[]{AntimatterMaterialTypes.PLATE.getMaterialIngredient(r, 4), AntimatterMaterialTypes.SCREW.getMaterialIngredient(r, 1), RecipeIngredient.of((ItemStack)AntimatterMaterialTypes.RING.get(Materials.Rubber, 1))}).fi(new FluidStack[]{Materials.SolderingAlloy.getLiquid(144)}).io(new ItemStack[]{new ItemStack((ItemLike)AntimatterMaterialTypes.ROTOR.get(r), 1)}).add(r.getId() + "_rotor", 240L, 24L));
    }

    private static void smdComponents() {
        RecipeMaps.ASSEMBLING.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)AntimatterMaterialTypes.PLATE.get(Materials.Silicon), (int)1), RecipeIngredient.of((ItemLike)AntimatterMaterialTypes.WIRE_FINE.get(Materials.AnnealedCopper), (int)8)}).fi(new FluidStack[]{Materials.Polyethylene.getLiquid(288)}).io(new ItemStack[]{new ItemStack(GregTechData.Transistor, 32)}).add("transistor", 80L, 96L);
        RecipeMaps.ASSEMBLING.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)AntimatterMaterialTypes.DUST.get(Materials.Carbon), (int)1), RecipeIngredient.of((ItemLike)AntimatterMaterialTypes.WIRE_FINE.get(Materials.Electrum), (int)4)}).fi(new FluidStack[]{Materials.Polyethylene.getLiquid(288)}).io(new ItemStack[]{new ItemStack(GregTechData.Resistor, 24)}).add("resistor", 80L, 96L);
        RecipeMaps.ASSEMBLING.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)AntimatterMaterialTypes.FOIL.get(Materials.PolyvinylChloride), (int)4), RecipeIngredient.of((ItemLike)AntimatterMaterialTypes.FOIL.get(Materials.Aluminium), (int)2)}).fi(new FluidStack[]{Materials.Polyethylene.getLiquid(288)}).io(new ItemStack[]{new ItemStack(GregTechData.Capacitor, 16)}).add("capacitor", 80L, 96L);
    }

    private static void addTierCasing(Tier tier) {
        RecipeMaps.ASSEMBLING.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)AntimatterMaterialTypes.PLATE.getMaterialTag((Material)TierMaps.TIER_MATERIALS.get((Object)tier)), (int)8), (Ingredient)TierMaps.INT_CIRCUITS.get((Object)8)}).io(new ItemStack[]{new ItemStack((ItemLike)AntimatterAPI.get(BlockCasing.class, (String)("casing_" + tier.getId()), (String)"gti"))}).add("casing_" + tier.getId(), 100L, (long)Math.pow(2.0, 2 * tier.getIntegerId() + 1));
    }

    private static void addTierHull(Material mat, Wire w, TagKey<Item> circ, Block casing, Block hull, int tier) {
        RecipeMaps.ASSEMBLING.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)AntimatterMaterialTypes.SCREW.get(mat), (int)2), RecipeIngredient.of((ItemLike)casing, (int)1), RecipeIngredient.of((ItemLike)Items.f_42451_, (int)1), RecipeIngredient.of((ItemLike)w.getBlockItem(PipeSize.VTINY), (int)1), RecipeIngredient.of((TagKey)((TagKey)TierMaps.TIER_CIRCUITS.getOrDefault((Object)tier, circ)), (int)1)}).io(new ItemStack[]{new ItemStack((ItemLike)hull)}).add(AntimatterPlatformUtils.getIdFromBlock((Block)hull).m_135815_(), 100L, (long)Math.pow(2.0, 2 * tier + 1));
    }

    private static void addTierHull(Material mat, Wire w, TagKey<Item> circ, Block casing, Block hull, int tier, int idOffset) {
        RecipeMaps.ASSEMBLING.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)AntimatterMaterialTypes.SCREW.get(mat), (int)2), RecipeIngredient.of((ItemLike)casing, (int)1), RecipeIngredient.of((ItemLike)Items.f_42451_, (int)1), RecipeIngredient.of((ItemLike)w.getBlockItem(PipeSize.VTINY), (int)1), RecipeIngredient.of((TagKey)((TagKey)TierMaps.TIER_CIRCUITS.getOrDefault((Object)tier, circ)), (int)1)}).io(new ItemStack[]{new ItemStack((ItemLike)hull)}).add(AntimatterPlatformUtils.getIdFromBlock((Block)hull).m_135815_() + "_" + idOffset, 100L, (long)Math.pow(2.0, 2 * tier + 1));
    }

    private static void addTierHull(Material mat, Tier tier) {
        Material liquid = tier == Tier.ZPM || tier == Tier.UV || tier == Tier.MAX ? Materials.Polytetrafluoroethylene : Materials.Polyethylene;
        RecipeMaps.ASSEMBLING.RB().ii(new Ingredient[]{AntimatterMaterialTypes.PLATE.getMaterialIngredient(mat, 1), RecipeIngredient.ofObject((Object)TierMaps.CABLE_GETTER.apply((Object)(tier == Tier.UV ? PipeSize.SMALL : PipeSize.VTINY), (Object)tier, (Object)false), (int)2), AntimatterMaterialTypes.PLATE.getMaterialIngredient((Material)TierMaps.TIER_MATERIALS.get((Object)tier), 1), RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)AntimatterAPI.get(BlockCasing.class, (String)("casing_" + tier.getId()), (String)"gti")})}).fi(new FluidStack[]{liquid.getLiquid(Ref.L * 2L)}).io(new ItemStack[]{new ItemStack((ItemLike)AntimatterAPI.get(BlockCasing.class, (String)("hull_" + tier.getId()), (String)"gti"))}).add("hull_" + tier.getId(), 100L, (long)Math.pow(2.0, 2 * tier.getIntegerId() + 1));
    }

    private static void addCasing(Material mat, BlockCasing casing) {
        RecipeMaps.ASSEMBLING.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)((MaterialTypeBlock.IBlockGetter)AntimatterMaterialTypes.FRAME.get()).get(mat).asItem(), (int)1), RecipeIngredient.of((ItemLike)AntimatterMaterialTypes.PLATE.get(mat), (int)4)}).io(new ItemStack[]{new ItemStack((ItemLike)casing, 2)}).add(AntimatterPlatformUtils.getIdFromBlock((Block)casing).m_135815_(), 80L, 30L);
    }

    private static void addCoil(BlockCoil coil, PipeItemBlock wire, Material fluidmat, int tier) {
        RecipeMaps.ASSEMBLING.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)wire, (int)8), RecipeIngredient.of((ItemLike)AntimatterMaterialTypes.DUST.get(Materials.Aluminosilicate), (int)4)}).fi(new FluidStack[]{fluidmat.getLiquid(Ref.L * 2L)}).io(new ItemStack[]{new ItemStack((ItemLike)coil, 1)}).add(AntimatterPlatformUtils.getIdFromBlock((Block)coil).m_135815_(), (long)(100 * tier), (long)(30.0 * Math.pow(4.0, tier - 1)));
    }
}

