/*
 * Decompiled with CFR 0.152.
 */
package muramasa.gregtech.loader.machines;

import java.util.List;
import muramasa.antimatter.data.AntimatterMaterialTypes;
import muramasa.antimatter.data.AntimatterMaterials;
import muramasa.antimatter.material.IMaterialTag;
import muramasa.antimatter.material.Material;
import muramasa.antimatter.material.MaterialStack;
import muramasa.antimatter.material.MaterialTags;
import muramasa.antimatter.recipe.ingredient.RecipeIngredient;
import muramasa.gregtech.data.GregTechData;
import muramasa.gregtech.data.GregTechMaterialTags;
import muramasa.gregtech.data.Materials;
import muramasa.gregtech.data.RecipeMaps;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class AlloyLoader {
    public static void init() {
        AntimatterMaterialTypes.INGOT.all().forEach(t -> {
            if (t.has(new IMaterialTag[]{GregTechMaterialTags.NEEDS_BLAST_FURNACE})) {
                return;
            }
            if (!t.has(new IMaterialTag[]{MaterialTags.METAL})) {
                return;
            }
            List stacks = t.getProcessInto();
            if (stacks.size() != 2) {
                return;
            }
            int cumulative = t == Materials.RedAlloy ? 1 : ((MaterialStack)stacks.get((int)0)).s + ((MaterialStack)stacks.get((int)1)).s;
            MaterialStack first = (MaterialStack)stacks.get(0);
            MaterialStack second = (MaterialStack)stacks.get(1);
            RecipeMaps.ALLOY_SMELTING.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)AntimatterMaterialTypes.DUST.getMaterialTag(first.m), (int)first.s), RecipeIngredient.of((TagKey)AntimatterMaterialTypes.DUST.getMaterialTag(second.m), (int)second.s)}).io(new ItemStack[]{new ItemStack((ItemLike)AntimatterMaterialTypes.INGOT.get(t), cumulative)}).add(t.getId() + "_ingot", 100L, 16L);
            boolean firstIngot = first.m.has(new IMaterialTag[]{AntimatterMaterialTypes.INGOT});
            boolean secondIngot = second.m.has(new IMaterialTag[]{AntimatterMaterialTypes.INGOT});
            if (firstIngot && secondIngot) {
                RecipeMaps.ALLOY_SMELTING.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)AntimatterMaterialTypes.INGOT.getMaterialTag(first.m), (int)first.s), RecipeIngredient.of((TagKey)AntimatterMaterialTypes.INGOT.getMaterialTag(second.m), (int)second.s)}).io(new ItemStack[]{new ItemStack((ItemLike)AntimatterMaterialTypes.INGOT.get(t), cumulative)}).add(t.getId() + "_ingot_2", 100L, 12L);
            }
            if (firstIngot) {
                RecipeMaps.ALLOY_SMELTING.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)AntimatterMaterialTypes.INGOT.getMaterialTag(first.m), (int)first.s), RecipeIngredient.of((TagKey)AntimatterMaterialTypes.DUST.getMaterialTag(second.m), (int)second.s)}).io(new ItemStack[]{new ItemStack((ItemLike)AntimatterMaterialTypes.INGOT.get(t), cumulative)}).add(t.getId() + "_ingot_3", 100L, 12L);
            }
            if (secondIngot) {
                RecipeMaps.ALLOY_SMELTING.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)AntimatterMaterialTypes.DUST.getMaterialTag(first.m), (int)first.s), RecipeIngredient.of((TagKey)AntimatterMaterialTypes.INGOT.getMaterialTag(second.m), (int)second.s)}).io(new ItemStack[]{new ItemStack((ItemLike)AntimatterMaterialTypes.INGOT.get(t), cumulative)}).add(t.getId() + "_ingot_4", 100L, 12L);
            }
        });
        AlloyLoader.addAlloyRecipes(AntimatterMaterials.Copper, 3, Materials.Electrum, 2, Materials.BlackBronze, 5);
        AlloyLoader.addAlloyRecipes(Materials.Bismuth, 1, Materials.Brass, 4, Materials.BismuthBronze, 5);
        RecipeMaps.ALLOY_SMELTING.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)AntimatterMaterialTypes.DUST.get(Materials.RawRubber), (int)3), RecipeIngredient.of((TagKey)AntimatterMaterialTypes.DUST.getMaterialTag(Materials.Sulfur), (int)1)}).io(new ItemStack[]{AntimatterMaterialTypes.INGOT.get(Materials.Rubber, 1)}).add("rubber_via_alloy_smelter", 20L, 10L);
        AntimatterMaterialTypes.PLATE.all().stream().filter(m -> !m.has(new IMaterialTag[]{GregTechMaterialTags.NEEDS_BLAST_FURNACE}) && m.has(new IMaterialTag[]{AntimatterMaterialTypes.INGOT})).forEach(m -> {
            int euPerTick = m.has(new IMaterialTag[]{MaterialTags.RUBBERTOOLS}) ? 8 : 32;
            RecipeMaps.ALLOY_SMELTING.RB().ii(new Ingredient[]{AntimatterMaterialTypes.INGOT.getMaterialIngredient(m, 2), RecipeIngredient.of(GregTechData.MoldPlate, (int)1).setNoConsume()}).io(new ItemStack[]{AntimatterMaterialTypes.PLATE.get(m, 1)}).add(m.getId() + "_plate", m.getMass() * 2L, (long)euPerTick);
            if (m.has(new IMaterialTag[]{MaterialTags.RUBBERTOOLS})) {
                RecipeMaps.ALLOY_SMELTING.RB().ii(new Ingredient[]{AntimatterMaterialTypes.DUST.getMaterialIngredient(m, 2), RecipeIngredient.of(GregTechData.MoldPlate, (int)1).setNoConsume()}).io(new ItemStack[]{AntimatterMaterialTypes.PLATE.get(m, 1)}).add(m.getId() + "_plate_from_dust", m.getMass() * 2L, (long)euPerTick);
            }
        });
        AntimatterMaterialTypes.INGOT.all().stream().filter(m -> m.has(new IMaterialTag[]{MaterialTags.RUBBERTOOLS})).forEach(m -> RecipeMaps.ALLOY_SMELTING.RB().ii(new Ingredient[]{AntimatterMaterialTypes.DUST.getMaterialIngredient(m, 1), RecipeIngredient.of(GregTechData.MoldIngot, (int)1).setNoConsume()}).io(new ItemStack[]{AntimatterMaterialTypes.INGOT.get(m, 1)}).add(m.getId() + "_ingot", m.getMass(), 10L));
        AntimatterMaterialTypes.ITEM_CASING.all().forEach(m -> RecipeMaps.ALLOY_SMELTING.RB().ii(new Ingredient[]{AntimatterMaterialTypes.INGOT.getMaterialIngredient(m, 2), RecipeIngredient.of(GregTechData.MoldCasing, (int)1).setNoConsume()}).io(new ItemStack[]{AntimatterMaterialTypes.ITEM_CASING.get(m, 3)}).add(m.getId() + "_item_casing", Math.max(m.getMass() * 2L / 3L, 1L), 16L));
        AntimatterMaterialTypes.FISSILE_FUEL.all().forEach(f -> RecipeMaps.ALLOY_SMELTING.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)AntimatterMaterialTypes.INGOT.get(f), (int)1), RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{AntimatterMaterialTypes.INGOT.get(f)})}).io(new Item[]{AntimatterMaterialTypes.FISSILE_FUEL.get(f)}).add(f.getId() + "_fissile_fuel_smelting"));
    }

    private static void addAlloyRecipes(Material input1, int count1, Material input2, int count2, Material output, int countO) {
        if (input1.has(new IMaterialTag[]{AntimatterMaterialTypes.INGOT}) && input2.has(new IMaterialTag[]{AntimatterMaterialTypes.INGOT})) {
            RecipeMaps.ALLOY_SMELTING.RB().ii(new Ingredient[]{AntimatterMaterialTypes.INGOT.getMaterialIngredient(input1, count1), AntimatterMaterialTypes.INGOT.getMaterialIngredient(input2, count2)}).io(new ItemStack[]{AntimatterMaterialTypes.INGOT.get(output, countO)}).add(output.getId() + "_ingot", 100L, 12L);
        }
        if (input2.has(new IMaterialTag[]{AntimatterMaterialTypes.INGOT})) {
            RecipeMaps.ALLOY_SMELTING.RB().ii(new Ingredient[]{AntimatterMaterialTypes.DUST.getMaterialIngredient(input1, count1), AntimatterMaterialTypes.INGOT.getMaterialIngredient(input2, count2)}).io(new ItemStack[]{AntimatterMaterialTypes.INGOT.get(output, countO)}).add(output.getId() + "_ingot_1", 100L, 12L);
        }
        if (input1.has(new IMaterialTag[]{AntimatterMaterialTypes.INGOT})) {
            RecipeMaps.ALLOY_SMELTING.RB().ii(new Ingredient[]{AntimatterMaterialTypes.INGOT.getMaterialIngredient(input1, count1), AntimatterMaterialTypes.DUST.getMaterialIngredient(input2, count2)}).io(new ItemStack[]{AntimatterMaterialTypes.INGOT.get(output, countO)}).add(output.getId() + "_ingot_2", 100L, 12L);
        }
        RecipeMaps.ALLOY_SMELTING.RB().ii(new Ingredient[]{AntimatterMaterialTypes.DUST.getMaterialIngredient(input1, count1), AntimatterMaterialTypes.DUST.getMaterialIngredient(input2, count2)}).io(new ItemStack[]{AntimatterMaterialTypes.INGOT.get(output, countO)}).add(output.getId() + "_ingot_3", 100L, 12L);
    }
}

