/*
 * Decompiled with CFR 0.152.
 */
package muramasa.gregtech.loader.items;

import io.github.gregtechintergalactical.gtrubber.GTRubberData;
import muramasa.antimatter.Ref;
import muramasa.antimatter.data.AntimatterMaterialTypes;
import muramasa.antimatter.data.AntimatterMaterials;
import muramasa.antimatter.material.Material;
import muramasa.antimatter.material.SubTag;
import muramasa.antimatter.pipe.PipeSize;
import muramasa.antimatter.recipe.ingredient.RecipeIngredient;
import muramasa.gregtech.data.GregTechData;
import muramasa.gregtech.data.GregTechMaterialTags;
import muramasa.gregtech.data.GregTechTags;
import muramasa.gregtech.data.Materials;
import muramasa.gregtech.data.RecipeMaps;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;

public class Circuitry {
    public static void init() {
        Circuitry.boards();
        Circuitry.circuits();
    }

    private static void boards() {
        RecipeMaps.ASSEMBLING.RB().ii(new Ingredient[]{AntimatterMaterialTypes.PLATE.getMaterialIngredient(Materials.Silicon, 1), AntimatterMaterialTypes.PLATE.getMaterialIngredient(Materials.Polyethylene, 1)}).io(new ItemStack[]{new ItemStack(GregTechData.CircuitBoardEmpty)}).add("empty_circuit_board", 32L, 16L);
        RecipeMaps.PRESSING.RB().ii(new Ingredient[]{RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{GregTechData.CircuitBoardEmpty}), RecipeIngredient.of(GregTechData.EtchedWiringMV, (int)4)}).io(new ItemStack[]{new ItemStack(GregTechData.CircuitBoardBasic)}).add("basic_circuit_board", 32L, 16L);
        RecipeMaps.PRESSING.RB().ii(new Ingredient[]{RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{GregTechData.CircuitBoardEmpty}), RecipeIngredient.of(GregTechData.EtchedWiringHV, (int)4)}).io(new ItemStack[]{new ItemStack(GregTechData.CircuitBoardAdvanced)}).add("advanced_circuit_board", 32L, 16L);
        RecipeMaps.PRESSING.RB().ii(new Ingredient[]{RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{GregTechData.CircuitBoardProcessorEmpty}), RecipeIngredient.of(GregTechData.EtchedWiringEV, (int)4)}).io(new ItemStack[]{new ItemStack(GregTechData.CircuitBoardProcessor)}).add("processor_circuit_board", 32L, 256L);
        RecipeMaps.ASSEMBLING.RB().ii(new Ingredient[]{AntimatterMaterialTypes.PLATE.getMaterialIngredient(Materials.Silicon, 2), AntimatterMaterialTypes.PLATE.getMaterialIngredient(Materials.Polytetrafluoroethylene, 1)}).io(new ItemStack[]{new ItemStack(GregTechData.CircuitBoardProcessorEmpty)}).add("empty_processor_circuit_board", 32L, 256L);
        RecipeMaps.ASSEMBLING.RB().ii(new Ingredient[]{AntimatterMaterialTypes.PLATE.getMaterialIngredient(Materials.Lazurite, 1), AntimatterMaterialTypes.DUST.getMaterialIngredient(AntimatterMaterials.Glowstone, 1)}).io(new ItemStack[]{new ItemStack(GregTechData.AdvCircuitParts, 2)}).add("advanced_circuit_parts", 32L, 64L);
        RecipeMaps.ASSEMBLING.RB().ii(new Ingredient[]{AntimatterMaterialTypes.PLATE.getMaterialIngredient(Materials.Polyethylene, 1), RecipeIngredient.of((ItemLike)GregTechData.WIRE_RED_ALLOY.getBlockItem(PipeSize.VTINY), (int)1)}).fi(new FluidStack[]{Materials.Tin.getLiquid(Ref.L / 4L)}).io(new ItemStack[]{new ItemStack(GregTechData.NandChip)}).add("nand_chip_tin_poly", 32L, 16L);
        RecipeMaps.ASSEMBLING.RB().ii(new Ingredient[]{AntimatterMaterialTypes.PLATE.getMaterialIngredient(Materials.Polyethylene, 1), RecipeIngredient.of((ItemLike)GregTechData.WIRE_RED_ALLOY.getBlockItem(PipeSize.VTINY), (int)1)}).fi(new FluidStack[]{Materials.SolderingAlloy.getLiquid(Ref.L / 8L)}).io(new ItemStack[]{new ItemStack(GregTechData.NandChip)}).add("nand_chip_soldering_alloy_poly", 32L, 16L);
        RecipeMaps.ASSEMBLING.RB().ii(new Ingredient[]{AntimatterMaterialTypes.PLATE.getMaterialIngredient(Materials.Polyethylene, 1), RecipeIngredient.of((ItemLike)GregTechData.WIRE_RED_ALLOY.getBlockItem(PipeSize.VTINY), (int)1)}).fi(new FluidStack[]{Materials.Lead.getLiquid(Ref.L / 2L)}).io(new ItemStack[]{new ItemStack(GregTechData.NandChip)}).add("nand_chip_lead_poly", 32L, 16L);
        RecipeMaps.ASSEMBLING.RB().ii(new Ingredient[]{AntimatterMaterialTypes.ITEM_CASING.getMaterialIngredient(Materials.Steel, 1), RecipeIngredient.of((ItemLike)GregTechData.WIRE_RED_ALLOY.getBlockItem(PipeSize.VTINY), (int)2)}).fi(new FluidStack[]{Materials.Tin.getLiquid(Ref.L / 4L)}).io(new ItemStack[]{new ItemStack(GregTechData.NandChip)}).add("nand_chip_tin_steel", 32L, 16L);
        RecipeMaps.ASSEMBLING.RB().ii(new Ingredient[]{AntimatterMaterialTypes.ITEM_CASING.getMaterialIngredient(Materials.Steel, 1), RecipeIngredient.of((ItemLike)GregTechData.WIRE_RED_ALLOY.getBlockItem(PipeSize.VTINY), (int)2)}).fi(new FluidStack[]{Materials.SolderingAlloy.getLiquid(Ref.L / 8L)}).io(new ItemStack[]{new ItemStack(GregTechData.NandChip)}).add("nand_chip_soldering_alloy_steel", 32L, 16L);
        RecipeMaps.ASSEMBLING.RB().ii(new Ingredient[]{AntimatterMaterialTypes.ITEM_CASING.getMaterialIngredient(Materials.Steel, 1), RecipeIngredient.of((ItemLike)GregTechData.WIRE_RED_ALLOY.getBlockItem(PipeSize.VTINY), (int)2)}).fi(new FluidStack[]{Materials.Lead.getLiquid(Ref.L / 2L)}).io(new ItemStack[]{new ItemStack(GregTechData.NandChip)}).add("nand_chip_lead_steel", 32L, 16L);
    }

    private static void circuits() {
        RecipeMaps.ASSEMBLING.RB().ii(new Ingredient[]{RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{GregTechData.CircuitBoardBasic}), RecipeIngredient.of(GregTechData.NandChip, (int)2)}).fi(new FluidStack[]{Materials.Tin.getLiquid(Ref.L / 2L)}).io(new ItemStack[]{new ItemStack(GregTechData.CircuitBasicElectronic)}).add("basic_circuit_tin", 32L, 16L);
        RecipeMaps.ASSEMBLING.RB().ii(new Ingredient[]{RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{GregTechData.CircuitBoardBasic}), RecipeIngredient.of(GregTechData.NandChip, (int)2)}).fi(new FluidStack[]{Materials.SolderingAlloy.getLiquid(Ref.L / 4L)}).io(new ItemStack[]{new ItemStack(GregTechData.CircuitBasicElectronic)}).add("basic_circuit_soldering_alloy", 32L, 16L);
        RecipeMaps.ASSEMBLING.RB().ii(new Ingredient[]{RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{GregTechData.CircuitBoardBasic}), RecipeIngredient.of(GregTechData.NandChip, (int)2)}).fi(new FluidStack[]{Materials.Lead.getLiquid(Ref.L)}).io(new ItemStack[]{new ItemStack(GregTechData.CircuitBasicElectronic)}).add("basic_circuit_lead", 32L, 16L);
        RecipeMaps.ASSEMBLING.RB().ii(new Ingredient[]{RecipeIngredient.m_204132_(GregTechTags.CIRCUITS_BASIC), RecipeIngredient.of(GregTechData.NandChip, (int)2)}).fi(new FluidStack[]{Materials.Tin.getLiquid(Ref.L / 2L)}).io(new ItemStack[]{new ItemStack(GregTechData.CircuitGood)}).add("good_circuit_tin", 32L, 16L);
        RecipeMaps.ASSEMBLING.RB().ii(new Ingredient[]{RecipeIngredient.m_204132_(GregTechTags.CIRCUITS_BASIC), RecipeIngredient.of(GregTechData.NandChip, (int)2)}).fi(new FluidStack[]{Materials.SolderingAlloy.getLiquid(Ref.L / 4L)}).io(new ItemStack[]{new ItemStack(GregTechData.CircuitGood)}).add("good_circuit_soldering_alloy", 32L, 16L);
        RecipeMaps.ASSEMBLING.RB().ii(new Ingredient[]{RecipeIngredient.m_204132_(GregTechTags.CIRCUITS_BASIC), RecipeIngredient.of(GregTechData.NandChip, (int)2)}).fi(new FluidStack[]{Materials.Lead.getLiquid(Ref.L)}).io(new ItemStack[]{new ItemStack(GregTechData.CircuitGood)}).add("good_circuit_lead", 32L, 16L);
        RecipeMaps.ASSEMBLING.RB().ii(new Ingredient[]{RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{GregTechData.CircuitBoardAdvanced}), RecipeIngredient.of(GregTechData.NandChip, (int)2)}).fi(new FluidStack[]{Materials.Tin.getLiquid(Ref.L)}).io(new ItemStack[]{new ItemStack(GregTechData.CircuitAdv)}).add("advanced_circuit_tin", 32L, 64L);
        RecipeMaps.ASSEMBLING.RB().ii(new Ingredient[]{RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{GregTechData.CircuitBoardAdvanced}), RecipeIngredient.of(GregTechData.NandChip, (int)2)}).fi(new FluidStack[]{Materials.SolderingAlloy.getLiquid(Ref.L / 2L)}).io(new ItemStack[]{new ItemStack(GregTechData.CircuitAdv)}).add("advanced_circuit_soldering_alloy", 32L, 64L);
        RecipeMaps.ASSEMBLING.RB().ii(new Ingredient[]{RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{GregTechData.CircuitBoardAdvanced}), RecipeIngredient.of(GregTechData.NandChip, (int)2)}).fi(new FluidStack[]{Materials.Lead.getLiquid(Ref.L * 2L)}).io(new ItemStack[]{new ItemStack(GregTechData.CircuitDataStorage)}).add("data_storage__circuit_lead", 32L, 64L);
        RecipeMaps.ASSEMBLING.RB().ii(new Ingredient[]{RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{GregTechData.CircuitBoardAdvanced}), RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{GregTechData.EngravedCrystalChip})}).fi(new FluidStack[]{Materials.Tin.getLiquid(Ref.L)}).io(new ItemStack[]{new ItemStack(GregTechData.CircuitDataStorage)}).add("data_storage_circuit_tin", 32L, 64L);
        RecipeMaps.ASSEMBLING.RB().ii(new Ingredient[]{RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{GregTechData.CircuitBoardAdvanced}), RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{GregTechData.EngravedCrystalChip})}).fi(new FluidStack[]{Materials.SolderingAlloy.getLiquid(Ref.L / 2L)}).io(new ItemStack[]{new ItemStack(GregTechData.CircuitDataStorage)}).add("data_storage__circuit_soldering_alloy", 32L, 64L);
        RecipeMaps.ASSEMBLING.RB().ii(new Ingredient[]{RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{GregTechData.CircuitBoardAdvanced}), RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{GregTechData.EngravedCrystalChip})}).fi(new FluidStack[]{Materials.Lead.getLiquid(Ref.L * 2L)}).io(new ItemStack[]{new ItemStack(GregTechData.CircuitAdv)}).add("advanced_circuit_lead", 32L, 64L);
        RecipeMaps.ASSEMBLING.RB().ii(new Ingredient[]{RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{GregTechData.CircuitBoardProcessor}), RecipeIngredient.of(GregTechData.CircuitDataStorage, (int)3)}).fi(new FluidStack[]{Materials.Tin.getLiquid(Ref.L * 2L)}).io(new ItemStack[]{new ItemStack(GregTechData.CircuitDataControl)}).add("data_control_circuit_tin", 32L, 256L);
        RecipeMaps.ASSEMBLING.RB().ii(new Ingredient[]{RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{GregTechData.CircuitBoardProcessor}), RecipeIngredient.of(GregTechData.CircuitDataStorage, (int)3)}).fi(new FluidStack[]{Materials.SolderingAlloy.getLiquid(Ref.L)}).io(new ItemStack[]{new ItemStack(GregTechData.CircuitDataControl)}).add("data_control_circuit_soldering_alloy", 32L, 256L);
        RecipeMaps.ASSEMBLING.RB().ii(new Ingredient[]{RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{GregTechData.CircuitBoardProcessor}), RecipeIngredient.of(GregTechData.CircuitDataStorage, (int)3)}).fi(new FluidStack[]{Materials.Lead.getLiquid(Ref.L * 4L)}).io(new ItemStack[]{new ItemStack(GregTechData.CircuitDataControl)}).add("data_control_circuit_lead", 32L, 256L);
        RecipeMaps.ASSEMBLING.RB().ii(new Ingredient[]{RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{GregTechData.CircuitBoardProcessor}), RecipeIngredient.of(GregTechData.EngravedLapotronChip, (int)3)}).fi(new FluidStack[]{Materials.Tin.getLiquid(Ref.L * 2L)}).io(new ItemStack[]{new ItemStack(GregTechData.CircuitEnergyFlow)}).add("energy_flow_circuit_tin", 32L, 256L);
        RecipeMaps.ASSEMBLING.RB().ii(new Ingredient[]{RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{GregTechData.CircuitBoardProcessor}), RecipeIngredient.of(GregTechData.EngravedLapotronChip, (int)3)}).fi(new FluidStack[]{Materials.SolderingAlloy.getLiquid(Ref.L)}).io(new ItemStack[]{new ItemStack(GregTechData.CircuitEnergyFlow)}).add("energy_flow_circuit_soldering_alloy", 32L, 256L);
        RecipeMaps.ASSEMBLING.RB().ii(new Ingredient[]{RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{GregTechData.CircuitBoardProcessor}), RecipeIngredient.of(GregTechData.EngravedLapotronChip, (int)3)}).fi(new FluidStack[]{Materials.Lead.getLiquid(Ref.L * 4L)}).io(new ItemStack[]{new ItemStack(GregTechData.CircuitEnergyFlow)}).add("energy_flow_circuit_lead", 32L, 256L);
    }

    private static void bloodyBoards() {
        RecipeMaps.ASSEMBLING.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)GTRubberData.StickyResin, (int)2), RecipeIngredient.of((ItemLike)AntimatterMaterialTypes.PLATE.get(AntimatterMaterials.Wood), (int)8)}).fi(new FluidStack[]{Materials.Glue.getLiquid(100)}).io(new ItemStack[]{new ItemStack(GregTechData.CircuitBoardCoated, 8)}).add("coated_circuit_board", 160L, 8L);
        RecipeMaps.ASSEMBLING.RB().ii(new Ingredient[]{RecipeIngredient.of(GregTechData.CircuitBoardCoated, (int)1), RecipeIngredient.of((ItemLike)AntimatterMaterialTypes.PLATE.get(AntimatterMaterials.Wood), (int)1)}).fi(new FluidStack[]{Materials.Phenol.getLiquid(100)}).io(new ItemStack[]{new ItemStack(GregTechData.CircuitBoardPhenolic, 1)}).add("phenolic_circuit_board", 160L, 32L);
        RecipeMaps.CHEMICAL_REACTING.RB().ii(new Ingredient[]{RecipeIngredient.of(GregTechData.CircuitBoardPhenolic, (int)1), RecipeIngredient.of((ItemLike)AntimatterMaterialTypes.PLATE.get(Materials.Polyethylene), (int)1), RecipeIngredient.of((ItemLike)AntimatterMaterialTypes.FOIL.get(AntimatterMaterials.Copper), (int)1)}).fi(new FluidStack[]{Materials.SulfuricAcid.getLiquid(125)}).io(new ItemStack[]{new ItemStack(GregTechData.CircuitBoardPlastic, 1)}).add("plastic_circuit_board", 160L, 128L);
        RecipeMaps.CHEMICAL_REACTING.RB().ii(new Ingredient[]{RecipeIngredient.of(GregTechData.CircuitBoardPhenolic, (int)1), RecipeIngredient.of((ItemLike)AntimatterMaterialTypes.PLATE.get(Materials.PolyvinylChloride), (int)1), RecipeIngredient.of((ItemLike)AntimatterMaterialTypes.FOIL.get(AntimatterMaterials.Copper), (int)1)}).fi(new FluidStack[]{Materials.SulfuricAcid.getLiquid(125)}).io(new ItemStack[]{new ItemStack(GregTechData.CircuitBoardPlastic, 2)}).add("plastic_circuit_board_2", 160L, 128L);
        RecipeMaps.CHEMICAL_REACTING.RB().ii(new Ingredient[]{RecipeIngredient.of(GregTechData.CircuitBoardPhenolic, (int)1), RecipeIngredient.of((ItemLike)AntimatterMaterialTypes.PLATE.get(Materials.Polytetrafluoroethylene), (int)1), RecipeIngredient.of((ItemLike)AntimatterMaterialTypes.FOIL.get(AntimatterMaterials.Copper), (int)1)}).fi(new FluidStack[]{Materials.SulfuricAcid.getLiquid(125)}).io(new ItemStack[]{new ItemStack(GregTechData.CircuitBoardPlastic, 4)}).add("plastic_circuit_board_3", 160L, 128L);
        RecipeMaps.CHEMICAL_REACTING.RB().ii(new Ingredient[]{RecipeIngredient.of(GregTechData.CircuitBoardPlastic, (int)1), RecipeIngredient.of((ItemLike)AntimatterMaterialTypes.PLATE.get(Materials.EpoxyResin), (int)1), RecipeIngredient.of((ItemLike)AntimatterMaterialTypes.FOIL.get(Materials.AnnealedCopper), (int)1)}).fi(new FluidStack[]{Materials.SulfuricAcid.getLiquid(125)}).io(new ItemStack[]{new ItemStack(GregTechData.CircuitBoardEpoxy, 1)}).add("epoxy_circuit_board", 160L, 512L);
        RecipeMaps.CHEMICAL_REACTING.RB().ii(new Ingredient[]{RecipeIngredient.of(GregTechData.CircuitBoardEpoxy, (int)1), RecipeIngredient.of((ItemLike)AntimatterMaterialTypes.PLATE.get(Materials.FiberReinforcedEpoxyResin), (int)1), RecipeIngredient.of((ItemLike)AntimatterMaterialTypes.FOIL.get(Materials.AnnealedCopper), (int)1)}).fi(new FluidStack[]{Materials.SulfuricAcid.getLiquid(125)}).io(new ItemStack[]{new ItemStack(GregTechData.CircuitBoardFiber, 1)}).add("fiber_circuit_board", 160L, 2048L);
        RecipeMaps.CHEMICAL_REACTING.RB().ii(new Ingredient[]{RecipeIngredient.of(GregTechData.CircuitBoardFiber, (int)1), RecipeIngredient.of((ItemLike)AntimatterMaterialTypes.FOIL.get(Materials.Electrum), (int)1)}).fi(new FluidStack[]{Materials.SulfuricAcid.getLiquid(125)}).io(new ItemStack[]{new ItemStack(GregTechData.CircuitBoardMultiFiber, 1)}).add("multi_fiber_circuit_board", 160L, 8192L);
        RecipeMaps.ASSEMBLING.RB().ii(new Ingredient[]{RecipeIngredient.of(GregTechData.CircuitBoardMultiFiber, (int)1), RecipeIngredient.of(GregTechData.CircuitEnergyFlow, (int)1), RecipeIngredient.of((ItemLike)AntimatterMaterialTypes.FOIL.get(Materials.Electrum), (int)1)}).fi(new FluidStack[]{Materials.Polystyrene.getLiquid(144)}).io(new ItemStack[]{new ItemStack(GregTechData.CircuitBoardWetware, 1)}).add("wetware_circuit_board", 160L, 32768L);
    }

    private static void bloodyCircuits() {
        for (Material material : GregTechMaterialTags.SOLDER.all()) {
            boolean hasBad;
            long base = Ref.L / 8L;
            boolean hasGood = GregTechMaterialTags.SOLDER.has(SubTag.GOOD_SOLDER, material);
            RecipeMaps.ASSEMBLING.RB().ii(new Ingredient[]{RecipeIngredient.of(GregTechData.CircuitBoardCoated, (int)1), RecipeIngredient.of(GregTechData.Resistor, (int)2), RecipeIngredient.of(GregTechData.Transistor, (int)2), RecipeIngredient.of(GregTechData.Capacitor, (int)2), RecipeIngredient.of((ItemLike)AntimatterMaterialTypes.WIRE_FINE.get(AntimatterMaterials.Copper), (int)2)}).io(new ItemStack[]{new ItemStack(GregTechData.CircuitBasicElectronic, 1)}).fi(new FluidStack[]{material.getLiquid((base *= (hasBad = GregTechMaterialTags.SOLDER.has(SubTag.BAD_SOLDER, material)) ? (long)(hasGood ? 2 : 4) : 1L) * 4L)}).add("basic_circuit_using_" + material.getId(), 400L, 8L);
            RecipeMaps.ASSEMBLING.RB().ii(new Ingredient[]{RecipeIngredient.of(GregTechData.CircuitBoardPhenolic, (int)1), RecipeIngredient.of(GregTechData.Resistor, (int)2), RecipeIngredient.of(GregTechData.Transistor, (int)2), RecipeIngredient.of(GregTechData.Capacitor, (int)2), RecipeIngredient.of((ItemLike)AntimatterMaterialTypes.WIRE_FINE.get(Materials.Electrum), (int)2)}).io(new ItemStack[]{new ItemStack(GregTechData.CircuitGood, 1)}).fi(new FluidStack[]{material.getLiquid(base * 4L)}).add("good_circuit_using_" + material.getId(), 400L, 32L);
            RecipeMaps.ASSEMBLING.RB().ii(new Ingredient[]{RecipeIngredient.of(GregTechData.CircuitBoardPlastic, (int)1), RecipeIngredient.of(GregTechData.Resistor, (int)4), RecipeIngredient.of(GregTechData.Transistor, (int)4), RecipeIngredient.of(GregTechData.Capacitor, (int)4), RecipeIngredient.of((ItemLike)AntimatterMaterialTypes.WIRE_FINE.get(Materials.RedAlloy), (int)2)}).io(new ItemStack[]{new ItemStack(GregTechData.CircuitAdv, 1)}).fi(new FluidStack[]{material.getLiquid(base * 4L)}).add("advanced_circuit_using_" + material.getId(), 400L, 128L);
            RecipeMaps.ASSEMBLING.RB().ii(new Ingredient[]{RecipeIngredient.of(GregTechData.CircuitBoardEpoxy, (int)1), RecipeIngredient.of(GregTechData.Resistor, (int)4), RecipeIngredient.of(GregTechData.Transistor, (int)4), RecipeIngredient.of(GregTechData.Capacitor, (int)4), RecipeIngredient.of((ItemLike)AntimatterMaterialTypes.WIRE_FINE.get(Materials.RoseGold), (int)2)}).io(new ItemStack[]{new ItemStack(GregTechData.CircuitNanoProcessor, 1)}).fi(new FluidStack[]{material.getLiquid(base * 4L)}).add("nano_processor_circuit_using_" + material.getId(), 400L, 512L);
            RecipeMaps.ASSEMBLING.RB().ii(new Ingredient[]{RecipeIngredient.of(GregTechData.CircuitBoardFiber, (int)1), RecipeIngredient.of(GregTechData.Resistor, (int)4), RecipeIngredient.of(GregTechData.Transistor, (int)4), RecipeIngredient.of(GregTechData.Capacitor, (int)4), RecipeIngredient.of((ItemLike)AntimatterMaterialTypes.WIRE_FINE.get(Materials.Platinum), (int)2)}).io(new ItemStack[]{new ItemStack(GregTechData.CircuitQuantumProcessor, 1)}).fi(new FluidStack[]{material.getLiquid(base * 4L)}).add("quantum_processor_circuit_using_" + material.getId(), 400L, 2048L);
            RecipeMaps.ASSEMBLING.RB().ii(new Ingredient[]{RecipeIngredient.of(GregTechData.CircuitBoardMultiFiber, (int)1), RecipeIngredient.of(GregTechData.Resistor, (int)8), RecipeIngredient.of(GregTechData.Transistor, (int)8), RecipeIngredient.of(GregTechData.Capacitor, (int)8), RecipeIngredient.of((ItemLike)AntimatterMaterialTypes.WIRE_FINE.get(Materials.NiobiumTitanium), (int)4)}).io(new ItemStack[]{new ItemStack(GregTechData.CircuitEnergyFlow, 1)}).fi(new FluidStack[]{material.getLiquid(base * 4L)}).add("energy_flow_circuit_using_" + material.getId(), 400L, 8192L);
            RecipeMaps.ASSEMBLING.RB().ii(new Ingredient[]{RecipeIngredient.of(GregTechData.CircuitBoardWetware, (int)1), RecipeIngredient.of(GregTechData.Resistor, (int)8), RecipeIngredient.of(GregTechData.Transistor, (int)8), RecipeIngredient.of(GregTechData.Capacitor, (int)8), RecipeIngredient.of((ItemLike)AntimatterMaterialTypes.WIRE_FINE.get(Materials.YttriumBariumCuprate), (int)4)}).io(new ItemStack[]{new ItemStack(GregTechData.CircuitWetware, 1)}).fi(new FluidStack[]{material.getLiquid(base * 4L)}).add("wetware_circuit_using_" + material.getId(), 400L, 32768L);
        }
    }
}

