/*
 * Decompiled with CFR 0.152.
 */
package muramasa.gregtech.loader.crafting;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import muramasa.antimatter.AntimatterAPI;
import muramasa.antimatter.data.AntimatterDefaultTools;
import muramasa.antimatter.data.AntimatterMaterialTypes;
import muramasa.antimatter.datagen.providers.AntimatterRecipeProvider;
import muramasa.antimatter.material.IMaterialTag;
import muramasa.antimatter.pipe.PipeSize;
import muramasa.antimatter.pipe.types.Wire;
import muramasa.antimatter.util.AntimatterPlatformUtils;
import muramasa.gregtech.data.GregTechData;
import muramasa.gregtech.data.Materials;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class WireCablesPlates {
    public static void loadRecipes(Consumer<FinishedRecipe> output, AntimatterRecipeProvider provider) {
        AntimatterAPI.all(Wire.class, wire -> {
            ImmutableSet sizes = wire.getSizes();
            Map<PipeSize, Item> wires = sizes.stream().map(s -> new Pair(s, (Object)wire.getBlockItem(s))).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond));
            PipeSize[] val = PipeSize.values();
            for (int i = 1; i < val.length; ++i) {
                WireCablesPlates.oneToTwo(wires, val[i], val[i - 1], output, provider);
                WireCablesPlates.twoToOne(wires, val[i - 1], val[i], output, provider);
                if (i <= 1) continue;
                WireCablesPlates.fourToOne(wires, val[i - 2], val[i], output, provider);
            }
            if (wire.getMaterial().has(new IMaterialTag[]{AntimatterMaterialTypes.PLATE})) {
                provider.shapeless(output, wire.getMaterial().getId() + "_plate_to_wire", "wire", "has_cutter", provider.hasSafeItem(AntimatterDefaultTools.WIRE_CUTTER.getTag()), new ItemStack((ItemLike)wires.get(PipeSize.VTINY)), new Object[]{AntimatterDefaultTools.WIRE_CUTTER.getTag(), AntimatterMaterialTypes.PLATE.get(wire.getMaterial())});
            }
        });
        provider.shapeless(output, "manual_copper_cable", "wire", "has_cutter", provider.hasSafeItem(AntimatterDefaultTools.WIRE_CUTTER.getTag()), new ItemStack((ItemLike)GregTechData.CABLE_COPPER.getBlockItem(PipeSize.VTINY)), new Object[]{GregTechData.WIRE_COPPER.getBlockItem(PipeSize.VTINY), AntimatterMaterialTypes.PLATE.get(Materials.Rubber)});
        provider.shapeless(output, "manual_tin_cable", "wire", "has_cutter", provider.hasSafeItem(AntimatterDefaultTools.WIRE_CUTTER.getTag()), new ItemStack((ItemLike)GregTechData.CABLE_TIN.getBlockItem(PipeSize.VTINY)), new Object[]{GregTechData.WIRE_TIN.getBlockItem(PipeSize.VTINY), AntimatterMaterialTypes.PLATE.get(Materials.Rubber)});
        provider.shapeless(output, "manual_red_alloy_cable", "wire", "has_cutter", provider.hasSafeItem(AntimatterDefaultTools.WIRE_CUTTER.getTag()), new ItemStack((ItemLike)GregTechData.CABLE_RED_ALLOY.getBlockItem(PipeSize.VTINY)), new Object[]{GregTechData.WIRE_RED_ALLOY.getBlockItem(PipeSize.VTINY), AntimatterMaterialTypes.PLATE.get(Materials.Rubber)});
    }

    private static void twoToOne(Map<PipeSize, Item> wires, PipeSize from, PipeSize to, Consumer<FinishedRecipe> output, AntimatterRecipeProvider provider) {
        provider.shapeless(output, "two_to_one_" + AntimatterPlatformUtils.getIdFromItem((Item)wires.get(to)).m_135815_(), "wire", "has_cutter", provider.hasSafeItem(AntimatterDefaultTools.WIRE_CUTTER.getTag()), new ItemStack((ItemLike)wires.get(to), 1), new Object[]{wires.get(from), wires.get(from)});
    }

    private static void oneToTwo(Map<PipeSize, Item> wires, PipeSize from, PipeSize to, Consumer<FinishedRecipe> output, AntimatterRecipeProvider provider) {
        provider.shapeless(output, "one_to_two_" + AntimatterPlatformUtils.getIdFromItem((Item)wires.get(to)).m_135815_(), "wire", "has_cutter", provider.hasSafeItem(AntimatterDefaultTools.WIRE_CUTTER.getTag()), new ItemStack((ItemLike)wires.get(to), 2), new Object[]{wires.get(from)});
    }

    private static void fourToOne(Map<PipeSize, Item> wires, PipeSize from, PipeSize to, Consumer<FinishedRecipe> output, AntimatterRecipeProvider provider) {
        provider.shapeless(output, "four_to_one_" + AntimatterPlatformUtils.getIdFromItem((Item)wires.get(to)).m_135815_(), "wire", "has_cutter", provider.hasSafeItem(AntimatterDefaultTools.WIRE_CUTTER.getTag()), new ItemStack((ItemLike)wires.get(to), 1), new Object[]{wires.get(from), wires.get(from), wires.get(from), wires.get(from)});
    }
}

