/*
 * Decompiled with CFR 0.152.
 */
package muramasa.gregtech.loader.crafting;

import com.google.common.collect.ImmutableMap;
import java.util.function.Consumer;
import muramasa.antimatter.data.AntimatterDefaultTools;
import muramasa.antimatter.data.AntimatterMaterialTypes;
import muramasa.antimatter.datagen.providers.AntimatterRecipeProvider;
import muramasa.antimatter.machine.Tier;
import muramasa.antimatter.pipe.PipeSize;
import muramasa.antimatter.util.TagUtils;
import muramasa.gregtech.block.BlockCasing;
import muramasa.gregtech.data.GregTechData;
import muramasa.gregtech.data.Machines;
import muramasa.gregtech.data.Materials;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class SteamMachines {
    public static void loadRecipes(Consumer<FinishedRecipe> output, AntimatterRecipeProvider provider) {
        Item bronzePlate = AntimatterMaterialTypes.PLATE.get(Materials.Bronze);
        Item steelPlate = AntimatterMaterialTypes.PLATE.get(Materials.Steel);
        Item silverPlate = AntimatterMaterialTypes.PLATE.get(Materials.Silver);
        TagKey wrench = AntimatterDefaultTools.WRENCH.getTag();
        Item bricks = Items.f_41995_;
        Item furnace = Items.f_41962_;
        TagKey piston = TagUtils.getForgelikeItemTag((String)"pistons");
        Item diamond = Items.f_42415_;
        Item glass = Items.f_41904_;
        Block steelPipe = GregTechData.FLUID_PIPE_STEEL.getBlock(PipeSize.SMALL);
        Block bronzePipe = GregTechData.FLUID_PIPE_BRONZE.getBlock(PipeSize.SMALL);
        BlockCasing hullBronze = GregTechData.CASING_BRONZE;
        BlockCasing hullSteel = GregTechData.CASING_STEEL;
        BlockCasing brickedBronzeHull = GregTechData.CASING_BRICKED_BRONZE;
        BlockCasing brickedSteelHull = GregTechData.CASING_BRICKED_STEEL;
        provider.addItemRecipe(output, "steam_machines", "has_wrench", provider.hasSafeItem(AntimatterDefaultTools.WRENCH.getTag()), (ItemLike)Machines.COAL_BOILER.getItem(Tier.BRONZE), ImmutableMap.of((Object)Character.valueOf('P'), (Object)bronzePlate, (Object)Character.valueOf('W'), (Object)wrench, (Object)Character.valueOf('B'), (Object)bricks, (Object)Character.valueOf('F'), (Object)furnace), new String[]{"PPP", "PWP", "BFB"});
        provider.addItemRecipe(output, "steam_machines", "has_bronze", provider.hasSafeItem(AntimatterMaterialTypes.INGOT.getMaterialTag(Materials.Bronze)), (ItemLike)GregTechData.CASING_BRONZE, ImmutableMap.of((Object)Character.valueOf('P'), (Object)bronzePlate, (Object)Character.valueOf('W'), (Object)wrench), new String[]{"PPP", "PWP", "PPP"});
        provider.addItemRecipe(output, "steam_machines", "has_wrench", provider.hasSafeItem(AntimatterDefaultTools.WRENCH.getTag()), (ItemLike)Machines.COAL_BOILER.getItem(Tier.STEEL), ImmutableMap.of((Object)Character.valueOf('P'), (Object)steelPlate, (Object)Character.valueOf('W'), (Object)wrench, (Object)Character.valueOf('B'), (Object)bricks, (Object)Character.valueOf('F'), (Object)furnace), new String[]{"PPP", "PWP", "BFB"});
        provider.addItemRecipe(output, "steam_machines", "has_wrench", provider.hasSafeItem(AntimatterDefaultTools.WRENCH.getTag()), (ItemLike)Machines.LAVA_BOILER.getItem(Tier.STEEL), ImmutableMap.of((Object)Character.valueOf('P'), (Object)steelPlate, (Object)Character.valueOf('G'), (Object)glass, (Object)Character.valueOf('H'), (Object)((Object)brickedSteelHull)), new String[]{"PPP", "GGG", "PHP"});
        provider.addItemRecipe(output, "steam_machines", "has_wrench", provider.hasSafeItem(AntimatterDefaultTools.WRENCH.getTag()), (ItemLike)Machines.SOLAR_BOILER.getItem(Tier.BRONZE), ImmutableMap.of((Object)Character.valueOf('P'), (Object)silverPlate, (Object)Character.valueOf('G'), (Object)glass, (Object)Character.valueOf('I'), (Object)bronzePipe, (Object)Character.valueOf('H'), (Object)((Object)brickedBronzeHull)), new String[]{"GGG", "PPP", "IHI"});
        provider.addItemRecipe(output, "steam_machines", "has_wrench", provider.hasSafeItem(AntimatterDefaultTools.WRENCH.getTag()), (ItemLike)Machines.STEAM_MACERATOR.getItem(Tier.BRONZE), ImmutableMap.of((Object)Character.valueOf('B'), (Object)bronzePipe, (Object)Character.valueOf('H'), (Object)((Object)brickedBronzeHull), (Object)Character.valueOf('P'), (Object)piston, (Object)Character.valueOf('D'), (Object)diamond), new String[]{"DBD", "BHB", "PBP"});
        provider.addItemRecipe(output, "steam_machines", "has_wrench", provider.hasSafeItem(AntimatterDefaultTools.WRENCH.getTag()), (ItemLike)Machines.STEAM_EXTRACTOR.getItem(Tier.BRONZE), ImmutableMap.of((Object)Character.valueOf('B'), (Object)bronzePipe, (Object)Character.valueOf('H'), (Object)((Object)hullBronze), (Object)Character.valueOf('P'), (Object)piston, (Object)Character.valueOf('G'), (Object)glass), new String[]{"BBB", "PHG", "BBB"});
        provider.addItemRecipe(output, "steam_machines", "has_wrench", provider.hasSafeItem(AntimatterDefaultTools.WRENCH.getTag()), (ItemLike)Machines.STEAM_FORGE_HAMMER.getItem(Tier.BRONZE), ImmutableMap.of((Object)Character.valueOf('B'), (Object)bronzePipe, (Object)Character.valueOf('H'), (Object)((Object)hullBronze), (Object)Character.valueOf('P'), (Object)piston, (Object)Character.valueOf('A'), (Object)Items.f_42146_), new String[]{"BPB", "BHB", "BAB"});
        provider.addItemRecipe(output, "steam_machines", "has_wrench", provider.hasSafeItem(AntimatterDefaultTools.WRENCH.getTag()), (ItemLike)Machines.STEAM_COMPRESSOR.getItem(Tier.BRONZE), ImmutableMap.of((Object)Character.valueOf('B'), (Object)bronzePipe, (Object)Character.valueOf('H'), (Object)((Object)hullBronze), (Object)Character.valueOf('P'), (Object)piston), new String[]{"BBB", "PHP", "BBB"});
        provider.addItemRecipe(output, "steam_machines", "has_wrench", provider.hasSafeItem(AntimatterDefaultTools.WRENCH.getTag()), (ItemLike)Machines.STEAM_ALLOY_SMELTER.getItem(Tier.BRONZE), ImmutableMap.of((Object)Character.valueOf('B'), (Object)bronzePipe, (Object)Character.valueOf('H'), (Object)((Object)brickedBronzeHull), (Object)Character.valueOf('F'), (Object)Items.f_41962_), new String[]{"BBB", "FHF", "BBB"});
        provider.addItemRecipe(output, "steam_machines", "has_wrench", provider.hasSafeItem(AntimatterDefaultTools.WRENCH.getTag()), (ItemLike)Machines.STEAM_SIFTER.getItem(Tier.BRONZE), ImmutableMap.of((Object)Character.valueOf('B'), (Object)bronzePipe, (Object)Character.valueOf('H'), (Object)((Object)hullBronze), (Object)Character.valueOf('P'), (Object)piston, (Object)Character.valueOf('S'), (Object)GregTechData.WIRE_STEEL.getBlock(PipeSize.VTINY)), new String[]{"SSS", "PHP", "BBB"});
        provider.addItemRecipe(output, "steam_machines", "has_wrench", provider.hasSafeItem(AntimatterDefaultTools.WRENCH.getTag()), (ItemLike)Machines.STEAM_FURNACE.getItem(Tier.BRONZE), ImmutableMap.of((Object)Character.valueOf('B'), (Object)bronzePipe, (Object)Character.valueOf('H'), (Object)((Object)brickedBronzeHull), (Object)Character.valueOf('F'), (Object)Items.f_41962_), new String[]{"BBB", "BHB", "BFB"});
        provider.addItemRecipe(output, "steam_machines", "has_wrench", provider.hasSafeItem(AntimatterDefaultTools.WRENCH.getTag()), (ItemLike)Machines.STEAM_FURNACE.getItem(Tier.STEEL), ImmutableMap.builder().put((Object)Character.valueOf('H'), (Object)brickedSteelHull).put((Object)Character.valueOf('F'), (Object)Items.f_41962_).put((Object)Character.valueOf('P'), (Object)steelPipe).build(), new String[]{"PPP", "PHP", "PFP"});
        provider.addItemRecipe(output, "steam_machines", "has_wrench", provider.hasSafeItem(AntimatterDefaultTools.WRENCH.getTag()), (ItemLike)Machines.STEAM_MACERATOR.getItem(Tier.STEEL), ImmutableMap.of((Object)Character.valueOf('B'), (Object)steelPipe, (Object)Character.valueOf('H'), (Object)((Object)brickedSteelHull), (Object)Character.valueOf('P'), (Object)piston, (Object)Character.valueOf('D'), (Object)diamond), new String[]{"DBD", "BHB", "PBP"});
        provider.addItemRecipe(output, "steam_machines", "has_wrench", provider.hasSafeItem(AntimatterDefaultTools.WRENCH.getTag()), (ItemLike)Machines.STEAM_ALLOY_SMELTER.getItem(Tier.STEEL), ImmutableMap.of((Object)Character.valueOf('B'), (Object)steelPipe, (Object)Character.valueOf('H'), (Object)((Object)brickedSteelHull), (Object)Character.valueOf('F'), (Object)Items.f_41962_), new String[]{"BBB", "FHF", "BBB"});
        provider.addItemRecipe(output, "steam_machines", "has_wrench", provider.hasSafeItem(AntimatterDefaultTools.WRENCH.getTag()), (ItemLike)Machines.STEAM_EXTRACTOR.getItem(Tier.STEEL), ImmutableMap.of((Object)Character.valueOf('B'), (Object)steelPipe, (Object)Character.valueOf('H'), (Object)((Object)hullSteel), (Object)Character.valueOf('P'), (Object)piston, (Object)Character.valueOf('G'), (Object)glass), new String[]{"BBB", "PHG", "BBB"});
        provider.addItemRecipe(output, "steam_machines", "has_wrench", provider.hasSafeItem(AntimatterDefaultTools.WRENCH.getTag()), (ItemLike)Machines.STEAM_COMPRESSOR.getItem(Tier.STEEL), ImmutableMap.of((Object)Character.valueOf('B'), (Object)steelPipe, (Object)Character.valueOf('H'), (Object)((Object)hullSteel), (Object)Character.valueOf('P'), (Object)piston), new String[]{"BBB", "PHP", "BBB"});
        provider.addItemRecipe(output, "steam_machines", "has_wrench", provider.hasSafeItem(AntimatterDefaultTools.WRENCH.getTag()), (ItemLike)Machines.STEAM_FORGE_HAMMER.getItem(Tier.STEEL), ImmutableMap.of((Object)Character.valueOf('B'), (Object)steelPipe, (Object)Character.valueOf('H'), (Object)((Object)hullSteel), (Object)Character.valueOf('P'), (Object)piston, (Object)Character.valueOf('A'), (Object)Items.f_42146_), new String[]{"BPB", "BHB", "BAB"});
        provider.addItemRecipe(output, "steam_machines", "has_wrench", provider.hasSafeItem(AntimatterDefaultTools.WRENCH.getTag()), (ItemLike)Machines.STEAM_SIFTER.getItem(Tier.STEEL), ImmutableMap.of((Object)Character.valueOf('B'), (Object)steelPipe, (Object)Character.valueOf('H'), (Object)((Object)hullSteel), (Object)Character.valueOf('P'), (Object)piston, (Object)Character.valueOf('S'), (Object)GregTechData.WIRE_STEEL.getBlock(PipeSize.VTINY)), new String[]{"SSS", "PHP", "BBB"});
    }
}

