/*
 * Decompiled with CFR 0.152.
 */
package muramasa.gregtech.loader.crafting;

import com.google.common.collect.ImmutableMap;
import io.github.gregtechintergalactical.gtrubber.GTRubberData;
import java.util.Arrays;
import java.util.function.Consumer;
import muramasa.antimatter.AntimatterAPI;
import muramasa.antimatter.data.AntimatterDefaultTools;
import muramasa.antimatter.data.AntimatterMaterialTypes;
import muramasa.antimatter.data.AntimatterMaterials;
import muramasa.antimatter.datagen.providers.AntimatterRecipeProvider;
import muramasa.antimatter.item.ItemBasic;
import muramasa.antimatter.item.ItemCover;
import muramasa.antimatter.machine.Tier;
import muramasa.antimatter.material.Material;
import muramasa.antimatter.material.MaterialItem;
import muramasa.antimatter.pipe.PipeSize;
import muramasa.antimatter.pipe.types.Cable;
import muramasa.antimatter.pipe.types.Wire;
import muramasa.antimatter.recipe.ingredient.RecipeIngredient;
import muramasa.gregtech.GregTech;
import muramasa.gregtech.data.GregTechData;
import muramasa.gregtech.data.GregTechTags;
import muramasa.gregtech.data.Materials;
import muramasa.gregtech.data.TierMaps;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class Parts {
    public static void loadRecipes(Consumer<FinishedRecipe> output, AntimatterRecipeProvider provider) {
        Parts.tieredItems(output, provider);
        Parts.circuits(output, provider);
        Parts.molds(output, provider);
        provider.shapeless(output, "fire_clay_dust", "parts", "has_clay_dust", provider.hasSafeItem(AntimatterMaterialTypes.DUST.getMaterialTag(Materials.Clay)), AntimatterMaterialTypes.DUST.get(Materials.Fireclay, 2), new Object[]{AntimatterMaterialTypes.DUST.getMaterialTag(Materials.Brick), AntimatterMaterialTypes.DUST.getMaterialTag(Materials.Clay)});
        provider.addStackRecipe(output, "gti", "drain_expensive", "parts", "has_battery", provider.hasSafeItem((ItemLike)Items.f_42025_), new ItemStack((ItemLike)GregTech.get(ItemCover.class, "drain"), 1), ImmutableMap.of((Object)Character.valueOf('A'), GregTechTags.PLATES_IRON_ALUMINIUM, (Object)Character.valueOf('B'), (Object)Items.f_42025_), new String[]{"ABA", "B B", "ABA"});
        provider.shapeless(output, "int_circuit", "gtparts", "has_wrench", provider.hasSafeItem(AntimatterDefaultTools.WRENCH.getTag()), ((RecipeIngredient)TierMaps.INT_CIRCUITS.get((Object)0)).m_43908_()[0], new Object[]{GregTechTags.CIRCUITS_BASIC});
        Ingredient ing = (Ingredient)TierMaps.INT_CIRCUITS.get((Object)0);
        provider.shapeless(output, "int_circuit_to_circuit", "gtparts", "has_wrench", provider.hasSafeItem(AntimatterDefaultTools.WRENCH.getTag()), GregTechData.CircuitBasicElectronic.m_7968_(), new Object[]{ing});
        provider.shapeless(output, "gti", "", "carbon", "has_carbon_fibre", provider.hasSafeItem(GregTechData.CarbonFibre), AntimatterMaterialTypes.DUST.get(Materials.FiberReinforcedEpoxyResin, 1), new Object[]{GregTechData.CarbonFibre, AntimatterMaterialTypes.DUST.getMaterialTag(Materials.EpoxyResin)});
        provider.shapeless(output, "gti", "", "carbon", "has_carbon_fibre", provider.hasSafeItem(GregTechData.CarbonFibre), new ItemStack(GregTechData.CarbonMesh), new Object[]{GregTechData.CarbonFibre, GregTechData.CarbonFibre});
        provider.addItemRecipe(output, "gti", "", "carbon", "has_coal", provider.hasSafeItem(AntimatterMaterialTypes.DUST.getMaterialTag(AntimatterMaterials.Coal)), GregTechData.CoalBall, ImmutableMap.of((Object)Character.valueOf('F'), (Object)Items.f_42484_, (Object)Character.valueOf('C'), (Object)AntimatterMaterialTypes.DUST.getMaterialTag(AntimatterMaterials.Coal)), new String[]{"CCC", "CFC", "CCC"});
        provider.addItemRecipe(output, "gti", "", "carbon", "has_coal", provider.hasSafeItem(AntimatterMaterialTypes.DUST.getMaterialTag(AntimatterMaterials.Coal)), GregTechData.CoalChunk, ImmutableMap.of((Object)Character.valueOf('F'), (Object)Items.f_41999_, (Object)Character.valueOf('C'), GregTechData.CompressedCoalBall), new String[]{"CCC", "CFC", "CCC"});
        provider.addItemRecipe(output, "gti", "", "batteries", "has_wrench", provider.hasSafeItem(AntimatterDefaultTools.WRENCH.getTag()), GregTechData.BatteryHullSmall, ImmutableMap.of((Object)Character.valueOf('P'), (Object)AntimatterMaterialTypes.PLATE.get(Materials.BatteryAlloy), (Object)Character.valueOf('C'), (Object)TierMaps.CABLE_GETTER.apply((Object)PipeSize.VTINY, (Object)Tier.LV, (Object)false)), new String[]{"C", "P", "P"});
        provider.addItemRecipe(output, "gti", "", "batteries", "has_wrench", provider.hasSafeItem(AntimatterDefaultTools.WRENCH.getTag()), GregTechData.BatteryHullMedium, ImmutableMap.of((Object)Character.valueOf('P'), (Object)AntimatterMaterialTypes.PLATE.get(Materials.BatteryAlloy), (Object)Character.valueOf('C'), (Object)TierMaps.CABLE_GETTER.apply((Object)PipeSize.VTINY, (Object)Tier.MV, (Object)false)), new String[]{"C C", "PPP", "PPP"});
        provider.addStackRecipe(output, "gti", "", "batteries", "has_ruby_dust", provider.hasSafeItem(AntimatterMaterialTypes.DUST.getMaterialTag(Materials.Ruby)), AntimatterMaterialTypes.DUST.get(Materials.Energium, 9), ImmutableMap.of((Object)Character.valueOf('R'), (Object)AntimatterMaterialTypes.DUST.getMaterialTag(AntimatterMaterials.Redstone), (Object)Character.valueOf('r'), (Object)AntimatterMaterialTypes.DUST.getMaterialTag(Materials.Ruby)), new String[]{"RrR", "rRr", "RrR"});
        provider.addItemRecipe(output, "gti", "diamondsaw_blade", "gtparts", "has_wrench", provider.hasSafeItem(AntimatterDefaultTools.WRENCH.getTag()), GregTechData.DiamondSawBlade, ImmutableMap.of((Object)Character.valueOf('G'), (Object)AntimatterMaterialTypes.GEAR.get(Materials.CobaltBrass), (Object)Character.valueOf('D'), (Object)AntimatterMaterialTypes.DUST_SMALL.get(AntimatterMaterials.Diamond)), new String[]{" D ", "DGD", " D "});
        provider.addItemRecipe(output, "board_basic", "has_wrench", provider.hasSafeItem(AntimatterDefaultTools.WRENCH.getTag()), GregTechData.CircuitBoardCoated, ImmutableMap.builder().put((Object)Character.valueOf('R'), (Object)GTRubberData.StickyResin).put((Object)Character.valueOf('P'), (Object)AntimatterMaterialTypes.PLATE.get(AntimatterMaterials.Wood)).build(), new String[]{" R ", "PPP", " R "});
    }

    private static void tieredItems(Consumer<FinishedRecipe> output, AntimatterRecipeProvider provider) {
        Arrays.stream(Tier.getStandard()).forEach(t -> {
            Material magnet = t == Tier.ULV || t == Tier.LV ? Materials.IronMagnetic : (t == Tier.EV || t == Tier.IV ? Materials.NeodymiumMagnetic : Materials.SteelMagnetic);
            Object cable = TierMaps.CABLE_GETTER.apply((Object)PipeSize.VTINY, t, (Object)false);
            Material mat = (Material)TierMaps.TIER_MATERIALS.get(t);
            Item smallGear = AntimatterMaterialTypes.GEAR.get(mat);
            TagKey plate = AntimatterMaterialTypes.PLATE.getMaterialTag(mat);
            TagKey rod = AntimatterMaterialTypes.ROD.getMaterialTag(mat);
            TagKey circuit = (TagKey)TierMaps.TIER_CIRCUITS.getOrDefault(t, GregTechTags.CIRCUITS_BASIC);
            Item motor = (Item)GregTech.get(ItemBasic.class, "motor_" + t.getId());
            Item piston = (Item)GregTech.get(ItemBasic.class, "piston_" + t.getId());
            Item robotArm = (Item)GregTech.get(ItemBasic.class, "robot_arm_" + t.getId());
            Item emitter = (Item)GregTech.get(ItemBasic.class, "emitter_" + t.getId());
            Item sensor = (Item)GregTech.get(ItemBasic.class, "sensor_" + t.getId());
            Item pump = (Item)GregTech.get(ItemCover.class, "pump_" + t.getId());
            Item conveyor = (Item)GregTech.get(ItemCover.class, "conveyor_" + t.getId());
            TagKey emitterRod = AntimatterMaterialTypes.ROD.getMaterialTag((Material)TierMaps.EMITTER_RODS.get(t));
            Object emitterGem = TierMaps.EMITTER_GEMS.get(t);
            provider.addItemRecipe(output, "gtparts", "has_wrench", provider.hasSafeItem(AntimatterDefaultTools.WRENCH.getTag()), (ItemLike)motor, ImmutableMap.of((Object)Character.valueOf('M'), (Object)AntimatterMaterialTypes.ROD.get(magnet), (Object)Character.valueOf('C'), (Object)cable, (Object)Character.valueOf('W'), (Object)GregTechData.WIRE_COPPER.getBlockItem(Parts.fromTier(t)), (Object)Character.valueOf('R'), (Object)rod), new String[]{"CWR", "WMW", "RWC"});
            provider.addItemRecipe(output, "gtparts", "has_wrench", provider.hasSafeItem(AntimatterDefaultTools.WRENCH.getTag()), (ItemLike)piston, ImmutableMap.of((Object)Character.valueOf('M'), (Object)motor, (Object)Character.valueOf('C'), (Object)cable, (Object)Character.valueOf('G'), (Object)smallGear, (Object)Character.valueOf('P'), (Object)plate, (Object)Character.valueOf('R'), (Object)rod), new String[]{"PPP", "CRR", "CMG"});
            provider.addItemRecipe(output, "gtparts", "has_wrench", provider.hasSafeItem(AntimatterDefaultTools.WRENCH.getTag()), (ItemLike)conveyor, ImmutableMap.of((Object)Character.valueOf('M'), (Object)motor, (Object)Character.valueOf('C'), (Object)cable, (Object)Character.valueOf('P'), (Object)AntimatterMaterialTypes.PLATE.get(Materials.Rubber)), new String[]{"PPP", "MCM", "PPP"});
            provider.addItemRecipe(output, "gtparts", "has_wrench", provider.hasSafeItem(AntimatterDefaultTools.WRENCH.getTag()), (ItemLike)robotArm, ImmutableMap.of((Object)Character.valueOf('M'), (Object)motor, (Object)Character.valueOf('C'), (Object)cable, (Object)Character.valueOf('P'), (Object)piston, (Object)Character.valueOf('I'), (Object)circuit, (Object)Character.valueOf('R'), (Object)rod), new String[]{"CCC", "MRM", "PIR"});
            provider.addItemRecipe(output, "gtparts", "has_wrench", provider.hasSafeItem(circuit), (ItemLike)emitter, ImmutableMap.of((Object)Character.valueOf('R'), (Object)emitterRod, (Object)Character.valueOf('G'), (Object)emitterGem, (Object)Character.valueOf('L'), (Object)cable, (Object)Character.valueOf('C'), (Object)circuit), new String[]{"RRC", "LGR", "CLR"});
            provider.addItemRecipe(output, "gtparts", "has_wrench", provider.hasSafeItem(circuit), (ItemLike)sensor, ImmutableMap.of((Object)Character.valueOf('R'), (Object)emitterRod, (Object)Character.valueOf('G'), (Object)emitterGem, (Object)Character.valueOf('C'), (Object)circuit, (Object)Character.valueOf('P'), (Object)plate), new String[]{"P G", "PR ", "CPP"});
            Material rotorMat = ((MaterialItem)TierMaps.TIER_ROTORS.get(t)).getMaterial();
            provider.addItemRecipe(output, "gtparts", "has_wrench", provider.hasSafeItem(AntimatterDefaultTools.WRENCH.getTag()), (ItemLike)pump, ImmutableMap.builder().put((Object)Character.valueOf('M'), (Object)motor).put((Object)Character.valueOf('C'), cable).put((Object)Character.valueOf('W'), (Object)AntimatterDefaultTools.WRENCH.getTag()).put((Object)Character.valueOf('S'), (Object)AntimatterDefaultTools.SCREWDRIVER.getTag()).put((Object)Character.valueOf('R'), (Object)AntimatterMaterialTypes.SCREW.get(rotorMat)).put((Object)Character.valueOf('T'), TierMaps.TIER_ROTORS.get(t)).put((Object)Character.valueOf('O'), (Object)AntimatterMaterialTypes.RING.get(Materials.Rubber)).put((Object)Character.valueOf('P'), TierMaps.TIER_PIPES.get(t)).build(), new String[]{"RTO", "SPW", "OMC"});
        });
    }

    private static void molds(Consumer<FinishedRecipe> output, AntimatterRecipeProvider provider) {
        provider.addItemRecipe(output, "gti", "empty_shape", "gtparts", "has_wrench", provider.hasSafeItem(AntimatterDefaultTools.WRENCH.getTag()), GregTechData.EmptyShape, ImmutableMap.of((Object)Character.valueOf('P'), (Object)AntimatterMaterialTypes.PLATE.get(Materials.Steel), (Object)Character.valueOf('H'), (Object)AntimatterDefaultTools.HAMMER.getTag()), new String[]{"PPH", "PP "});
        provider.addItemRecipe(output, "gti", "", "gtparts", "has_wrench", provider.hasSafeItem(AntimatterDefaultTools.WRENCH.getTag()), GregTechData.MoldPlate, ImmutableMap.of((Object)Character.valueOf('P'), GregTechData.EmptyShape, (Object)Character.valueOf('H'), (Object)AntimatterDefaultTools.HAMMER.getTag()), new String[]{"H", "P"});
        provider.addItemRecipe(output, "gti", "", "gtparts", "has_wrench", provider.hasSafeItem(AntimatterDefaultTools.WRENCH.getTag()), GregTechData.MoldIngot, ImmutableMap.of((Object)Character.valueOf('P'), GregTechData.EmptyShape, (Object)Character.valueOf('H'), (Object)AntimatterDefaultTools.HAMMER.getTag()), new String[]{"P", "H"});
        provider.addItemRecipe(output, "gti", "", "gtparts", "has_wrench", provider.hasSafeItem(AntimatterDefaultTools.WRENCH.getTag()), GregTechData.MoldCasing, ImmutableMap.of((Object)Character.valueOf('P'), GregTechData.EmptyShape, (Object)Character.valueOf('H'), (Object)AntimatterDefaultTools.HAMMER.getTag()), new String[]{" H", "P "});
        provider.addItemRecipe(output, "gti", "", "gtparts", "has_wrench", provider.hasSafeItem(AntimatterDefaultTools.WRENCH.getTag()), GregTechData.MoldGear, ImmutableMap.of((Object)Character.valueOf('P'), GregTechData.EmptyShape, (Object)Character.valueOf('H'), (Object)AntimatterDefaultTools.HAMMER.getTag()), new String[]{"PH"});
    }

    private static void bloodyCircuits(Consumer<FinishedRecipe> output, AntimatterRecipeProvider provider) {
        provider.addItemRecipe(output, "circuit_basic", "has_wrench", provider.hasSafeItem(AntimatterDefaultTools.WRENCH.getTag()), GregTechData.CircuitBasic, ImmutableMap.builder().put((Object)Character.valueOf('V'), GregTechData.VacuumTube).put((Object)Character.valueOf('B'), GregTechData.CircuitBoardCoated).put((Object)Character.valueOf('W'), (Object)((Cable)AntimatterAPI.getOrThrow(Cable.class, (String)("cable_" + Materials.RedAlloy.getId()), () -> new RuntimeException("Missing red alloy cable"))).getBlockItem(PipeSize.VTINY)).put((Object)Character.valueOf('C'), (Object)((Cable)AntimatterAPI.getOrThrow(Cable.class, (String)("cable_" + Materials.Tin.getId()), () -> new RuntimeException("Missing tin cable"))).getBlockItem(PipeSize.VTINY)).put((Object)Character.valueOf('R'), GregTechData.Resistor).put((Object)Character.valueOf('P'), (Object)AntimatterMaterialTypes.PLATE.get(Materials.Steel)).build(), new String[]{"RPR", "VBV", "CWC"});
        provider.addItemRecipe(output, "vac_tube", "has_wrench", provider.hasSafeItem(AntimatterDefaultTools.WRENCH.getTag()), GregTechData.VacuumTube, ImmutableMap.builder().put((Object)Character.valueOf('G'), (Object)Items.f_41904_).put((Object)Character.valueOf('P'), (Object)Items.f_42516_).put((Object)Character.valueOf('W'), (Object)((Wire)AntimatterAPI.getOrThrow(Wire.class, (String)("wire_" + AntimatterMaterials.Copper.getId()), () -> new RuntimeException("Missing copper wire"))).getBlockItem(PipeSize.VTINY)).build(), new String[]{"   ", "PGP", "WWW"});
        provider.addItemRecipe(output, "resistor", "has_wrench", provider.hasSafeItem(AntimatterDefaultTools.WRENCH.getTag()), GregTechData.Resistor, ImmutableMap.builder().put((Object)Character.valueOf('C'), (Object)AntimatterMaterialTypes.DUST.get(AntimatterMaterials.Coal)).put((Object)Character.valueOf('P'), (Object)Items.f_42516_).put((Object)Character.valueOf('W'), (Object)((Wire)AntimatterAPI.getOrThrow(Wire.class, (String)("wire_" + AntimatterMaterials.Copper.getId()), () -> new RuntimeException("Missing copper wire"))).getBlockItem(PipeSize.VTINY)).build(), new String[]{" P ", "WCW", " P "});
    }

    private static void circuits(Consumer<FinishedRecipe> output, AntimatterRecipeProvider provider) {
        provider.addItemRecipe(output, "gti", "circuit_basic_copper_h", "circuits", "has_copper_cable", provider.hasSafeItem((TagKey)TierMaps.CABLE_GETTER.apply((Object)PipeSize.VTINY, (Object)Tier.MV, (Object)false)), GregTechData.CircuitBasicElectronic, ImmutableMap.builder().put((Object)Character.valueOf('C'), TierMaps.CABLE_GETTER.apply((Object)PipeSize.VTINY, (Object)Tier.MV, (Object)false)).put((Object)Character.valueOf('N'), GregTechData.NandChip).put((Object)Character.valueOf('S'), GregTechData.CircuitBoardCoated).build(), new String[]{"CCC", "NSN", "CCC"});
        provider.addItemRecipe(output, "gti", "circuit_basic_copper_v", "circuits", "has_copper_cable", provider.hasSafeItem((TagKey)TierMaps.CABLE_GETTER.apply((Object)PipeSize.VTINY, (Object)Tier.MV, (Object)false)), GregTechData.CircuitBasicElectronic, ImmutableMap.builder().put((Object)Character.valueOf('C'), TierMaps.CABLE_GETTER.apply((Object)PipeSize.VTINY, (Object)Tier.MV, (Object)false)).put((Object)Character.valueOf('N'), GregTechData.NandChip).put((Object)Character.valueOf('S'), GregTechData.CircuitBoardCoated).build(), new String[]{"CNC", "CSC", "CNC"});
        provider.addItemRecipe(output, "gti", "circuit_basic_red_alloy_h", "circuits", "has_red_alloy_cable", provider.hasSafeItem((ItemLike)GregTechData.CABLE_RED_ALLOY.getBlockItem(PipeSize.VTINY)), GregTechData.CircuitBasicElectronic, ImmutableMap.builder().put((Object)Character.valueOf('C'), (Object)GregTechData.CABLE_RED_ALLOY.getBlockItem(PipeSize.VTINY)).put((Object)Character.valueOf('N'), GregTechData.NandChip).put((Object)Character.valueOf('S'), GregTechData.CircuitBoardCoated).build(), new String[]{"CCC", "NSN", "CCC"});
        provider.addItemRecipe(output, "gti", "circuit_basic_red_alloy_v", "circuits", "has_red_alloy_cable", provider.hasSafeItem((ItemLike)GregTechData.CABLE_RED_ALLOY.getBlockItem(PipeSize.VTINY)), GregTechData.CircuitBasicElectronic, ImmutableMap.builder().put((Object)Character.valueOf('C'), (Object)GregTechData.CABLE_RED_ALLOY.getBlockItem(PipeSize.VTINY)).put((Object)Character.valueOf('N'), GregTechData.NandChip).put((Object)Character.valueOf('S'), GregTechData.CircuitBoardCoated).build(), new String[]{"CNC", "CSC", "CNC"});
        provider.addItemRecipe(output, "gti", "", "circuits", "has_item_casing", provider.hasSafeItem(AntimatterMaterialTypes.ITEM_CASING.getMaterialTag(Materials.Steel)), GregTechData.NandChip, ImmutableMap.of((Object)Character.valueOf('C'), (Object)AntimatterMaterialTypes.ITEM_CASING.getMaterialTag(Materials.Steel), (Object)Character.valueOf('R'), (Object)GregTechData.WIRE_RED_ALLOY.getBlockItem(PipeSize.VTINY), (Object)Character.valueOf('T'), (Object)TierMaps.WIRE_GETTER.apply(PipeSize.VTINY, Tier.LV)), new String[]{"CR", "RT"});
        provider.addItemRecipe(output, "gti", "lapotron_crystal_upgrade", "energy_orbs", "has_circuit", provider.hasSafeItem(GregTechTags.CIRCUITS_ADVANCED), GregTechData.LapotronCrystal, ImmutableMap.of((Object)Character.valueOf('C'), GregTechTags.CIRCUITS_ADVANCED, (Object)Character.valueOf('L'), GregTechTags.DUST_LAPIS_LAZURITE, (Object)Character.valueOf('E'), GregTechData.EnergyCrystal), new String[]{"LCL", "LEL", "LCL"});
        provider.addItemRecipe(output, "gti", "", "energy_orbs", "has_circuit", provider.hasSafeItem(GregTechTags.CIRCUITS_ADVANCED), GregTechData.LapotronCrystal, ImmutableMap.of((Object)Character.valueOf('C'), GregTechTags.CIRCUITS_ADVANCED, (Object)Character.valueOf('L'), GregTechTags.DUST_LAPIS_LAZURITE, (Object)Character.valueOf('S'), (Object)AntimatterMaterialTypes.GEM.getMaterialTag(Materials.Sapphire)), new String[]{"LCL", "LSL", "LCL"});
    }

    static PipeSize fromTier(Tier tier) {
        if (tier == Tier.LV) {
            return PipeSize.VTINY;
        }
        if (tier == Tier.MV) {
            return PipeSize.TINY;
        }
        if (tier == Tier.HV) {
            return PipeSize.SMALL;
        }
        if (tier == Tier.IV) {
            return PipeSize.HUGE;
        }
        return PipeSize.NORMAL;
    }
}

