/*
 * Decompiled with CFR 0.152.
 */
package muramasa.gregtech.loader.crafting;

import com.google.common.collect.ImmutableMap;
import io.github.gregtechintergalactical.gtutility.machine.WorkbenchMachine;
import java.util.Arrays;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import muramasa.antimatter.AntimatterAPI;
import muramasa.antimatter.data.AntimatterDefaultTools;
import muramasa.antimatter.data.AntimatterMaterialTypes;
import muramasa.antimatter.data.AntimatterMaterials;
import muramasa.antimatter.data.ForgeCTags;
import muramasa.antimatter.datagen.providers.AntimatterRecipeProvider;
import muramasa.antimatter.item.ItemBasic;
import muramasa.antimatter.item.ItemCover;
import muramasa.antimatter.machine.Tier;
import muramasa.antimatter.machine.types.BasicMachine;
import muramasa.antimatter.machine.types.GeneratorMachine;
import muramasa.antimatter.machine.types.Machine;
import muramasa.antimatter.machine.types.MultiMachine;
import muramasa.antimatter.material.Material;
import muramasa.antimatter.pipe.PipeItemBlock;
import muramasa.antimatter.pipe.PipeSize;
import muramasa.antimatter.pipe.types.Wire;
import muramasa.gregtech.GregTech;
import muramasa.gregtech.block.BlockCasing;
import muramasa.gregtech.data.GregTechData;
import muramasa.gregtech.data.GregTechTags;
import muramasa.gregtech.data.Materials;
import muramasa.gregtech.data.TierMaps;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class Machines {
    public static void loadRecipes(Consumer<FinishedRecipe> output, AntimatterRecipeProvider provider) {
        Arrays.stream(Tier.getAllElectric()).forEach(tier -> {
            BlockCasing firebox;
            Item motor = (Item)GregTech.get(ItemBasic.class, "motor_" + tier.getId());
            if (motor == null) {
                return;
            }
            Item piston = (Item)GregTech.get(ItemBasic.class, "piston_" + tier.getId());
            if (piston == null) {
                return;
            }
            Item arm = (Item)GregTech.get(ItemBasic.class, "robot_arm_" + tier.getId());
            if (arm == null) {
                return;
            }
            Item conveyor = (Item)GregTech.get(ItemCover.class, "conveyor_" + tier.getId());
            if (conveyor == null) {
                return;
            }
            Item pump = (Item)GregTech.get(ItemCover.class, "pump_" + tier.getId());
            if (pump == null) {
                return;
            }
            Item hull = (Item)Item.f_41373_.get((Object)GregTech.get(BlockCasing.class, "hull_" + tier.getId()));
            if (hull == null) {
                return;
            }
            Item sensor = (Item)GregTech.get(ItemBasic.class, "sensor_" + tier.getId());
            if (sensor == null) {
                return;
            }
            Item emitter = (Item)GregTech.get(ItemBasic.class, "emitter_" + tier.getId());
            if (emitter == null) {
                return;
            }
            Item field = (Item)GregTech.get(ItemBasic.class, "field_gen_" + tier.getId());
            if (field == null) {
                return;
            }
            TagKey<Item> circuit = (TagKey<Item>)TierMaps.TIER_CIRCUITS.getOrDefault(tier, GregTechTags.CIRCUITS_BASIC);
            if (circuit == null) {
                return;
            }
            Object cable = TierMaps.CABLE_GETTER.apply((Object)PipeSize.VTINY, tier, (Object)true);
            if (cable == null) {
                return;
            }
            Item rotor = (Item)TierMaps.TIER_ROTORS.get(tier);
            if (rotor == null) {
                return;
            }
            Item glass = Items.f_41904_;
            Item diamond = Items.f_42415_;
            Material material = (Material)TierMaps.TIER_MATERIALS.getOrDefault(tier, (Object)Material.NULL);
            Machines.add(muramasa.gregtech.data.Machines.MACERATOR, tier, (arg_0, arg_1) -> Machines.lambda$loadRecipes$0(provider, output, motor, piston, (TagKey)circuit, cable, hull, arg_0, arg_1));
            Machines.add(muramasa.gregtech.data.Machines.ALLOY_SMELTER, tier, (arg_0, arg_1) -> Machines.lambda$loadRecipes$1(provider, output, motor, tier, hull, (TagKey)circuit, cable, arg_0, arg_1));
            Machines.add(muramasa.gregtech.data.Machines.COMPRESSOR, tier, (arg_0, arg_1) -> Machines.lambda$loadRecipes$2(provider, output, motor, (TagKey)circuit, piston, cable, hull, arg_0, arg_1));
            Machines.add(muramasa.gregtech.data.Machines.CUTTER, tier, (arg_0, arg_1) -> Machines.lambda$loadRecipes$3(provider, output, motor, (TagKey)circuit, cable, hull, conveyor, glass, arg_0, arg_1));
            Machines.add(muramasa.gregtech.data.Machines.FURNACE, tier, (arg_0, arg_1) -> Machines.lambda$loadRecipes$4(provider, output, motor, (TagKey)circuit, cable, hull, tier, arg_0, arg_1));
            Machines.add(muramasa.gregtech.data.Machines.EXTRACTOR, tier, (arg_0, arg_1) -> Machines.lambda$loadRecipes$5(provider, output, motor, piston, pump, glass, (TagKey)circuit, cable, hull, arg_0, arg_1));
            Machines.add(muramasa.gregtech.data.Machines.EXTRUDER, tier, (arg_0, arg_1) -> Machines.lambda$loadRecipes$6(provider, output, motor, piston, tier, (TagKey)circuit, hull, arg_0, arg_1));
            Machines.add(muramasa.gregtech.data.Machines.LATHE, tier, (arg_0, arg_1) -> Machines.lambda$loadRecipes$7(provider, output, motor, piston, (TagKey)circuit, cable, hull, diamond, arg_0, arg_1));
            Wire<?> electroWire = tier == Tier.LV ? GregTechData.WIRE_GOLD : (tier == Tier.MV ? GregTechData.WIRE_SILVER : (tier == Tier.HV ? GregTechData.WIRE_ELECTRUM : (tier == Tier.EV ? GregTechData.WIRE_PLATINUM : GregTechData.WIRE_OSMIUM)));
            Machines.add(muramasa.gregtech.data.Machines.ELECTROLYZER, tier, (arg_0, arg_1) -> Machines.lambda$loadRecipes$8(provider, output, motor, (TagKey)circuit, electroWire, cable, hull, glass, arg_0, arg_1));
            Machines.add(muramasa.gregtech.data.Machines.ARC_FURNACE, tier, (arg_0, arg_1) -> Machines.lambda$loadRecipes$9(provider, output, motor, (TagKey)circuit, tier, material, hull, arg_0, arg_1));
            Machines.add(muramasa.gregtech.data.Machines.PLASMA_ARC_FURNACE, tier, (arg_0, arg_1) -> Machines.lambda$loadRecipes$10(provider, output, motor, (TagKey)circuit, tier, material, hull, pump, arg_0, arg_1));
            Machines.add(muramasa.gregtech.data.Machines.CHEMICAL_BATH, tier, (arg_0, arg_1) -> Machines.lambda$loadRecipes$11(provider, output, motor, (TagKey)circuit, conveyor, pump, cable, hull, glass, arg_0, arg_1));
            Machines.add(muramasa.gregtech.data.Machines.SIFTER, tier, (arg_0, arg_1) -> Machines.lambda$loadRecipes$12(provider, output, motor, (TagKey)circuit, piston, cable, hull, arg_0, arg_1));
            PipeItemBlock esWire = tier == Tier.LV ? GregTechData.WIRE_TIN.getBlockItem(PipeSize.TINY) : (tier == Tier.MV ? GregTechData.WIRE_COPPER.getBlockItem(PipeSize.TINY) : (tier == Tier.HV ? GregTechData.WIRE_COPPER.getBlockItem(PipeSize.SMALL) : GregTechData.WIRE_ANNEALED_COPPER.getBlockItem(PipeSize.NORMAL)));
            Machines.add(muramasa.gregtech.data.Machines.ELECTROMAGNETIC_SEPARATOR, tier, (arg_0, arg_1) -> Machines.lambda$loadRecipes$13(provider, output, conveyor, cable, (Item)esWire, hull, material, (TagKey)circuit, arg_0, arg_1));
            Machines.add(muramasa.gregtech.data.Machines.BENDER, tier, (arg_0, arg_1) -> Machines.lambda$loadRecipes$14(provider, output, motor, piston, (TagKey)circuit, cable, hull, arg_0, arg_1));
            Machines.add(muramasa.gregtech.data.Machines.WIRE_MILL, tier, (arg_0, arg_1) -> Machines.lambda$loadRecipes$15(provider, output, motor, (TagKey)circuit, cable, hull, arg_0, arg_1));
            Machines.add(muramasa.gregtech.data.Machines.ASSEMBLER, tier, (arg_0, arg_1) -> Machines.lambda$loadRecipes$16(provider, output, motor, arm, conveyor, (TagKey)circuit, cable, hull, arg_0, arg_1));
            Machines.add(muramasa.gregtech.data.Machines.CENTRIFUGE, tier, (arg_0, arg_1) -> Machines.lambda$loadRecipes$17(provider, output, motor, (TagKey)circuit, cable, hull, arg_0, arg_1));
            Machines.add(muramasa.gregtech.data.Machines.MIXER, tier, (arg_0, arg_1) -> Machines.lambda$loadRecipes$18(provider, output, motor, rotor, glass, (TagKey)circuit, hull, arg_0, arg_1));
            Machines.add(muramasa.gregtech.data.Machines.STEAM_GENERATOR, tier, (arg_0, arg_1) -> Machines.lambda$loadRecipes$19(provider, output, motor, cable, hull, rotor, (TagKey)circuit, tier, arg_0, arg_1));
            Machines.add(muramasa.gregtech.data.Machines.COMBUSTION_GENERATOR, tier, (arg_0, arg_1) -> Machines.lambda$loadRecipes$20(provider, output, motor, cable, hull, material, (TagKey)circuit, piston, arg_0, arg_1));
            Machines.add(muramasa.gregtech.data.Machines.GAS_GENERATOR, tier, (arg_0, arg_1) -> Machines.lambda$loadRecipes$21(provider, output, motor, cable, hull, rotor, (TagKey)circuit, arg_0, arg_1));
            Machines.add(muramasa.gregtech.data.Machines.BLAST_FURNACE, tier, (arg_0, arg_1) -> Machines.lambda$loadRecipes$22(provider, output, motor, cable, (TagKey)circuit, arg_0, arg_1));
            BlockCasing blockCasing = tier == Tier.LV ? GregTechData.CASING_FIREBOX_BRONZE : (tier == Tier.MV ? GregTechData.CASING_FIREBOX_STEEL : (firebox = tier == Tier.HV ? GregTechData.CASING_FIREBOX_TITANIUM : GregTechData.CASING_FIREBOX_TUNGSTENSTEEL));
            TagKey<Item> circuit2 = tier == Tier.LV ? circuit : (tier == Tier.MV ? GregTechTags.CIRCUITS_ADVANCED : (tier == Tier.HV ? GregTechTags.CIRCUITS_ELITE : GregTechTags.CIRCUITS_MASTER));
            Machines.add(muramasa.gregtech.data.Machines.LARGE_BOILER, tier, (arg_0, arg_1) -> Machines.lambda$loadRecipes$23(provider, output, circuit, cable, (Block)firebox, circuit2, arg_0, arg_1));
            Machines.add(muramasa.gregtech.data.Machines.COMBUSTION_ENGINE, tier, (m, item) -> provider.addItemRecipe(output, "machines", "has_motor", provider.hasSafeItem((ItemLike)motor), (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('L'), (Object)GregTechData.CABLE_TUNGSTEN_STEEL.getBlockItem(PipeSize.VTINY)).put((Object)Character.valueOf('H'), (Object)hull).put((Object)Character.valueOf('C'), (Object)circuit).put((Object)Character.valueOf('P'), (Object)piston).put((Object)Character.valueOf('G'), (Object)AntimatterMaterialTypes.GEAR.getMaterialTag(material)).put((Object)Character.valueOf('M'), (Object)motor).build(), new String[]{"PCP", "MHM", "GLG"}));
            Machines.add(muramasa.gregtech.data.Machines.VACUUM_FREEZER, tier, (m, item) -> provider.addItemRecipe(output, "machines", "has_motor", provider.hasSafeItem((ItemLike)motor), (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('L'), cable).put((Object)Character.valueOf('F'), (Object)GregTechData.CASING_FROST_PROOF).put((Object)Character.valueOf('C'), (Object)circuit).put((Object)Character.valueOf('P'), (Object)pump).build(), new String[]{"PPP", "CFC", "LCL"}));
            Machines.add(muramasa.gregtech.data.Machines.IMPLOSION_COMPRESSOR, tier, (m, item) -> provider.addItemRecipe(output, "machines", "has_motor", provider.hasSafeItem((ItemLike)motor), (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('L'), cable).put((Object)Character.valueOf('O'), (Object)Items.f_41999_).put((Object)Character.valueOf('C'), (Object)circuit).put((Object)Character.valueOf('S'), (Object)GregTechData.CASING_SOLID_STEEL).build(), new String[]{"OOO", "CSC", "LCL"}));
            Machines.add(muramasa.gregtech.data.Machines.MULTI_SMELTER, tier, (m, item) -> provider.addItemRecipe(output, "machines", "has_motor", provider.hasSafeItem((ItemLike)motor), (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('L'), cable).put((Object)Character.valueOf('F'), (Object)Items.f_41962_).put((Object)Character.valueOf('C'), (Object)circuit).put((Object)Character.valueOf('H'), (Object)GregTechData.CASING_HEAT_PROOF).build(), new String[]{"FFF", "CHC", "LCL"}));
            Machines.add(muramasa.gregtech.data.Machines.HEAT_EXCHANGER, tier, (m, item) -> provider.addItemRecipe(output, "machines", "has_motor", provider.hasSafeItem((ItemLike)motor), (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('P'), (Object)pump).put((Object)Character.valueOf('I'), (Object)GregTechData.FLUID_PIPE_TITANIUM.getBlock(PipeSize.SMALL)).put((Object)Character.valueOf('H'), (Object)GregTechData.CASING_PIPE_TITANIUM).build(), new String[]{"PIP", "IHI", "PIP"}));
            Machines.add(muramasa.gregtech.data.Machines.DISTLLATION_TOWER, tier, (m, item) -> provider.addItemRecipe(output, "machines", "has_motor", provider.hasSafeItem((ItemLike)motor), (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('P'), (Object)pump).put((Object)Character.valueOf('I'), (Object)GregTechData.FLUID_PIPE_STAINLESS_STEEL.getBlock(PipeSize.LARGE)).put((Object)Character.valueOf('H'), (Object)hull).put((Object)Character.valueOf('C'), (Object)circuit).build(), new String[]{"CIC", "PHP", "CIC"}));
            Machines.add(muramasa.gregtech.data.Machines.CRACKING_UNIT, tier, (m, item) -> provider.addItemRecipe(output, "machines", "has_motor", provider.hasSafeItem((ItemLike)motor), (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('P'), (Object)pump).put((Object)Character.valueOf('O'), (Object)GregTechData.COIL_CUPRONICKEL).put((Object)Character.valueOf('H'), (Object)hull).put((Object)Character.valueOf('C'), (Object)circuit).build(), new String[]{"OPO", "CHC", "OPO"}));
            Machines.add(muramasa.gregtech.data.Machines.CANNER, tier, (m, item) -> provider.addItemRecipe(output, "machines", "has_motor", provider.hasSafeItem(GregTechData.MotorLV), (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('L'), cable).put((Object)Character.valueOf('P'), (Object)pump).put((Object)Character.valueOf('C'), (Object)circuit).put((Object)Character.valueOf('H'), (Object)hull).put((Object)Character.valueOf('G'), (Object)glass).build(), new String[]{"LPL", "CHC", "GGG"}));
            Machines.add(muramasa.gregtech.data.Machines.FORGE_HAMMER, tier, (m, item) -> provider.addItemRecipe(output, "machines", "has_motor", provider.hasSafeItem(GregTechData.MotorLV), (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('L'), cable).put((Object)Character.valueOf('P'), (Object)piston).put((Object)Character.valueOf('C'), (Object)circuit).put((Object)Character.valueOf('H'), (Object)hull).put((Object)Character.valueOf('A'), (Object)Items.f_42146_).build(), new String[]{"LPL", "CHC", "LAL"}));
            Machines.add(muramasa.gregtech.data.Machines.FORMING_PRESS, tier, (m, item) -> provider.addItemRecipe(output, "machines", "has_motor", provider.hasSafeItem(GregTechData.MotorLV), (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('L'), cable).put((Object)Character.valueOf('P'), (Object)piston).put((Object)Character.valueOf('C'), (Object)circuit).put((Object)Character.valueOf('H'), (Object)hull).build(), new String[]{"LPL", "CHC", "LPL"}));
            Machines.add(muramasa.gregtech.data.Machines.RECYCLER, tier, (m, item) -> provider.addItemRecipe(output, "machines", "has_motor", provider.hasSafeItem(GregTechData.MotorLV), (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('G'), (Object)Items.f_42525_).put((Object)Character.valueOf('P'), (Object)piston).put((Object)Character.valueOf('C'), (Object)circuit).put((Object)Character.valueOf('H'), (Object)hull).put((Object)Character.valueOf('L'), cable).build(), new String[]{"GCG", "PHP", "LCL"}));
            Machines.add(muramasa.gregtech.data.Machines.SCANNER, tier, (m, item) -> provider.addItemRecipe(output, "machines", "has_motor", provider.hasSafeItem(GregTechData.MotorLV), (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('S'), (Object)sensor).put((Object)Character.valueOf('E'), (Object)emitter).put((Object)Character.valueOf('C'), (Object)circuit).put((Object)Character.valueOf('H'), (Object)hull).put((Object)Character.valueOf('L'), TierMaps.CABLE_GETTER.apply((Object)PipeSize.VTINY, tier, (Object)false)).build(), new String[]{"CEC", "LHL", "CSC"}));
            Machines.add(muramasa.gregtech.data.Machines.THERMAL_CENTRIFUGE, tier, (m, item) -> provider.addItemRecipe(output, "machines", "has_motor", provider.hasSafeItem(GregTechData.MotorLV), (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('M'), (Object)motor).put((Object)Character.valueOf('C'), (Object)circuit).put((Object)Character.valueOf('H'), (Object)hull).put((Object)Character.valueOf('W'), TierMaps.WIRE_GETTER.apply(tier == Tier.IV ? PipeSize.HUGE : PipeSize.SMALL, (Tier)tier)).put((Object)Character.valueOf('L'), cable).build(), new String[]{"CMC", "WHW", "LML"}));
            Machines.add(muramasa.gregtech.data.Machines.ORE_WASHER, tier, (m, item) -> provider.addItemRecipe(output, "machines", "has_motor", provider.hasSafeItem(GregTechData.MotorLV), (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('M'), (Object)motor).put((Object)Character.valueOf('G'), (Object)glass).put((Object)Character.valueOf('C'), (Object)circuit).put((Object)Character.valueOf('H'), (Object)hull).put((Object)Character.valueOf('R'), (Object)rotor).put((Object)Character.valueOf('L'), cable).build(), new String[]{"RGR", "CMC", "LHL"}));
            Machines.add(muramasa.gregtech.data.Machines.CHEMICAL_REACTOR, tier, (m, item) -> provider.addItemRecipe(output, "machines", "has_motor", provider.hasSafeItem(GregTechData.MotorLV), (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('M'), (Object)motor).put((Object)Character.valueOf('G'), (Object)glass).put((Object)Character.valueOf('C'), (Object)circuit).put((Object)Character.valueOf('H'), (Object)hull).put((Object)Character.valueOf('R'), (Object)rotor).put((Object)Character.valueOf('L'), cable).build(), new String[]{"GRG", "LML", "CHC"}));
            Machines.add(muramasa.gregtech.data.Machines.FLUID_CANNER, tier, (m, item) -> provider.addItemRecipe(output, "machines", "has_motor", provider.hasSafeItem(GregTechData.MotorLV), (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('P'), (Object)pump).put((Object)Character.valueOf('G'), (Object)glass).put((Object)Character.valueOf('C'), (Object)circuit).put((Object)Character.valueOf('H'), (Object)hull).put((Object)Character.valueOf('L'), cable).build(), new String[]{"GCG", "PHP", "LCL"}));
            Machines.add(muramasa.gregtech.data.Machines.DISASSEMBLER, tier, (m, item) -> provider.addItemRecipe(output, "machines", "has_motor", provider.hasSafeItem(GregTechData.MotorLV), (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('R'), (Object)arm).put((Object)Character.valueOf('C'), (Object)circuit).put((Object)Character.valueOf('H'), (Object)hull).put((Object)Character.valueOf('L'), TierMaps.CABLE_GETTER.apply((Object)PipeSize.VTINY, tier, (Object)false)).build(), new String[]{"RCR", "LHL", "RCR"}));
            Machines.add(muramasa.gregtech.data.Machines.MASS_FABRICATOR, tier, (m, item) -> provider.addItemRecipe(output, "machines", "has_motor", provider.hasSafeItem(GregTechData.MotorLV), (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('F'), (Object)field).put((Object)Character.valueOf('B'), TierMaps.CABLE_GETTER.apply((Object)PipeSize.SMALL, tier, (Object)true)).put((Object)Character.valueOf('C'), (Object)circuit).put((Object)Character.valueOf('H'), (Object)hull).build(), new String[]{"CFC", "BHB", "CFC"}));
            Machines.add(muramasa.gregtech.data.Machines.REPLICATOR, tier, (m, item) -> provider.addItemRecipe(output, "machines", "has_motor", provider.hasSafeItem(GregTechData.MotorLV), (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('F'), (Object)field).put((Object)Character.valueOf('E'), (Object)emitter).put((Object)Character.valueOf('C'), (Object)circuit).put((Object)Character.valueOf('H'), (Object)hull).put((Object)Character.valueOf('B'), TierMaps.CABLE_GETTER.apply((Object)PipeSize.SMALL, tier, (Object)true)).build(), new String[]{"EFE", "CHC", "EBE"}));
            Machines.add(muramasa.gregtech.data.Machines.FERMENTER, tier, (m, item) -> provider.addItemRecipe(output, "machines", "has_motor", provider.hasSafeItem(GregTechData.MotorLV), (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('P'), (Object)pump).put((Object)Character.valueOf('C'), (Object)circuit).put((Object)Character.valueOf('G'), (Object)glass).put((Object)Character.valueOf('H'), (Object)hull).put((Object)Character.valueOf('L'), cable).build(), new String[]{"LPL", "GHG", "LCL"}));
            Machines.add(muramasa.gregtech.data.Machines.FLUID_EXTRACTOR, tier, (m, item) -> provider.addItemRecipe(output, "machines", "has_motor", provider.hasSafeItem(GregTechData.MotorLV), (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('P'), (Object)pump).put((Object)Character.valueOf('C'), (Object)circuit).put((Object)Character.valueOf('G'), (Object)glass).put((Object)Character.valueOf('H'), (Object)hull).put((Object)Character.valueOf('T'), (Object)piston).put((Object)Character.valueOf('L'), cable).build(), new String[]{"GCG", "PHT", "LCL"}));
            Machines.add(muramasa.gregtech.data.Machines.FLUID_SOLIDIFIER, tier, (m, item) -> provider.addItemRecipe(output, "machines", "has_motor", provider.hasSafeItem(GregTechData.MotorLV), (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('P'), (Object)pump).put((Object)Character.valueOf('C'), (Object)circuit).put((Object)Character.valueOf('G'), (Object)glass).put((Object)Character.valueOf('H'), (Object)hull).put((Object)Character.valueOf('E'), (Object)ForgeCTags.CHESTS).put((Object)Character.valueOf('L'), cable).build(), new String[]{"PGP", "LHL", "CEC"}));
            Machines.add(muramasa.gregtech.data.Machines.DISTILLERY, tier, (m, item) -> provider.addItemRecipe(output, "machines", "has_motor", provider.hasSafeItem(GregTechData.MotorLV), (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('P'), (Object)pump).put((Object)Character.valueOf('Z'), (Object)Items.f_42585_).put((Object)Character.valueOf('C'), (Object)circuit).put((Object)Character.valueOf('G'), (Object)glass).put((Object)Character.valueOf('H'), (Object)hull).put((Object)Character.valueOf('L'), cable).build(), new String[]{"GZG", "CHC", "LPL"}));
            Machines.add(muramasa.gregtech.data.Machines.AUTOCLAVE, tier, (m, item) -> provider.addItemRecipe(output, "machines", "has_motor", provider.hasSafeItem((ItemLike)motor), (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('T'), (Object)AntimatterMaterialTypes.PLATE.getMaterialTag(material)).put((Object)Character.valueOf('C'), (Object)circuit).put((Object)Character.valueOf('G'), (Object)glass).put((Object)Character.valueOf('H'), (Object)hull).put((Object)Character.valueOf('P'), (Object)pump).build(), new String[]{"TGT", "THT", "CPC"}));
            Machines.add(muramasa.gregtech.data.Machines.LASER_ENGRAVER, tier, (m, item) -> provider.addItemRecipe(output, "machines", "has_motor", provider.hasSafeItem((ItemLike)motor), (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('P'), (Object)piston).put((Object)Character.valueOf('E'), (Object)emitter).put((Object)Character.valueOf('C'), (Object)circuit).put((Object)Character.valueOf('H'), (Object)hull).put((Object)Character.valueOf('L'), cable).build(), new String[]{"PEP", "CHC", "LCL"}));
            Machines.add(muramasa.gregtech.data.Machines.PACKAGER, tier, (m, item) -> provider.addItemRecipe(output, "machines", "has_motor", provider.hasSafeItem((ItemLike)motor), (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('c'), (Object)conveyor).put((Object)Character.valueOf('R'), (Object)arm).put((Object)Character.valueOf('C'), (Object)circuit).put((Object)Character.valueOf('H'), (Object)hull).put((Object)Character.valueOf('L'), cable).put((Object)Character.valueOf('S'), (Object)ForgeCTags.CHESTS).build(), new String[]{"SCS", "RHc", "LCL"}));
            Machines.add(muramasa.gregtech.data.Machines.BATTERY_BUFFER_ONE, tier, (m, item) -> provider.addItemRecipe(output, "machines", "has_motor", provider.hasSafeItem((ItemLike)motor), (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('C'), (Object)ForgeCTags.CHESTS).put((Object)Character.valueOf('H'), (Object)hull).put((Object)Character.valueOf('L'), (Object)((PipeItemBlock)TierMaps.TIER_WIRES.get(tier)).getPipe().getType().getBlockItem(PipeSize.VTINY)).build(), new String[]{"LCL", "LHL"}));
            Machines.add(muramasa.gregtech.data.Machines.BATTERY_BUFFER_FOUR, tier, (m, item) -> provider.addItemRecipe(output, "machines", "has_motor", provider.hasSafeItem((ItemLike)motor), (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('C'), (Object)ForgeCTags.CHESTS).put((Object)Character.valueOf('H'), (Object)hull).put((Object)Character.valueOf('L'), (Object)((PipeItemBlock)TierMaps.TIER_WIRES.get(tier)).getPipe().getType().getBlockItem(PipeSize.SMALL)).build(), new String[]{"LCL", "LHL"}));
            Machines.add(muramasa.gregtech.data.Machines.BATTERY_BUFFER_EIGHT, tier, (m, item) -> provider.addItemRecipe(output, "machines", "has_motor", provider.hasSafeItem((ItemLike)motor), (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('C'), (Object)ForgeCTags.CHESTS).put((Object)Character.valueOf('H'), (Object)hull).put((Object)Character.valueOf('L'), (Object)((PipeItemBlock)TierMaps.TIER_WIRES.get(tier)).getPipe().getType().getBlockItem(PipeSize.NORMAL)).build(), new String[]{"LCL", "LHL"}));
            Machines.add(muramasa.gregtech.data.Machines.BATTERY_BUFFER_SIXTEEN, tier, (m, item) -> provider.addItemRecipe(output, "machines", "has_motor", provider.hasSafeItem((ItemLike)motor), (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('C'), (Object)ForgeCTags.CHESTS).put((Object)Character.valueOf('H'), (Object)hull).put((Object)Character.valueOf('L'), (Object)((PipeItemBlock)TierMaps.TIER_WIRES.get(tier)).getPipe().getType().getBlockItem(PipeSize.HUGE)).build(), new String[]{"LCL", "LHL"}));
            Machines.add(muramasa.gregtech.data.Machines.HATCH_ITEM_I, tier, (m, item) -> provider.addItemRecipe(output, "machines", "has_motor", provider.hasSafeItem((ItemLike)motor), (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('C'), (Object)ForgeCTags.CHESTS).put((Object)Character.valueOf('H'), (Object)hull).build(), new String[]{"C", "H"}));
            Machines.add(muramasa.gregtech.data.Machines.HATCH_FLUID_I, tier, (m, item) -> provider.addItemRecipe(output, "machines", "has_motor", provider.hasSafeItem((ItemLike)motor), (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('G'), (Object)Items.f_41904_).put((Object)Character.valueOf('H'), (Object)hull).build(), new String[]{"G", "H"}));
            Machines.add(muramasa.gregtech.data.Machines.HATCH_ITEM_O, tier, (m, item) -> provider.addItemRecipe(output, "machines", "has_motor", provider.hasSafeItem((ItemLike)motor), (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('C'), (Object)ForgeCTags.CHESTS).put((Object)Character.valueOf('H'), (Object)hull).build(), new String[]{"H", "C"}));
            Machines.add(muramasa.gregtech.data.Machines.HATCH_FLUID_O, tier, (m, item) -> provider.addItemRecipe(output, "machines", "has_motor", provider.hasSafeItem((ItemLike)motor), (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('G'), (Object)Items.f_41904_).put((Object)Character.valueOf('H'), (Object)hull).build(), new String[]{"H", "G"}));
            Machines.add(muramasa.gregtech.data.Machines.HATCH_ENERGY, tier, (m, item) -> provider.addItemRecipe(output, "machines", "has_motor", provider.hasSafeItem((ItemLike)motor), (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('C'), TierMaps.CABLE_GETTER.apply((Object)PipeSize.VTINY, tier, (Object)false)).put((Object)Character.valueOf('H'), (Object)hull).build(), new String[]{"CH"}));
            Machines.add(muramasa.gregtech.data.Machines.HATCH_DYNAMO, tier, (m, item) -> provider.addItemRecipe(output, "machines", "has_motor", provider.hasSafeItem((ItemLike)motor), (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('C'), TierMaps.CABLE_GETTER.apply((Object)PipeSize.VTINY, tier, (Object)false)).put((Object)Character.valueOf('H'), (Object)hull).build(), new String[]{"HC"}));
            Machines.add(muramasa.gregtech.data.Machines.HATCH_MUFFLER, tier, (m, item) -> provider.addItemRecipe(output, "machines", "has_motor", provider.hasSafeItem((ItemLike)motor), (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('C'), (Object)GregTechData.FLUID_PIPE_STEEL.getBlockItem(PipeSize.NORMAL)).put((Object)Character.valueOf('H'), (Object)hull).build(), new String[]{"H", "C"}));
            if (!AntimatterAPI.isModLoaded((String)"gt4r")) {
                Machines.add(muramasa.gregtech.data.Machines.ELECTRIC_TYPE_FILTER, tier, (m, item) -> provider.addItemRecipe(output, "machines", "has_motor", provider.hasSafeItem(GregTechData.MotorHV), (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('H'), (Object)hull).put((Object)Character.valueOf('C'), GregTechData.CircuitAdv).put((Object)Character.valueOf('F'), GregTechData.ItemFilter).put((Object)Character.valueOf('E'), (Object)ForgeCTags.CHESTS).build(), new String[]{" H ", "ECE", " F "}));
                Machines.add(muramasa.gregtech.data.Machines.ELECTRIC_ITEM_FILTER, tier, (m, item) -> provider.addItemRecipe(output, "machines", "has_motor", provider.hasSafeItem((ItemLike)motor), (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('H'), (Object)hull).put((Object)Character.valueOf('C'), GregTechTags.CIRCUITS_BASIC).put((Object)Character.valueOf('F'), GregTechData.ItemFilter).put((Object)Character.valueOf('E'), (Object)ForgeCTags.CHESTS).build(), new String[]{" H ", "ECE", " F "}));
            }
        });
        provider.addItemRecipe(output, "machines", "has_motor", provider.hasSafeItem(GregTechData.FireBrick), (ItemLike)muramasa.gregtech.data.Machines.PRIMITIVE_BLAST_FURNACE.getItem(muramasa.gregtech.data.Machines.PRIMITIVE_BLAST_FURNACE.getFirstTier()), ImmutableMap.builder().put((Object)Character.valueOf('H'), GregTechData.FireBrick).put((Object)Character.valueOf('C'), (Object)AntimatterMaterialTypes.PLATE.getMaterialTag(AntimatterMaterials.Iron)).build(), new String[]{"HHH", "HCH", "HHH"});
        provider.addItemRecipe(output, "machines", "has_wrench", provider.hasSafeItem(AntimatterDefaultTools.WRENCH.getTag()), (ItemLike)muramasa.gregtech.data.Machines.COKE_OVEN.getItem(muramasa.gregtech.data.Machines.COKE_OVEN.getFirstTier()), ImmutableMap.builder().put((Object)Character.valueOf('H'), GregTechData.FireBrick).build(), new String[]{"HHH", "H H", "HHH"});
        provider.addItemRecipe(output, "machines", "has_wrench", provider.hasSafeItem(AntimatterDefaultTools.WRENCH.getTag()), (ItemLike)muramasa.gregtech.data.Machines.CHARCOAL_PIT.getItem(muramasa.gregtech.data.Machines.CHARCOAL_PIT.getFirstTier()), ImmutableMap.builder().put((Object)Character.valueOf('H'), (Object)GregTechData.CASING_BRONZE_PLATED_BRICK).put((Object)Character.valueOf('G'), (Object)AntimatterMaterialTypes.GEAR.get(Materials.Steel)).put((Object)Character.valueOf('B'), (Object)Blocks.f_50353_).build(), new String[]{"GHG", "HBH", "GHG"});
        provider.addItemRecipe(output, "machines", "has_wrench", provider.hasSafeItem(AntimatterDefaultTools.WRENCH.getTag()), (ItemLike)muramasa.gregtech.data.Machines.PYROLYSIS_OVEN.getItem(muramasa.gregtech.data.Machines.PYROLYSIS_OVEN.getFirstTier()), ImmutableMap.builder().put((Object)Character.valueOf('H'), (Object)GregTechData.HULL_MV).put((Object)Character.valueOf('C'), GregTechData.CircuitGood).put((Object)Character.valueOf('P'), (Object)GregTechData.COVER_PUMP.getItem(Tier.MV).m_41720_()).put((Object)Character.valueOf('M'), GregTechData.MotorMV).put((Object)Character.valueOf('W'), (Object)GregTechData.WIRE_CUPRONICKEL.getBlockItem(PipeSize.SMALL)).put((Object)Character.valueOf('B'), (Object)Blocks.f_50039_).build(), new String[]{"BMW", "CHC", "MPW"});
        provider.addItemRecipe(output, "machines", "has_wrench", provider.hasSafeItem(AntimatterDefaultTools.WRENCH.getTag()), (ItemLike)muramasa.gregtech.data.Machines.NUCLEAR_REACTOR.getItem(muramasa.gregtech.data.Machines.NUCLEAR_REACTOR.getFirstTier()), ImmutableMap.builder().put((Object)Character.valueOf('H'), (Object)GregTechData.HULL_EV).put((Object)Character.valueOf('A'), GregTechData.RobotArmEV).put((Object)Character.valueOf('G'), (Object)AntimatterMaterialTypes.GEAR.get(Materials.NiobiumTitanium)).put((Object)Character.valueOf('P'), (Object)AntimatterMaterialTypes.PLATE.get(Materials.Iridium)).put((Object)Character.valueOf('T'), (Object)AntimatterMaterialTypes.PLATE_DENSE.get(Materials.Thorium)).build(), new String[]{"GTG", "AHA", "PTP"});
        provider.addItemRecipe(output, "machines", "has_wrench", provider.hasSafeItem(AntimatterDefaultTools.WRENCH.getTag()), (ItemLike)muramasa.gregtech.data.Machines.QUANTUM_TANK.getItem(Tier.LV), ImmutableMap.builder().put((Object)Character.valueOf('H'), (Object)GregTechData.HULL_LV).put((Object)Character.valueOf('C'), GregTechData.CircuitBasicElectronic).put((Object)Character.valueOf('F'), GregTechData.FieldGenLV).put((Object)Character.valueOf('P'), (Object)AntimatterMaterialTypes.PLATE.get(Materials.Steel)).build(), new String[]{"CFC", "PHP", "CPC"});
        provider.addItemRecipe(output, "machines", "has_wrench", provider.hasSafeItem(AntimatterDefaultTools.WRENCH.getTag()), (ItemLike)muramasa.gregtech.data.Machines.QUANTUM_TANK.getItem(Tier.MV), ImmutableMap.builder().put((Object)Character.valueOf('H'), (Object)GregTechData.HULL_MV).put((Object)Character.valueOf('C'), GregTechData.CircuitGood).put((Object)Character.valueOf('F'), GregTechData.FieldGenMV).put((Object)Character.valueOf('P'), (Object)AntimatterMaterialTypes.PLATE.get(Materials.Aluminium)).build(), new String[]{"CFC", "PHP", "CPC"});
        provider.addItemRecipe(output, "machines", "has_wrench", provider.hasSafeItem(AntimatterDefaultTools.WRENCH.getTag()), (ItemLike)muramasa.gregtech.data.Machines.QUANTUM_TANK.getItem(Tier.HV), ImmutableMap.builder().put((Object)Character.valueOf('H'), (Object)GregTechData.HULL_HV).put((Object)Character.valueOf('C'), GregTechData.CircuitAdv).put((Object)Character.valueOf('F'), GregTechData.FieldGenHV).put((Object)Character.valueOf('P'), (Object)AntimatterMaterialTypes.PLATE.get(Materials.StainlessSteel)).build(), new String[]{"CFC", "PHP", "CPC"});
        provider.addItemRecipe(output, "machines", "has_wrench", provider.hasSafeItem(AntimatterDefaultTools.WRENCH.getTag()), (ItemLike)muramasa.gregtech.data.Machines.QUANTUM_TANK.getItem(Tier.EV), ImmutableMap.builder().put((Object)Character.valueOf('H'), (Object)GregTechData.HULL_EV).put((Object)Character.valueOf('C'), GregTechData.CircuitNanoProcessor).put((Object)Character.valueOf('F'), GregTechData.FieldGenEV).put((Object)Character.valueOf('P'), (Object)AntimatterMaterialTypes.PLATE.get(Materials.Titanium)).build(), new String[]{"CFC", "PHP", "CPC"});
        provider.addItemRecipe(output, "machines", "has_wrench", provider.hasSafeItem(AntimatterDefaultTools.WRENCH.getTag()), (ItemLike)muramasa.gregtech.data.Machines.QUANTUM_TANK.getItem(Tier.IV), ImmutableMap.builder().put((Object)Character.valueOf('H'), (Object)GregTechData.HULL_IV).put((Object)Character.valueOf('C'), GregTechData.CircuitQuantumProcessor).put((Object)Character.valueOf('F'), GregTechData.FieldGenIV).put((Object)Character.valueOf('P'), (Object)AntimatterMaterialTypes.PLATE.get(Materials.TungstenSteel)).build(), new String[]{"CFC", "PHP", "CPC"});
        provider.addItemRecipe(output, "machines", "has_wrench", provider.hasSafeItem(AntimatterDefaultTools.WRENCH.getTag()), (ItemLike)muramasa.gregtech.data.Machines.TRANSFORMER.getItem(Tier.LV), ImmutableMap.builder().put((Object)Character.valueOf('H'), (Object)GregTechData.HULL_LV).put((Object)Character.valueOf('C'), (Object)GregTechData.CABLE_LEAD.getBlockItem(PipeSize.VTINY)).put((Object)Character.valueOf('W'), (Object)GregTechData.CABLE_TIN.getBlockItem(PipeSize.VTINY)).build(), new String[]{" CC", "WH ", " CC"});
        provider.addItemRecipe(output, "machines", "has_wrench", provider.hasSafeItem(AntimatterDefaultTools.WRENCH.getTag()), (ItemLike)muramasa.gregtech.data.Machines.TRANSFORMER.getItem(Tier.MV), ImmutableMap.builder().put((Object)Character.valueOf('H'), (Object)GregTechData.HULL_MV).put((Object)Character.valueOf('C'), (Object)GregTechData.CABLE_TIN.getBlockItem(PipeSize.VTINY)).put((Object)Character.valueOf('W'), (Object)GregTechData.CABLE_COPPER.getBlockItem(PipeSize.VTINY)).build(), new String[]{" CC", "WH ", " CC"});
        provider.addItemRecipe(output, "machines", "has_wrench", provider.hasSafeItem(AntimatterDefaultTools.WRENCH.getTag()), (ItemLike)muramasa.gregtech.data.Machines.TRANSFORMER.getItem(Tier.HV), ImmutableMap.builder().put((Object)Character.valueOf('H'), (Object)GregTechData.HULL_HV).put((Object)Character.valueOf('C'), (Object)GregTechData.CABLE_COPPER.getBlockItem(PipeSize.VTINY)).put((Object)Character.valueOf('W'), (Object)GregTechData.CABLE_GOLD.getBlockItem(PipeSize.VTINY)).build(), new String[]{" CC", "WH ", " CC"});
        provider.addItemRecipe(output, "machines", "has_wrench", provider.hasSafeItem(AntimatterDefaultTools.WRENCH.getTag()), (ItemLike)muramasa.gregtech.data.Machines.TRANSFORMER.getItem(Tier.EV), ImmutableMap.builder().put((Object)Character.valueOf('H'), (Object)GregTechData.HULL_EV).put((Object)Character.valueOf('C'), (Object)GregTechData.CABLE_GOLD.getBlockItem(PipeSize.VTINY)).put((Object)Character.valueOf('W'), (Object)GregTechData.CABLE_ALUMINIUM.getBlockItem(PipeSize.VTINY)).build(), new String[]{" CC", "WH ", " CC"});
        provider.addItemRecipe(output, "machines", "has_wrench", provider.hasSafeItem(AntimatterDefaultTools.WRENCH.getTag()), (ItemLike)muramasa.gregtech.data.Machines.TRANSFORMER.getItem(Tier.IV), ImmutableMap.builder().put((Object)Character.valueOf('H'), (Object)GregTechData.HULL_IV).put((Object)Character.valueOf('C'), (Object)GregTechData.CABLE_ALUMINIUM.getBlockItem(PipeSize.VTINY)).put((Object)Character.valueOf('W'), (Object)GregTechData.CABLE_TUNGSTEN.getBlockItem(PipeSize.VTINY)).build(), new String[]{" CC", "WH ", " CC"});
        AntimatterAPI.all(WorkbenchMachine.class).forEach(m -> {
            if (!m.getId().contains("charging")) {
                provider.addItemRecipe(output, "gti", "", "machines", "has_chest", provider.hasSafeItem(ForgeCTags.CHESTS_WOODEN), (ItemLike)m.getItem(Tier.NONE), ImmutableMap.of((Object)Character.valueOf('P'), (Object)AntimatterMaterialTypes.PLATE.getMaterialTag(m.getMaterial()), (Object)Character.valueOf('C'), (Object)ForgeCTags.CHESTS_WOODEN, (Object)Character.valueOf('c'), (Object)Items.f_41960_, (Object)Character.valueOf('S'), (Object)AntimatterDefaultTools.SCREWDRIVER.getTag()), new String[]{"PSP", "PcP", "PCP"});
            } else {
                provider.addItemRecipe(output, "antimatter", "", "machines", "has_chest", provider.hasSafeItem(ForgeCTags.CHESTS_WOODEN), (ItemLike)m.getItem(Tier.HV), ImmutableMap.of((Object)Character.valueOf('S'), (Object)AntimatterDefaultTools.SCREWDRIVER.getTag(), (Object)Character.valueOf('w'), (Object)AntimatterDefaultTools.WIRE_CUTTER.getTag(), (Object)Character.valueOf('W'), (Object)Machine.get((String)m.getId().replace("charging_", ""), (String)"gtutility").map(mch -> mch.getItem(Tier.NONE)).orElse(Items.f_41852_), (Object)Character.valueOf('c'), (Object)TierMaps.CABLE_GETTER.apply((Object)PipeSize.SMALL, (Object)Tier.HV, (Object)false), (Object)Character.valueOf('C'), GregTechTags.CIRCUITS_ADVANCED, (Object)Character.valueOf('R'), (Object)AntimatterMaterialTypes.ROD.getMaterialTag(m.getMaterial())), new String[]{"RCR", "SWw", "ccc"});
            }
        });
    }

    private static <T extends Machine<T>> void add(T machine, Tier tier, BiConsumer<T, Item> callback) {
        Item item = machine.getItem(tier);
        if (item != null) {
            callback.accept(machine, item);
        }
    }

    private static /* synthetic */ void lambda$loadRecipes$23(AntimatterRecipeProvider provider, Consumer output, TagKey circuit, Object cable, Block firebox, TagKey circuit2, MultiMachine m, Item item) {
        provider.addItemRecipe(output, "machines", "has_circuit", provider.hasSafeItem(circuit), (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('L'), cable).put((Object)Character.valueOf('H'), (Object)firebox).put((Object)Character.valueOf('C'), (Object)circuit2).build(), new String[]{"LCL", "CHC", "LCL"});
    }

    private static /* synthetic */ void lambda$loadRecipes$22(AntimatterRecipeProvider provider, Consumer output, Item motor, Object cable, TagKey circuit, MultiMachine m, Item item) {
        provider.addItemRecipe(output, "machines", "has_motor", provider.hasSafeItem((ItemLike)motor), (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('L'), cable).put((Object)Character.valueOf('H'), (Object)GregTechData.CASING_HEAT_PROOF).put((Object)Character.valueOf('C'), (Object)circuit).put((Object)Character.valueOf('F'), (Object)Items.f_41962_).build(), new String[]{"FFF", "CHC", "LCL"});
    }

    private static /* synthetic */ void lambda$loadRecipes$21(AntimatterRecipeProvider provider, Consumer output, Item motor, Object cable, Item hull, Item rotor, TagKey circuit, GeneratorMachine m, Item item) {
        provider.addItemRecipe(output, "machines", "has_motor", provider.hasSafeItem((ItemLike)motor), (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('M'), (Object)motor).put((Object)Character.valueOf('L'), cable).put((Object)Character.valueOf('H'), (Object)hull).put((Object)Character.valueOf('R'), (Object)rotor).put((Object)Character.valueOf('C'), (Object)circuit).build(), new String[]{"CRC", "RHR", "MLM"});
    }

    private static /* synthetic */ void lambda$loadRecipes$20(AntimatterRecipeProvider provider, Consumer output, Item motor, Object cable, Item hull, Material material, TagKey circuit, Item piston, GeneratorMachine m, Item item) {
        provider.addItemRecipe(output, "machines", "has_motor", provider.hasSafeItem((ItemLike)motor), (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('M'), (Object)motor).put((Object)Character.valueOf('L'), cable).put((Object)Character.valueOf('H'), (Object)hull).put((Object)Character.valueOf('G'), (Object)AntimatterMaterialTypes.GEAR.getMaterialTag(material)).put((Object)Character.valueOf('C'), (Object)circuit).put((Object)Character.valueOf('P'), (Object)piston).build(), new String[]{"PCP", "MHM", "GLG"});
    }

    private static /* synthetic */ void lambda$loadRecipes$19(AntimatterRecipeProvider provider, Consumer output, Item motor, Object cable, Item hull, Item rotor, TagKey circuit, Tier tier, GeneratorMachine m, Item item) {
        provider.addItemRecipe(output, "machines", "has_motor", provider.hasSafeItem((ItemLike)motor), (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('M'), (Object)motor).put((Object)Character.valueOf('L'), cable).put((Object)Character.valueOf('H'), (Object)hull).put((Object)Character.valueOf('R'), (Object)rotor).put((Object)Character.valueOf('C'), (Object)circuit).put((Object)Character.valueOf('P'), TierMaps.TIER_PIPES.get((Object)tier)).build(), new String[]{"PCP", "RHR", "MLM"});
    }

    private static /* synthetic */ void lambda$loadRecipes$18(AntimatterRecipeProvider provider, Consumer output, Item motor, Item rotor, Item glass, TagKey circuit, Item hull, BasicMachine m, Item item) {
        provider.addItemRecipe(output, "machines", "has_motor", provider.hasSafeItem((ItemLike)motor), (ItemLike)item, ImmutableMap.of((Object)Character.valueOf('M'), (Object)motor, (Object)Character.valueOf('R'), (Object)rotor, (Object)Character.valueOf('G'), (Object)glass, (Object)Character.valueOf('C'), (Object)circuit, (Object)Character.valueOf('H'), (Object)hull), new String[]{"GRG", "GMG", "CHC"});
    }

    private static /* synthetic */ void lambda$loadRecipes$17(AntimatterRecipeProvider provider, Consumer output, Item motor, TagKey circuit, Object cable, Item hull, BasicMachine m, Item item) {
        provider.addItemRecipe(output, "machines", "has_motor", provider.hasSafeItem((ItemLike)motor), (ItemLike)item, ImmutableMap.of((Object)Character.valueOf('M'), (Object)motor, (Object)Character.valueOf('C'), (Object)circuit, (Object)Character.valueOf('L'), (Object)cable, (Object)Character.valueOf('H'), (Object)hull), new String[]{"CMC", "LHL", "CMC"});
    }

    private static /* synthetic */ void lambda$loadRecipes$16(AntimatterRecipeProvider provider, Consumer output, Item motor, Item arm, Item conveyor, TagKey circuit, Object cable, Item hull, BasicMachine m, Item item) {
        provider.addItemRecipe(output, "machines", "has_motor", provider.hasSafeItem((ItemLike)motor), (ItemLike)item, ImmutableMap.of((Object)Character.valueOf('R'), (Object)arm, (Object)Character.valueOf('O'), (Object)conveyor, (Object)Character.valueOf('C'), (Object)circuit, (Object)Character.valueOf('L'), (Object)cable, (Object)Character.valueOf('H'), (Object)hull), new String[]{"RCR", "OHO", "LCL"});
    }

    private static /* synthetic */ void lambda$loadRecipes$15(AntimatterRecipeProvider provider, Consumer output, Item motor, TagKey circuit, Object cable, Item hull, BasicMachine m, Item item) {
        provider.addItemRecipe(output, "machines", "has_motor", provider.hasSafeItem((ItemLike)motor), (ItemLike)item, ImmutableMap.of((Object)Character.valueOf('M'), (Object)motor, (Object)Character.valueOf('C'), (Object)circuit, (Object)Character.valueOf('L'), (Object)cable, (Object)Character.valueOf('H'), (Object)hull), new String[]{"MLM", "CHC", "MLM"});
    }

    private static /* synthetic */ void lambda$loadRecipes$14(AntimatterRecipeProvider provider, Consumer output, Item motor, Item piston, TagKey circuit, Object cable, Item hull, BasicMachine m, Item item) {
        provider.addItemRecipe(output, "machines", "has_motor", provider.hasSafeItem((ItemLike)motor), (ItemLike)item, ImmutableMap.of((Object)Character.valueOf('P'), (Object)piston, (Object)Character.valueOf('M'), (Object)motor, (Object)Character.valueOf('C'), (Object)circuit, (Object)Character.valueOf('L'), (Object)cable, (Object)Character.valueOf('H'), (Object)hull), new String[]{"PLP", "CHC", "MLM"});
    }

    private static /* synthetic */ void lambda$loadRecipes$13(AntimatterRecipeProvider provider, Consumer output, Item conveyor, Object cable, Item esWire, Item hull, Material material, TagKey circuit, BasicMachine m, Item item) {
        provider.addItemRecipe(output, "machines", "has_conveyor", provider.hasSafeItem((ItemLike)conveyor), (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('c'), (Object)conveyor).put((Object)Character.valueOf('W'), cable).put((Object)Character.valueOf('w'), (Object)esWire).put((Object)Character.valueOf('H'), (Object)hull).put((Object)Character.valueOf('R'), (Object)AntimatterMaterialTypes.ROD.getMaterialTag(material)).put((Object)Character.valueOf('C'), (Object)circuit).build(), new String[]{"cWw", "WHR", "CWw"});
    }

    private static /* synthetic */ void lambda$loadRecipes$12(AntimatterRecipeProvider provider, Consumer output, Item motor, TagKey circuit, Item piston, Object cable, Item hull, BasicMachine m, Item item) {
        provider.addItemRecipe(output, "machines", "has_motor", provider.hasSafeItem((ItemLike)motor), (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('C'), (Object)circuit).put((Object)Character.valueOf('P'), (Object)piston).put((Object)Character.valueOf('L'), cable).put((Object)Character.valueOf('H'), (Object)hull).put((Object)Character.valueOf('F'), GregTechData.ItemFilter).build(), new String[]{"LFL", "PHP", "CFC"});
    }

    private static /* synthetic */ void lambda$loadRecipes$11(AntimatterRecipeProvider provider, Consumer output, Item motor, TagKey circuit, Item conveyor, Item pump, Object cable, Item hull, Item glass, BasicMachine m, Item item) {
        provider.addItemRecipe(output, "machines", "has_motor", provider.hasSafeItem((ItemLike)motor), (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('C'), (Object)circuit).put((Object)Character.valueOf('W'), (Object)conveyor).put((Object)Character.valueOf('P'), (Object)pump).put((Object)Character.valueOf('L'), cable).put((Object)Character.valueOf('H'), (Object)hull).put((Object)Character.valueOf('G'), (Object)glass).build(), new String[]{"WGL", "PGW", "CHC"});
    }

    private static /* synthetic */ void lambda$loadRecipes$10(AntimatterRecipeProvider provider, Consumer output, Item motor, TagKey circuit, Tier tier, Material material, Item hull, Item pump, BasicMachine m, Item item) {
        provider.addItemRecipe(output, "machines", "has_motor", provider.hasSafeItem((ItemLike)motor), (ItemLike)item, ImmutableMap.of((Object)Character.valueOf('C'), (Object)circuit, (Object)Character.valueOf('W'), (Object)AntimatterMaterialTypes.DUST.get(Materials.Graphite), (Object)Character.valueOf('L'), (Object)TierMaps.CABLE_GETTER.apply((Object)PipeSize.SMALL, (Object)tier, (Object)true), (Object)Character.valueOf('H'), (Object)AntimatterMaterialTypes.PLATE.get(material), (Object)Character.valueOf('M'), (Object)hull, (Object)Character.valueOf('P'), (Object)pump), new String[]{"LWL", "CMC", "PHP"});
    }

    private static /* synthetic */ void lambda$loadRecipes$9(AntimatterRecipeProvider provider, Consumer output, Item motor, TagKey circuit, Tier tier, Material material, Item hull, BasicMachine m, Item item) {
        provider.addItemRecipe(output, "machines", "has_motor", provider.hasSafeItem((ItemLike)motor), (ItemLike)item, ImmutableMap.of((Object)Character.valueOf('C'), (Object)circuit, (Object)Character.valueOf('W'), (Object)AntimatterMaterialTypes.DUST.get(Materials.Graphite), (Object)Character.valueOf('L'), (Object)TierMaps.CABLE_GETTER.apply((Object)PipeSize.SMALL, (Object)tier, (Object)true), (Object)Character.valueOf('H'), (Object)AntimatterMaterialTypes.PLATE.get(material), (Object)Character.valueOf('M'), (Object)hull), new String[]{"LWL", "CMC", "HHH"});
    }

    private static /* synthetic */ void lambda$loadRecipes$8(AntimatterRecipeProvider provider, Consumer output, Item motor, TagKey circuit, Wire electroWire, Object cable, Item hull, Item glass, BasicMachine m, Item item) {
        provider.addItemRecipe(output, "machines", "has_motor", provider.hasSafeItem((ItemLike)motor), (ItemLike)item, ImmutableMap.of((Object)Character.valueOf('C'), (Object)circuit, (Object)Character.valueOf('W'), (Object)electroWire.getBlockItem(PipeSize.VTINY), (Object)Character.valueOf('L'), (Object)cable, (Object)Character.valueOf('H'), (Object)hull, (Object)Character.valueOf('G'), (Object)glass), new String[]{"WGW", "WHW", "CLC"});
    }

    private static /* synthetic */ void lambda$loadRecipes$7(AntimatterRecipeProvider provider, Consumer output, Item motor, Item piston, TagKey circuit, Object cable, Item hull, Object diamond, BasicMachine m, Item item) {
        provider.addItemRecipe(output, "machines", "has_motor", provider.hasSafeItem((ItemLike)motor), (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('P'), (Object)piston).put((Object)Character.valueOf('M'), (Object)motor).put((Object)Character.valueOf('C'), (Object)circuit).put((Object)Character.valueOf('L'), cable).put((Object)Character.valueOf('H'), (Object)hull).put((Object)Character.valueOf('D'), diamond).build(), new String[]{"LCL", "MHD", "CLP"});
    }

    private static /* synthetic */ void lambda$loadRecipes$6(AntimatterRecipeProvider provider, Consumer output, Item motor, Item piston, Tier tier, TagKey circuit, Item hull, BasicMachine m, Item item) {
        provider.addItemRecipe(output, "machines", "has_motor", provider.hasSafeItem((ItemLike)motor), (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('P'), (Object)piston).put((Object)Character.valueOf('I'), TierMaps.TIER_PIPES.get((Object)tier)).put((Object)Character.valueOf('W'), TierMaps.WIRE_GETTER.apply(PipeSize.SMALL, tier)).put((Object)Character.valueOf('C'), (Object)circuit).put((Object)Character.valueOf('H'), (Object)hull).build(), new String[]{"WWC", "PHI", "WWC"});
    }

    private static /* synthetic */ void lambda$loadRecipes$5(AntimatterRecipeProvider provider, Consumer output, Item motor, Item piston, Item pump, Item glass, TagKey circuit, Object cable, Item hull, BasicMachine m, Item item) {
        provider.addItemRecipe(output, "machines", "has_motor", provider.hasSafeItem((ItemLike)motor), (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('P'), (Object)piston).put((Object)Character.valueOf('M'), (Object)pump).put((Object)Character.valueOf('G'), (Object)glass).put((Object)Character.valueOf('C'), (Object)circuit).put((Object)Character.valueOf('L'), cable).put((Object)Character.valueOf('H'), (Object)hull).build(), new String[]{"GCG", "PHM", "LCL"});
    }

    private static /* synthetic */ void lambda$loadRecipes$4(AntimatterRecipeProvider provider, Consumer output, Item motor, TagKey circuit, Object cable, Item hull, Tier tier, BasicMachine m, Item item) {
        provider.addItemRecipe(output, "machines", "has_motor", provider.hasSafeItem((ItemLike)motor), (ItemLike)item, ImmutableMap.of((Object)Character.valueOf('C'), (Object)circuit, (Object)Character.valueOf('L'), (Object)cable, (Object)Character.valueOf('H'), (Object)hull, (Object)Character.valueOf('W'), (Object)TierMaps.WIRE_GETTER.apply(PipeSize.TINY, tier)), new String[]{"CWC", "WHW", "LWL"});
    }

    private static /* synthetic */ void lambda$loadRecipes$3(AntimatterRecipeProvider provider, Consumer output, Item motor, TagKey circuit, Object cable, Item hull, Item conveyor, Item glass, BasicMachine m, Item item) {
        provider.addItemRecipe(output, "machines", "has_motor", provider.hasSafeItem((ItemLike)motor), (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('M'), (Object)motor).put((Object)Character.valueOf('C'), (Object)circuit).put((Object)Character.valueOf('L'), cable).put((Object)Character.valueOf('H'), (Object)hull).put((Object)Character.valueOf('D'), GregTechData.DiamondSawBlade).put((Object)Character.valueOf('V'), (Object)conveyor).put((Object)Character.valueOf('G'), (Object)glass).build(), new String[]{"LCG", "VHD", "CLM"});
    }

    private static /* synthetic */ void lambda$loadRecipes$2(AntimatterRecipeProvider provider, Consumer output, Item motor, TagKey circuit, Item piston, Object cable, Item hull, BasicMachine m, Item item) {
        provider.addItemRecipe(output, "machines", "has_motor", provider.hasSafeItem((ItemLike)motor), (ItemLike)item, ImmutableMap.of((Object)Character.valueOf('C'), (Object)circuit, (Object)Character.valueOf('P'), (Object)piston, (Object)Character.valueOf('L'), (Object)cable, (Object)Character.valueOf('H'), (Object)hull), new String[]{"LCL", "PHP", "LCL"});
    }

    private static /* synthetic */ void lambda$loadRecipes$1(AntimatterRecipeProvider provider, Consumer output, Item motor, Tier tier, Item hull, TagKey circuit, Object cable, BasicMachine m, Item item) {
        provider.addItemRecipe(output, "machines", "has_motor", provider.hasSafeItem((ItemLike)motor), (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('L'), TierMaps.WIRE_GETTER.apply(PipeSize.SMALL, tier)).put((Object)Character.valueOf('H'), (Object)hull).put((Object)Character.valueOf('C'), (Object)circuit).put((Object)Character.valueOf('G'), cable).build(), new String[]{"CLC", "LHL", "GLG"});
    }

    private static /* synthetic */ void lambda$loadRecipes$0(AntimatterRecipeProvider provider, Consumer output, Item motor, Item piston, TagKey circuit, Object cable, Item hull, BasicMachine m, Item item) {
        provider.addItemRecipe(output, "machines", "has_motor", provider.hasSafeItem((ItemLike)motor), (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('P'), (Object)piston).put((Object)Character.valueOf('M'), (Object)motor).put((Object)Character.valueOf('C'), (Object)circuit).put((Object)Character.valueOf('L'), cable).put((Object)Character.valueOf('H'), (Object)hull).put((Object)Character.valueOf('D'), (Object)Items.f_42415_).build(), new String[]{"PMD", "LLH", "CCL"});
    }
}

