/*
 * Decompiled with CFR 0.152.
 */
package muramasa.gregtech.loader.crafting;

import com.google.common.collect.ImmutableMap;
import java.util.function.Consumer;
import muramasa.antimatter.AntimatterAPI;
import muramasa.antimatter.data.AntimatterDefaultTools;
import muramasa.antimatter.data.AntimatterMaterialTypes;
import muramasa.antimatter.data.AntimatterMaterials;
import muramasa.antimatter.datagen.providers.AntimatterRecipeProvider;
import muramasa.antimatter.machine.Tier;
import muramasa.antimatter.material.IMaterialTag;
import muramasa.antimatter.material.Material;
import muramasa.antimatter.material.MaterialTypeBlock;
import muramasa.antimatter.pipe.PipeSize;
import muramasa.gregtech.block.BlockCasing;
import muramasa.gregtech.data.GregTechData;
import muramasa.gregtech.data.Materials;
import muramasa.gregtech.data.TierMaps;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class BlockParts {
    public static void loadRecipes(Consumer<FinishedRecipe> output, AntimatterRecipeProvider provider) {
        AntimatterMaterialTypes.FRAME.all().forEach(frame -> {
            if (!frame.has(new IMaterialTag[]{AntimatterMaterialTypes.ROD})) {
                return;
            }
            provider.addItemRecipe(output, "gtblockparts", "has_wrench", provider.hasSafeItem(AntimatterDefaultTools.WRENCH.getTag()), (ItemLike)((MaterialTypeBlock.IBlockGetter)AntimatterMaterialTypes.FRAME.get()).get(frame).asItem(), ImmutableMap.of((Object)Character.valueOf('R'), (Object)AntimatterMaterialTypes.ROD.get(frame), (Object)Character.valueOf('W'), (Object)AntimatterDefaultTools.WRENCH.getTag()), new String[]{"RRR", "RWR", "RRR"});
        });
        BlockParts.addBrickedCasing(output, provider, Materials.Bronze, (Block)GregTechData.CASING_BRICKED_BRONZE);
        provider.addStackRecipe(output, "gti", "firebricks", "blocks", "has_fire_brick", provider.hasSafeItem(GregTechData.FireBrick), new ItemStack((ItemLike)GregTechData.CASING_FIRE_BRICK), ImmutableMap.of((Object)Character.valueOf('F'), GregTechData.FireBrick), new String[]{"FF", "FF"});
        BlockParts.addBrickedCasing(output, provider, Materials.Steel, (Block)GregTechData.CASING_BRICKED_STEEL);
        BlockParts.addFirebox(output, provider, Materials.Bronze, (Block)GregTechData.CASING_FIREBOX_BRONZE);
        BlockParts.addFirebox(output, provider, Materials.Steel, (Block)GregTechData.CASING_FIREBOX_STEEL);
        BlockParts.addFirebox(output, provider, Materials.Titanium, (Block)GregTechData.CASING_FIREBOX_TITANIUM);
        BlockParts.addFirebox(output, provider, Materials.TungstenSteel, (Block)GregTechData.CASING_FIREBOX_TUNGSTENSTEEL);
        BlockParts.addTurbine(output, provider, Materials.Steel, (Block)GregTechData.CASING_TURBINE_1);
        BlockParts.addTurbine(output, provider, Materials.StainlessSteel, (Block)GregTechData.CASING_TURBINE_2);
        BlockParts.addTurbine(output, provider, Materials.Titanium, (Block)GregTechData.CASING_TURBINE_3);
        BlockParts.addTurbine(output, provider, Materials.TungstenSteel, (Block)GregTechData.CASING_TURBINE_4);
        BlockParts.addCasing(output, provider, Materials.Invar, (Block)GregTechData.CASING_HEAT_PROOF);
        BlockParts.addCasing(output, provider, Materials.Aluminium, (Block)GregTechData.CASING_FROST_PROOF);
        BlockParts.addCasing(output, provider, Materials.Steel, (Block)GregTechData.CASING_SOLID_STEEL);
        BlockParts.addCasing(output, provider, Materials.StainlessSteel, (Block)GregTechData.CASING_STAINLESS_STEEL);
        BlockParts.addCasing(output, provider, Materials.Titanium, (Block)GregTechData.CASING_TITANIUM);
        BlockParts.addCasing(output, provider, Materials.Lead, (Block)GregTechData.CASING_RADIATION_PROOF);
        BlockParts.addCasing(output, provider, Materials.TungstenSteel, (Block)GregTechData.CASING_TUNGSTENSTEEL);
        BlockParts.addTierCasing(output, provider, Tier.ULV);
        BlockParts.addTierCasing(output, provider, Tier.LV);
        BlockParts.addTierCasing(output, provider, Tier.MV);
        BlockParts.addTierCasing(output, provider, Tier.HV);
        BlockParts.addTierCasing(output, provider, Tier.EV);
        BlockParts.addTierCasing(output, provider, Tier.IV);
        BlockParts.addTierCasing(output, provider, Tier.LUV);
        BlockParts.addTierCasing(output, provider, Tier.ZPM);
        BlockParts.addTierCasing(output, provider, Tier.UV);
        BlockParts.addTierCasing(output, provider, Tier.MAX);
        BlockParts.addTierHull(output, provider, AntimatterMaterials.Wood, Tier.ULV);
        BlockParts.addTierHull(output, provider, Materials.WroughtIron, Tier.LV);
        BlockParts.addTierHull(output, provider, Materials.WroughtIron, Tier.MV);
        BlockParts.addTierHull(output, provider, Materials.Polyethylene, Tier.HV);
        BlockParts.addTierHull(output, provider, Materials.Polyethylene, Tier.EV);
        BlockParts.addTierHull(output, provider, Materials.Polyethylene, Tier.IV);
        BlockParts.addTierHull(output, provider, Materials.Polyethylene, Tier.LUV);
        BlockParts.addTierHull(output, provider, Materials.Polytetrafluoroethylene, Tier.ZPM);
        BlockParts.addTierHull(output, provider, Materials.Polytetrafluoroethylene, Tier.UV);
        BlockParts.addTierHull(output, provider, Materials.Polytetrafluoroethylene, Tier.MAX);
        provider.addItemRecipe(output, "gtblockparts", "has_wrench", provider.hasSafeItem(AntimatterDefaultTools.WRENCH.getTag()), (ItemLike)GregTechData.CASING_BRONZE_PLATED_BRICK, ImmutableMap.builder().put((Object)Character.valueOf('P'), (Object)AntimatterMaterialTypes.PLATE.get(Materials.Bronze)).put((Object)Character.valueOf('B'), (Object)Blocks.f_50076_).put((Object)Character.valueOf('W'), (Object)AntimatterDefaultTools.WRENCH.getTag()).build(), new String[]{"BPB", "PWP", "BPB"});
        provider.addItemRecipe(output, "gtblockparts", "has_wrench", provider.hasSafeItem(AntimatterDefaultTools.WRENCH.getTag()), (ItemLike)GregTechData.CASING_STEEL, ImmutableMap.builder().put((Object)Character.valueOf('P'), (Object)AntimatterMaterialTypes.PLATE.get(Materials.Steel)).put((Object)Character.valueOf('B'), (Object)AntimatterMaterialTypes.INGOT.get(Materials.Steel)).put((Object)Character.valueOf('W'), (Object)AntimatterDefaultTools.WRENCH.getTag()).build(), new String[]{"BPB", "PWP", "BPB"});
    }

    private static void addCasing(Consumer<FinishedRecipe> output, AntimatterRecipeProvider provider, Material mat, Block casing) {
        provider.addItemRecipe(output, "gtblockparts", "has_wrench", provider.hasSafeItem(AntimatterDefaultTools.WRENCH.getTag()), (ItemLike)casing, ImmutableMap.of((Object)Character.valueOf('P'), (Object)AntimatterMaterialTypes.PLATE.getMaterialTag(mat), (Object)Character.valueOf('W'), (Object)AntimatterDefaultTools.WRENCH.getTag(), (Object)Character.valueOf('H'), (Object)AntimatterDefaultTools.HAMMER.getTag(), (Object)Character.valueOf('F'), (Object)((MaterialTypeBlock.IBlockGetter)AntimatterMaterialTypes.FRAME.get()).get(mat).asItem()), new String[]{"PHP", "PFP", "PWP"});
    }

    private static void addBrickedCasing(Consumer<FinishedRecipe> output, AntimatterRecipeProvider provider, Material mat, Block casing) {
        provider.addItemRecipe(output, "gtblockparts", "has_wrench", provider.hasSafeItem(AntimatterDefaultTools.WRENCH.getTag()), (ItemLike)casing, ImmutableMap.of((Object)Character.valueOf('B'), (Object)Items.f_42460_, (Object)Character.valueOf('P'), (Object)AntimatterMaterialTypes.PLATE.getMaterialTag(mat), (Object)Character.valueOf('H'), (Object)AntimatterDefaultTools.HAMMER.getTag()), new String[]{"PPP", "PHP", "BBB"});
    }

    private static void addFirebox(Consumer<FinishedRecipe> output, AntimatterRecipeProvider provider, Material mat, Block casing) {
        provider.addItemRecipe(output, "gtblockparts", "has_wrench", provider.hasSafeItem(AntimatterDefaultTools.WRENCH.getTag()), (ItemLike)casing, ImmutableMap.of((Object)Character.valueOf('P'), (Object)AntimatterMaterialTypes.PLATE.getMaterialTag(mat), (Object)Character.valueOf('W'), (Object)AntimatterDefaultTools.WRENCH.getTag(), (Object)Character.valueOf('H'), (Object)AntimatterDefaultTools.HAMMER.getTag(), (Object)Character.valueOf('F'), (Object)((MaterialTypeBlock.IBlockGetter)AntimatterMaterialTypes.FRAME.get()).get(mat).asItem()), new String[]{"PHP", "PFP", "PWP"});
    }

    private static void addTurbine(Consumer<FinishedRecipe> output, AntimatterRecipeProvider provider, Material mat, Block casing) {
        provider.addItemRecipe(output, "gtblockparts", "has_wrench", provider.hasSafeItem(AntimatterDefaultTools.WRENCH.getTag()), (ItemLike)casing, ImmutableMap.of((Object)Character.valueOf('P'), (Object)AntimatterMaterialTypes.PLATE.getMaterialTag(mat), (Object)Character.valueOf('R'), (Object)AntimatterMaterialTypes.ROD.getMaterialTag(mat), (Object)Character.valueOf('F'), (Object)((MaterialTypeBlock.IBlockGetter)AntimatterMaterialTypes.FRAME.get()).get(mat).asItem()), new String[]{"PRP", "PFP", "PRP"});
    }

    private static void addTierCasing(Consumer<FinishedRecipe> output, AntimatterRecipeProvider provider, Tier tier) {
        provider.addItemRecipe(output, "casings", "has_casing", provider.hasSafeItem(AntimatterDefaultTools.WRENCH.getTag()), (ItemLike)AntimatterAPI.get(BlockCasing.class, (String)("casing_" + tier.getId()), (String)"gti"), ImmutableMap.of((Object)Character.valueOf('P'), (Object)AntimatterMaterialTypes.PLATE.getMaterialTag((Material)TierMaps.TIER_MATERIALS.get((Object)tier)), (Object)Character.valueOf('W'), (Object)AntimatterDefaultTools.WRENCH.getTag()), new String[]{"PPP", "PWP", "PPP"});
    }

    private static void addTierHull(Consumer<FinishedRecipe> output, AntimatterRecipeProvider provider, Material mat, Tier tier) {
        provider.addItemRecipe(output, "hulls", "has_hull", provider.hasSafeItem(AntimatterDefaultTools.WRENCH.getTag()), (ItemLike)AntimatterAPI.get(BlockCasing.class, (String)("hull_" + tier.getId()), (String)"gti"), ImmutableMap.of((Object)Character.valueOf('P'), (Object)AntimatterMaterialTypes.PLATE.getMaterialTag(mat), (Object)Character.valueOf('R'), (Object)AntimatterMaterialTypes.PLATE.getMaterialTag((Material)TierMaps.TIER_MATERIALS.get((Object)tier)), (Object)Character.valueOf('W'), (Object)TierMaps.CABLE_GETTER.apply((Object)(tier == Tier.UV ? PipeSize.SMALL : PipeSize.VTINY), (Object)tier, (Object)false), (Object)Character.valueOf('K'), (Object)AntimatterAPI.get(BlockCasing.class, (String)("casing_" + tier.getId()), (String)"gti")), new String[]{"PRP", "WKW"});
    }
}

