/*
 * Decompiled with CFR 0.152.
 */
package muramasa.gregtech.loader;

import muramasa.antimatter.AntimatterConfig;
import muramasa.antimatter.data.AntimatterMaterialTypes;
import muramasa.antimatter.data.AntimatterMaterials;
import muramasa.antimatter.data.AntimatterStoneTypes;
import muramasa.antimatter.event.WorldGenEvent;
import muramasa.antimatter.material.Material;
import muramasa.antimatter.material.MaterialTypeBlock;
import muramasa.antimatter.worldgen.StoneLayerOre;
import muramasa.antimatter.worldgen.object.WorldGenStoneLayerBuilder;
import muramasa.antimatter.worldgen.smallore.WorldGenSmallOreBuilder;
import muramasa.antimatter.worldgen.vein.WorldGenVeinLayerBuilder;
import muramasa.gregtech.data.GregTechData;
import muramasa.gregtech.data.Materials;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class WorldGenLoader {
    public static void init(WorldGenEvent ev) {
        if (AntimatterConfig.WORLD.STONE_LAYERS) {
            WorldGenLoader.initStoneVeins(ev);
        }
        if (AntimatterConfig.WORLD.ORE_VEINS) {
            WorldGenLoader.initOreVeins(ev);
            WorldGenLoader.initStoneOreVeins(ev);
        }
        if (AntimatterConfig.WORLD.SMALL_ORES) {
            WorldGenLoader.initSmallOres(ev);
        }
    }

    private static void initSmallOres(WorldGenEvent event) {
        event.smallOre(new WorldGenSmallOreBuilder().withMaterial(AntimatterMaterials.Copper).withAmountPerChunk(32).atHeight(16, 126).buildMaterial());
        event.smallOre(new WorldGenSmallOreBuilder().withMaterial(Materials.Tin).withAmountPerChunk(32).atHeight(16, 126).buildMaterial());
        event.smallOre(new WorldGenSmallOreBuilder().withMaterial(Materials.Bismuth).withAmountPerChunk(8).atHeight(76, 196).buildMaterial());
        event.smallOre(new WorldGenSmallOreBuilder().withMaterial(AntimatterMaterials.Coal).withAmountPerChunk(24).atHeight(16, 126).buildMaterial());
        event.smallOre(new WorldGenSmallOreBuilder().withMaterial(AntimatterMaterials.Iron).withAmountPerChunk(16).atHeight(16, 61).buildMaterial());
        event.smallOre(new WorldGenSmallOreBuilder().withMaterial(Materials.Lead).withAmountPerChunk(16).atHeight(16, 61).buildMaterial());
        event.smallOre(new WorldGenSmallOreBuilder().withMaterial(Materials.Zinc).withAmountPerChunk(12).atHeight(16, 96).buildMaterial());
        event.smallOre(new WorldGenSmallOreBuilder().withMaterial(AntimatterMaterials.Gold).withAmountPerChunk(8).atHeight(-34, 16).buildMaterial());
        event.smallOre(new WorldGenSmallOreBuilder().withMaterial(Materials.Silver).withAmountPerChunk(8).atHeight(-34, 16).buildMaterial());
        event.smallOre(new WorldGenSmallOreBuilder().withMaterial(Materials.Nickel).withAmountPerChunk(8).atHeight(-34, 16).buildMaterial());
        event.smallOre(new WorldGenSmallOreBuilder().withMaterial(AntimatterMaterials.Lapis).withAmountPerChunk(4).atHeight(-34, 16).buildMaterial());
        event.smallOre(new WorldGenSmallOreBuilder().withMaterial(AntimatterMaterials.Diamond).withAmountPerChunk(3).atHeight(-59, -52).buildMaterial());
        event.smallOre(new WorldGenSmallOreBuilder().withMaterial(AntimatterMaterials.Emerald).withAmountPerChunk(2).buildMaterial());
        event.smallOre(new WorldGenSmallOreBuilder().withMaterial(Materials.Ruby).withAmountPerChunk(2).buildMaterial());
        event.smallOre(new WorldGenSmallOreBuilder().withMaterial(Materials.Sapphire).withAmountPerChunk(2).buildMaterial());
        event.smallOre(new WorldGenSmallOreBuilder().withMaterial(Materials.GreenSapphire).withAmountPerChunk(2).buildMaterial());
        event.smallOre(new WorldGenSmallOreBuilder().withMaterial(Materials.Olivine).withAmountPerChunk(2).buildMaterial());
        event.smallOre(new WorldGenSmallOreBuilder().withMaterial(Materials.Topaz).withAmountPerChunk(2).buildMaterial());
        event.smallOre(new WorldGenSmallOreBuilder().withMaterial(Materials.Tanzanite).withAmountPerChunk(2).buildMaterial());
        event.smallOre(new WorldGenSmallOreBuilder().withMaterial(Materials.Amethyst).withAmountPerChunk(2).buildMaterial());
        event.smallOre(new WorldGenSmallOreBuilder().withMaterial(Materials.Opal).withAmountPerChunk(2).buildMaterial());
        event.smallOre(new WorldGenSmallOreBuilder().withMaterial(Materials.Jade).withAmountPerChunk(2).buildMaterial());
        event.smallOre(new WorldGenSmallOreBuilder().withMaterial(Materials.BlueTopaz).withAmountPerChunk(2).buildMaterial());
        event.smallOre(new WorldGenSmallOreBuilder().withMaterial(Materials.Amber).withAmountPerChunk(2).buildMaterial());
        event.smallOre(new WorldGenSmallOreBuilder().withMaterial(Materials.RedGarnet).withAmountPerChunk(2).buildMaterial());
        event.smallOre(new WorldGenSmallOreBuilder().withMaterial(Materials.YellowGarnet).withAmountPerChunk(2).buildMaterial());
        event.smallOre(new WorldGenSmallOreBuilder().withMaterial(AntimatterMaterials.Redstone).withAmountPerChunk(8).atHeight(-59, -34).buildMaterial());
        event.smallOre(new WorldGenSmallOreBuilder().withMaterial(Materials.Platinum).withAmountPerChunk(8).atHeight(20, 40).withDimensions(new ResourceLocation[]{new ResourceLocation("the_end")}).buildMaterial());
        event.smallOre(new WorldGenSmallOreBuilder().withMaterial(Materials.Iridium).withAmountPerChunk(8).atHeight(20, 40).withDimensions(new ResourceLocation[]{new ResourceLocation("the_end")}).buildMaterial());
        event.smallOre(new WorldGenSmallOreBuilder().withMaterial(AntimatterMaterials.Quartz).withAmountPerChunk(64).atHeight(30, 120).withDimensions(new ResourceLocation[]{new ResourceLocation("the_nether")}).buildMaterial());
        event.smallOre(new WorldGenSmallOreBuilder().withMaterial(Materials.Saltpeter).withAmountPerChunk(8).atHeight(10, 60).withDimensions(new ResourceLocation[]{new ResourceLocation("the_nether")}).buildMaterial());
        event.smallOre(new WorldGenSmallOreBuilder().withMaterial(Materials.Sulfur).withAmountPerChunk(32).atHeight(5, 60).withDimensions(new ResourceLocation[]{new ResourceLocation("the_nether")}).buildMaterial());
        event.smallOre(new WorldGenSmallOreBuilder().withMaterial(Materials.Sulfur).withAmountPerChunk(8).atHeight(-59, -34).withCustomId("sulfur_overworld").buildMaterial());
    }

    private static void initStoneVeins(WorldGenEvent ev) {
        ev.stoneLayer(new WorldGenStoneLayerBuilder("stone").withStone(AntimatterStoneTypes.STONE).withWeight(4).buildVein());
        ev.stoneLayer(new WorldGenStoneLayerBuilder("stone_ores_1").withStone(AntimatterStoneTypes.STONE).withWeight(4).buildVein());
        ev.stoneLayer(new WorldGenStoneLayerBuilder("stone_ores_2").withStone(AntimatterStoneTypes.STONE).withWeight(4).buildVein());
        ev.stoneLayer(new WorldGenStoneLayerBuilder("stone_ores_3").withStone(AntimatterStoneTypes.STONE).withWeight(4).buildVein());
        ev.stoneLayer(new WorldGenStoneLayerBuilder("stone_ores_4").withStone(AntimatterStoneTypes.STONE).withWeight(4).buildVein());
        ev.stoneLayer(new WorldGenStoneLayerBuilder("black_granite").withStone(GregTechData.GRANITE_BLACK).withWeight(2).buildVein());
        ev.stoneLayer(new WorldGenStoneLayerBuilder("black_granite_ores").withStone(GregTechData.GRANITE_BLACK).withWeight(1).addOres(new StoneLayerOre[]{new StoneLayerOre(Materials.Cooperite, 113400, -64, -32), new StoneLayerOre(Materials.Iridium, 56700, -64, -46)}).buildVein());
        ev.stoneLayer(new WorldGenStoneLayerBuilder("red_granite").withStone(GregTechData.GRANITE_RED).withWeight(2).buildVein());
        ev.stoneLayer(new WorldGenStoneLayerBuilder("red_granite_ores").withStone(GregTechData.GRANITE_RED).withWeight(1).addOres(new StoneLayerOre[]{new StoneLayerOre(Materials.Pitchblende, 113400, -32, 0), new StoneLayerOre(Materials.Uraninite, 113400, -32, 0), new StoneLayerOre(Materials.Tantalite, 226800, -32, 0)}).buildVein());
        ev.stoneLayer(new WorldGenStoneLayerBuilder("komatiite").withStone(GregTechData.KOMATIITE).withWeight(4).buildVein());
        ev.stoneLayer(new WorldGenStoneLayerBuilder("komatiite_ores").withStone(GregTechData.KOMATIITE).withWeight(1).addOres(new StoneLayerOre[]{new StoneLayerOre(Materials.Magnesite, 226800, -54, -9), new StoneLayerOre(Materials.Cinnabar, 302400, -64, -19), new StoneLayerOre(AntimatterMaterials.Redstone, 453600, -54, -9), new StoneLayerOre(Materials.Pyrite, 302400, 5, 66)}).buildVein());
        ev.stoneLayer(new WorldGenStoneLayerBuilder("basalt").withStone(AntimatterStoneTypes.BASALT).withWeight(3).buildVein());
        ev.stoneLayer(new WorldGenStoneLayerBuilder("basalt_ores").withStone(AntimatterStoneTypes.BASALT).withWeight(1).buildVein());
        ev.stoneLayer(new WorldGenStoneLayerBuilder("basalt_ores_2").withStone(AntimatterStoneTypes.BASALT).withWeight(1).buildVein());
        ev.stoneLayer(new WorldGenStoneLayerBuilder("marble").withStone(GregTechData.MARBLE).withWeight(4).buildVein());
        ev.stoneLayer(new WorldGenStoneLayerBuilder("marble_ores").withStone(GregTechData.MARBLE).withWeight(1).buildVein());
        ev.stoneLayer(new WorldGenStoneLayerBuilder("limestone").withStone(GregTechData.LIMESTONE).withWeight(3).buildVein());
        ev.stoneLayer(new WorldGenStoneLayerBuilder("limestone_ores").withStone(GregTechData.LIMESTONE).withWeight(1).buildVein());
        ev.stoneLayer(new WorldGenStoneLayerBuilder("limestone_ores_2").withStone(GregTechData.LIMESTONE).withWeight(1).buildVein());
        ev.stoneLayer(new WorldGenStoneLayerBuilder("green_schist").withStone(GregTechData.GREEN_SCHIST).withWeight(1).buildVein());
        ev.stoneLayer(new WorldGenStoneLayerBuilder("green_schist_ores").withStone(GregTechData.GREEN_SCHIST).withWeight(1).buildVein());
        ev.stoneLayer(new WorldGenStoneLayerBuilder("blue_schist").withStone(GregTechData.BLUE_SCHIST).withWeight(1).buildVein());
        ev.stoneLayer(new WorldGenStoneLayerBuilder("blue_schist_ores").withStone(GregTechData.BLUE_SCHIST).withWeight(1).buildVein());
        ev.stoneLayer(new WorldGenStoneLayerBuilder("kimberlite").withStone(GregTechData.KIMBERLITE).withWeight(3).buildVein());
        ev.stoneLayer(new WorldGenStoneLayerBuilder("kimberlite_ores").withStone(GregTechData.KIMBERLITE).withWeight(1).buildVein());
        ev.stoneLayer(new WorldGenStoneLayerBuilder("quartzite").withStone(GregTechData.QUARTZITE).withWeight(4).buildVein());
        ev.stoneLayer(new WorldGenStoneLayerBuilder("quartzite_ores").withStone(GregTechData.QUARTZITE).withWeight(1).buildVein());
        ev.stoneLayer(new WorldGenStoneLayerBuilder("granite").withStone(AntimatterStoneTypes.GRANITE).withWeight(3).buildVein());
        ev.stoneLayer(new WorldGenStoneLayerBuilder("granite_ores").withStone(AntimatterStoneTypes.GRANITE).withWeight(1).buildVein());
        ev.stoneLayer(new WorldGenStoneLayerBuilder("granite_ores").withStone(AntimatterStoneTypes.GRANITE).withWeight(1).buildVein());
        ev.stoneLayer(new WorldGenStoneLayerBuilder("diorite").withStone(AntimatterStoneTypes.DIORITE).withWeight(3).buildVein());
        ev.stoneLayer(new WorldGenStoneLayerBuilder("diorite_ores").withStone(AntimatterStoneTypes.DIORITE).withWeight(1).buildVein());
        ev.stoneLayer(new WorldGenStoneLayerBuilder("diorite_ores").withStone(AntimatterStoneTypes.DIORITE).withWeight(1).buildVein());
        ev.stoneLayer(new WorldGenStoneLayerBuilder("andesite").withStone(AntimatterStoneTypes.ANDESITE).withWeight(4).buildVein());
        ev.stoneLayer(new WorldGenStoneLayerBuilder("andesite_ores").withStone(AntimatterStoneTypes.ANDESITE).withWeight(1).buildVein());
        ev.stoneLayer(new WorldGenStoneLayerBuilder("andesite_ores").withStone(AntimatterStoneTypes.ANDESITE).withWeight(1).buildVein());
        ev.stoneLayer(new WorldGenStoneLayerBuilder("tuff").withStone(AntimatterStoneTypes.TUFF).withWeight(3).buildVein());
        ev.stoneLayer(new WorldGenStoneLayerBuilder("tuff_ores").withStone(AntimatterStoneTypes.TUFF).withWeight(1).buildVein());
        ev.stoneLayer(new WorldGenStoneLayerBuilder("tuff_ores").withStone(AntimatterStoneTypes.TUFF).withWeight(1).buildVein());
        ev.stoneLayer(new WorldGenStoneLayerBuilder("coal").withStone(((MaterialTypeBlock.IBlockGetter)AntimatterMaterialTypes.ORE_STONE.get()).get(AntimatterMaterials.Coal).asState()).withWeight(1).buildVein());
        ev.stoneLayer(new WorldGenStoneLayerBuilder("lignite").withStone(((MaterialTypeBlock.IBlockGetter)AntimatterMaterialTypes.ORE_STONE.get()).get(Materials.Lignite).asState()).withWeight(1).buildVein());
        ev.stoneLayer(new WorldGenStoneLayerBuilder("salt").withStone(((MaterialTypeBlock.IBlockGetter)AntimatterMaterialTypes.ORE_STONE.get()).get(Materials.Salt).asState()).withWeight(1).buildVein());
        ev.stoneLayer(new WorldGenStoneLayerBuilder("rock_salt").withStone(((MaterialTypeBlock.IBlockGetter)AntimatterMaterialTypes.ORE_STONE.get()).get(Materials.RockSalt).asState()).withWeight(1).buildVein());
        ev.stoneLayer(new WorldGenStoneLayerBuilder("bauxite").withStone(((MaterialTypeBlock.IBlockGetter)AntimatterMaterialTypes.ORE_STONE.get()).get(Materials.Bauxite).asState()).withWeight(1).buildVein());
        ev.stoneLayer(new WorldGenStoneLayerBuilder("oinanl_shale").withStone(((MaterialTypeBlock.IBlockGetter)AntimatterMaterialTypes.ORE_STONE.get()).get(Materials.OilShale).asState()).withWeight(1).buildVein());
        ev.addCollision(AntimatterStoneTypes.BASALT.getState(), GregTechData.LIMESTONE.getState(), new StoneLayerOre[]{new StoneLayerOre(Materials.Ilmenite, 453600, -64, 0), new StoneLayerOre(Materials.Rutile, 302400, -64, 0)});
    }

    private static void initStoneOreVeins(WorldGenEvent ev) {
    }

    private static void initOreVeins(WorldGenEvent ev) {
        ev.vein(new WorldGenVeinLayerBuilder("naquadah").asOreVein(10, 60, 10, 5, 32, Materials.Naquadah, Materials.Naquadah, Materials.Naquadah, Materials.Naquadah, new ResourceKey[]{Level.f_46430_}).buildVein());
        ev.vein(new WorldGenVeinLayerBuilder("lignite").asOreVein(0, 200, 160, 8, 32, Materials.Lignite, Materials.Lignite, Materials.Lignite, AntimatterMaterials.Coal, new ResourceKey[]{Level.f_46428_}).buildVein());
        ev.vein(new WorldGenVeinLayerBuilder("coal").asOreVein(0, 200, 80, 6, 32, AntimatterMaterials.Coal, AntimatterMaterials.Coal, AntimatterMaterials.Coal, Materials.Lignite, new ResourceKey[]{Level.f_46428_}).buildVein());
        ev.vein(new WorldGenVeinLayerBuilder("magnetite").asOreVein(-14, 91, 160, 3, 32, Materials.Magnetite, Materials.Magnetite, AntimatterMaterials.Iron, Materials.VanadiumMagnetite, new ResourceKey[]{Level.f_46428_, Level.f_46429_}).buildVein());
        ev.vein(new WorldGenVeinLayerBuilder("gold").asOreVein(-4, 26, 160, 3, 32, Materials.Magnetite, Materials.Magnetite, Materials.VanadiumMagnetite, AntimatterMaterials.Gold, new ResourceKey[]{Level.f_46428_}).buildVein());
        ev.vein(new WorldGenVeinLayerBuilder("iron").asOreVein(-14, 51, 120, 4, 24, Materials.BrownLimonite, Materials.YellowLimonite, Materials.BandedIron, Materials.Malachite, new ResourceKey[]{Level.f_46428_, Level.f_46429_}).buildVein());
        ev.vein(new WorldGenVeinLayerBuilder("cassiterite").asOreVein(6, 126, 50, 5, 24, Materials.Tin, Materials.Tin, Materials.Cassiterite, Materials.Tin, new ResourceKey[]{Level.f_46428_, Level.f_46430_}).buildVein());
        ev.vein(new WorldGenVeinLayerBuilder("tetrahedrite").asOreVein(51, 131, 70, 4, 24, Materials.Tetrahedrite, Materials.Tetrahedrite, AntimatterMaterials.Copper, Materials.Stibnite, new ResourceKey[]{Level.f_46428_, Level.f_46429_}).buildVein());
        ev.vein(new WorldGenVeinLayerBuilder("nether_quartz").asOreVein(40, 80, 80, 5, 24, AntimatterMaterials.Quartz, AntimatterMaterials.Quartz, AntimatterMaterials.Quartz, AntimatterMaterials.Quartz, new ResourceKey[]{Level.f_46429_}).buildVein());
        ev.vein(new WorldGenVeinLayerBuilder("sulfur").asOreVein(5, 20, 100, 5, 24, Materials.Sulfur, Materials.Sulfur, Materials.Pyrite, Materials.Sphalerite, new ResourceKey[]{Level.f_46429_}).buildVein());
        ev.vein(new WorldGenVeinLayerBuilder("copper").asOreVein(36, 66, 80, 4, 24, Materials.Chalcopyrite, AntimatterMaterials.Iron, Materials.Pyrite, AntimatterMaterials.Copper, new ResourceKey[]{Level.f_46428_, Level.f_46429_}).buildVein());
        ev.vein(new WorldGenVeinLayerBuilder("bauxite").asOreVein(-14, 46, 80, 4, 24, Materials.Bauxite, Materials.Bauxite, Materials.Aluminium, Materials.Ilmenite, new ResourceKey[]{Level.f_46428_}).buildVein());
        ev.vein(new WorldGenVeinLayerBuilder("salts").asOreVein(51, 66, 50, 3, 24, Materials.RockSalt, Materials.Salt, Materials.Lepidolite, Materials.Spodumene, new ResourceKey[]{Level.f_46428_}).buildVein());
        ev.vein(new WorldGenVeinLayerBuilder("redstone").asOreVein(-54, -9, 60, 3, 24, AntimatterMaterials.Redstone, AntimatterMaterials.Redstone, Materials.Ruby, Materials.Cinnabar, new ResourceKey[]{Level.f_46428_}).buildVein());
        ev.vein(new WorldGenVeinLayerBuilder("redstone_nether").asOreVein(10, 40, 60, 3, 24, AntimatterMaterials.Redstone, AntimatterMaterials.Redstone, Materials.Ruby, Materials.Cinnabar, new ResourceKey[]{Level.f_46429_}).buildVein());
        ev.vein(new WorldGenVeinLayerBuilder("soapstone").asOreVein(-54, -9, 40, 3, 16, Materials.Soapstone, Materials.Talc, Materials.Glauconite, Materials.Pentlandite, new ResourceKey[]{Level.f_46428_}).buildVein());
        ev.vein(new WorldGenVeinLayerBuilder("nickel").asOreVein(11, 56, 40, 3, 16, Materials.Garnierite, Materials.Nickel, Materials.Cobaltite, Materials.Pentlandite, new ResourceKey[]{Level.f_46428_, Level.f_46429_, Level.f_46430_}).buildVein());
        ev.vein(new WorldGenVeinLayerBuilder("platinum").asOreVein(-24, -9, 5, 3, 16, Materials.Cooperite, Materials.Palladium, Materials.Platinum, Materials.Iridium, new ResourceKey[]{Level.f_46428_}).buildVein());
        ev.vein(new WorldGenVeinLayerBuilder("platinum_end").asOreVein(40, 50, 5, 3, 16, Materials.Cooperite, Materials.Palladium, Materials.Platinum, Materials.Iridium, new ResourceKey[]{Level.f_46428_, Level.f_46430_}).buildVein());
        ev.vein(new WorldGenVeinLayerBuilder("pitchblend").asOreVein(-54, -9, 40, 3, 16, Materials.Pitchblende, Materials.Pitchblende, Materials.Uraninite, Materials.Uraninite, new ResourceKey[]{Level.f_46428_}).buildVein());
        ev.vein(new WorldGenVeinLayerBuilder("uranium").asOreVein(-44, -29, 20, 3, 16, Materials.Uraninite, Materials.Uraninite, Materials.Uranium, Materials.Uranium, new ResourceKey[]{Level.f_46428_}).buildVein());
        ev.vein(new WorldGenVeinLayerBuilder("monazite").asOreVein(-44, -14, 30, 3, 16, Materials.Bastnasite, Materials.Bastnasite, Materials.Monazite, Materials.Neodymium, new ResourceKey[]{Level.f_46428_}).buildVein());
        ev.vein(new WorldGenVeinLayerBuilder("molybdenum").asOreVein(-44, 1, 5, 3, 16, Materials.Wulfenite, Materials.Molybdenite, Materials.Molybdenum, Materials.Powellite, new ResourceKey[]{Level.f_46428_}).buildVein());
        ev.vein(new WorldGenVeinLayerBuilder("molybdenum_end").asOreVein(20, 50, 5, 3, 16, Materials.Wulfenite, Materials.Molybdenite, Materials.Molybdenum, Materials.Powellite, new ResourceKey[]{Level.f_46430_}).buildVein());
        ev.vein(new WorldGenVeinLayerBuilder("tungstate").asOreVein(-44, 1, 10, 3, 16, Materials.Scheelite, Materials.Scheelite, Materials.Tungstate, Materials.Lithium, new ResourceKey[]{Level.f_46428_}).buildVein());
        ev.vein(new WorldGenVeinLayerBuilder("tungstate_end").asOreVein(20, 50, 10, 3, 16, Materials.Scheelite, Materials.Scheelite, Materials.Tungstate, Materials.Lithium, new ResourceKey[]{Level.f_46430_}).buildVein());
        ev.vein(new WorldGenVeinLayerBuilder("sapphire").asOreVein(-54, -9, 60, 3, 16, Materials.Almandine, Materials.Pyrope, Materials.Sapphire, Materials.GreenSapphire, new ResourceKey[]{Level.f_46428_}).buildVein());
        ev.vein(new WorldGenVeinLayerBuilder("manganese").asOreVein(-44, -29, 20, 3, 16, Materials.Grossular, Materials.Spessartine, Materials.Pyrolusite, Materials.Tantalite, new ResourceKey[]{Level.f_46428_}).buildVein());
        ev.vein(new WorldGenVeinLayerBuilder("manganese_end").asOreVein(20, 30, 20, 3, 16, Materials.Grossular, Materials.Spessartine, Materials.Pyrolusite, Materials.Tantalite, new ResourceKey[]{Level.f_46430_}).buildVein());
        Material third = Materials.CertusQuartz.enabled ? Materials.CertusQuartz : Materials.Barite;
        ev.vein(new WorldGenVeinLayerBuilder("quartz").asOreVein(6, 66, 60, 3, 16, Materials.Quartzite, Materials.Barite, third, third, new ResourceKey[]{Level.f_46428_}).buildVein());
        ev.vein(new WorldGenVeinLayerBuilder("diamond").asOreVein(-59, -48, 40, 2, 16, Materials.Graphite, Materials.Graphite, AntimatterMaterials.Diamond, AntimatterMaterials.Coal, new ResourceKey[]{Level.f_46428_}).buildVein());
        ev.vein(new WorldGenVeinLayerBuilder("olivine").asOreVein(-54, -9, 60, 3, 16, Materials.Bentonite, Materials.Magnesite, Materials.Olivine, Materials.Glauconite, new ResourceKey[]{Level.f_46428_}).buildVein());
        ev.vein(new WorldGenVeinLayerBuilder("olivine_end").asOreVein(10, 40, 60, 3, 16, Materials.Bentonite, Materials.Magnesite, Materials.Olivine, Materials.Glauconite, new ResourceKey[]{Level.f_46430_}).buildVein());
        ev.vein(new WorldGenVeinLayerBuilder("apatite").asOreVein(-4, 41, 60, 3, 16, Materials.Apatite, Materials.Apatite, Materials.Phosphorus, Materials.Phosphate, new ResourceKey[]{Level.f_46428_}).buildVein());
        ev.vein(new WorldGenVeinLayerBuilder("galena").asOreVein(6, 51, 40, 5, 16, Materials.Galena, Materials.Galena, Materials.Silver, Materials.Lead, new ResourceKey[]{Level.f_46428_}).buildVein());
        ev.vein(new WorldGenVeinLayerBuilder("lapis").asOreVein(-44, 1, 40, 5, 16, Materials.Lazurite, Materials.Sodalite, AntimatterMaterials.Lapis, Materials.Calcite, new ResourceKey[]{Level.f_46428_}).buildVein());
        ev.vein(new WorldGenVeinLayerBuilder("lapis_end").asOreVein(20, 50, 40, 5, 16, Materials.Lazurite, Materials.Sodalite, AntimatterMaterials.Lapis, Materials.Calcite, new ResourceKey[]{Level.f_46430_}).buildVein());
        ev.vein(new WorldGenVeinLayerBuilder("beryllium").asOreVein(-59, -21, 30, 3, 16, Materials.Beryllium, Materials.Beryllium, AntimatterMaterials.Emerald, Materials.Thorium, new ResourceKey[]{Level.f_46428_}).buildVein());
        ev.vein(new WorldGenVeinLayerBuilder("beryllium_end").asOreVein(5, 30, 30, 3, 16, Materials.Beryllium, Materials.Beryllium, AntimatterMaterials.Emerald, Materials.Thorium, new ResourceKey[]{Level.f_46430_}).buildVein());
        ev.vein(new WorldGenVeinLayerBuilder("oilshale").asOreVein(-14, 31, 80, 6, 32, Materials.OilShale, Materials.OilShale, Materials.OilShale, Materials.OilShale, new ResourceKey[]{Level.f_46428_}).buildVein());
    }
}

