/*
 * Decompiled with CFR 0.152.
 */
package muramasa.gregtech.integration.rei;

import java.util.Arrays;
import java.util.List;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.EntryType;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.util.EntryStacks;
import muramasa.antimatter.data.AntimatterMaterialTypes;
import muramasa.antimatter.material.IMaterialTag;
import muramasa.antimatter.material.Material;
import muramasa.antimatter.material.MaterialTags;
import muramasa.gregtech.data.GregTechMaterialTags;
import muramasa.gregtech.integration.rei.OreProcessingCategory;
import net.minecraft.world.item.crafting.Ingredient;

public class OreProcessingDisplay
implements Display {
    Material ore;
    private final List<EntryIngredient> input;
    private final List<EntryIngredient> output;
    SepMode sepMode;
    BathingMode bathingMode;
    Material byProduct1;
    Material byProduct2;
    Material byProduct3;

    public OreProcessingDisplay(Material material, BathingMode bathingMode) {
        this.ore = material;
        this.bathingMode = bathingMode;
        this.sepMode = material.has(new IMaterialTag[]{GregTechMaterialTags.ELECSEPI}) ? SepMode.IRON : (material.has(new IMaterialTag[]{GregTechMaterialTags.ELECSEPG}) ? SepMode.GOLD : (material.has(new IMaterialTag[]{GregTechMaterialTags.ELECSEPN}) ? SepMode.NEODYMIUM : SepMode.NONE));
        this.input = OreProcessingDisplay.createInputEntries(List.of(AntimatterMaterialTypes.ORE.getMaterialIngredient(material, 1)));
        Material aOreByProduct1 = this.ore.getByProducts().size() >= 1 ? (Material)this.ore.getByProducts().get(0) : MaterialTags.MACERATE_INTO.getMapping(this.ore);
        Material aOreByProduct2 = this.ore.getByProducts().size() >= 2 ? (Material)this.ore.getByProducts().get(1) : aOreByProduct1;
        Material aOreByProduct3 = this.ore.getByProducts().size() >= 3 ? (Material)this.ore.getByProducts().get(2) : aOreByProduct2;
        this.byProduct1 = aOreByProduct1;
        this.byProduct2 = aOreByProduct2;
        this.byProduct3 = aOreByProduct3;
        this.output = List.of(EntryIngredient.of((EntryStack[])new EntryStack[]{EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)AntimatterMaterialTypes.DUST.get(material, 1)), EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)AntimatterMaterialTypes.DUST.get(this.byProduct1, 1)), EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)AntimatterMaterialTypes.DUST.get(this.byProduct2, 1)), EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)AntimatterMaterialTypes.DUST.get(this.byProduct3, 1))}));
    }

    public Material getOre() {
        return this.ore;
    }

    public static List<EntryIngredient> createInputEntries(List<Ingredient> input) {
        return input.stream().map(i -> Arrays.stream(i.m_43908_()).map(EntryStacks::of).toList()).map(EntryIngredient::of).toList();
    }

    public List<EntryIngredient> getInputEntries() {
        return this.input;
    }

    public List<EntryIngredient> getOutputEntries() {
        return this.output;
    }

    public CategoryIdentifier<?> getCategoryIdentifier() {
        return OreProcessingCategory.id;
    }

    public static enum BathingMode {
        NONE,
        MERCURY,
        PERSULFATE;

    }

    public static enum SepMode {
        NONE,
        IRON,
        GOLD,
        NEODYMIUM;

    }
}

