/*
 * Decompiled with CFR 0.152.
 */
package muramasa.gregtech.integration.rei;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.EntryType;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.api.common.util.EntryStacks;
import muramasa.antimatter.data.AntimatterMaterialTypes;
import muramasa.antimatter.data.AntimatterMaterials;
import muramasa.antimatter.integration.rei.REIUtils;
import muramasa.antimatter.machine.types.Machine;
import muramasa.antimatter.material.IMaterialTag;
import muramasa.antimatter.material.Material;
import muramasa.antimatter.material.MaterialTags;
import muramasa.gregtech.data.GregTechMaterialTags;
import muramasa.gregtech.data.Machines;
import muramasa.gregtech.data.Materials;
import muramasa.gregtech.integration.rei.OreProcessingDisplay;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;

public class OreProcessingCategory
implements DisplayCategory<OreProcessingDisplay> {
    protected static Renderer icon = EntryStacks.of((ItemLike)Items.f_41834_);
    private static final Component title = new TranslatableComponent("gti.rei.tooltip.ore.byproducts");
    static CategoryIdentifier<? extends OreProcessingDisplay> id = CategoryIdentifier.of((String)"gti", (String)"ore_byproducts");

    public CategoryIdentifier<? extends OreProcessingDisplay> getCategoryIdentifier() {
        return id;
    }

    public List<Widget> setupDisplay(OreProcessingDisplay display, Rectangle bounds) {
        ArrayList<Widget> widgets = new ArrayList<Widget>();
        widgets.add((Widget)Widgets.createRecipeBase((Rectangle)bounds));
        widgets.add(Widgets.createDrawableWidget((helper, matrices, mouseX, mouseY, delta) -> {
            OreProcessingCategory.drawTexture(matrices, new ResourceLocation("gti", "textures/gui/ore_byproducts/background.png"), bounds.x, bounds.y, 0, 0, bounds.getWidth(), bounds.getHeight());
            OreProcessingCategory.drawTexture(matrices, new ResourceLocation("gti", "textures/gui/ore_byproducts/base.png"), bounds.x, bounds.y, 0, 0, bounds.getWidth(), bounds.getHeight());
            if (display.bathingMode != OreProcessingDisplay.BathingMode.NONE) {
                OreProcessingCategory.drawTexture(matrices, new ResourceLocation("gti", "textures/gui/ore_byproducts/chem.png"), bounds.x, bounds.y, 0, 0, bounds.getWidth(), bounds.getHeight());
            }
            if (display.ore.has(new IMaterialTag[]{AntimatterMaterialTypes.GEM})) {
                OreProcessingCategory.drawTexture(matrices, new ResourceLocation("gti", "textures/gui/ore_byproducts/sift.png"), bounds.x, bounds.y, 0, 0, bounds.getWidth(), bounds.getHeight());
            }
            if (display.sepMode != OreProcessingDisplay.SepMode.NONE) {
                OreProcessingCategory.drawTexture(matrices, new ResourceLocation("gti", "textures/gui/ore_byproducts/sep.png"), bounds.x, bounds.y, 0, 0, bounds.getWidth(), bounds.getHeight());
            }
            if (!display.ore.has(new IMaterialTag[]{GregTechMaterialTags.NEEDS_BLAST_FURNACE})) {
                OreProcessingCategory.drawTexture(matrices, new ResourceLocation("gti", "textures/gui/ore_byproducts/smelt1.png"), bounds.x, bounds.y, 0, 0, bounds.getWidth(), bounds.getHeight());
            }
            if (display.ore.has(new IMaterialTag[]{AntimatterMaterialTypes.DUST}) && display.ore.has(new IMaterialTag[]{AntimatterMaterialTypes.INGOT})) {
                OreProcessingCategory.drawTexture(matrices, new ResourceLocation("gti", "textures/gui/ore_byproducts/smelt2.png"), bounds.x, bounds.y, 0, 0, bounds.getWidth(), bounds.getHeight());
            }
            if (display.ore.has(new IMaterialTag[]{GregTechMaterialTags.NEEDS_BLAST_FURNACE}) && display.ore.has(new IMaterialTag[]{AntimatterMaterialTypes.INGOT_HOT})) {
                OreProcessingCategory.drawTexture(matrices, new ResourceLocation("gti", "textures/gui/ore_byproducts/vac.png"), bounds.x, bounds.y, 0, 0, bounds.getWidth(), bounds.getHeight());
            }
        }));
        widgets.addAll(this.setupSlots(display, bounds));
        return widgets;
    }

    private List<Widget> setupSlots(OreProcessingDisplay display, Rectangle bounds) {
        ArrayList<Widget> widgets = new ArrayList<Widget>();
        widgets.add((Widget)Widgets.createSlot((Point)this.xy(4, 4, bounds)).entries((Collection)EntryIngredients.ofIngredient((Ingredient)AntimatterMaterialTypes.ORE.getMaterialIngredient(display.ore, 1))).markInput().disableBackground());
        widgets.addAll(this.setupBaseMachineSlots(display, bounds));
        if (!display.ore.has(new IMaterialTag[]{GregTechMaterialTags.NEEDS_BLAST_FURNACE})) {
            widgets.addAll(this.setupPrimaryFurnaceSlot(display, bounds));
        }
        if (display.ore.has(new IMaterialTag[]{AntimatterMaterialTypes.INGOT})) {
            widgets.addAll(this.setupSecondaryFurnaceSlots(display, bounds));
        }
        if (display.bathingMode != OreProcessingDisplay.BathingMode.NONE) {
            widgets.addAll(this.setupChemMachineSlots(display, bounds));
        }
        if (display.ore.has(new IMaterialTag[]{AntimatterMaterialTypes.GEM})) {
            widgets.addAll(this.setupSiftMachineSlots(display, bounds));
        }
        if (display.sepMode != OreProcessingDisplay.SepMode.NONE) {
            widgets.addAll(this.setupSepMachineSlots(display, bounds));
        }
        if (display.ore.has(new IMaterialTag[]{AntimatterMaterialTypes.INGOT_HOT})) {
            widgets.addAll(this.setupVacMachineSlots(display, bounds));
        }
        return widgets;
    }

    private List<Widget> setupPrimaryFurnaceSlot(OreProcessingDisplay display, Rectangle bounds) {
        if (!(MaterialTags.SMELT_INTO.getMapping(display.ore).has(new IMaterialTag[]{AntimatterMaterialTypes.INGOT}) || MaterialTags.SMELT_INTO.getMapping(display.ore).has(new IMaterialTag[]{AntimatterMaterialTypes.GEM}) || MaterialTags.SMELT_INTO.getMapping(display.ore).has(new IMaterialTag[]{AntimatterMaterialTypes.DUST}))) {
            return List.of();
        }
        if (display.ore.has(new IMaterialTag[]{GregTechMaterialTags.NEEDS_BLAST_FURNACE})) {
            return List.of();
        }
        if (MaterialTags.SMELT_INTO.getMapping(display.ore).has(new IMaterialTag[]{AntimatterMaterialTypes.INGOT}) && !MaterialTags.SMELT_INTO.getMapping(display.ore).has(new IMaterialTag[]{AntimatterMaterialTypes.GEM})) {
            Item ingot = AntimatterMaterialTypes.INGOT.get(MaterialTags.SMELT_INTO.getMapping(display.ore));
            return List.of(Widgets.createSlot((Point)this.xy(50, 4, bounds)).entries(List.of(EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)new ItemStack((ItemLike)ingot, MaterialTags.SMELTING_MULTI.getInt(display.ore))))).markOutput().disableBackground());
        }
        if (!MaterialTags.SMELT_INTO.getMapping(display.ore).has(new IMaterialTag[]{AntimatterMaterialTypes.INGOT}) && MaterialTags.SMELT_INTO.getMapping(display.ore).has(new IMaterialTag[]{AntimatterMaterialTypes.GEM})) {
            Item gem = AntimatterMaterialTypes.GEM.get(MaterialTags.SMELT_INTO.getMapping(display.ore));
            return List.of(Widgets.createSlot((Point)this.xy(50, 4, bounds)).entries(List.of(EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)new ItemStack((ItemLike)gem, MaterialTags.SMELTING_MULTI.getInt(display.ore))))).markOutput().disableBackground());
        }
        if (!MaterialTags.SMELT_INTO.getMapping(display.ore).has(new IMaterialTag[]{AntimatterMaterialTypes.INGOT}) && !MaterialTags.SMELT_INTO.getMapping(display.ore).has(new IMaterialTag[]{AntimatterMaterialTypes.GEM}) && MaterialTags.SMELT_INTO.getMapping(display.ore).has(new IMaterialTag[]{AntimatterMaterialTypes.DUST})) {
            Item dust = AntimatterMaterialTypes.DUST.get(MaterialTags.SMELT_INTO.getMapping(display.ore));
            return List.of(Widgets.createSlot((Point)this.xy(50, 4, bounds)).entries(List.of(EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)new ItemStack((ItemLike)dust, MaterialTags.SMELTING_MULTI.getInt(display.ore))))).markOutput().disableBackground());
        }
        return List.of();
    }

    private List<Widget> setupSecondaryFurnaceSlots(OreProcessingDisplay display, Rectangle bounds) {
        ArrayList<Widget> widgets = new ArrayList<Widget>();
        if (display.ore.has(new IMaterialTag[]{GregTechMaterialTags.NEEDS_BLAST_FURNACE})) {
            widgets.add((Widget)Widgets.createSlot((Point)this.xy(122, 111, bounds)).entries((Collection)this.ofMachine((Machine<?>)Machines.BLAST_FURNACE, new Item[0])).markOutput().disableBackground());
            widgets.add((Widget)Widgets.createSlot((Point)this.xy(72, 146, bounds)).entries((Collection)this.ofMachine((Machine<?>)Machines.BLAST_FURNACE, new Item[0])).markOutput().disableBackground());
            if (display.ore.has(new IMaterialTag[]{AntimatterMaterialTypes.INGOT_HOT})) {
                widgets.add((Widget)Widgets.createSlot((Point)this.xy(97, 146, bounds)).entries(List.of(EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)new ItemStack((ItemLike)AntimatterMaterialTypes.INGOT_HOT.get(display.ore), 1)))).markOutput().disableBackground());
            } else {
                widgets.add((Widget)Widgets.createSlot((Point)this.xy(97, 146, bounds)).entries(List.of(EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)new ItemStack((ItemLike)AntimatterMaterialTypes.INGOT.get(display.ore), 1)))).markOutput().disableBackground());
            }
        } else {
            widgets.add((Widget)Widgets.createSlot((Point)this.xy(122, 111, bounds)).entries((Collection)EntryIngredient.of((EntryStack[])new EntryStack[]{EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)new ItemStack((ItemLike)Items.f_41962_)), EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)new ItemStack((ItemLike)Items.f_42770_))})).markInput().disableBackground());
            widgets.add((Widget)Widgets.createSlot((Point)this.xy(72, 146, bounds)).entries((Collection)EntryIngredient.of((EntryStack[])new EntryStack[]{EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)new ItemStack((ItemLike)Items.f_41962_)), EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)new ItemStack((ItemLike)Items.f_42770_))})).markInput().disableBackground());
            widgets.add((Widget)Widgets.createSlot((Point)this.xy(97, 146, bounds)).entries(List.of(EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)new ItemStack((ItemLike)AntimatterMaterialTypes.INGOT.get(display.ore), 1)))).markOutput().disableBackground());
        }
        return widgets;
    }

    private List<Widget> setupBaseMachineSlots(OreProcessingDisplay display, Rectangle bounds) {
        ArrayList<Widget> widgets = new ArrayList<Widget>();
        widgets.add((Widget)Widgets.createSlot((Point)this.xy(4, 26, bounds)).entries((Collection)this.ofMachine((Machine<?>)Machines.MACERATOR, new Item[0])).markInput().disableBackground());
        widgets.add((Widget)Widgets.createSlot((Point)this.xy(4, 48, bounds)).entries(List.of(EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)AntimatterMaterialTypes.CRUSHED.get(display.ore, 2 * MaterialTags.ORE_MULTI.getInt(display.ore))))).markOutput().disableBackground());
        widgets.add((Widget)Widgets.createSlot((Point)this.xy(4, 66, bounds)).entries(List.of(EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)new ItemStack((ItemLike)AntimatterMaterialTypes.DUST.get(display.byProduct1), 1)))).markOutput().disableBackground());
        widgets.add((Widget)Widgets.createSlot((Point)this.xy(25, 72, bounds)).entries((Collection)this.ofMachine((Machine<?>)Machines.MACERATOR, new Item[0])).markInput().disableBackground());
        widgets.add((Widget)Widgets.createSlot((Point)this.xy(25, 93, bounds)).entries(List.of(EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)AntimatterMaterialTypes.DUST_IMPURE.get(display.ore, 1)))).markOutput().disableBackground());
        widgets.add((Widget)Widgets.createSlot((Point)this.xy(25, 111, bounds)).entries(List.of(EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)new ItemStack((ItemLike)AntimatterMaterialTypes.DUST.get(display.byProduct1), 1)))).markOutput().disableBackground());
        widgets.add((Widget)Widgets.createSlot((Point)this.xy(29, 26, bounds)).entries((Collection)this.ofMachine((Machine<?>)Machines.ORE_WASHER, new Item[0])).markInput().disableBackground());
        widgets.add((Widget)Widgets.createSlot((Point)this.xy(50, 26, bounds)).entries((Collection)this.ofFluid(AntimatterMaterials.Water, 1000)).markInput().disableBackground());
        widgets.add((Widget)Widgets.createSlot((Point)this.xy(72, 26, bounds)).entries(List.of(EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)AntimatterMaterialTypes.CRUSHED_PURIFIED.get(display.ore, 1)))).markOutput().disableBackground());
        widgets.add((Widget)Widgets.createSlot((Point)this.xy(90, 26, bounds)).entries(List.of(EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)new ItemStack((ItemLike)AntimatterMaterialTypes.DUST_TINY.get(display.byProduct1), 3)))).markOutput().disableBackground());
        widgets.add((Widget)Widgets.createSlot((Point)this.xy(120, 48, bounds)).entries((Collection)this.ofMachine((Machine<?>)Machines.MACERATOR, new Item[0])).markInput().disableBackground());
        widgets.add((Widget)Widgets.createSlot((Point)this.xy(148, 48, bounds)).entries(List.of(EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)AntimatterMaterialTypes.DUST_PURE.get(display.ore, 1)))).markOutput().disableBackground());
        widgets.add((Widget)Widgets.createSlot((Point)this.xy(166, 48, bounds)).entries(List.of(EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)new ItemStack((ItemLike)AntimatterMaterialTypes.DUST.get(display.byProduct2), 1)))).markOutput().disableBackground());
        widgets.add((Widget)Widgets.createSlot((Point)this.xy(97, 72, bounds)).entries((Collection)this.ofMachine((Machine<?>)Machines.THERMAL_CENTRIFUGE, new Item[0])).markInput().disableBackground());
        widgets.add((Widget)Widgets.createSlot((Point)this.xy(97, 93, bounds)).entries(List.of(EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)AntimatterMaterialTypes.CRUSHED_REFINED.get(display.ore, 1)))).markOutput().disableBackground());
        widgets.add((Widget)Widgets.createSlot((Point)this.xy(97, 111, bounds)).entries(List.of(EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)new ItemStack((ItemLike)AntimatterMaterialTypes.DUST_TINY.get(display.byProduct2), 3)))).markOutput().disableBackground());
        widgets.add((Widget)Widgets.createSlot((Point)this.xy(148, 72, bounds)).entries((Collection)this.ofMachine((Machine<?>)Machines.CENTRIFUGE, new Item[0])).markInput().disableBackground());
        widgets.add((Widget)Widgets.createSlot((Point)this.xy(148, 93, bounds)).entries(List.of(EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)AntimatterMaterialTypes.DUST.get(display.ore, 1)))).markOutput().disableBackground());
        widgets.add((Widget)Widgets.createSlot((Point)this.xy(148, 111, bounds)).entries(List.of(EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)new ItemStack((ItemLike)AntimatterMaterialTypes.DUST_TINY.get(display.byProduct2), 1)))).markOutput().disableBackground());
        widgets.add((Widget)Widgets.createSlot((Point)this.xy(50, 81, bounds)).entries((Collection)this.ofMachine((Machine<?>)Machines.CENTRIFUGE, new Item[0])).markInput().disableBackground());
        widgets.add((Widget)Widgets.createSlot((Point)this.xy(50, 102, bounds)).entries(List.of(EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)AntimatterMaterialTypes.DUST.get(display.ore, 1)))).markOutput().disableBackground());
        widgets.add((Widget)Widgets.createSlot((Point)this.xy(50, 120, bounds)).entries(List.of(EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)new ItemStack((ItemLike)AntimatterMaterialTypes.DUST_TINY.get(display.byProduct1), 1)))).markOutput().disableBackground());
        widgets.add((Widget)Widgets.createSlot((Point)this.xy(72, 81, bounds)).entries((Collection)this.ofMachine((Machine<?>)Machines.MACERATOR, new Item[0])).markInput().disableBackground());
        widgets.add((Widget)Widgets.createSlot((Point)this.xy(72, 102, bounds)).entries(List.of(EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)AntimatterMaterialTypes.DUST.get(display.ore, 1)))).markOutput().disableBackground());
        widgets.add((Widget)Widgets.createSlot((Point)this.xy(72, 120, bounds)).entries(List.of(EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)new ItemStack((ItemLike)AntimatterMaterialTypes.DUST.get(display.byProduct3), 1)))).markOutput().disableBackground());
        widgets.add((Widget)Widgets.createSlot((Point)this.xy(4, 128, bounds)).entries((Collection)this.ofMachine((Machine<?>)Machines.ORE_WASHER, Items.f_42544_)).markInput().disableBackground());
        widgets.add((Widget)Widgets.createSlot((Point)this.xy(25, 146, bounds)).entries(List.of(EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)AntimatterMaterialTypes.DUST.get(display.ore, 1)))).markOutput().disableBackground());
        return widgets;
    }

    private List<Widget> setupChemMachineSlots(OreProcessingDisplay display, Rectangle bounds) {
        ArrayList<Widget> widgets = new ArrayList<Widget>();
        widgets.add((Widget)Widgets.createSlot((Point)this.xy(29, 48, bounds)).entries((Collection)this.ofMachine((Machine<?>)Machines.CHEMICAL_BATH, new Item[0])).markInput().disableBackground());
        if (display.bathingMode == OreProcessingDisplay.BathingMode.MERCURY) {
            widgets.add((Widget)Widgets.createSlot((Point)this.xy(50, 48, bounds)).entries((Collection)this.ofFluid(Materials.Mercury, 1000)).markInput().disableBackground());
            widgets.add((Widget)Widgets.createSlot((Point)this.xy(90, 48, bounds)).entries(List.of(EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)new ItemStack((ItemLike)AntimatterMaterialTypes.DUST.get(GregTechMaterialTags.CHEMBATH_MERCURY.getMapping(display.ore)), 1)))).markOutput().disableBackground());
        } else {
            widgets.add((Widget)Widgets.createSlot((Point)this.xy(50, 48, bounds)).entries((Collection)this.ofFluid(Materials.SodiumPersulfate, 1000)).markInput().disableBackground());
            widgets.add((Widget)Widgets.createSlot((Point)this.xy(90, 48, bounds)).entries(List.of(EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)new ItemStack((ItemLike)AntimatterMaterialTypes.DUST.get(GregTechMaterialTags.CHEMBATH_PERSULFATE.getMapping(display.ore)), 1)))).markOutput().disableBackground());
        }
        widgets.add((Widget)Widgets.createSlot((Point)this.xy(72, 48, bounds)).entries(List.of(EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)new ItemStack((ItemLike)AntimatterMaterialTypes.CRUSHED_PURIFIED.get(display.ore), 1)))).markOutput().disableBackground());
        return widgets;
    }

    private List<Widget> setupSiftMachineSlots(OreProcessingDisplay display, Rectangle bounds) {
        ArrayList<Widget> widgets = new ArrayList<Widget>();
        widgets.add((Widget)Widgets.createSlot((Point)this.xy(110, 25, bounds)).entries((Collection)this.ofMachine((Machine<?>)Machines.SIFTER, new Item[0])).markInput().disableBackground());
        boolean e = display.ore.has(new IMaterialTag[]{AntimatterMaterialTypes.GEM_EXQUISITE});
        widgets.add((Widget)Widgets.createSlot((Point)this.xy(130, 4, bounds)).entries(List.of(EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)new ItemStack((ItemLike)(e ? AntimatterMaterialTypes.GEM_EXQUISITE.get(display.ore) : AntimatterMaterialTypes.GEM.get(display.ore)), 1)))).markOutput().disableBackground());
        widgets.add((Widget)Widgets.createSlot((Point)this.xy(148, 4, bounds)).entries(List.of(EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)new ItemStack((ItemLike)(e ? AntimatterMaterialTypes.GEM_FLAWLESS.get(display.ore) : AntimatterMaterialTypes.GEM.get(display.ore)), 1)))).markOutput().disableBackground());
        widgets.add((Widget)Widgets.createSlot((Point)this.xy(130, 22, bounds)).entries(List.of(EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)new ItemStack((ItemLike)(e ? AntimatterMaterialTypes.GEM_FLAWED.get(display.ore) : AntimatterMaterialTypes.GEM.get(display.ore)), 1)))).markOutput().disableBackground());
        widgets.add((Widget)Widgets.createSlot((Point)this.xy(148, 22, bounds)).entries(List.of(EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)new ItemStack((ItemLike)(e ? AntimatterMaterialTypes.GEM_CHIPPED.get(display.ore) : AntimatterMaterialTypes.GEM.get(display.ore)), 1)))).markOutput().disableBackground());
        widgets.add((Widget)Widgets.createSlot((Point)this.xy(166, 4, bounds)).entries(List.of(EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)new ItemStack((ItemLike)AntimatterMaterialTypes.GEM.get(display.ore), 1)))).markOutput().disableBackground());
        widgets.add((Widget)Widgets.createSlot((Point)this.xy(166, 22, bounds)).entries(List.of(EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)new ItemStack((ItemLike)AntimatterMaterialTypes.DUST.get(display.ore), 1)))).markOutput().disableBackground());
        return widgets;
    }

    private List<Widget> setupSepMachineSlots(OreProcessingDisplay display, Rectangle bounds) {
        Item nugget;
        Item dust;
        ArrayList<Widget> widgets = new ArrayList<Widget>();
        if (display.sepMode == OreProcessingDisplay.SepMode.IRON) {
            dust = AntimatterMaterialTypes.DUST_SMALL.get(AntimatterMaterials.Iron);
            nugget = AntimatterMaterialTypes.NUGGET.get(AntimatterMaterials.Iron);
        } else if (display.sepMode == OreProcessingDisplay.SepMode.GOLD) {
            dust = AntimatterMaterialTypes.DUST_SMALL.get(AntimatterMaterials.Gold);
            nugget = AntimatterMaterialTypes.NUGGET.get(AntimatterMaterials.Gold);
        } else {
            dust = AntimatterMaterialTypes.DUST_SMALL.get(Materials.Neodymium);
            nugget = AntimatterMaterialTypes.NUGGET.get(Materials.Neodymium);
        }
        widgets.add((Widget)Widgets.createSlot((Point)this.xy(166, 72, bounds)).entries((Collection)this.ofMachine((Machine<?>)Machines.ELECTROMAGNETIC_SEPARATOR, new Item[0])).markInput().disableBackground());
        widgets.add((Widget)Widgets.createSlot((Point)this.xy(166, 93, bounds)).entries(List.of(EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)new ItemStack((ItemLike)AntimatterMaterialTypes.DUST.get(display.ore), 1)))).markOutput().disableBackground());
        widgets.add((Widget)Widgets.createSlot((Point)this.xy(166, 111, bounds)).entries(List.of(EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)new ItemStack((ItemLike)dust, 2)))).markOutput().disableBackground());
        widgets.add((Widget)Widgets.createSlot((Point)this.xy(166, 129, bounds)).entries(List.of(EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)new ItemStack((ItemLike)nugget, 1)))).markOutput().disableBackground());
        return widgets;
    }

    private List<Widget> setupVacMachineSlots(OreProcessingDisplay display, Rectangle bounds) {
        ArrayList<Widget> widgets = new ArrayList<Widget>();
        widgets.add((Widget)Widgets.createSlot((Point)this.xy(123, 146, bounds)).entries((Collection)this.ofMachine((Machine<?>)Machines.VACUUM_FREEZER, new Item[0])).markInput().disableBackground());
        widgets.add((Widget)Widgets.createSlot((Point)this.xy(148, 146, bounds)).entries(List.of(EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)new ItemStack((ItemLike)AntimatterMaterialTypes.INGOT.get(display.ore), 1)))).markOutput().disableBackground());
        return widgets;
    }

    private Point xy(int x, int y, Rectangle bounds) {
        int offsetX = 0;
        int offsetY = 0;
        return new Point(offsetX + x + bounds.x, offsetY + y + bounds.y);
    }

    private EntryIngredient ofMachine(Machine<?> machine, Item ... extra) {
        ArrayList<EntryStack> stacks = new ArrayList<EntryStack>();
        machine.getTiers().forEach(t -> stacks.add(EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)new ItemStack((ItemLike)machine.getItem(t)))));
        for (Item item : extra) {
            stacks.add(EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)new ItemStack((ItemLike)item)));
        }
        return EntryIngredient.of(stacks);
    }

    private EntryIngredient ofFluid(Material fluid, int amount) {
        ArrayList<EntryStack> stacks = new ArrayList<EntryStack>();
        FluidStack stack = fluid.has(new IMaterialTag[]{AntimatterMaterialTypes.LIQUID}) ? fluid.getLiquid(amount) : fluid.getGas(amount);
        stacks.add(EntryStack.of((EntryType)VanillaEntryTypes.FLUID, (Object)REIUtils.toREIFLuidStack((FluidStack)stack)));
        return EntryIngredient.of(stacks);
    }

    private static void drawTexture(PoseStack stack, ResourceLocation loc, int left, int top, int x, int y, int sizeX, int sizeY) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)loc);
        GuiComponent.m_93143_((PoseStack)stack, (int)left, (int)top, (int)0, (float)x, (float)y, (int)sizeX, (int)sizeY, (int)186, (int)166);
    }

    public Component getTitle() {
        return title;
    }

    public Renderer getIcon() {
        return icon;
    }

    public int getDisplayHeight() {
        return 166;
    }

    public int getDisplayWidth(OreProcessingDisplay display) {
        return 186;
    }
}

