/*
 * Decompiled with CFR 0.152.
 */
package muramasa.gregtech.integration.rei;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.EntryType;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.util.EntryStacks;
import muramasa.antimatter.AntimatterAPI;
import muramasa.antimatter.data.AntimatterMaterialTypes;
import muramasa.antimatter.integration.rei.REIUtils;
import muramasa.antimatter.material.IMaterialTag;
import muramasa.antimatter.material.Material;
import muramasa.antimatter.material.MaterialTags;
import muramasa.antimatter.material.MaterialTypeBlock;
import muramasa.antimatter.pipe.PipeItemBlock;
import muramasa.antimatter.pipe.PipeSize;
import muramasa.antimatter.pipe.types.Cable;
import muramasa.antimatter.pipe.types.FluidPipe;
import muramasa.antimatter.pipe.types.ItemPipe;
import muramasa.antimatter.pipe.types.PipeType;
import muramasa.antimatter.pipe.types.Wire;
import muramasa.gregtech.integration.rei.MaterialTreeCategory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;

public class MaterialTreeDisplay
implements Display {
    Material mat;
    private List<EntryIngredient> input;
    private List<EntryIngredient> output;

    public MaterialTreeDisplay(Material material) {
        FluidPipe pipe;
        this.mat = material;
        this.input = MaterialTreeDisplay.createInputEntries(List.of(AntimatterMaterialTypes.DUST.getMaterialIngredient(material, 1)));
        this.output = new ArrayList<EntryIngredient>();
        if (this.mat.has(new IMaterialTag[]{AntimatterMaterialTypes.LIQUID})) {
            this.output.add(EntryIngredient.of((EntryStack)EntryStack.of((EntryType)VanillaEntryTypes.FLUID, (Object)REIUtils.toREIFLuidStack((FluidStack)this.mat.getLiquid(1000)))));
        }
        if (this.mat.has(new IMaterialTag[]{AntimatterMaterialTypes.DUST_SMALL})) {
            this.output.add(EntryIngredient.of((EntryStack)EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)new ItemStack((ItemLike)AntimatterMaterialTypes.DUST_SMALL.get(this.mat), 1))));
        }
        if (this.mat.has(new IMaterialTag[]{AntimatterMaterialTypes.DUST_TINY})) {
            this.output.add(EntryIngredient.of((EntryStack)EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)new ItemStack((ItemLike)AntimatterMaterialTypes.DUST_TINY.get(this.mat), 1))));
        }
        if (this.mat.has(new IMaterialTag[]{AntimatterMaterialTypes.INGOT})) {
            this.output.add(EntryIngredient.of((EntryStack)EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)new ItemStack((ItemLike)AntimatterMaterialTypes.INGOT.get(this.mat), 1))));
        }
        if (this.mat.has(new IMaterialTag[]{AntimatterMaterialTypes.BLOCK})) {
            this.output.add(EntryIngredient.of((EntryStack)EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)((MaterialTypeBlock.IBlockGetter)AntimatterMaterialTypes.BLOCK.get()).get(this.mat).asStack(1))));
        }
        if (this.mat.has(new IMaterialTag[]{AntimatterMaterialTypes.NUGGET})) {
            this.output.add(EntryIngredient.of((EntryStack)EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)new ItemStack((ItemLike)AntimatterMaterialTypes.NUGGET.get(this.mat), 1))));
        }
        if (this.mat.has(new IMaterialTag[]{AntimatterMaterialTypes.PLATE})) {
            this.output.add(EntryIngredient.of((EntryStack)EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)new ItemStack((ItemLike)AntimatterMaterialTypes.PLATE.get(this.mat), 1))));
        }
        if (this.mat.has(new IMaterialTag[]{AntimatterMaterialTypes.PLATE_DENSE})) {
            this.output.add(EntryIngredient.of((EntryStack)EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)new ItemStack((ItemLike)AntimatterMaterialTypes.PLATE_DENSE.get(this.mat), 1))));
        }
        if (this.mat.has(new IMaterialTag[]{AntimatterMaterialTypes.GEAR})) {
            this.output.add(EntryIngredient.of((EntryStack)EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)new ItemStack((ItemLike)AntimatterMaterialTypes.GEAR.get(this.mat), 1))));
        }
        if (this.mat.has(new IMaterialTag[]{AntimatterMaterialTypes.GEAR_SMALL})) {
            this.output.add(EntryIngredient.of((EntryStack)EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)new ItemStack((ItemLike)AntimatterMaterialTypes.GEAR_SMALL.get(this.mat), 1))));
        }
        if (this.mat.has(new IMaterialTag[]{AntimatterMaterialTypes.ROD})) {
            this.output.add(EntryIngredient.of((EntryStack)EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)new ItemStack((ItemLike)AntimatterMaterialTypes.ROD.get(this.mat), 1))));
        }
        if (this.mat.has(new IMaterialTag[]{AntimatterMaterialTypes.ROD_LONG})) {
            this.output.add(EntryIngredient.of((EntryStack)EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)new ItemStack((ItemLike)AntimatterMaterialTypes.ROD_LONG.get(this.mat), 1))));
        }
        if (this.mat.has(new IMaterialTag[]{AntimatterMaterialTypes.RING})) {
            this.output.add(EntryIngredient.of((EntryStack)EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)new ItemStack((ItemLike)AntimatterMaterialTypes.RING.get(this.mat), 1))));
        }
        if (this.mat.has(new IMaterialTag[]{AntimatterMaterialTypes.BOLT})) {
            this.output.add(EntryIngredient.of((EntryStack)EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)new ItemStack((ItemLike)AntimatterMaterialTypes.BOLT.get(this.mat), 1))));
        }
        if (this.mat.has(new IMaterialTag[]{AntimatterMaterialTypes.SCREW})) {
            this.output.add(EntryIngredient.of((EntryStack)EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)new ItemStack((ItemLike)AntimatterMaterialTypes.SCREW.get(this.mat), 1))));
        }
        if (this.mat.has(new IMaterialTag[]{MaterialTags.WIRE})) {
            PipeItemBlock wireItem = ((Wire)AntimatterAPI.get(Wire.class, (String)("wire_" + this.mat.getId()))).getBlockItem(PipeSize.VTINY);
            this.output.add(EntryIngredient.of((EntryStack)EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)new ItemStack((ItemLike)wireItem))));
        }
        if (this.mat.has(new IMaterialTag[]{MaterialTags.CABLE})) {
            PipeItemBlock cableItem = ((Cable)AntimatterAPI.get(Cable.class, (String)("cable_" + this.mat.getId()))).getBlockItem(PipeSize.VTINY);
            this.output.add(EntryIngredient.of((EntryStack)EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)new ItemStack((ItemLike)cableItem))));
        }
        if (this.mat.has(new IMaterialTag[]{AntimatterMaterialTypes.WIRE_FINE})) {
            this.output.add(EntryIngredient.of((EntryStack)EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)new ItemStack((ItemLike)AntimatterMaterialTypes.WIRE_FINE.get(this.mat), 1))));
        }
        if (this.mat.has(new IMaterialTag[]{MaterialTags.FLUIDPIPE}) && (pipe = (FluidPipe)AntimatterAPI.get(FluidPipe.class, (String)("fluid_pipe_" + this.mat.getId()))) != null) {
            pipe.getSizes().forEach(s -> this.addPipe((PipeType<?>)pipe, (PipeSize)s));
        }
        if (this.mat.has(new IMaterialTag[]{MaterialTags.ITEMPIPE}) && (pipe = (ItemPipe)AntimatterAPI.get(ItemPipe.class, (String)("item_pipe_" + this.mat.getId()))) != null) {
            pipe.getSizes().forEach(arg_0 -> this.lambda$new$1((ItemPipe)pipe, arg_0));
        }
    }

    private void addPipe(PipeType<?> type, PipeSize size) {
        this.output.add(EntryIngredient.of((EntryStack)EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)new ItemStack((ItemLike)type.getBlockItem(size)))));
    }

    public Material getMat() {
        return this.mat;
    }

    public static List<EntryIngredient> createInputEntries(List<Ingredient> input) {
        return input.stream().map(i -> Arrays.stream(i.m_43908_()).map(EntryStacks::of).toList()).map(EntryIngredient::of).toList();
    }

    public List<EntryIngredient> getInputEntries() {
        return this.input;
    }

    public List<EntryIngredient> getOutputEntries() {
        return this.output;
    }

    public CategoryIdentifier<?> getCategoryIdentifier() {
        return MaterialTreeCategory.id;
    }

    private /* synthetic */ void lambda$new$1(ItemPipe pipe, PipeSize s) {
        this.addPipe((PipeType<?>)pipe, s);
    }
}

