/*
 * Decompiled with CFR 0.152.
 */
package muramasa.gregtech.integration.rei;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.EntryType;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.api.common.util.EntryStacks;
import muramasa.antimatter.AntimatterAPI;
import muramasa.antimatter.data.AntimatterMaterialTypes;
import muramasa.antimatter.data.AntimatterMaterials;
import muramasa.antimatter.integration.rei.REIUtils;
import muramasa.antimatter.material.IMaterialTag;
import muramasa.antimatter.material.Material;
import muramasa.antimatter.material.MaterialTags;
import muramasa.antimatter.pipe.PipeItemBlock;
import muramasa.antimatter.pipe.PipeSize;
import muramasa.antimatter.pipe.types.Cable;
import muramasa.antimatter.pipe.types.FluidPipe;
import muramasa.antimatter.pipe.types.ItemPipe;
import muramasa.antimatter.pipe.types.Wire;
import muramasa.gregtech.integration.rei.MaterialTreeDisplay;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;

public class MaterialTreeCategory
implements DisplayCategory<MaterialTreeDisplay> {
    protected static Renderer icon = EntryStacks.of((ItemLike)AntimatterMaterialTypes.DUST.get(AntimatterMaterials.Iron));
    private static final Component title = new TranslatableComponent("gti.rei.tooltip.material_tree");
    static CategoryIdentifier<? extends MaterialTreeDisplay> id = CategoryIdentifier.of((String)"gti", (String)"material_tree");

    public CategoryIdentifier<? extends MaterialTreeDisplay> getCategoryIdentifier() {
        return id;
    }

    public List<Widget> setupDisplay(MaterialTreeDisplay display, Rectangle bounds) {
        Material mat = display.mat;
        ArrayList<Widget> widgets = new ArrayList<Widget>();
        widgets.add((Widget)Widgets.createRecipeBase((Rectangle)bounds));
        widgets.add(Widgets.createDrawableWidget((helper, matrices, mouseX, mouseY, delta) -> {
            MaterialTreeCategory.drawTexture(matrices, new ResourceLocation("gti", "textures/gui/material_tree/background.png"), bounds.x, bounds.y, 0, 0, bounds.getWidth(), bounds.getHeight());
            MaterialTreeCategory.drawTexture(matrices, new ResourceLocation("gti", "textures/gui/material_tree/base.png"), bounds.x, bounds.y, 0, 0, bounds.getWidth(), bounds.getHeight());
            if (mat.has(new IMaterialTag[]{AntimatterMaterialTypes.INGOT}) && !mat.has(new IMaterialTag[]{AntimatterMaterialTypes.INGOT_HOT})) {
                MaterialTreeCategory.drawTexture(matrices, new ResourceLocation("gti", "textures/gui/material_tree/ingot.png"), bounds.x, bounds.y, 0, 0, bounds.getWidth(), bounds.getHeight());
            }
            if (mat.has(new IMaterialTag[]{AntimatterMaterialTypes.INGOT_HOT})) {
                MaterialTreeCategory.drawTexture(matrices, new ResourceLocation("gti", "textures/gui/material_tree/ingot_hot.png"), bounds.x, bounds.y, 0, 0, bounds.getWidth(), bounds.getHeight());
            }
            if (mat.has(new IMaterialTag[]{AntimatterMaterialTypes.NUGGET})) {
                MaterialTreeCategory.drawTexture(matrices, new ResourceLocation("gti", "textures/gui/material_tree/nugget.png"), bounds.x, bounds.y, 0, 0, bounds.getWidth(), bounds.getHeight());
            }
            if (mat.has(new IMaterialTag[]{AntimatterMaterialTypes.LIQUID})) {
                if (mat.has(new IMaterialTag[]{AntimatterMaterialTypes.INGOT})) {
                    MaterialTreeCategory.drawTexture(matrices, new ResourceLocation("gti", "textures/gui/material_tree/fluid_from_ingot.png"), bounds.x, bounds.y, 0, 0, bounds.getWidth(), bounds.getHeight());
                } else {
                    MaterialTreeCategory.drawTexture(matrices, new ResourceLocation("gti", "textures/gui/material_tree/fluid_from_dust.png"), bounds.x, bounds.y, 0, 0, bounds.getWidth(), bounds.getHeight());
                }
            }
            if (mat.has(new IMaterialTag[]{AntimatterMaterialTypes.BLOCK})) {
                if (mat.has(new IMaterialTag[]{AntimatterMaterialTypes.INGOT})) {
                    MaterialTreeCategory.drawTexture(matrices, new ResourceLocation("gti", "textures/gui/material_tree/block.png"), bounds.x, bounds.y, 0, 0, bounds.getWidth(), bounds.getHeight());
                } else {
                    MaterialTreeCategory.drawTexture(matrices, new ResourceLocation("gti", "textures/gui/material_tree/block_no_ingot.png"), bounds.x, bounds.y, 0, 0, bounds.getWidth(), bounds.getHeight());
                }
            }
            if (mat.has(new IMaterialTag[]{AntimatterMaterialTypes.PLATE})) {
                if (mat.has(new IMaterialTag[]{AntimatterMaterialTypes.INGOT}) && mat.has(new IMaterialTag[]{AntimatterMaterialTypes.BLOCK})) {
                    MaterialTreeCategory.drawTexture(matrices, new ResourceLocation("gti", "textures/gui/material_tree/plate_from_ingot_and_block.png"), bounds.x, bounds.y, 0, 0, bounds.getWidth(), bounds.getHeight());
                } else if (mat.has(new IMaterialTag[]{AntimatterMaterialTypes.INGOT})) {
                    MaterialTreeCategory.drawTexture(matrices, new ResourceLocation("gti", "textures/gui/material_tree/plate_from_ingot.png"), bounds.x, bounds.y, 0, 0, bounds.getWidth(), bounds.getHeight());
                } else if (mat.has(new IMaterialTag[]{AntimatterMaterialTypes.BLOCK})) {
                    MaterialTreeCategory.drawTexture(matrices, new ResourceLocation("gti", "textures/gui/material_tree/plate_no_ingot_from_dust_and_block.png"), bounds.x, bounds.y, 0, 0, bounds.getWidth(), bounds.getHeight());
                } else {
                    MaterialTreeCategory.drawTexture(matrices, new ResourceLocation("gti", "textures/gui/material_tree/plate_no_ingot_from_dust.png"), bounds.x, bounds.y, 0, 0, bounds.getWidth(), bounds.getHeight());
                }
            }
            if (mat.has(new IMaterialTag[]{AntimatterMaterialTypes.PLATE_DENSE})) {
                MaterialTreeCategory.drawTexture(matrices, new ResourceLocation("gti", "textures/gui/material_tree/plate_dense.png"), bounds.x, bounds.y, 0, 0, bounds.getWidth(), bounds.getHeight());
            }
            if (mat.has(new IMaterialTag[]{AntimatterMaterialTypes.FOIL})) {
                MaterialTreeCategory.drawTexture(matrices, new ResourceLocation("gti", "textures/gui/material_tree/foil.png"), bounds.x, bounds.y, 0, 0, bounds.getWidth(), bounds.getHeight());
            }
            if (mat.has(new IMaterialTag[]{AntimatterMaterialTypes.FRAME})) {
                MaterialTreeCategory.drawTexture(matrices, new ResourceLocation("gti", "textures/gui/material_tree/frame.png"), bounds.x, bounds.y, 0, 0, bounds.getWidth(), bounds.getHeight());
            }
            if (mat.has(new IMaterialTag[]{MaterialTags.FLUIDPIPE}) || mat.has(new IMaterialTag[]{MaterialTags.ITEMPIPE})) {
                MaterialTreeCategory.drawTexture(matrices, new ResourceLocation("gti", "textures/gui/material_tree/pipe.png"), bounds.x, bounds.y, 0, 0, bounds.getWidth(), bounds.getHeight());
            }
            if (mat.has(new IMaterialTag[]{AntimatterMaterialTypes.GEAR})) {
                MaterialTreeCategory.drawTexture(matrices, new ResourceLocation("gti", "textures/gui/material_tree/gear.png"), bounds.x, bounds.y, 0, 0, bounds.getWidth(), bounds.getHeight());
            }
            if (mat.has(new IMaterialTag[]{AntimatterMaterialTypes.GEAR_SMALL})) {
                MaterialTreeCategory.drawTexture(matrices, new ResourceLocation("gti", "textures/gui/material_tree/gear_small.png"), bounds.x, bounds.y, 0, 0, bounds.getWidth(), bounds.getHeight());
            }
            if (mat.has(new IMaterialTag[]{AntimatterMaterialTypes.ROD})) {
                if (mat.has(new IMaterialTag[]{AntimatterMaterialTypes.INGOT})) {
                    MaterialTreeCategory.drawTexture(matrices, new ResourceLocation("gti", "textures/gui/material_tree/rod.png"), bounds.x, bounds.y, 0, 0, bounds.getWidth(), bounds.getHeight());
                } else {
                    MaterialTreeCategory.drawTexture(matrices, new ResourceLocation("gti", "textures/gui/material_tree/rod_no_ingot.png"), bounds.x, bounds.y, 0, 0, bounds.getWidth(), bounds.getHeight());
                }
            }
            if (mat.has(new IMaterialTag[]{AntimatterMaterialTypes.ROD_LONG})) {
                MaterialTreeCategory.drawTexture(matrices, new ResourceLocation("gti", "textures/gui/material_tree/rod_long.png"), bounds.x, bounds.y, 0, 0, bounds.getWidth(), bounds.getHeight());
            }
            if (mat.has(new IMaterialTag[]{AntimatterMaterialTypes.RING})) {
                MaterialTreeCategory.drawTexture(matrices, new ResourceLocation("gti", "textures/gui/material_tree/ring.png"), bounds.x, bounds.y, 0, 0, bounds.getWidth(), bounds.getHeight());
            }
            if (mat.has(new IMaterialTag[]{AntimatterMaterialTypes.BOLT})) {
                MaterialTreeCategory.drawTexture(matrices, new ResourceLocation("gti", "textures/gui/material_tree/bolt.png"), bounds.x, bounds.y, 0, 0, bounds.getWidth(), bounds.getHeight());
            }
            if (mat.has(new IMaterialTag[]{AntimatterMaterialTypes.SCREW})) {
                MaterialTreeCategory.drawTexture(matrices, new ResourceLocation("gti", "textures/gui/material_tree/screw.png"), bounds.x, bounds.y, 0, 0, bounds.getWidth(), bounds.getHeight());
            }
            if (mat.has(new IMaterialTag[]{AntimatterMaterialTypes.SPRING})) {
                MaterialTreeCategory.drawTexture(matrices, new ResourceLocation("gti", "textures/gui/material_tree/spring.png"), bounds.x, bounds.y, 0, 0, bounds.getWidth(), bounds.getHeight());
            }
            if (mat.has(new IMaterialTag[]{MaterialTags.WIRE})) {
                MaterialTreeCategory.drawTexture(matrices, new ResourceLocation("gti", "textures/gui/material_tree/wire.png"), bounds.x, bounds.y, 0, 0, bounds.getWidth(), bounds.getHeight());
            }
            if (mat.has(new IMaterialTag[]{MaterialTags.CABLE})) {
                MaterialTreeCategory.drawTexture(matrices, new ResourceLocation("gti", "textures/gui/material_tree/cable.png"), bounds.x, bounds.y, 0, 0, bounds.getWidth(), bounds.getHeight());
            }
            if (mat.has(new IMaterialTag[]{AntimatterMaterialTypes.WIRE_FINE})) {
                MaterialTreeCategory.drawTexture(matrices, new ResourceLocation("gti", "textures/gui/material_tree/wire_fine.png"), bounds.x, bounds.y, 0, 0, bounds.getWidth(), bounds.getHeight());
            }
            this.setupInfo(display, bounds, matrices);
        }));
        widgets.addAll(this.setupSlots(display, bounds));
        return widgets;
    }

    private List<Widget> setupSlots(MaterialTreeDisplay display, Rectangle bounds) {
        PipeItemBlock wireItem;
        ArrayList<Widget> widgets = new ArrayList<Widget>();
        Material mat = display.mat;
        widgets.add((Widget)Widgets.createSlot((Point)this.xy(4, 92, bounds)).entries((Collection)EntryIngredients.ofIngredient((Ingredient)AntimatterMaterialTypes.DUST.getMaterialIngredient(mat, 1))).markInput().disableBackground());
        widgets.add((Widget)Widgets.createSlot((Point)this.xy(30, 50, bounds)).entries((Collection)EntryIngredients.ofIngredient((Ingredient)AntimatterMaterialTypes.DUST_TINY.getMaterialIngredient(mat, 1))).markOutput().disableBackground());
        widgets.add((Widget)Widgets.createSlot((Point)this.xy(4, 50, bounds)).entries((Collection)EntryIngredients.ofIngredient((Ingredient)AntimatterMaterialTypes.DUST_SMALL.getMaterialIngredient(mat, 1))).markOutput().disableBackground());
        if (mat.has(new IMaterialTag[]{AntimatterMaterialTypes.INGOT}) && !mat.has(new IMaterialTag[]{AntimatterMaterialTypes.INGOT_HOT})) {
            widgets.add((Widget)Widgets.createSlot((Point)this.xy(30, 110, bounds)).entries((Collection)EntryIngredients.ofIngredient((Ingredient)AntimatterMaterialTypes.INGOT.getMaterialIngredient(mat, 1))).markOutput().disableBackground());
        }
        if (mat.has(new IMaterialTag[]{AntimatterMaterialTypes.INGOT_HOT})) {
            widgets.add((Widget)Widgets.createSlot((Point)this.xy(30, 74, bounds)).entries((Collection)EntryIngredients.ofIngredient((Ingredient)AntimatterMaterialTypes.INGOT_HOT.getMaterialIngredient(mat, 1))).markOutput().disableBackground());
            widgets.add((Widget)Widgets.createSlot((Point)this.xy(30, 110, bounds)).entries((Collection)EntryIngredients.ofIngredient((Ingredient)AntimatterMaterialTypes.INGOT.getMaterialIngredient(mat, 1))).markOutput().disableBackground());
        }
        if (mat.has(new IMaterialTag[]{AntimatterMaterialTypes.NUGGET})) {
            widgets.add((Widget)Widgets.createSlot((Point)this.xy(60, 110, bounds)).entries((Collection)EntryIngredients.ofIngredient((Ingredient)AntimatterMaterialTypes.NUGGET.getMaterialIngredient(mat, 1))).markOutput().disableBackground());
        }
        if (mat.has(new IMaterialTag[]{AntimatterMaterialTypes.LIQUID})) {
            widgets.add((Widget)Widgets.createSlot((Point)this.xy(5, 128, bounds)).entries((Collection)this.ofFluid(mat, 144)).markInput().disableBackground());
        }
        if (mat.has(new IMaterialTag[]{AntimatterMaterialTypes.BLOCK})) {
            widgets.add((Widget)Widgets.createSlot((Point)this.xy(30, 146, bounds)).entries((Collection)EntryIngredients.ofIngredient((Ingredient)AntimatterMaterialTypes.BLOCK.getMaterialIngredient(mat, 1))).markOutput().disableBackground());
        }
        if (mat.has(new IMaterialTag[]{AntimatterMaterialTypes.PLATE})) {
            widgets.add((Widget)Widgets.createSlot((Point)this.xy(60, 146, bounds)).entries((Collection)EntryIngredients.ofIngredient((Ingredient)AntimatterMaterialTypes.PLATE.getMaterialIngredient(mat, 1))).markOutput().disableBackground());
        }
        if (mat.has(new IMaterialTag[]{AntimatterMaterialTypes.PLATE_DENSE})) {
            widgets.add((Widget)Widgets.createSlot((Point)this.xy(90, 146, bounds)).entries((Collection)EntryIngredients.ofIngredient((Ingredient)AntimatterMaterialTypes.PLATE_DENSE.getMaterialIngredient(mat, 1))).markOutput().disableBackground());
        }
        if (mat.has(new IMaterialTag[]{AntimatterMaterialTypes.FOIL})) {
            widgets.add((Widget)Widgets.createSlot((Point)this.xy(150, 146, bounds)).entries((Collection)EntryIngredients.ofIngredient((Ingredient)AntimatterMaterialTypes.FOIL.getMaterialIngredient(mat, 1))).markOutput().disableBackground());
        }
        if (mat.has(new IMaterialTag[]{AntimatterMaterialTypes.FRAME})) {
            widgets.add((Widget)Widgets.createSlot((Point)this.xy(90, 74, bounds)).entries((Collection)EntryIngredients.ofIngredient((Ingredient)AntimatterMaterialTypes.FRAME.getMaterialIngredient(mat, 1))).markOutput().disableBackground());
        }
        if (mat.has(new IMaterialTag[]{MaterialTags.FLUIDPIPE}) || mat.has(new IMaterialTag[]{MaterialTags.ITEMPIPE})) {
            ItemPipe itemPipe;
            FluidPipe fluidPipe;
            ArrayList<Item> itemList = new ArrayList<Item>();
            if (mat.has(new IMaterialTag[]{MaterialTags.FLUIDPIPE}) && (fluidPipe = (FluidPipe)AntimatterAPI.get(FluidPipe.class, (String)("fluid_pipe_" + mat.getId()))) != null) {
                fluidPipe.getSizes().forEach(s -> itemList.add((Item)fluidPipe.getBlockItem(s)));
            }
            if (mat.has(new IMaterialTag[]{MaterialTags.ITEMPIPE}) && (itemPipe = (ItemPipe)AntimatterAPI.get(ItemPipe.class, (String)("item_pipe_" + mat.getId()))) != null) {
                itemPipe.getSizes().forEach(s -> itemList.add((Item)itemPipe.getBlockItem(s)));
            }
            if (!itemList.isEmpty()) {
                widgets.add((Widget)Widgets.createSlot((Point)this.xy(90, 110, bounds)).entries((Collection)this.ofItems(itemList)).markOutput().disableBackground());
            }
        }
        if (mat.has(new IMaterialTag[]{AntimatterMaterialTypes.GEAR})) {
            widgets.add((Widget)Widgets.createSlot((Point)this.xy(120, 110, bounds)).entries((Collection)EntryIngredients.ofIngredient((Ingredient)AntimatterMaterialTypes.GEAR.getMaterialIngredient(mat, 1))).markOutput().disableBackground());
        }
        if (mat.has(new IMaterialTag[]{AntimatterMaterialTypes.GEAR_SMALL})) {
            widgets.add((Widget)Widgets.createSlot((Point)this.xy(150, 110, bounds)).entries((Collection)EntryIngredients.ofIngredient((Ingredient)AntimatterMaterialTypes.GEAR_SMALL.getMaterialIngredient(mat, 1))).markOutput().disableBackground());
        }
        if (mat.has(new IMaterialTag[]{AntimatterMaterialTypes.ROD})) {
            widgets.add((Widget)Widgets.createSlot((Point)this.xy(60, 74, bounds)).entries((Collection)EntryIngredients.ofIngredient((Ingredient)AntimatterMaterialTypes.ROD.getMaterialIngredient(mat, 1))).markOutput().disableBackground());
        }
        if (mat.has(new IMaterialTag[]{AntimatterMaterialTypes.ROD_LONG})) {
            widgets.add((Widget)Widgets.createSlot((Point)this.xy(180, 110, bounds)).entries((Collection)EntryIngredients.ofIngredient((Ingredient)AntimatterMaterialTypes.ROD_LONG.getMaterialIngredient(mat, 1))).markOutput().disableBackground());
        }
        if (mat.has(new IMaterialTag[]{AntimatterMaterialTypes.RING})) {
            widgets.add((Widget)Widgets.createSlot((Point)this.xy(180, 146, bounds)).entries((Collection)EntryIngredients.ofIngredient((Ingredient)AntimatterMaterialTypes.RING.getMaterialIngredient(mat, 1))).markOutput().disableBackground());
        }
        if (mat.has(new IMaterialTag[]{AntimatterMaterialTypes.BOLT})) {
            widgets.add((Widget)Widgets.createSlot((Point)this.xy(120, 74, bounds)).entries((Collection)EntryIngredients.ofIngredient((Ingredient)AntimatterMaterialTypes.BOLT.getMaterialIngredient(mat, 1))).markOutput().disableBackground());
        }
        if (mat.has(new IMaterialTag[]{AntimatterMaterialTypes.SCREW})) {
            widgets.add((Widget)Widgets.createSlot((Point)this.xy(150, 74, bounds)).entries((Collection)EntryIngredients.ofIngredient((Ingredient)AntimatterMaterialTypes.SCREW.getMaterialIngredient(mat, 1))).markOutput().disableBackground());
        }
        if (mat.has(new IMaterialTag[]{AntimatterMaterialTypes.SPRING})) {
            widgets.add((Widget)Widgets.createSlot((Point)this.xy(180, 74, bounds)).entries((Collection)EntryIngredients.ofIngredient((Ingredient)AntimatterMaterialTypes.SPRING.getMaterialIngredient(mat, 1))).markOutput().disableBackground());
        }
        if (mat.has(new IMaterialTag[]{MaterialTags.WIRE})) {
            wireItem = ((Wire)AntimatterAPI.get(Wire.class, (String)("wire_" + mat.getId()))).getBlockItem(PipeSize.VTINY);
            widgets.add((Widget)Widgets.createSlot((Point)this.xy(90, 50, bounds)).entries((Collection)EntryIngredients.of((ItemLike)wireItem)).markOutput().disableBackground());
        }
        if (mat.has(new IMaterialTag[]{MaterialTags.CABLE})) {
            wireItem = ((Cable)AntimatterAPI.get(Cable.class, (String)("cable_" + mat.getId()))).getBlockItem(PipeSize.VTINY);
            widgets.add((Widget)Widgets.createSlot((Point)this.xy(60, 50, bounds)).entries((Collection)EntryIngredients.of((ItemLike)wireItem)).markOutput().disableBackground());
        }
        if (mat.has(new IMaterialTag[]{AntimatterMaterialTypes.WIRE_FINE})) {
            widgets.add((Widget)Widgets.createSlot((Point)this.xy(120, 50, bounds)).entries((Collection)EntryIngredients.ofIngredient((Ingredient)AntimatterMaterialTypes.WIRE_FINE.getMaterialIngredient(mat, 1))).markOutput().disableBackground());
        }
        return widgets;
    }

    private void setupInfo(MaterialTreeDisplay display, Rectangle bounds, PoseStack stack) {
        Material mat = display.mat;
        this.renderString(stack, mat.getDisplayName().getString(), Minecraft.m_91087_().f_91062_, 12.0f, 10.0f, 0xFFFFFF, bounds.x, bounds.y);
        this.renderString(stack, "Mass: " + mat.getMass(), Minecraft.m_91087_().f_91062_, 12.0f, 20.0f, 0xFFFFFF, bounds.x, bounds.y);
        this.renderString(stack, "Formula: " + mat.getChemicalFormula(), Minecraft.m_91087_().f_91062_, 12.0f, 30.0f, 0xFFFFFF, bounds.x, bounds.y);
        this.renderString(stack, "Density: " + mat.getDensity(), Minecraft.m_91087_().f_91062_, 120.0f, 10.0f, 0xFFFFFF, bounds.x, bounds.y);
        this.renderString(stack, "Hardness: " + mat.getHardness(), Minecraft.m_91087_().f_91062_, 120.0f, 20.0f, 0xFFFFFF, bounds.x, bounds.y);
    }

    private void renderString(PoseStack stack, String string, Font render, float x, float y, int color, int guiOffsetX, int guiOffsetY) {
        render.m_92750_(stack, string, (float)guiOffsetX + x, (float)guiOffsetY + y, color);
    }

    private Point xy(int x, int y, Rectangle bounds) {
        int offsetX = 0;
        int offsetY = 0;
        return new Point(offsetX + x + bounds.x, offsetY + y + bounds.y);
    }

    private EntryIngredient ofFluid(Material fluid, int amount) {
        ArrayList<EntryStack> stacks = new ArrayList<EntryStack>();
        FluidStack stack = fluid.has(new IMaterialTag[]{AntimatterMaterialTypes.LIQUID}) ? fluid.getLiquid(amount) : fluid.getGas(amount);
        stacks.add(EntryStack.of((EntryType)VanillaEntryTypes.FLUID, (Object)REIUtils.toREIFLuidStack((FluidStack)stack)));
        return EntryIngredient.of(stacks);
    }

    private EntryIngredient ofItems(List<Item> items) {
        ArrayList<EntryStack> stacks = new ArrayList<EntryStack>();
        for (Item extra : items) {
            stacks.add(EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)new ItemStack((ItemLike)extra)));
        }
        return EntryIngredient.of(stacks);
    }

    private static void drawTexture(PoseStack stack, ResourceLocation loc, int left, int top, int x, int y, int sizeX, int sizeY) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)loc);
        GuiComponent.m_93143_((PoseStack)stack, (int)left, (int)top, (int)0, (float)x, (float)y, (int)sizeX, (int)sizeY, (int)200, (int)166);
    }

    public Component getTitle() {
        return title;
    }

    public Renderer getIcon() {
        return icon;
    }

    public int getDisplayHeight() {
        return 166;
    }

    public int getDisplayWidth(MaterialTreeDisplay display) {
        return 200;
    }
}

